<?xml version="1.0"?>
<!-- 

 Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuobjtbl.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of object table ADTs
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    lbarton     06/17/09 - lrg 3543159: XMLType virtual columns
    shvenugo    03/23/09 - add store all varrays as lobs(tables) support
    rapayne     12/06/08 - merge BLOCKSIZE logic for CM
    htseng      03/20/06 - add xmltype binary support 
    lbarton     01/20/06 - code restructuring 
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     01/04/05 - bug 4017065: SUBSTITUTABLE on object table 
    rpfau       12/02/04 - Have callers of DoXMLTypeStorage emit XMLTYPE and
                           simplify call logic.
    lbarton     05/12/04 - Disentangle OID and EXPORT 
    rpfau       03/31/04 - Fix temporary table with name specified for 
                           oidindex - bug 3470762. Remove OidIndex template.
    bmccarth    10/30/03 - get REF correct for XMLSchemas 
    lbarton     09/02/03 - Bug 3103169: dataobjnum for oidindex storage 
    lbarton     03/20/03 - Bug 2859037: emit OID if EXPORT true
    bmccarth    03/31/03 - change call to lobmd
    lbarton     02/26/03 - emit owner with type synonym
    bmccarth    03/07/03 - add space after element num
    ataracha    02/19/03 - add space after out_of_line
    lbarton     01/30/03 - syntax for out-of-line tables
    bmccarth    10/08/02 - bug 2518404-xmlschema location
    bmccarth    08/15/02 - Move OID of table to after XMLTABLE
    bmccarth    08/08/02 - add space after oid value
    lbarton	04/03/02 - xdb bugfix
    lbarton     10/25/01 - xdb support
    dgagne      07/12/01 - fix OidIndex clause, missing index name
    gclaborn    11/03/00 - change name
    gclaborn    08/29/00 - use table, not type OID in OID clause
    lbarton	07/07/00 - bugfix: PkOid
    lbarton	05/17/00 - Params for new API
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <xsl:template name="ObjTable">
  <!-- *******************************************************************
Template: ObjTable
 For an object table generate
   OF typeowner.typename [ OID oid ] [ substitution-clauses ]
******************************************************************** -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD">
   <xsl:text>OF </xsl:text>
   <xsl:choose>
    <xsl:when test="SYN_NAME">
     <xsl:if test="SYN_OWNER!='PUBLIC'">
      <xsl:text>"</xsl:text>
      <xsl:value-of select="SYN_OWNER"/>
      <xsl:text>".</xsl:text>
     </xsl:if>
     <xsl:text>"</xsl:text>
     <xsl:value-of select="SYN_NAME"/>
     <xsl:text>"</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:apply-templates select="SCHEMA_OBJ"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$OID=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> OID &apos;</xsl:text>
    <xsl:value-of select="../../../SCHEMA_OBJ/OID"/>
    <!-- Use table's OID -->
    <xsl:text>&apos; </xsl:text>
   </xsl:if>
   <!-- object table substitution -->
   <xsl:choose>
    <!--  0x800 - SUBSTITUTABLE specified explicitly -->
    <xsl:when test="(FLAGS mod 4096)>= 2048">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> SUBSTITUTABLE AT ALL LEVELS </xsl:text>
    </xsl:when>
    <!--  0x400 - NOT SUBSTITUTABLE specified explicitly -->
    <xsl:when test="(FLAGS mod 2048)>=1024">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> NOT SUBSTITUTABLE AT ALL LEVELS </xsl:text>
    </xsl:when>
   </xsl:choose>
   <!-- Because of parsing issues with XMLSchema based object tables -->
   <!-- don't check for that here (it's done later by the caller) -->
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoOidindex">
  <!-- *******************************************************************
Template: DoOidindex - emit OIDINDEX clause
Current node: TABLE_T
  If not a temporary table and segment_attributes is TRUE, 
   write OIDINDEX and segment attributes. If user name specified,
   write that too. 
   If a temporary table, segment_attributes not allowed. But if a 
   user name was specified, write out OIDINDEX and the name. 
   If name specified for oidindex (not system generated), write it out.
******************************************************************** -->
   <xsl:choose>
    <!-- Skip XMLSchema object table -->
    <xsl:when test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT"/>
    <xsl:otherwise>
     <xsl:for-each select="COL_LIST/COL_LIST_ITEM/OIDINDEX">
      <xsl:choose>
       <xsl:when test="(../../../PROPERTY mod 8388608)>=4194304">
        <!-- temp table. If oidindex has a user specified name, write -->
        <!-- OIDINDEX and name -->
        <xsl:if test="(FLAGS mod 16) &lt; 8">
         <!-- user specified name -->
         <xsl:text>OIDINDEX </xsl:text>
         <xsl:value-of select="NAME"/>
         <xsl:if test="$PRETTY=1">
          <xsl:text>&#xa; </xsl:text>
         </xsl:if>
        </xsl:if>
       </xsl:when>
       <xsl:otherwise>
        <!-- Not a temp table. -->
        <xsl:choose>
         <xsl:when test="$SEGMENT_ATTRIBUTES=0">
          <!-- SEGMENT_ATTRIBUTES=0, Only write OIDINDEX and name if user -->
          <!-- specified a name. -->
          <xsl:if test="(FLAGS mod 16) &lt; 8">
           <xsl:text>OIDINDEX </xsl:text>
           <xsl:value-of select="NAME"/>
           <xsl:if test="$PRETTY=1">
            <xsl:text>&#xa; </xsl:text>
           </xsl:if>
          </xsl:if>
         </xsl:when>
         <xsl:otherwise>
          <!-- SEGMENT_ATTRIBUTES=1, always write OIDINDEX -->
          <xsl:text>OIDINDEX </xsl:text>
          <!-- If oidindex has a user specified name, write it -->
          <xsl:if test="(FLAGS mod 16) &lt; 8">
           <xsl:value-of select="NAME"/>
          </xsl:if>
          <xsl:text> ( </xsl:text>
          <xsl:apply-templates select="PCT_FREE">
           <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
          </xsl:apply-templates>
          <!-- Write storage attributes only if both SEGMENT_ATTRIBUTES and -->
          <!-- STORAGE are TRUE. That check is done in template -->
          <!-- "NamedStorage" which is called by template match "STORAGE" -->
          <xsl:apply-templates select="STORAGE">
            <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
           <xsl:with-param name="Dataobjnum" select="STORAGE/HWMINCR"/>
           <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
          </xsl:apply-templates>
          <xsl:text>) </xsl:text>
          <xsl:if test="$PRETTY=1">
           <xsl:text>&#xa; </xsl:text>
          </xsl:if>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:for-each>
    </xsl:otherwise>
   </xsl:choose>
 </xsl:template>
 <xsl:template name="PkOid">
  <!-- *******************************************************************
Template; PkOid
????? Looks like this template is no longer used
******************************************************************** -->
  <xsl:text>(PRIMARY KEY (</xsl:text>
  <xsl:call-template name="DoConstraintColList">
   <xsl:with-param name="ColListNode" select="CON1_LIST/CON1_LIST_ITEM[CONTYPE='2']/COL_LIST"/>
  </xsl:call-template>
  <xsl:text>)) OBJECT ID PRIMARY KEY
 </xsl:text>
 </xsl:template>
 <xsl:template match="OPQMD/SCHEMA_ELMT">
  <!-- *******************************************************************
Template; OPQMD/SCHEMA_ELMT 
******************************************************************** -->
  <xsl:apply-templates select="../../LOBMD"/>
  <xsl:call-template name="DoSchemaElmt">
   <xsl:with-param name="SchemaElmt" select="current()"/>
  </xsl:call-template>
  <xsl:call-template name="DoAllowDisallow">
   <xsl:with-param name="OpqmdElmt" select=".."/>
  </xsl:call-template>
  <xsl:if test="((../FLAGS) mod 64)>=32">
   <xsl:text>OUT_OF_LINE </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="LOBMD">
  <!-- *******************************************************************
Template: LOBMD
******************************************************************** -->
  <xsl:call-template name="DoXMLTypeStorage"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoSchemaElmt">
  <xsl:param name="SchemaElmt" select="''"/>
  <!-- *******************************************************************
Template: DoSchemaElmt - emit the XMLSchema_spec clause
Parameters:
  SchemaElmt - the SCHEMA_ELMT node
******************************************************************** -->
  <xsl:text> XMLSCHEMA "</xsl:text>
  <xsl:value-of select="$SchemaElmt/XMLSCHEMA"/>
  <xsl:text>" ELEMENT "</xsl:text>
  <xsl:value-of select="$SchemaElmt/ELEMENT_NAME"/>
  <xsl:text>" ID </xsl:text>
  <xsl:value-of select="$SchemaElmt/ELEMNUM"/>
  <xsl:text> </xsl:text>
 </xsl:template>
 <xsl:template name="DoAllowDisallow">
  <xsl:param name="OpqmdElmt" select="''"/>
  <!-- *******************************************************************
Template: DoAllowDisallow - emit [DIS]ALLOW [NON]SCHEMA
Parameters:
  OpqmdElmt - the OPQMD node
******************************************************************** -->
  <xsl:if test="(($OpqmdElmt/FLAGS) mod 4096)>=2048 and $VERSION >= 1102000000">
   <xsl:text>STORE ALL VARRAYS AS LOBS </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="(($OpqmdElmt/FLAGS) mod 128)>=64">
   <xsl:choose>
    <xsl:when test="(($OpqmdElmt/FLAGS) mod 512 )>=256">
     <xsl:text>DISALLOW NONSCHEMA </xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>ALLOW NONSCHEMA </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
    <xsl:when test="(($OpqmdElmt/FLAGS) mod 256 )>=128">
     <xsl:text>ALLOW ANYSCHEMA </xsl:text>
    </xsl:when>
    <xsl:when test="(($OpqmdElmt/FLAGS) mod 512 )&lt;256">
     <xsl:text>DISALLOW ANYSCHEMA </xsl:text>
    </xsl:when>
   </xsl:choose>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
