package org.jdesktop.animation.timing.interpolation;

import java.util.ArrayList;

public class KeySplines
{
    private ArrayList<Spline> splines;
    
    public KeySplines(final Spline... splines) {
        this.splines = new ArrayList<Spline>();
        for (final Spline points : splines) {
            this.splines.add(points);
        }
    }
    
    public int getSize() {
        return this.splines.size();
    }
    
    float interpolate(final int index, final float t) {
        final Spline spline = this.splines.get(index);
        return spline.getInterpolatedValue(t);
    }
}