/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public abstract class DerivedPropertyBuilder<T extends AbstractBuildableObject>
extends AbstractDBObjectBuilder<T> {
    private final Map<String, Tuple<Object, DBException>> m_lastErrors = new HashMap<String, Tuple<Object, DBException>>();
    private DerivedPropertyBuilder<T> m_tempCopySourceBuilder;

    public DerivedPropertyBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        super(abstractDBObjectProvider, string);
        if (Metadata.getInstance().getObjectClass(string) == null) {
            throw new IllegalArgumentException(string + "is not a valid DBObject type");
        }
    }

    public boolean isClearDerivedPropertiesRequired(T t, DBObjectChange dBObjectChange, Collection<String> collection) {
        boolean bl = false;
        for (String string : collection) {
            if (!this.isBuildableProperty(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Collection<String> clearDerivedProperties(T t, DBObjectChange dBObjectChange) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : dBObjectChange.getAllChangedProperties()) {
            Collection<String> collection = this.clearDerivedProperties(t, string, dBObjectChange);
            if (collection == null) continue;
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public Collection<String> clearDerivedProperties(T t, String string, DBObjectChange dBObjectChange) {
        ArrayList<String> arrayList = null;
        this.m_lastErrors.remove(string);
        Collection<String> collection = this.getDerivedProperties(string);
        if (collection != null) {
            arrayList = new ArrayList<String>();
            Collection<String> collection2 = dBObjectChange.getAllChangedProperties();
            for (String string2 : collection) {
                if (collection2.contains(string2)) continue;
                arrayList.add(string2);
                ((AbstractDBObject)t).setProperty(string2, null);
            }
        }
        return arrayList;
    }

    @Override
    protected final boolean canBuildComponents() {
        return true;
    }

    @Override
    public final T createObject(String string, Schema schema, DBObjectID dBObjectID) {
        return null;
    }

    @Override
    public boolean cancelCurrentBuild(T t) {
        boolean bl = super.cancelCurrentBuild(t);
        DerivedPropertyBuilder<T> derivedPropertyBuilder = this.m_tempCopySourceBuilder;
        if (bl && derivedPropertyBuilder != null) {
            AbstractBuildableObject abstractBuildableObject = (AbstractBuildableObject)TemporaryObjectID.findOriginalObject(t);
            derivedPropertyBuilder.cancelCurrentBuild(abstractBuildableObject == null ? t : abstractBuildableObject);
        }
        return bl;
    }

    @Override
    protected void registerObject(T t) throws DBException {
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        if (((AbstractDBObject)t).getID() instanceof BaseObjectID) {
            CascadeManager cascadeManager;
            abstractDBObjectProvider.getObjectFactory().ensureID((DBObject)t, true, false);
            SystemObject systemObject = DBUtil.getSystemObject(t);
            if (systemObject != null && (cascadeManager = abstractDBObjectProvider.getCascadeManager()) instanceof SchemaObjectManager) {
                ((SchemaObjectManager)cascadeManager).registerObject(systemObject, true);
            }
        } else {
            abstractDBObjectProvider.getObjectFactory().ensureDerivedPropertyBuilder((DBObject)t);
        }
    }

    protected boolean canCacheBuildFailure(T t, String string) {
        return string != null;
    }

    protected Object getFailureCacheValue(T t, String string) {
        return this.canCacheBuildFailure(t, string) ? ((AbstractDBObject)t).getProperty(string) : null;
    }

    @Override
    protected boolean isBuiltOnFailure(T t, String[] stringArray, DBException dBException) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            String string2 = this.getDerivedPropertySource(string);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        boolean bl = hashSet.isEmpty();
        for (String string : hashSet) {
            if (this.canCacheBuildFailure(t, string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    protected boolean fillInObjectComponentImpl(T t, String string) throws DBException {
        boolean bl;
        Tuple<Object, DBException> tuple;
        String string2 = this.getDerivedPropertySource(string);
        Object object = this.getFailureCacheValue(t, string);
        if (object != null && (tuple = this.m_lastErrors.get(string2)) != null && object.equals(tuple.getFirst())) {
            throw (DBException)tuple.getSecond();
        }
        try {
            T t2 = this.getOriginalObjectForFillInComponentImpl(t, string, string2);
            if (t2 == null) {
                bl = super.fillInObjectComponentImpl(t, string);
            } else {
                this.derivePropertiesForTempCopy(t, t2, string);
                bl = true;
            }
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (DBException dBException) {
            if (object != null) {
                this.m_lastErrors.put(string2, (Tuple<Object, DBException>)new Tuple(object, (Object)dBException));
            }
            throw dBException;
        }
        return bl;
    }

    private T getOriginalObjectForFillInComponentImpl(T t, String string, String string2) {
        AbstractBuildableObject abstractBuildableObject;
        AbstractBuildableObject abstractBuildableObject2 = null;
        if (string2 != null && (abstractBuildableObject = (AbstractBuildableObject)TemporaryObjectID.getOriginalObject(t)) instanceof AbstractBuildableObject) {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder(abstractBuildableObject);
            if (this.isSourcePropertyValueEqual(abstractBuildableObject, t, string2)) {
                abstractBuildableObject2 = abstractBuildableObject;
            }
        }
        return (T)abstractBuildableObject2;
    }

    protected boolean isSourcePropertyValueEqual(T t, T t2, String string) {
        boolean bl = false;
        Object object = ((AbstractDBObject)t).getProperty(string);
        Object object2 = ((AbstractDBObject)t2).getProperty(string);
        if (!(object2 instanceof DBObject) && object != null && object2 != null && ModelUtil.areEqual((Object)object, (Object)object2)) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void derivePropertiesForTempCopy(T t, T t2, String string) throws DBException {
        TemporaryObjectID.TemporaryIDPolicy temporaryIDPolicy = new TemporaryObjectID.TemporaryIDPolicy();
        this.checkInterruptOrCancel(t);
        String[] stringArray = this.getBuiltProperties(string);
        if (stringArray != null) {
            try {
                this.m_tempCopySourceBuilder = this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)t2);
                DBUtil.ensureObjectBuilt(t2, stringArray);
            }
            finally {
                this.m_tempCopySourceBuilder = null;
            }
            this.checkInterruptOrCancel(t);
            for (String string2 : stringArray) {
                Object object = ((AbstractDBObject)t2).getProperty(string2);
                this.checkInterruptOrCancel(t);
                Object object2 = DBUtil.copyPropertyValue(object, t2, t, temporaryIDPolicy);
                ((AbstractDBObject)t).setProperty(string2, object2);
            }
            Map<DBObjectID, DBObjectID> map = temporaryIDPolicy.getIDMap();
            map.putAll(DBUtil.getTemporaryIDMap(DBUtil.getUppermostParent(t)));
            this.replaceReferenceIDs(t, map);
        }
    }
}

