/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;

public class MaterializedView
extends Table
implements SQLQueryOwner {
    public static final String TYPE = "MATERIALIZED VIEW";

    public MaterializedView() {
        this((String)null, (Schema)null);
    }

    public MaterializedView(String string, Schema schema) {
        super(string, schema);
        this.setUpdatable(false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public SQLQuery getSQLQuery() {
        return (SQLQuery)this.getProperty("SQLQuery");
    }

    @Override
    public void setSQLQuery(SQLQuery sQLQuery) {
        this.setProperty("SQLQuery", sQLQuery);
    }

    @Override
    @Derived(value="SQLQuery")
    public Column[] getColumns() {
        return super.getColumns();
    }

    @Internal
    public String getViewText() {
        SQLQuery sQLQuery = this.getSQLQuery();
        return sQLQuery == null ? null : sQLQuery.getSQLText().trim();
    }

    public void setUpdatable(boolean bl) {
        this.setProperty("updatable", bl);
    }

    public boolean isUpdatable() {
        return (Boolean)this.getProperty("updatable", false);
    }

    public void setQueryRewrite(Boolean bl) {
        this.setProperty("queryRewrite", bl);
    }

    public Boolean getQueryRewrite() {
        return (Boolean)this.getProperty("queryRewrite");
    }

    @Deprecated
    @Transient
    public void setRewrite(boolean bl) {
        this.setQueryRewrite(bl);
    }

    @Deprecated
    public boolean isRewrite() {
        return Boolean.TRUE.equals(this.getQueryRewrite());
    }

    public void setRewriteType(RewriteCapability rewriteCapability) {
        this.setProperty("rewriteType", (Object)rewriteCapability);
    }

    public RewriteCapability getRewriteType() {
        return (RewriteCapability)((Object)this.getProperty("rewriteType"));
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public void setRefreshMode(RefreshMode refreshMode) {
        this.setProperty("refreshMode", (Object)refreshMode);
    }

    public RefreshMode getRefreshMode() {
        RefreshMode refreshMode = (RefreshMode)((Object)this.getProperty("refreshMode"));
        return refreshMode;
    }

    public void setRefreshMethod(RefreshMethod refreshMethod) {
        if (DBUtil.isDeprecated(refreshMethod)) {
            this.setProperty("refreshMethod", null);
        } else {
            this.setProperty("refreshMethod", (Object)refreshMethod);
        }
    }

    public RefreshMethod getRefreshMethod() {
        return (RefreshMethod)((Object)this.getProperty("refreshMethod"));
    }

    public void setFastRefresh(FastRefreshable fastRefreshable) {
        this.setProperty("fastRefresh", (Object)fastRefreshable);
    }

    public FastRefreshable getFastRefresh() {
        return (FastRefreshable)((Object)this.getProperty("fastRefresh"));
    }

    public void setLastRefreshType(RefreshMethod refreshMethod) {
        this.setProperty("lastRefreshType", (Object)refreshMethod);
    }

    public RefreshMethod getLastRefreshType() {
        return (RefreshMethod)((Object)this.getProperty("lastRefreshType"));
    }

    public void setLastRefreshDate(Date date) {
        this.setProperty("lastRefreshDate", date);
    }

    public Date getLastRefreshDate() {
        return (Date)this.getProperty("lastRefreshDate");
    }

    public void setNextRefreshDate(Date date) {
        this.setProperty("nextRefreshDate", date);
    }

    public Date getNextRefreshDate() {
        return (Date)this.getProperty("nextRefreshDate");
    }

    @Deprecated
    @Transient
    public String getNextRefresh() {
        Date date = this.getNextRefreshDate();
        return date == null ? null : date.toString();
    }

    @Deprecated
    @Transient
    public void setNextRefresh(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            this.setNextRefreshDate(simpleDateFormat.parse(string));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getInterval() {
        return (String)this.getProperty("interval");
    }

    public void setInterval(String string) {
        this.setProperty("interval", string);
    }

    public String getFirstRefresh() {
        return (String)this.getProperty("firstRefresh");
    }

    public void setFirstRefresh(String string) {
        this.setProperty("firstRefresh", string);
    }

    public void setStaleness(Staleness staleness) {
        this.setProperty("staleness", (Object)staleness);
    }

    public Staleness getStaleness() {
        return (Staleness)((Object)this.getProperty("staleness"));
    }

    public void setBuildType(BuildType buildType) {
        this.setProperty("buildType", (Object)buildType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public BuildType getBuildType() {
        return (BuildType)((Object)this.getProperty("buildType"));
    }

    public void setOnPrebuilt(PrebuiltType prebuiltType) {
        this.setProperty("onPrebuilt", (Object)prebuiltType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public PrebuiltType getOnPrebuilt() {
        return (PrebuiltType)((Object)this.getProperty("onPrebuilt"));
    }

    public void setDefaultIndex(Boolean bl) {
        this.setProperty("defaultIndex", bl);
    }

    public Boolean getDefaultIndex() {
        return (Boolean)this.getProperty("defaultIndex");
    }

    @Deprecated
    public boolean isUseNoIndex() {
        return Boolean.FALSE.equals(this.getDefaultIndex());
    }

    @Deprecated
    @Transient
    public void setUseNoIndex(boolean bl) {
        this.setDefaultIndex(!bl);
    }

    @Deprecated
    @Transient
    public void setIndexPercentFree(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, true);
            oracleStorageProperties.setPercentFree(n);
        }
    }

    @Deprecated
    public int getIndexPercentFree() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getPercentFree();
    }

    @Deprecated
    @Transient
    public void setIndexPercentUsed(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, true);
            oracleStorageProperties.setPercentUsed(n);
        }
    }

    @Deprecated
    @Transient
    public int getIndexPercentUsed() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getPercentUsed();
    }

    @Transient
    @Deprecated
    public void setIndexInitTrans(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, true);
            oracleStorageProperties.setInitrans(n);
        }
    }

    @Deprecated
    public int getIndexInitTrans() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getInitrans();
    }

    @Transient
    @Deprecated
    public void setMaxTrans(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, true);
            oracleStorageProperties.setMaxtrans(n);
        }
    }

    @Deprecated
    public int getMaxTrans() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getMaxtrans();
    }

    @Transient
    @Deprecated
    public void setMinTrans(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, true);
            oracleStorageProperties.setInitrans(n);
        }
    }

    @Deprecated
    public int getMinTrans() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getInitrans();
    }

    @Transient
    @Deprecated
    public void setInitExtent(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, true);
            oracleStorageProperties.setInitialExtent(new BigInteger(Integer.toString(n)));
        }
    }

    @Deprecated
    public int getInitExtent() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getInitialExtent().intValue();
    }

    @Deprecated
    @Transient
    public void setNextExtent(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, true);
            oracleStorageProperties.setNextExtent(new BigInteger(Integer.toString(n)));
        }
    }

    @Deprecated
    public int getNextExtent() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(false, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getNextExtent().intValue();
    }

    @Transient
    @Deprecated
    public void setIndexMinExtent(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, true);
            oracleStorageProperties.setMinExtent(BigInteger.valueOf(n));
        }
    }

    @Deprecated
    public int getIndexMinExtent() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getMinExtent().intValue();
    }

    @Transient
    @Deprecated
    public void setIndexMaxExtent(int n) {
        if (n > 0) {
            OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, true);
            oracleStorageProperties.setMaxExtent(BigInteger.valueOf(n));
        }
    }

    @Deprecated
    public int getIndexMaxExtent() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, false);
        return oracleStorageProperties == null ? 0 : oracleStorageProperties.getMaxExtent().intValue();
    }

    @Deprecated
    public String getTablespace() {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, false);
        return oracleStorageProperties == null ? null : oracleStorageProperties.getTablespace();
    }

    @Transient
    @Deprecated
    public void setTablespace(String string) {
        OracleStorageProperties oracleStorageProperties = this.getOracleStorageProperties(true, true);
        oracleStorageProperties.setTablespace(string);
    }

    public void setCache(Boolean bl) {
        this.setProperty("cache", bl);
    }

    public Boolean getCache() {
        return (Boolean)this.getProperty("cache");
    }

    @Deprecated
    public Boolean isCache() {
        return this.getCache();
    }

    @Deprecated
    @Transient
    public void setMasters(String[] stringArray) {
        this.getChildSupport("masters").setChildArray(stringArray);
    }

    @Deprecated
    @Transient
    public String[] getMasters() {
        return this.getChildSupport("masters").getChildArray(String.class);
    }

    public RefreshWith getKeyType() {
        return (RefreshWith)((Object)this.getProperty("keyType"));
    }

    public void setKeyType(RefreshWith refreshWith) {
        if (refreshWith == RefreshWith.UNSPECIFIED) {
            refreshWith = null;
        }
        this.setProperty("keyType", (Object)refreshWith);
    }

    public UsingConstraints getUsingConstraints() {
        return (UsingConstraints)((Object)this.getProperty("usingConstraints"));
    }

    public void setUsingConstraints(UsingConstraints usingConstraints) {
        this.setProperty("usingConstraints", (Object)usingConstraints);
    }

    public RollbackSegmentType getRollbackSegmentType() {
        return (RollbackSegmentType)((Object)this.getProperty("rollbackSegmentType"));
    }

    public void setRollbackSegmentType(RollbackSegmentType rollbackSegmentType) {
        this.setProperty("rollbackSegmentType", (Object)rollbackSegmentType);
    }

    public String getRollbackSegmentName() {
        return (String)this.getProperty("rollbackSegmentName");
    }

    public void setRollbackSegmentName(String string) {
        this.setProperty("rollbackSegmentName", string);
    }

    @Override
    public boolean isDeclarative() {
        SQLQuery sQLQuery = this.getSQLQuery();
        return sQLQuery != null && sQLQuery.isDeclarative();
    }

    @Deprecated
    @Transient
    public void setParallel(int n) {
        this.setParallelDegree(n);
    }

    @Deprecated
    public int getParallel() {
        Integer n = this.getParallelDegree();
        return n instanceof Integer ? n : 1;
    }

    @Deprecated
    @Transient
    public void setParallelDegree(Integer n) {
        OracleTableProperties oracleTableProperties;
        OracleTableProperties oracleTableProperties2 = oracleTableProperties = n == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
        if (oracleTableProperties != null) {
            oracleTableProperties.setParallelDegree(n);
        }
    }

    @Deprecated
    public Integer getParallelDegree() {
        OracleTableProperties oracleTableProperties = (OracleTableProperties)this.getProperty("OracleTableProperties");
        return oracleTableProperties == null ? null : oracleTableProperties.getParallelDegree();
    }

    @Deprecated
    @Transient
    public void setCompression(Boolean bl) {
        OracleTableProperties oracleTableProperties;
        OracleTableProperties oracleTableProperties2 = oracleTableProperties = bl == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
        if (oracleTableProperties != null) {
            oracleTableProperties.setTableCompression(OracleTableProperties.OracleTableCompression.migrateFrom(bl));
        }
    }

    @Deprecated
    public Boolean getCompression() {
        OracleTableProperties oracleTableProperties = (OracleTableProperties)this.getProperty("OracleTableProperties");
        return oracleTableProperties == null ? null : OracleTableProperties.OracleTableCompression.convertToBoolean(oracleTableProperties.getTableCompression());
    }

    private OracleStorageProperties getOracleStorageProperties(boolean bl, boolean bl2) {
        String string = bl ? "MatViewIndexStorageProperties" : "OracleStorageProperties";
        OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)this.getProperty(string);
        if (oracleStorageProperties == null && bl2) {
            oracleStorageProperties = new OracleStorageProperties();
            this.setProperty(string, oracleStorageProperties);
        }
        return oracleStorageProperties;
    }

    public static enum RewriteCapability {
        NONE,
        TEXTMATCH,
        GENERAL;

    }

    public static enum RefreshMode {
        NEVER,
        DEMAND,
        COMMIT,
        SPECIFY;

    }

    public static enum RefreshMethod {
        FAST,
        COMPLETE,
        FORCE,
        NEVER,
        NA;

    }

    public static enum FastRefreshable {
        NO,
        DIRLOAD,
        DML,
        DIRLOAD_DML,
        DIRLOAD_LIMITEDDML;

    }

    public static enum Staleness {
        FRESH,
        STALE,
        UNUSABLE,
        UNKNOWN,
        UNDEFINED,
        NEEDS_COMPILE,
        COMPILATION_ERROR;

    }

    public static enum BuildType {
        IMMEDIATE,
        DEFERRED,
        PREBUILT;

    }

    public static enum PrebuiltType {
        NONE,
        UNSPECIFIED_PRECISION,
        WITH_REDUCED_PRECISION,
        WITHOUT_REDUCED_PRECISION;

    }

    public static enum RefreshWith {
        UNSPECIFIED,
        PRIMARY_KEY,
        ROWID;

    }

    public static enum UsingConstraints {
        TRUSTED,
        ENFORCED;

    }

    public static enum RollbackSegmentType {
        NONE,
        LOCAL,
        MASTER;

    }
}

