/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.adf.share.perf.analysis.RequestAnalyzer;
import oracle.adf.share.perf.analysis.SensorAnalyzer;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.SensorTable;

public class Analyzer {
    private static final String SENSOR = "sensor";
    private static final String REQUEST = "request";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PERFLOG_FILE_PREFIX = "adfperf";
    private static final String LOG_FILE_SUFFIX = ".log";
    private static final int PROGRESS_UPDATE_GAP = 100;
    protected static Vector sSensorTypes = new Vector();
    protected static Vector sSensorNames = new Vector();
    protected static int sExcludeCount = 0;
    protected static String sExcludeFileName = null;
    protected static PrintStream sOut = null;
    protected static final int TYPE_SENSOR = 1;
    protected static final int TYPE_REQUEST = 2;
    protected static int sAnalysisType = 1;
    private static final String AGGTYPE_ALL = "all";
    protected static boolean sTimerOnly = true;
    private static final String FORMAT_XML = "xml";
    protected static boolean sFormatXml = false;
    protected static boolean sAllPattern = false;
    protected static boolean sDebug = false;
    protected static int sIgnoreThreshold = 0;
    protected static int sNumTopUrls = Integer.MAX_VALUE;
    private static LinkedList<Sensor> sExcludeSensors = null;
    private static long sBeginDate = 0L;
    private static long sEndDate = 0L;
    private static final String FACES_STATE = "org.apache.myfaces.trinidad.faces.STATE";
    private static final String VIEW_STATE = "javax.faces.ViewState";
    private static final String CTRL_STATE = "_adf.ctrl-state";
    private static final String WIN_ID = "_adf.winId";
    private static final String SCOPE_ID = "_bridgeRequestScopeId";
    protected static Vector<String> sReplaceParams = new Vector();
    private long mLogStartTimeStamp = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.out.println("Usage: java -cp <classpath> oracle.adf.share.perf.analysis.Analyser [-t sensor|request] [-x <exclude_warmup_counter>] [-a all|timer] [-f text|xml] [-i <millisecond>] [-p] [-d] [-r <replace_param_list>] [-o <N>] [-l exclude_file] [-b M/d/y,H:m:s] [-e M/d/y,H:m:s] <perflog_path> <output_file_name>");
            System.out.println("Option -t: choose processing type:");
            System.out.println("    sensor - aggregate the performance statistics based on sensor name");
            System.out.println("    request - aggregate the performance statistics based on request");
            System.out.println("    default is 'sensor'");
            System.out.println("Option -x: exclude specified number of warmup encounters to sensors");
            System.out.println("    default is to exclude nothing");
            System.out.println("Option -a: aggregate what type of sensors:");
            System.out.println("    all - aggregate all types of sensors");
            System.out.println("    timers - aggregate timers only");
            System.out.println("    default is to aggregate timers only");
            System.out.println("Option -f: format of the output file (applicable for request type only):");
            System.out.println("    text - pure text format");
            System.out.println("    xml - xml format which can be transformed to tree control html document");
            System.out.println("    default is to use text");
            System.out.println("Option -i: ignore the sensors with smaller than specified millisecond average time (applicable for request type only)");
            System.out.println("    default is 0, meaning all sensors are shown in the report.");
            System.out.println("Option -p: aggregate and report all thread patterns");
            System.out.println("    default is to aggregate and report only top 95% thread patterns and ignore rare (<5%) thread patterns");
            System.out.println("Option -r: replace values in the listed additional parameters (separated by ',') in url while doing aggregation");
            System.out.println("    default is to replace five parameters: org.apache.myfaces.trinidad.faces.STATE,javax.faces.viewState,_adf.ctrl-state,_adf.winId,_bridgeRequestScopeId");
            System.out.println("Option -o: report only top <N> longest requests or sensors");
            System.out.println("    default is is to list all different requests or sensors");
            System.out.println("Option -d: debug analysis processing (applicable for request type and text format only)");
            System.out.println("Option -l: points to a file that contains a list of sensors to be excluded in aggregation");
            System.out.println("Option -b: aggregate those sensors only after the begin date/time specified here in format of M/d/y,H:m:s");
            System.out.println("Option -e: aggregate those sensors only before the end date/time specified here in format of M/d/y,H:m:s");
            System.out.print("For example: to analyze the performance log file ");
            System.out.print("in /tmp/log directory based on requests, ");
            System.out.print("and exclude the first 5 requests from statistics. ");
            System.out.println("Send result report to result.txt in current working directory.");
            System.out.println(">java oracle.adf.share.perf.analysis.Analyser -t request -x 5 /tmp/log result.txt");
            return;
        }
        try {
            String type = SENSOR;
            sReplaceParams.add(FACES_STATE);
            sReplaceParams.add(VIEW_STATE);
            sReplaceParams.add(CTRL_STATE);
            sReplaceParams.add(WIN_ID);
            sReplaceParams.add(SCOPE_ID);
            int argc = 0;
            String arg = args[argc++];
            while (true) {
                SimpleDateFormat sdf;
                String agg;
                if (arg.equalsIgnoreCase("-t")) {
                    type = args[argc++];
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-x")) {
                    sExcludeCount = Integer.parseInt(args[argc++]);
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-a")) {
                    if ((agg = args[argc++]).equalsIgnoreCase(AGGTYPE_ALL)) {
                        sTimerOnly = false;
                    }
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-f")) {
                    if ((agg = args[argc++]).equalsIgnoreCase(FORMAT_XML)) {
                        sFormatXml = true;
                    }
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-p")) {
                    sAllPattern = true;
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-d")) {
                    sDebug = true;
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-r")) {
                    String list = args[argc++];
                    String[] params = list.split(",");
                    for (int i = 0; i < params.length; ++i) {
                        sReplaceParams.add(params[i]);
                    }
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-o")) {
                    sNumTopUrls = Integer.parseInt(args[argc++]);
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-i")) {
                    sIgnoreThreshold = Integer.parseInt(args[argc++]);
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-l")) {
                    sExcludeFileName = args[argc++];
                    arg = args[argc++];
                    continue;
                }
                if (arg.equalsIgnoreCase("-b")) {
                    String beginDate = args[argc++];
                    sdf = new SimpleDateFormat("M/dd/y,H:m:s");
                    sBeginDate = sdf.parse(beginDate).getTime();
                    arg = args[argc++];
                    continue;
                }
                if (!arg.equalsIgnoreCase("-e")) break;
                String endDate = args[argc++];
                sdf = new SimpleDateFormat("M/dd/y,H:m:s");
                sEndDate = sdf.parse(endDate).getTime();
                arg = args[argc++];
            }
            String path = arg + FILE_SEPARATOR;
            Object outFile = args[argc++];
            if (!type.equalsIgnoreCase(REQUEST)) {
                sFormatXml = false;
            }
            if (sDebug) {
                sFormatXml = false;
                type = REQUEST;
            }
            if (sFormatXml) {
                int ext = ((String)outFile).lastIndexOf(46);
                outFile = ext != -1 ? ((String)outFile).substring(0, ext) + ".xml" : (String)outFile + ".xml";
                File file = new File((String)outFile);
                String parent = file.getParent();
                String[] files = new String[]{"closed.gif", "doc.gif", "open.gif", "tree.dtd", "xmlTree.css", "xmlTree.js", "xmlTree.xsl"};
                try {
                    byte[] buf = new byte[1024];
                    for (int i = 0; i < files.length; ++i) {
                        URL url = Analyzer.class.getResource("resources/" + files[i]);
                        InputStream in = null;
                        OutputStream out = null;
                        try {
                            int len;
                            in = url.openStream();
                            out = new FileOutputStream(new File(parent, files[i]));
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                            continue;
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    System.exit(-1);
                }
            }
            sOut = new PrintStream(new FileOutputStream((String)outFile));
            Analyzer analyzer = Analyzer.getAnalyzer(type);
            analyzer.analyse(path);
            analyzer.print();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private static Analyzer getAnalyzer(String type) {
        if (type.equalsIgnoreCase(SENSOR)) {
            sAnalysisType = 1;
            return new SensorAnalyzer();
        }
        if (type.equalsIgnoreCase(REQUEST)) {
            sAnalysisType = 2;
            return new RequestAnalyzer();
        }
        sAnalysisType = 1;
        return new Analyzer();
    }

    void analyse(String perfFilePath) {
        String fn = perfFilePath + "adfperf.log";
        this.process(fn);
        for (int i = this.getNumberOfLogFile(perfFilePath); i >= 0; --i) {
            fn = perfFilePath + PERFLOG_FILE_PREFIX + i + LOG_FILE_SUFFIX;
            this.process(fn);
        }
    }

    boolean isFiltered(SensorResult result) {
        int nameIdx = result.mNameIndex;
        Sensor s = new Sensor((String)sSensorTypes.get(nameIdx), (String)sSensorNames.get(nameIdx));
        if (sExcludeSensors.contains(s)) {
            return true;
        }
        if (sBeginDate != 0L && result.mTimeStamp + this.mLogStartTimeStamp < sBeginDate) {
            return true;
        }
        return sEndDate != 0L && result.mTimeStamp + this.mLogStartTimeStamp >= sEndDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(String fn) {
        String line;
        sExcludeSensors = new LinkedList();
        BufferedReader in = null;
        try {
            String filename = null;
            if (sExcludeFileName != null) {
                in = new BufferedReader(new FileReader(sExcludeFileName));
                filename = sExcludeFileName;
            } else {
                URL url = SensorTable.class.getResource("resources/sensors.lst");
                filename = url.toString();
                in = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            System.out.println("Excludes sensors in " + filename);
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String type = st.nextToken();
                String name = st.nextToken();
                String group = st.nextToken();
                sExcludeSensors.add(new Sensor(type, name, group));
            }
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            System.exit(1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
                in = null;
            }
        }
        System.out.println("Processing " + fn + "...");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fn));
            int lineCount = 0;
            System.out.print("  Processing line# 1");
            while ((line = br.readLine()) != null) {
                if (++lineCount % 100 == 0) {
                    System.out.print(" " + lineCount);
                }
                if (line.startsWith("# ")) continue;
                if (line.startsWith("I ")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    int index = Integer.parseInt(st.nextToken());
                    String name = st.nextToken();
                    String type = st.nextToken();
                    this.addSensor(index, name, type);
                    continue;
                }
                if (line.startsWith("T ")) {
                    line = line.substring(2);
                    Date startDate = DateFormat.getDateTimeInstance(0, 1).parse(line);
                    this.mLogStartTimeStamp = startDate.getTime();
                    continue;
                }
                this.analyseLine(line);
            }
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void analyseLine(String line) {
    }

    void addSensor(int index, String name, String type) {
        if (index + 1 > sSensorNames.size()) {
            sSensorNames.setSize(index + 1);
        }
        if (index + 1 > sSensorTypes.size()) {
            sSensorTypes.setSize(index + 1);
        }
        sSensorNames.set(index, name);
        sSensorTypes.set(index, type);
    }

    void print() {
    }

    private int getNumberOfLogFile(String perfFilePath) {
        String fn;
        File f;
        int count = 0;
        while ((f = new File(fn = perfFilePath + PERFLOG_FILE_PREFIX + count + LOG_FILE_SUFFIX)).exists()) {
            ++count;
        }
        return --count;
    }

    static String htmlEncode(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    class Sensor {
        String mType;
        String mName;
        String mGroup;

        Sensor(String type, String name, String group) {
            this.mType = type;
            this.mName = name;
            this.mGroup = group;
        }

        Sensor(String type, String name) {
            this.mType = type;
            int index = name.lastIndexOf(47);
            this.mName = name.substring(index + 1);
            this.mGroup = name.substring(0, index);
        }

        public boolean equals(Object o) {
            Sensor s = (Sensor)o;
            return this.mType.compareToIgnoreCase(s.mType) == 0 && this.mName.compareToIgnoreCase(s.mName) == 0 && (this.mGroup.startsWith(s.mGroup) || s.mGroup.startsWith(this.mGroup));
        }
    }
}

