/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.io.ObjectStreamException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLoggerExtension;
import oracle.adf.share.logging.ADFLoggerExtensionJUL;
import oracle.adf.share.logging.ADFLoggerExtensionODL;
import oracle.adf.share.logging.ADFLoggerFactory;
import oracle.adf.share.logging.BeginEndTracer;
import oracle.adf.share.logging.BeginEndTracerNOP;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.analytics.AnalyticsFileHandler;
import oracle.adf.share.logging.internal.diagnostic.ADFLogRecord;
import oracle.adf.share.logging.internal.perf.PerfFileHandler;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adfinternal.share.util.ProviderUtil;
import oracle.dms.context.ExecutionContext;

@CodeSharingSafe(value="StaticInitializer")
public class ADFLogger {
    static final String STD_CLASS_NAME = "oracle.adf.share.logging.ADFLogger";
    static final Logger stackLogger = Logger.getLogger("oracle.adf.share.logging.ADFLogger.stack");
    private Logger mLogger = null;
    private final String CLAZZ_NAME;
    public static final Level INTERNAL_ERROR = ADFLoggerLevel.INTERNAL_ERROR;
    public static final Level ERROR = ADFLoggerLevel.ERROR;
    public static final Level TRACE = ADFLoggerLevel.TRACE;
    public static final Level NOTIFICATION = ADFLoggerLevel.NOTIFICATION;
    public static final Level WARNING = ADFLoggerLevel.WARNING;
    @Deprecated
    public static final String ENTERRING_TAG = "begin";
    public static final String ENTERING_TAG = "begin";
    public static final String EXITING_TAG = "end";
    public static final String ADD_CONTEXT_DATA_TAG = "add_context_data";
    public static final String ADF_MESSAGE_DELIMITER = ";#;";
    public static final String ADF_MESSAGE_STATUS = "ADF_MESSAGE_STATUS";
    public static final String ADF_MESSAGE_ACTION_NAME = "ADF_MESSAGE_ACTION_NAME";
    public static final String ADF_MESSAGE_ACTION_DESC = "ADF_MESSAGE_ACTION_DESC";
    public static final String ADF_MESSAGE_PAYLOAD = "ADF_MESSAGE_PAYLOAD";
    public static final String ADF_MESSAGE_CONTEXT_DATA = "ADF_MESSAGE_CONTEXT_DATA";
    public static final String ADF_MESSAGE_DEFAULT_CONTEXT_DATA = "ADF_MESSAGE_DEFAULT_CONTEXT_DATA";
    public static final String ADF_ANALYTICS_LOGGER_NAME = "oracle.adf.analytics";
    public static final String ADF_PERF_LOGGER_NAME = "oracle.adf.perf";
    public static final String ADF_LOGGER_MESSAGE_BUNDLE = "oracle.adf.share.logging.resources.LoggerMessageBundle";
    public static final String ADF_WEB_REQUEST = "ADF web request";
    public static final String ADD_REQUEST_MESSAGE_TAG = "add_request_message";
    public static final String ADF_REQUEST_END = "request_end";
    public static final String ADF_NODE_END = "node_end";
    public static final String ADF_COMPONENT_NAME = "Component";
    public static final String ADD_CONTEXT_DATA = "addContextData";
    static final ExtensionHolder loggerExtn = AdfServerPlatformUtil.isBreezeAvailable() || AdfServerPlatformUtil.isInternalJsePlatform() ? new ExtensionHolderTL() : new ExtensionHolder();

    public static ADFLoggerExtension setLoggerExtension(ADFLoggerExtension extn) {
        if (stackLogger.isLoggable(Level.FINE)) {
            stackLogger.fine("Setting override " + extn + " in " + Thread.currentThread());
        }
        ADFLoggerExtension ret = loggerExtn.get();
        loggerExtn.set(extn);
        return ret;
    }

    protected ADFLogger(Logger log) {
        if (log == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_REQUIRED"));
        }
        this.mLogger = log;
        String cn = this.getClass().getName();
        this.CLAZZ_NAME = STD_CLASS_NAME.equals(cn) ? null : cn;
    }

    protected ADFLogger(Logger log, String clazzName) {
        if (log == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_REQUIRED"));
        }
        this.mLogger = log;
        this.CLAZZ_NAME = clazzName == null || STD_CLASS_NAME.equals(clazzName) ? null : clazzName;
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    public static ADFLogger createADFLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_NAME_REQUIRED"));
        }
        Logger logger = ADFLoggerFactory.getADFLogger(name, null);
        return new ADFLogger(logger, STD_CLASS_NAME);
    }

    public static ADFLogger createADFLogger(String name, String resourceBundleName) {
        if (name == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_NAME_REQUIRED"));
        }
        Logger logger = ADFLoggerFactory.getADFLogger(name, resourceBundleName);
        return new ADFLogger(logger, STD_CLASS_NAME);
    }

    public static ADFLogger createADFLogger(Builder builder) {
        return builder.build();
    }

    public static ADFLogger createADFLogger(Class c) {
        if (c == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("CLASS_REQUIRED"));
        }
        String name = c.getName();
        return ADFLogger.createADFLogger(name);
    }

    public static ADFLogger createADFLogger(Class c, String resourceBundleName) {
        if (c == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("CLASS_REQUIRED"));
        }
        String name = c.getName();
        return ADFLogger.createADFLogger(name, resourceBundleName);
    }

    public static ADFLogger createADFLogger(Package p) {
        if (p == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("PACKAGE_REQUIRED"));
        }
        String name = p.getName();
        return ADFLogger.createADFLogger(name);
    }

    public static ADFLogger createADFLogger(Package p, String resourceBundleName) {
        if (p == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("PACKAGE_REQUIRED"));
        }
        String name = p.getName();
        return ADFLogger.createADFLogger(name, resourceBundleName);
    }

    public static ADFLogger getAnonymousLogger() {
        return new ADFLogger(Logger.getAnonymousLogger(), STD_CLASS_NAME);
    }

    public static ADFLogger getAnonymousLogger(String resourceBundleName) {
        return new ADFLogger(Logger.getAnonymousLogger(resourceBundleName), STD_CLASS_NAME);
    }

    public ResourceBundle getResourceBundle() {
        return this.mLogger.getResourceBundle();
    }

    public String getResourceBundleName() {
        return this.mLogger.getResourceBundleName();
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.mLogger.setFilter(newFilter);
    }

    public Filter getFilter() {
        return this.mLogger.getFilter();
    }

    public void log(LogRecord record) {
        this.mLogger.log(record);
    }

    public void log(String msg) {
        this.log(ADFLoggerLevel.TRACE, msg);
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object[] params, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setParameters(params);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.validateADFLogRecord(msg);
            ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    @Deprecated
    public void begin(String actionName, HashMap<String, String> contextData) {
        this.beginNode(Level.CONFIG, actionName, contextData);
    }

    public void begin(String actionName) {
        this.beginNode(Level.CONFIG, actionName, null);
    }

    public void begin(String actionName, Map<String, String> contextData) {
        this.beginNode(Level.CONFIG, actionName, contextData);
    }

    public void begin(Level level, String actionName) {
        this.beginNode(level, actionName, null);
    }

    public void begin(Level level, String actionName, Map<String, String> contextData) {
        this.beginNode(level, actionName, contextData);
    }

    public void beginRequest(Level level, Map<String, String> contextData) {
        this.beginNode(level, ADF_WEB_REQUEST, contextData);
    }

    public void beginRequest(Level level) {
        this.beginNode(level, ADF_WEB_REQUEST, null);
    }

    private void beginNode(Level level, String actionName, Map<String, String> contextData) {
        loggerExtn.get().begin(this, level, actionName, contextData);
    }

    @Deprecated
    public void addContextData(String actionName, HashMap<String, String> contextData) {
        this.addMessageToRequest(Level.CONFIG, actionName, contextData, ADD_CONTEXT_DATA_TAG, null);
    }

    public void addContextData(String actionName, Map<String, String> contextData) {
        this.addMessageToRequest(Level.CONFIG, actionName, contextData, ADD_CONTEXT_DATA_TAG, null);
    }

    public void addContextData(Level level, String actionName, Map<String, String> contextData) {
        this.addMessageToRequest(level, actionName, contextData, ADD_CONTEXT_DATA_TAG, null);
    }

    public void addRequestMessage(Level level, String actionName) {
        this.addMessageToRequest(level, actionName, null, ADD_REQUEST_MESSAGE_TAG, null);
    }

    public void addRequestMessage(Level level, String actionName, Throwable thrown) {
        this.addMessageToRequest(level, actionName, null, ADD_REQUEST_MESSAGE_TAG, thrown);
    }

    public void addRequestMessage(Level level, String actionName, Map<String, String> contextData) {
        this.addMessageToRequest(level, actionName, contextData, ADD_REQUEST_MESSAGE_TAG, null);
    }

    public void addRequestMessage(Level level, String actionName, Throwable thrown, Map<String, String> contextData) {
        this.addMessageToRequest(level, actionName, contextData, ADD_REQUEST_MESSAGE_TAG, thrown);
    }

    private void addMessageToRequest(Level level, String actionName, Map<String, String> contextData, String MessageTag, Throwable thrown) {
        loggerExtn.get().addMessageToRequest(this, level, actionName, contextData, MessageTag, thrown);
    }

    public void end(String actionName) {
        this.endNode(Level.CONFIG, actionName);
    }

    private void endNode(Level level, String actionName) {
        loggerExtn.get().end(this, level, actionName);
    }

    public void end(Level level, String actionName) {
        this.endNode(level, actionName);
    }

    @Deprecated
    public void end(Level level) {
        this.endNode(level, ADF_NODE_END);
    }

    public void endRequest(Level level) {
        this.endNode(level, ADF_WEB_REQUEST);
    }

    public void LogRelativeADFRequest(String parentEcid) {
        loggerExtn.get().logRelativeADFRequest(this, parentEcid);
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.mLogger.entering(sourceClass, sourceMethod);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.mLogger.entering(sourceClass, sourceMethod, param1);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.mLogger.entering(sourceClass, sourceMethod, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.mLogger.exiting(sourceClass, sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.mLogger.exiting(sourceClass, sourceMethod, result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.mLogger.throwing(sourceClass, sourceMethod, thrown);
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void throwing(Level level, String sourceClass, String sourceMethod, Throwable thrown) {
        this.logp(level, sourceClass, sourceMethod, "", thrown);
    }

    public void severe(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg, param1);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg, params);
    }

    public void warning(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg, param1);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg, params);
    }

    public void info(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg, param1);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg, params);
    }

    public void config(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.CONFIG, sourceClass, sourceMethod, msg);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.mLogger.logp(Level.CONFIG, sourceClass, sourceMethod, msg, param1);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.CONFIG, sourceClass, sourceMethod, msg, params);
    }

    public void fine(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg, param1);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINE, sourceClass, sourceMethod, msg, params);
    }

    public void finer(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, param1);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void finest(String sourceClass, String sourceMethod, String msg) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg, param1);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logp(Level.FINEST, sourceClass, sourceMethod, msg, params);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object params1, Object params2, Object params3) {
        this.logp(level, sourceClass, sourceMethod, msg, new Object[]{params1, params2, params3});
    }

    public void setLevel(Level newLevel) throws SecurityException {
        this.mLogger.setLevel(newLevel);
    }

    public Level getLevel() {
        return this.mLogger.getLevel();
    }

    public boolean isLoggable(Level level) {
        return loggerExtn.get().isLoggable(this.mLogger, level);
    }

    public String getName() {
        return this.mLogger.getName();
    }

    public void addHandler(Handler handler) throws SecurityException {
        this.mLogger.addHandler(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.mLogger.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this.mLogger.getHandlers();
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.mLogger.setUseParentHandlers(useParentHandlers);
    }

    public boolean getUseParentHandlers() {
        return this.mLogger.getUseParentHandlers();
    }

    public Logger getParent() {
        return this.mLogger.getParent();
    }

    public void setParent(Logger parent) {
        this.mLogger.setParent(parent);
    }

    private ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        ClassLoader cl = ClassUtils.getClassLoader(ADFLogger.class);
        return ResourceBundle.getBundle(name, currentLocale, cl);
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.mLogger.getName());
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.findResourceBundle(rbname));
        }
        this.log(lr);
    }

    private void doLog(LogRecord lr) {
        lr.setLoggerName(this.mLogger.getName());
        String ebname = this.mLogger.getResourceBundleName();
        if (ebname != null) {
            lr.setResourceBundleName(ebname);
            lr.setResourceBundle(this.mLogger.getResourceBundle());
        }
        this.mLogger.log(lr);
    }

    public void internal(Throwable t) {
        this.internal("", t);
    }

    public void internal(String message, Throwable t) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, message, t);
    }

    public void internal(String message, Object param) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, message, param);
    }

    public void internal(String message, Object[] params) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, message, params);
    }

    public void severe(Throwable t) {
        this.severe("", t);
    }

    public void severe(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public void severe(String message, Object param) {
        this.log(Level.SEVERE, message, param);
    }

    public void severe(String message, Object[] params) {
        this.log(Level.SEVERE, message, params);
    }

    public void warning(Throwable t) {
        this.warning("", t);
    }

    public void warning(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public void warning(String message, Object param) {
        this.log(Level.WARNING, message, param);
    }

    public void warning(String message, Object[] params) {
        this.log(Level.WARNING, message, params);
    }

    public void info(Throwable t) {
        this.info("", t);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void info(String message, Object param) {
        this.log(Level.INFO, message, param);
    }

    public void info(String message, Object[] params) {
        this.log(Level.INFO, message, params);
    }

    public void fine(Throwable t) {
        this.fine("", t);
    }

    public void fine(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    public void fine(String message, Object param) {
        this.log(Level.FINE, message, param);
    }

    public void fine(String message, Object[] params) {
        this.log(Level.FINE, message, params);
    }

    public void finer(Throwable t) {
        this.finer("", t);
    }

    public void finer(String message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    public void finer(String message, Object param) {
        this.log(Level.FINER, message, param);
    }

    public void finer(String message, Object[] params) {
        this.log(Level.FINER, message, params);
    }

    public void finest(Throwable t) {
        this.finest("", t);
    }

    public void finest(String message, Throwable t) {
        this.log(Level.FINEST, message, t);
    }

    public void finest(String message, Object param) {
        this.log(Level.FINEST, message, param);
    }

    public void finest(String message, Object[] params) {
        this.log(Level.FINEST, message, params);
    }

    public boolean isInternal() {
        return this.isLoggable(ADFLoggerLevel.INTERNAL_ERROR);
    }

    public boolean isSevere() {
        return this.isLoggable(Level.SEVERE);
    }

    public boolean isWarning() {
        return this.isLoggable(Level.WARNING);
    }

    public boolean isInfo() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isConfig() {
        return this.isLoggable(Level.CONFIG);
    }

    public boolean isFine() {
        return this.isLoggable(Level.FINE);
    }

    public boolean isFiner() {
        return this.isLoggable(Level.FINER);
    }

    public boolean isFinest() {
        return this.isLoggable(Level.FINEST);
    }

    public static void flush() {
        int i;
        Logger logger = ADFLoggerFactory.getADFLogger(ADF_PERF_LOGGER_NAME, null);
        Handler[] h = logger.getHandlers();
        for (i = 0; i < h.length; ++i) {
            if (!(h[i] instanceof PerfFileHandler)) continue;
            h[i].flush();
        }
        logger = ADFLoggerFactory.getADFLogger(ADF_ANALYTICS_LOGGER_NAME, null);
        h = logger.getHandlers();
        for (i = 0; i < h.length; ++i) {
            if (!(h[i] instanceof AnalyticsFileHandler)) continue;
            h[i].flush();
        }
    }

    @Deprecated
    public static String getECID() {
        String ecid = null;
        try {
            ecid = LoggingUtils.getECID();
            if (ecid != null) {
                ExecutionContext.stash((Object)ecid);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return ecid;
    }

    @Deprecated
    public static void setECID(String ecid) {
        try {
            ExecutionContext.get((Object)ecid);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public String getFormattedMessage(String msg) {
        return this.getFormattedMessage(msg, null);
    }

    public String getFormattedMessage(String msg, Object[] params) {
        String returnMessage = msg;
        this.validateADFLogRecord(msg);
        ADFLogRecord lr = new ADFLogRecord(this.CLAZZ_NAME, Level.ALL, msg);
        ResourceBundle res = null;
        try {
            res = this.getResourceBundle();
            if (res == null) {
                res = this.getParent().getResourceBundle();
            }
            if (res != null) {
                lr.setResourceBundle(res);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (params != null) {
            lr.setParameters(params);
        }
        Handler[] handlers = this.getHandlers();
        Formatter formatter = null;
        if (handlers.length > 0) {
            formatter = handlers[0].getFormatter();
        }
        if (formatter == null) {
            formatter = new SimpleFormatter();
        }
        returnMessage = formatter.formatMessage(lr);
        return returnMessage;
    }

    private void validateADFLogRecord(String msg) {
        if (msg == null) {
            String classPackage = this.mLogger.getName();
            String string = classPackage = classPackage == null ? "" : classPackage;
            if (this.mLogger.isLoggable(Level.WARNING)) {
                this.mLogger.log(Level.WARNING, MessageFormat.format(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("NULL_MESSAGE"), classPackage), stackLogger.isLoggable(Level.FINE) ? new Throwable("DIAGNOSTIC AID, NOT AN ERROR") : null);
            }
        }
    }

    private static ADFLoggerExtension initADFLoggerExtension() {
        ADFLoggerExtension extn = ProviderUtil.loadProviderPlugin(ADFLoggerExtension.class);
        if (extn != null) {
            return extn;
        }
        if (AdfServerPlatformUtil.isODLAvailable() && AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
            try {
                extn = new ADFLoggerExtensionODL();
                if (stackLogger.isLoggable(Level.INFO)) {
                    stackLogger.info("ADFLoggerExtensionODL setup complete");
                }
                return extn;
            }
            catch (Throwable t) {
                stackLogger.log(Level.SEVERE, "ADFLoggerExtensionODL failed", t);
            }
        }
        if (extn != null) {
            return extn;
        }
        if (stackLogger.isLoggable(Level.INFO)) {
            stackLogger.info("Defaulting ADFLoggerExtensionJUL setup");
        }
        return new ADFLoggerExtensionJUL();
    }

    public static BeginEndTracer getBeginEndTracer() {
        return loggerExtn.get().getBeginEndTracer();
    }

    private static BeginEndTracer initBeginEndTracer() {
        BeginEndTracer extn = ProviderUtil.loadProviderPlugin(BeginEndTracer.class);
        if (extn != null) {
            return extn;
        }
        if (extn != null) {
            return extn;
        }
        if (stackLogger.isLoggable(Level.INFO)) {
            stackLogger.info("Defaulting BeginEndTracer setup");
        }
        return new BeginEndTracerNOP();
    }

    static {
        Logger baLogger = ADFLoggerFactory.getADFLogger(ADF_ANALYTICS_LOGGER_NAME, null);
        try {
            AnalyticsFileHandler.setupLoggerHandler(baLogger);
        }
        catch (Throwable t) {
            System.out.println(t.toString());
        }
    }

    static class ExtensionHolder {
        ExtensionHolder() {
        }

        public void set(ADFLoggerExtension extnOverride) {
            throw new UnsupportedOperationException("No per-thread override of ADFLoggerExtension.");
        }

        public ADFLoggerExtension get() {
            return ExtnHolder.INST;
        }
    }

    public static class Builder {
        private final String name;
        private String bundleName = null;
        private String clazzName = null;

        public Builder(String name, String bundleName) {
            if (name == null) {
                throw new IllegalArgumentException(ResourceBundle.getBundle(ADFLogger.ADF_LOGGER_MESSAGE_BUNDLE).getString("LOGGER_NAME_REQUIRED"));
            }
            this.name = name;
            this.bundleName = bundleName;
        }

        public Builder withClazzName(String clazzName) {
            this.clazzName = clazzName;
            return this;
        }

        public Logger getPlatformLogger() {
            return ADFLoggerFactory.getADFLogger(this.name, this.bundleName);
        }

        public String getName() {
            return this.name;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public ADFLogger build() {
            return new ADFLogger(this.getPlatformLogger(), this.getClazzName());
        }
    }

    private static class ADFLoggerLevel
    extends Level {
        private int currentADFLevel;
        private String adfName;
        private static final Level INTERNAL_ERROR = new ADFLoggerLevel("INTERNAL_ERROR", Level.SEVERE.intValue() + 100);
        private static final Level ERROR = Level.SEVERE;
        private static final Level WARNING = Level.WARNING;
        private static final Level NOTIFICATION = Level.INFO;
        private static final Level TRACE = Level.FINE;

        private ADFLoggerLevel(String name, int value) {
            super(name, value, null);
            this.currentADFLevel = value;
            this.adfName = name;
        }

        private Object readResolve() throws ObjectStreamException {
            return new ADFLoggerLevel(this.adfName, this.currentADFLevel);
        }
    }

    static class ExtensionHolderTL
    extends ExtensionHolder {
        private static final ThreadLocal<ADFLoggerExtension> threadLocal = new ThreadLocal<ADFLoggerExtension>(){

            @Override
            protected ADFLoggerExtension initialValue() {
                if (stackLogger.isLoggable(Level.FINEST)) {
                    stackLogger.finest("ADFLoggerExtension defaulting in " + Thread.currentThread());
                }
                return ExtnHolder.INST;
            }
        };

        ExtensionHolderTL() {
        }

        @Override
        public void set(ADFLoggerExtension extnOverride) {
            threadLocal.set(extnOverride);
        }

        @Override
        public ADFLoggerExtension get() {
            return threadLocal.get();
        }
    }

    static final class TracerHolder {
        static final BeginEndTracer INST = ADFLogger.initBeginEndTracer();

        TracerHolder() {
        }
    }

    private static final class ExtnHolder {
        static final ADFLoggerExtension INST = ADFLogger.initADFLoggerExtension();

        private ExtnHolder() {
        }
    }
}

