/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.SecureRandomSpi;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.core.RandomBitsSource;

public abstract class PhaosSecureRandomSpi
extends SecureRandomSpi {
    private static final int DEFAULT_SEED_SIZE = 20;
    private EntropySource es;
    private RandomBitsSource rbs;
    private boolean seeded = false;

    PhaosSecureRandomSpi(RandomBitsSource rbs) {
        this.rbs = rbs;
        this.es = EntropySource.getDefault();
        this.seeded = false;
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] b = new byte[numBytes];
        return this.es.generateBytes(b);
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        if (!this.seeded) {
            this.engineSetSeed(this.engineGenerateSeed(20));
        }
        this.rbs.randomBytes(bytes);
    }

    @Override
    protected void engineSetSeed(byte[] bytes) {
        this.rbs.seed(bytes);
        this.seeded = true;
    }
}

