/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class X509CRLEntryImpl
extends X509CRLEntry
implements ASN1Object {
    private BigInteger serialNo;
    private Date revocationDate;
    private Hashtable extensions;
    private Set criticalOIDs;
    private Set nonCriticalOIDs;
    private ASN1Sequence contents;
    private boolean unsupportedCriticalExtension;

    public X509CRLEntryImpl(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public byte[] getEncoded() {
        return Utils.toBytes((Streamable)this.contents);
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    @Override
    public Date getRevocationDate() {
        return this.revocationDate;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.criticalOIDs;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.nonCriticalOIDs;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        return (byte[])this.extensions.get(oid);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCriticalExtension;
    }

    @Override
    public String toString() {
        String s = "serialNo = " + this.serialNo + ", revocationDate = " + this.revocationDate;
        return s;
    }

    @Override
    public int hashCode() {
        return new String(this.getEncoded()).hashCode();
    }

    public void input(InputStream is) throws IOException {
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.serialNo = new ASN1Integer((InputStream)sis).getValue();
        this.revocationDate = new ASN1Date((InputStream)sis).getValue();
        if (sis.hasMoreData()) {
            ASN1SequenceInputStream extensionsStream = new ASN1SequenceInputStream((InputStream)sis);
            this.extensions = new Hashtable();
            this.criticalOIDs = new HashSet();
            this.nonCriticalOIDs = new HashSet();
            while (extensionsStream.hasMoreData()) {
                ASN1SequenceInputStream extension = new ASN1SequenceInputStream((InputStream)extensionsStream);
                String type = new ASN1ObjectID((InputStream)extension).toStringCompact();
                boolean critical = false;
                if (extension.getCurrentTag() == 1) {
                    critical = ASN1Boolean.inputValue((InputStream)extension);
                }
                if (critical) {
                    this.criticalOIDs.add(type);
                    this.unsupportedCriticalExtension = true;
                } else {
                    this.nonCriticalOIDs.add(type);
                }
                this.extensions.put(type, ASN1OctetString.inputValue((InputStream)extension));
                extension.terminate();
            }
            extensionsStream.terminate();
        } else {
            this.extensions = null;
            this.criticalOIDs = null;
            this.nonCriticalOIDs = null;
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.contents.output(os);
    }

    public int length() {
        return this.contents.length();
    }

    @Override
    public boolean equals(Object o) {
        try {
            if (o != null && o instanceof X509CRLEntry) {
                return Utils.areEqual((byte[])this.getEncoded(), (byte[])((X509CRLEntry)o).getEncoded());
            }
            return false;
        }
        catch (CRLException ex) {
            return false;
        }
    }
}

