/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.binding;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.beans.JavaIntrospector;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.xml.gui.base.binding.BaseDatabindingEditorGui;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.swing.binding.DataboundPropertyEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.DatabindingHandler;
import org.w3c.dom.Node;

public class SwingDatabindingEditorGui
extends BaseDatabindingEditorGui {
    protected static final Border _sEmptyBorder = new EmptyBorder(0, 0, 0, 0);

    public Object getDatabindingObjects(XmlContext context, XmlKey nodeKey, Node node, Node parentNode) {
        ArrayList mainList = new ArrayList();
        return mainList;
    }

    public SwingDatabindingEditorGui(XmlView view) {
        super(view);
    }

    public PropertyEditor getDatabindingPropertyEditor(XmlContext context, XmlKey attrKey, Node node, Node ownerNode) {
        return new DataboundPropertyEditor();
    }

    public JTree createJTree(XmlContext context, XmlKey attrKey, Node node, Node ownerNode) {
        JTree tree = new JTree();
        tree.setRootVisible(false);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        this._insertDatabindingObjects(root, context, attrKey, node, ownerNode);
        tree.setModel(new DefaultTreeModel(root));
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        renderer.setLeafIcon(null);
        tree.setCellRenderer(renderer);
        tree.setShowsRootHandles(true);
        return tree;
    }

    public String getBindingString(XmlContext context, XmlKey key, Node node, Node ownerNode, TreePath path) {
        DatabindingHandler handler = this.getDatabindingHandler(key);
        if (handler == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(path.getPathCount());
        Object[] pathArray = path.getPath();
        for (int i = 0; i < pathArray.length; ++i) {
            list.add(pathArray[i].toString());
        }
        return handler.getDataboundExpression(context, key, node, ownerNode, list);
    }

    public TableCellEditor createInPlaceEditor(Locale locale, XmlContext context, XmlKey attrKey, Node node, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        Set s = this._getAttributeValues(attrKey, node, ownerNode, ownerKey, nearestAncestor, targetNode);
        if (s.isEmpty()) {
            JTextField field = this.createTextField(context, attrKey, node, ownerNode, false);
            field.setLocale(locale);
            return new DefaultCellEditor(field);
        }
        JComboBox box = this.createComboBox(s.toArray(), context, attrKey, node, ownerNode);
        box.setLocale(locale);
        return new DefaultCellEditor(box);
    }

    public Component createInlineEditorComponent(Locale locale, XmlContext context, XmlKey attrKey, Node node, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        Set s = this._getAttributeValues(attrKey, node, ownerNode, ownerKey, nearestAncestor, targetNode);
        if (s.isEmpty()) {
            JTextField field = this.createTextField(context, attrKey, node, ownerNode, true);
            if (locale != null) {
                field.setLocale(locale);
            }
            return field;
        }
        JComboBox box = this.createComboBox(s.toArray(), context, attrKey, node, ownerNode);
        if (locale != null) {
            box.setLocale(locale);
        }
        return box;
    }

    public Component createExpressionComponent(final DataboundPropertyEditor editor, int preferredColumns, XmlContext context, XmlKey attrKey, Node node, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        Set s = this._getAttributeValues(attrKey, node, ownerNode, ownerKey, nearestAncestor, targetNode);
        if (s.isEmpty()) {
            JTextField expression = this.createTextField(context, attrKey, node, ownerNode, true);
            this._initTextField(expression, editor, preferredColumns);
            return expression;
        }
        final JComboBox box = this.createComboBox(s.toArray(), context, attrKey, node, ownerNode);
        ComboBoxEditor ce = box.getEditor();
        if (ce.getEditorComponent() instanceof JTextField) {
            JTextField expression = (JTextField)ce.getEditorComponent();
            this._initTextField(expression, editor, preferredColumns);
        } else {
            ce.getEditorComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    Object o = box.getSelectedItem();
                    String s = o == null ? null : o.toString();
                    editor.expressionComponentLostFocus(s);
                }
            });
        }
        return box;
    }

    public void setExpression(Component c, String expression) {
        if (c instanceof JTextField) {
            ((JTextField)c).setText(expression);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).setSelectedItem(expression);
        }
    }

    public String getExpression(Component c) {
        if (c instanceof JTextField) {
            return ((JTextField)c).getText();
        }
        if (c instanceof JComboBox) {
            Object o = ((JComboBox)c).getSelectedItem();
            return o == null ? null : o.toString();
        }
        return null;
    }

    public JTextField createTextField(XmlContext context, XmlKey attrKey, Node node, Node ownerNode, boolean border) {
        return border ? new JTextField() : new NoBorderTextField();
    }

    public JTextArea createTextArea(XmlContext context, XmlKey attrKey, Node node, Node ownerNode, boolean border) {
        return border ? new JTextArea() : new NoBorderTextArea();
    }

    public JComboBox createComboBox(Object[] objects, XmlContext context, XmlKey attrKey, Node node, Node ownerNode) {
        return new JComboBox<Object>(objects);
    }

    private Set _getAttributeValues(XmlKey attrKey, Node attr, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        BaseInspectorGui gui = (BaseInspectorGui)this.getGuiContext().getGui(XmlUsage.PROPERTY_INSPECTOR);
        Set s = gui.getAttributeValues(attr, attrKey, (Object)(attr != null ? attr.getNodeValue() : null), ownerNode, ownerKey, nearestAncestor, targetNode);
        return s;
    }

    private void _initTextField(final JTextField expression, final DataboundPropertyEditor editor, int preferredColumns) {
        expression.setColumns(preferredColumns);
        expression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                editor.expressionChanged(expression.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                editor.expressionChanged(expression.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                editor.expressionChanged(expression.getText());
            }
        });
        expression.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                editor.expressionComponentLostFocus(expression.getText());
            }
        });
    }

    private void _insertDatabindingObjects(DefaultMutableTreeNode treeNode, XmlContext context, XmlKey attrKey, Node node, Node ownerNode) {
        Object object = this.getDatabindingObjects(context, attrKey, node, ownerNode);
        if (object != null) {
            this._insertObject(treeNode, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _insertObject(DefaultMutableTreeNode parent, Object o) {
        if (o instanceof String || o instanceof StringBuffer) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(o);
            parent.add(child);
            return;
        } else {
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    this._insertObject(parent, i.next());
                }
                return;
            }
            if (o instanceof Map) {
                Map m = (Map)o;
                Iterator i = m.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(key);
                    parent.add(child);
                    this._insertObject(child, m.get(key));
                }
                return;
            }
            if (o == null) return;
            try {
                BeanInfo info = JavaIntrospector.getBeanInfo(o.getClass());
                if (info == null) return;
                PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                if (descriptors == null) {
                    return;
                }
                int n = descriptors.length;
                int count = n;
                if (count == 0) return;
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(o);
                parent.add(child);
                int i = 0;
                while (i < count) {
                    Object value;
                    PropertyDescriptor pd = descriptors[i];
                    if (!"class".equalsIgnoreCase(pd.getName()) && (value = pd.getReadMethod().invoke(o, null)) != null) {
                        DefaultMutableTreeNode pChild = new DefaultMutableTreeNode(pd.getName());
                        child.add(pChild);
                        this._insertObject(pChild, value);
                    }
                    ++i;
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final PropertyDescriptor[] _getProperties(Class c) {
        try {
            BeanInfo bi;
            if (c != null && (bi = Introspector.getBeanInfo(c, c.getSuperclass())) != null) {
                PropertyDescriptor[] pd = bi.getPropertyDescriptors();
                int count = pd == null ? 0 : pd.length;
                ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(count);
                for (int i = 0; i < count; ++i) {
                    if ("class".equalsIgnoreCase(pd[i].getName())) continue;
                    list.add(pd[i]);
                }
                if (list.size() > 0) {
                    return list.toArray(new PropertyDescriptor[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static final PropertyDescriptor[] _getProperties(String s) {
        try {
            Class<?> c = Class.forName(s);
            return SwingDatabindingEditorGui._getProperties(c);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final PropertyDescriptor[] _getProperties(Object o) {
        if (o == null) {
            return null;
        }
        try {
            Class<?> c = o.getClass();
            return SwingDatabindingEditorGui._getProperties(c);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class NoBorderTextField
    extends JTextField {
        private NoBorderTextField() {
        }

        @Override
        public Border getBorder() {
            return _sEmptyBorder;
        }
    }

    private class NoBorderTextArea
    extends JTextArea {
        private NoBorderTextArea() {
        }

        @Override
        public Border getBorder() {
            return _sEmptyBorder;
        }
    }

    private static class PropertyDescriptorComparator
    implements Comparator {
        private PropertyDescriptorComparator() {
        }

        public int compare(Object o1, Object o2) {
            Collator sorter = Collator.getInstance(LocaleUtils.ENGLISH);
            PropertyDescriptor pd1 = (PropertyDescriptor)o1;
            PropertyDescriptor pd2 = (PropertyDescriptor)o2;
            return sorter.compare(pd1.getDisplayName(), pd2.getDisplayName());
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }
    }
}

