/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.swing.action.ConvertAction;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.convert.Convertible;
import oracle.bali.xml.model.convert.XmlKeyConvertibleMarker;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlKeyConvertible
extends Convertible
implements XmlKeyConvertibleMarker {
    protected final XmlContext _context;
    protected final XmlKey _key;

    public XmlKeyConvertible(XmlContext context, XmlKey key) {
        this._context = context;
        this._key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CategoryDefinition getCategory() {
        this._context.getModel().acquireReadLock();
        try {
            XmlMetadataResolver resolver = this._context.getModel().getXmlMetadataResolver();
            List catDefs = resolver.getCategoryDefinition(this._key);
            if (catDefs != null && !catDefs.isEmpty()) {
                CategoryDefinition categoryDefinition = (CategoryDefinition)catDefs.get(0);
                return categoryDefinition;
            }
        }
        finally {
            this._context.getModel().releaseReadLock();
        }
        return null;
    }

    public String getDisplayName() {
        this._context.getModel().acquireReadLock();
        try {
            XmlMetadataResolver resolver = this._context.getModel().getXmlMetadataResolver();
            String string = resolver.getShortDisplayName(this._key);
            return string;
        }
        finally {
            this._context.getModel().releaseReadLock();
        }
    }

    public String getShortDescription() {
        this._context.getModel().acquireReadLock();
        try {
            XmlMetadataResolver resolver = this._context.getModel().getXmlMetadataResolver();
            String string = resolver.getShortDescription(this._key);
            return string;
        }
        finally {
            this._context.getModel().releaseReadLock();
        }
    }

    public Icon getIcon() {
        this._context.getModel().acquireReadLock();
        try {
            XmlMetadataResolver resolver = this._context.getModel().getXmlMetadataResolver();
            Icon icon = resolver.getSmallIcon(this._key);
            return icon;
        }
        finally {
            this._context.getModel().releaseReadLock();
        }
    }

    public boolean doConvert(final Node nodeToConvert) throws XmlCommitException {
        if (nodeToConvert == null) {
            return false;
        }
        XmlModel model = this._context.getModel();
        return new StandardTransactionTask(){

            protected void performTask(AbstractModel model) {
                Selection baseSelection = model.getBaseModel().getSelection();
                DomPosition oldCursorLocation = baseSelection.getCursorLocation();
                HashSet invalidNodes = new HashSet();
                Node convertedNode = XmlModelUtils.convert((XmlModel)model.getBaseModel(), (Node)nodeToConvert, (XmlKey)XmlKeyConvertible.this._key, invalidNodes);
                if (convertedNode != null && invalidNodes.size() > 0 && !XmlKeyConvertible.this.displayInvalidNodes(model, invalidNodes)) {
                    convertedNode = null;
                }
                if (convertedNode == null) {
                    this.cancelTask();
                }
                baseSelection.set(convertedNode);
                if (oldCursorLocation != null && oldCursorLocation.getTargetNode() == nodeToConvert) {
                    baseSelection.setCursorLocation(oldCursorLocation.getRetargetedPosition(convertedNode, true));
                }
            }

            protected String computeTransactionName(AbstractModel model) {
                XmlMetadataResolver baseResolver = model.getBaseModel().getXmlMetadataResolver();
                return model.getTranslatedString("CONVERT_ACTION_FORMAT", baseResolver.getMediumDisplayName(nodeToConvert));
            }
        }.runThrowingXCE((AbstractModel)model);
    }

    public boolean equals(Object o) {
        return o instanceof XmlKeyConvertible && ((XmlKeyConvertible)((Object)o))._key.equals((Object)this._key);
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public boolean matchesXmlKey(XmlKey matchKey) {
        return this._key.equals((Object)matchKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean displayInvalidNodes(AbstractModel modelForTxn, Set invalidNodes) {
        ArrayList<Node> invalidElements = new ArrayList<Node>();
        ArrayList<Node> invalidAttributes = new ArrayList<Node>();
        XmlContext context = modelForTxn.getContext();
        XmlModel model = context.getModel();
        String title = model.getTranslatedString("ConversionResults");
        String elementsLabelString = model.getTranslatedString("Elements");
        String attributesLabelString = model.getTranslatedString("Attributes");
        block6: for (Node invalidNode : invalidNodes) {
            switch (invalidNode.getNodeType()) {
                case 2: {
                    invalidAttributes.add(invalidNode);
                    continue block6;
                }
            }
            invalidElements.add(invalidNode);
        }
        JEWTDialog dialog = JEWTDialog.createDialog((Component)UIUtils.getParentFrame(context), (String)title, (int)3);
        JPanel invalidPanel = new JPanel(new BorderLayout(3, 3));
        invalidPanel.add((Component)new MultiLineLabel(model.getTranslatedString("BelowAreInvalid")), "North");
        if (!invalidElements.isEmpty()) {
            JList invalidElementsList = new JList(new InvalidNodesListModel(invalidElements, model));
            invalidElementsList.setSelectionMode(0);
            invalidElementsList.setVisibleRowCount(4);
            JScrollPane elementsScrollPane = new JScrollPane(invalidElementsList);
            JLabel elementsLabel = new JLabel(StringUtils.stripMnemonic((String)elementsLabelString));
            elementsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)elementsLabelString));
            elementsLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)elementsLabelString));
            elementsLabel.setLabelFor(invalidElementsList);
            JPanel elementTablePanel = new JPanel(new BorderLayout(3, 3));
            elementTablePanel.add((Component)elementsLabel, "North");
            elementTablePanel.add((Component)elementsScrollPane, "Center");
            JButton convertButton = new JButton(new DoConvertAction(modelForTxn, invalidElements, invalidElementsList));
            invalidElementsList.setSelectedIndex(0);
            JPanel buttonPanel = new JPanel(new BorderLayout(3, 3));
            ButtonBar bar = new ButtonBar();
            bar.setOrientation(1);
            bar.add((Component)convertButton);
            buttonPanel.add("North", (Component)bar);
            elementTablePanel.add((Component)buttonPanel, "East");
            invalidPanel.add((Component)elementTablePanel, "Center");
        }
        if (!invalidAttributes.isEmpty()) {
            JList invalidAttributesList = new JList(new InvalidNodesListModel(invalidAttributes, model));
            invalidAttributesList.setSelectionMode(0);
            invalidAttributesList.setVisibleRowCount(3);
            invalidAttributesList.setSelectedIndex(0);
            JScrollPane attributesScrollPane = new JScrollPane(invalidAttributesList);
            JLabel attributesLabel = new JLabel(StringUtils.stripMnemonic((String)attributesLabelString));
            attributesLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)attributesLabelString));
            attributesLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)attributesLabelString));
            attributesLabel.setLabelFor(invalidAttributesList);
            JPanel attributesTablePanel = new JPanel(new BorderLayout(3, 3));
            attributesTablePanel.add((Component)attributesLabel, "North");
            attributesTablePanel.add((Component)attributesScrollPane, "Center");
            invalidPanel.add((Component)attributesTablePanel, "South");
        }
        dialog.setContent((Component)invalidPanel);
        dialog.setResizable(true);
        try {
            XmlModelUtils.setModalDialogRunning((boolean)true);
            if (dialog.runDialog()) {
                Iterator iter = invalidElements.iterator();
                while (iter.hasNext()) {
                    XmlKeyConvertible._removeInvalidNode((Node)iter.next());
                }
                iter = invalidAttributes.iterator();
                while (iter.hasNext()) {
                    XmlKeyConvertible._removeInvalidNode((Node)iter.next());
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            XmlModelUtils.setModalDialogRunning((boolean)false);
        }
        return false;
    }

    private static void _removeInvalidNode(Node invalidNode) {
        if (2 == invalidNode.getNodeType()) {
            Attr attr = (Attr)invalidNode;
            Element ownerElement = attr.getOwnerElement();
            ownerElement.removeAttributeNode(attr);
        } else {
            Node parentNode = invalidNode.getParentNode();
            parentNode.removeChild(invalidNode);
        }
    }

    private static class InvalidNodesListModel
    extends AbstractListModel {
        private XmlModel _model;
        private ArrayList _invalidNodes;

        public InvalidNodesListModel(ArrayList invalidNodes, XmlModel model) {
            this._invalidNodes = invalidNodes;
            this._model = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getElementAt(int index) {
            Node invalidNode = (Node)this._invalidNodes.get(index);
            this._model.acquireReadLock();
            try {
                String string = this._model.getXmlMetadataResolver().getShortDisplayName(invalidNode);
                return string;
            }
            finally {
                this._model.releaseReadLock();
            }
        }

        @Override
        public int getSize() {
            return this._invalidNodes.size();
        }
    }

    private static class DoConvertAction
    extends AbstractAction
    implements ListSelectionListener {
        private final AbstractModel _modelForTxn;
        private final ArrayList _invalidNodes;
        private final JList _invalidNodesList;

        public DoConvertAction(AbstractModel modelForTxn, ArrayList invalidNodes, JList invalidNodesTable) {
            this._modelForTxn = modelForTxn;
            this._invalidNodes = invalidNodes;
            this._invalidNodesList = invalidNodesTable;
            this.setEnabled(false);
            this._invalidNodesList.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Node nodeToConvert = this._getSelectedNode();
            if (nodeToConvert != null) {
                try {
                    boolean ok = ConvertAction.launchDialog(this._modelForTxn, nodeToConvert);
                    if (ok) {
                        this._invalidNodesList.clearSelection();
                        this._invalidNodes.remove(nodeToConvert);
                        this._invalidNodes.trimToSize();
                        this._invalidNodesList.revalidate();
                    }
                }
                catch (XmlCommitException xmlCommitException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
        }

        private Node _getSelectedNode() {
            int selRow = this._invalidNodesList.getSelectedIndex();
            if (selRow != -1 && selRow < this._invalidNodes.size()) {
                return (Node)this._invalidNodes.get(selRow);
            }
            return null;
        }
    }
}

