/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.parser.DocumentTypeInfo;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.javatools.buffer.TextBuffer;

public class InsightLocation {
    private List _elementDecls = null;
    private NamespaceDeclarations _namespaceDecls = null;
    private TextBuffer _buffer = null;
    private LocatorManager _manager = null;
    private int _caretPosition = -1;
    private DocumentTypeInfo _doctype = null;
    private TextInfo _textInfo = null;

    public InsightLocation(TextBuffer buffer, int caretPosition) {
        this._buffer = buffer;
        this._caretPosition = caretPosition;
        this._manager = new LocatorManager(buffer.getLineMap());
        this._elementDecls = new ArrayList();
        this._namespaceDecls = new NamespaceDeclarations();
    }

    public List getElementDeclarations() {
        return this._elementDecls;
    }

    public void append(ElementDeclaration elementDecl) {
        this._elementDecls.add(elementDecl);
    }

    public void remove(ResolvedName name) {
        for (int i = this._elementDecls.size() - 1; i >= 0; --i) {
            ElementDeclaration elementDecl = (ElementDeclaration)this._elementDecls.get(i);
            ResolvedName test = elementDecl.getResolvedName();
            if (test == null || !test.matches(name)) continue;
            this._elementDecls.remove(i);
            break;
        }
    }

    public NamespaceDeclarations getNamespaceDeclarations() {
        return this._namespaceDecls;
    }

    public TextBuffer getTextBuffer() {
        return this._buffer;
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public LocatorManager getLocatorManager() {
        return this._manager;
    }

    public void setDocumentType(DocumentTypeInfo doctype) {
        this._doctype = doctype;
    }

    public DocumentTypeInfo getDocumentType() {
        return this._doctype;
    }

    public void setCurrentTextInfo(TextInfo textInfo) {
        this._textInfo = textInfo;
    }

    public TextInfo getCurrentTextInfo() {
        return this._textInfo;
    }
}

