/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasetools.model.RemoveResourceLockDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemoveDatabaseToolsConnectionLockRequest
extends BmcRequest<RemoveResourceLockDetails> {
    private String databaseToolsConnectionId;
    private RemoveResourceLockDetails removeResourceLockDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getDatabaseToolsConnectionId() {
        return this.databaseToolsConnectionId;
    }

    public RemoveResourceLockDetails getRemoveResourceLockDetails() {
        return this.removeResourceLockDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public RemoveResourceLockDetails getBody$() {
        return this.removeResourceLockDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseToolsConnectionId(this.databaseToolsConnectionId).removeResourceLockDetails(this.removeResourceLockDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseToolsConnectionId=").append(String.valueOf(this.databaseToolsConnectionId));
        sb.append(",removeResourceLockDetails=").append(String.valueOf((Object)this.removeResourceLockDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveDatabaseToolsConnectionLockRequest)) {
            return false;
        }
        RemoveDatabaseToolsConnectionLockRequest other = (RemoveDatabaseToolsConnectionLockRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseToolsConnectionId, other.databaseToolsConnectionId) && Objects.equals((Object)this.removeResourceLockDetails, (Object)other.removeResourceLockDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseToolsConnectionId == null ? 43 : this.databaseToolsConnectionId.hashCode());
        result = result * 59 + (this.removeResourceLockDetails == null ? 43 : this.removeResourceLockDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveDatabaseToolsConnectionLockRequest, RemoveResourceLockDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseToolsConnectionId = null;
        private RemoveResourceLockDetails removeResourceLockDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder databaseToolsConnectionId(String databaseToolsConnectionId) {
            this.databaseToolsConnectionId = databaseToolsConnectionId;
            return this;
        }

        public Builder removeResourceLockDetails(RemoveResourceLockDetails removeResourceLockDetails) {
            this.removeResourceLockDetails = removeResourceLockDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveDatabaseToolsConnectionLockRequest o) {
            this.databaseToolsConnectionId(o.getDatabaseToolsConnectionId());
            this.removeResourceLockDetails(o.getRemoveResourceLockDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveDatabaseToolsConnectionLockRequest build() {
            RemoveDatabaseToolsConnectionLockRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RemoveResourceLockDetails body) {
            this.removeResourceLockDetails(body);
            return this;
        }

        public RemoveDatabaseToolsConnectionLockRequest buildWithoutInvocationCallback() {
            RemoveDatabaseToolsConnectionLockRequest request = new RemoveDatabaseToolsConnectionLockRequest();
            request.databaseToolsConnectionId = this.databaseToolsConnectionId;
            request.removeResourceLockDetails = this.removeResourceLockDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

