/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Function;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultExpr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Expr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.FunctionCallExpr;

class DefaultFunctionCallExpr
extends DefaultExpr
implements FunctionCallExpr {
    private String prefix;
    private String functionName;
    private List parameters;

    public DefaultFunctionCallExpr(String string, String string2) {
        this.prefix = string;
        this.functionName = string2;
        this.parameters = new ArrayList();
    }

    @Override
    public void addParameter(Expr expr) {
        this.parameters.add(expr);
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPrefix();
        if (string != null && !string.equals("")) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        stringBuffer.append(this.getFunctionName());
        stringBuffer.append("(");
        Iterator iterator = this.getParameters().iterator();
        Expr expr = null;
        while (iterator.hasNext()) {
            expr = (Expr)iterator.next();
            stringBuffer.append(expr.getText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public Expr simplify() {
        List list = this.getParameters();
        int n = list.size();
        Expr expr = null;
        ArrayList<Expr> arrayList = new ArrayList<Expr>(n);
        for (int i = 0; i < n; ++i) {
            expr = (Expr)list.get(i);
            arrayList.add(expr.simplify());
        }
        this.parameters = arrayList;
        return this;
    }

    public String toString() {
        String string = this.getPrefix();
        if (string == null) {
            return "[(DefaultFunctionCallExpr): " + this.getFunctionName() + "(" + this.getParameters() + ") ]";
        }
        return "[(DefaultFunctionCallExpr): " + this.getPrefix() + ":" + this.getFunctionName() + "(" + this.getParameters() + ") ]";
    }

    @Override
    public Object evaluate(Context context) throws JaxenException {
        String string = context.translateNamespacePrefixToUri(this.getPrefix());
        Function function = context.getFunction(string, this.getPrefix(), this.getFunctionName());
        List list = this.getParameters();
        int n = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        Expr expr = null;
        Object object = null;
        for (int i = 0; i < n; ++i) {
            expr = (Expr)list.get(i);
            object = expr.evaluate(context);
            arrayList.add(object);
        }
        return function.call(context, arrayList);
    }
}

