/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.adapter;

import java.util.Iterator;
import org.xmlpull.v1.builder.Iterable;
import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlContainer;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;

public class XmlElementAdapter
implements XmlElement {
    private XmlElementAdapter topAdapter;
    private XmlElement target;
    private XmlContainer parent;

    public XmlElementAdapter(XmlElement xmlElement) {
        this.setTarget(xmlElement);
    }

    private void setTarget(XmlElement xmlElement) {
        Object object;
        this.target = xmlElement;
        if (xmlElement.getParent() != null) {
            this.parent = xmlElement.getParent();
            if (this.parent instanceof XmlDocument) {
                object = (XmlDocument)this.parent;
                object.setDocumentElement(this);
            }
            if (this.parent instanceof XmlElement) {
                object = (XmlElement)this.parent;
                object.replaceChild(this, xmlElement);
            }
        }
        object = xmlElement.children();
        while (object.hasNext()) {
            Object e = object.next();
            this.fixImportedChildParent(e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XmlElementAdapter xmlElementAdapter = (XmlElementAdapter)super.clone();
        xmlElementAdapter.parent = null;
        xmlElementAdapter.target = (XmlElement)this.target.clone();
        return xmlElementAdapter;
    }

    public XmlElement getTarget() {
        return this.target;
    }

    public XmlElementAdapter getTopAdapter() {
        return this.topAdapter != null ? this.topAdapter : this;
    }

    public void setTopAdapter(XmlElementAdapter xmlElementAdapter) {
        this.topAdapter = xmlElementAdapter;
        if (this.target instanceof XmlElementAdapter) {
            ((XmlElementAdapter)this.target).setTopAdapter(xmlElementAdapter);
        }
    }

    public static XmlElementAdapter castOrWrap(XmlElement xmlElement, Class clazz) {
        if (xmlElement == null) {
            throw new IllegalArgumentException("null element can not be wrapped");
        }
        if (!XmlElementAdapter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("class for cast/wrap must extend " + XmlElementAdapter.class);
        }
        if (xmlElement instanceof XmlElementAdapter) {
            XmlElementAdapter xmlElementAdapter = (XmlElementAdapter)xmlElement;
            Class<?> clazz2 = xmlElementAdapter.getClass();
            if (clazz.isAssignableFrom(clazz2)) {
                return xmlElementAdapter;
            }
            XmlElementAdapter xmlElementAdapter2 = xmlElementAdapter = xmlElementAdapter.getTopAdapter();
            while (xmlElementAdapter.topAdapter != null) {
                clazz2 = xmlElementAdapter.getClass();
                if (clazz2.isAssignableFrom(clazz)) {
                    return xmlElementAdapter;
                }
                if (!(xmlElementAdapter.target instanceof XmlElementAdapter)) break;
                xmlElementAdapter = (XmlElementAdapter)xmlElementAdapter.target;
            }
            try {
                xmlElementAdapter.topAdapter = (XmlElementAdapter)clazz.getConstructor(XmlElement.class).newInstance(xmlElementAdapter2);
                xmlElementAdapter.topAdapter.setTopAdapter(xmlElementAdapter.topAdapter);
                return xmlElementAdapter.topAdapter;
            }
            catch (Exception exception) {
                throw new XmlBuilderException("could not create wrapper of " + clazz, exception);
            }
        }
        try {
            XmlElementAdapter xmlElementAdapter = (XmlElementAdapter)clazz.getConstructor(XmlElement.class).newInstance(xmlElement);
            return xmlElementAdapter;
        }
        catch (Exception exception) {
            throw new XmlBuilderException("could not wrap element " + xmlElement, exception);
        }
    }

    private void fixImportedChildParent(Object object) {
        XmlElement xmlElement;
        XmlContainer xmlContainer;
        if (object instanceof XmlElement && (xmlContainer = (xmlElement = (XmlElement)object).getParent()) == this.target) {
            xmlElement.setParent(this);
        }
    }

    private XmlElement fixElementParent(XmlElement xmlElement) {
        xmlElement.setParent(this);
        return xmlElement;
    }

    @Override
    public XmlContainer getRoot() {
        XmlContainer xmlContainer = this.target.getRoot();
        if (xmlContainer == this.target) {
            xmlContainer = this;
        }
        return xmlContainer;
    }

    @Override
    public XmlContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XmlContainer xmlContainer) {
        this.parent = xmlContainer;
    }

    @Override
    public XmlNamespace newNamespace(String string, String string2) {
        return this.target.newNamespace(string, string2);
    }

    @Override
    public XmlAttribute attribute(String string) {
        return this.target.attribute(string);
    }

    @Override
    public XmlAttribute attribute(XmlNamespace xmlNamespace, String string) {
        return this.target.attribute(xmlNamespace, string);
    }

    @Override
    public XmlAttribute findAttribute(String string, String string2) {
        return this.target.findAttribute(string, string2);
    }

    @Override
    public Iterator attributes() {
        return this.target.attributes();
    }

    @Override
    public void removeAllChildren() {
        this.target.removeAllChildren();
    }

    @Override
    public XmlAttribute addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return this.target.addAttribute(string, string2, string3, string4, string5, bl);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return this.target.getAttributeValue(string, string2);
    }

    @Override
    public XmlAttribute addAttribute(XmlNamespace xmlNamespace, String string, String string2) {
        return this.target.addAttribute(xmlNamespace, string, string2);
    }

    @Override
    public String getNamespaceName() {
        return this.target.getNamespaceName();
    }

    @Override
    public void ensureChildrenCapacity(int n) {
        this.target.ensureChildrenCapacity(n);
    }

    @Override
    public Iterator namespaces() {
        return this.target.namespaces();
    }

    @Override
    public void removeAllAttributes() {
        this.target.removeAllAttributes();
    }

    @Override
    public XmlNamespace getNamespace() {
        return this.target.getNamespace();
    }

    @Override
    public String getBaseUri() {
        return this.target.getBaseUri();
    }

    @Override
    public void removeAttribute(XmlAttribute xmlAttribute) {
        this.target.removeAttribute(xmlAttribute);
    }

    @Override
    public XmlNamespace declareNamespace(String string, String string2) {
        return this.target.declareNamespace(string, string2);
    }

    @Override
    public void removeAllNamespaceDeclarations() {
        this.target.removeAllNamespaceDeclarations();
    }

    @Override
    public boolean hasAttributes() {
        return this.target.hasAttributes();
    }

    @Override
    public XmlAttribute addAttribute(String string, XmlNamespace xmlNamespace, String string2, String string3, boolean bl) {
        return this.target.addAttribute(string, xmlNamespace, string2, string3, bl);
    }

    @Override
    public XmlNamespace declareNamespace(XmlNamespace xmlNamespace) {
        return this.target.declareNamespace(xmlNamespace);
    }

    @Override
    public XmlAttribute addAttribute(String string, String string2) {
        return this.target.addAttribute(string, string2);
    }

    @Override
    public boolean hasNamespaceDeclarations() {
        return this.target.hasNamespaceDeclarations();
    }

    @Override
    public XmlNamespace lookupNamespaceByName(String string) {
        XmlContainer xmlContainer;
        XmlNamespace xmlNamespace = this.target.lookupNamespaceByName(string);
        if (xmlNamespace == null && (xmlContainer = this.getParent()) instanceof XmlElement) {
            XmlElement xmlElement = (XmlElement)xmlContainer;
            return xmlElement.lookupNamespaceByName(string);
        }
        return xmlNamespace;
    }

    @Override
    public XmlNamespace lookupNamespaceByPrefix(String string) {
        XmlContainer xmlContainer;
        XmlNamespace xmlNamespace = this.target.lookupNamespaceByPrefix(string);
        if (xmlNamespace == null && (xmlContainer = this.getParent()) instanceof XmlElement) {
            XmlElement xmlElement = (XmlElement)xmlContainer;
            return xmlElement.lookupNamespaceByPrefix(string);
        }
        return xmlNamespace;
    }

    @Override
    public XmlNamespace newNamespace(String string) {
        return this.target.newNamespace(string);
    }

    @Override
    public void setBaseUri(String string) {
        this.target.setBaseUri(string);
    }

    @Override
    public void setNamespace(XmlNamespace xmlNamespace) {
        this.target.setNamespace(xmlNamespace);
    }

    @Override
    public void ensureNamespaceDeclarationsCapacity(int n) {
        this.target.ensureNamespaceDeclarationsCapacity(n);
    }

    @Override
    public String getName() {
        return this.target.getName();
    }

    @Override
    public void setName(String string) {
        this.target.setName(string);
    }

    @Override
    public XmlAttribute addAttribute(String string, XmlNamespace xmlNamespace, String string2, String string3) {
        return this.target.addAttribute(string, xmlNamespace, string2, string3);
    }

    @Override
    public void ensureAttributeCapacity(int n) {
        this.target.ensureAttributeCapacity(n);
    }

    @Override
    public XmlAttribute addAttribute(XmlAttribute xmlAttribute) {
        return this.target.addAttribute(xmlAttribute);
    }

    @Override
    public XmlElement element(int n) {
        return this.target.element(n);
    }

    @Override
    public XmlElement requiredElement(XmlNamespace xmlNamespace, String string) {
        return this.target.requiredElement(xmlNamespace, string);
    }

    @Override
    public XmlElement element(XmlNamespace xmlNamespace, String string) {
        return this.target.element(xmlNamespace, string);
    }

    @Override
    public XmlElement element(XmlNamespace xmlNamespace, String string, boolean bl) {
        return this.target.element(xmlNamespace, string, bl);
    }

    @Override
    public Iterable elements(XmlNamespace xmlNamespace, String string) {
        return this.target.elements(xmlNamespace, string);
    }

    @Override
    public XmlElement findElementByName(String string, XmlElement xmlElement) {
        return this.target.findElementByName(string, xmlElement);
    }

    @Override
    public XmlElement newElement(XmlNamespace xmlNamespace, String string) {
        return this.target.newElement(xmlNamespace, string);
    }

    @Override
    public XmlElement addElement(XmlElement xmlElement) {
        return this.fixElementParent(this.target.addElement(xmlElement));
    }

    @Override
    public XmlElement addElement(int n, XmlElement xmlElement) {
        return this.fixElementParent(this.target.addElement(n, xmlElement));
    }

    @Override
    public XmlElement addElement(String string) {
        return this.fixElementParent(this.target.addElement(string));
    }

    @Override
    public XmlElement findElementByName(String string, String string2) {
        return this.target.findElementByName(string, string2);
    }

    @Override
    public void addChild(Object object) {
        this.target.addChild(object);
        this.fixImportedChildParent(object);
    }

    @Override
    public void insertChild(int n, Object object) {
        this.target.insertChild(n, object);
        this.fixImportedChildParent(object);
    }

    @Override
    public XmlElement findElementByName(String string) {
        return this.target.findElementByName(string);
    }

    @Override
    public XmlElement findElementByName(String string, String string2, XmlElement xmlElement) {
        return this.target.findElementByName(string, string2, xmlElement);
    }

    @Override
    public void removeChild(Object object) {
        this.target.removeChild(object);
    }

    @Override
    public Iterator children() {
        return this.target.children();
    }

    @Override
    public Iterable requiredElementContent() {
        return this.target.requiredElementContent();
    }

    @Override
    public String requiredTextContent() {
        return this.target.requiredTextContent();
    }

    @Override
    public boolean hasChild(Object object) {
        return this.target.hasChild(object);
    }

    @Override
    public XmlElement newElement(String string, String string2) {
        return this.target.newElement(string, string2);
    }

    @Override
    public XmlElement addElement(XmlNamespace xmlNamespace, String string) {
        return this.fixElementParent(this.target.addElement(xmlNamespace, string));
    }

    @Override
    public boolean hasChildren() {
        return this.target.hasChildren();
    }

    @Override
    public void addChild(int n, Object object) {
        this.target.addChild(n, object);
        this.fixImportedChildParent(object);
    }

    @Override
    public void replaceChild(Object object, Object object2) {
        this.target.replaceChild(object, object2);
        this.fixImportedChildParent(object);
    }

    @Override
    public XmlElement newElement(String string) {
        return this.target.newElement(string);
    }

    @Override
    public void replaceChildrenWithText(String string) {
        this.target.replaceChildrenWithText(string);
    }
}

