/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.tocNavigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;

public class TOCUtils {
    public static TopicTreeNode findClosestMatchingNode(TopicTreeNode current, URL url, List tocViews) {
        int closestDistance = Integer.MAX_VALUE;
        TopicTreeNode closestMatch = null;
        if (url != null) {
            int matchIter = 0;
            for (int iter = 0; iter < tocViews.size(); ++iter) {
                Vector matches;
                View aView = (View)tocViews.get(iter);
                TopicTree aTree = TOCUtils.getTopicTree(aView);
                if (aTree == null || (matches = aTree.findNodesForURL(url)) == null) continue;
                for (matchIter = 0; matchIter < matches.size(); ++matchIter) {
                    TopicTreeNode aMatch = (TopicTreeNode)matches.elementAt(matchIter);
                    int matchDistance = TOCUtils._calculateDistance(current, aMatch);
                    if (matchDistance >= closestDistance) continue;
                    closestMatch = aMatch;
                    closestDistance = matchDistance;
                }
            }
        }
        return closestMatch;
    }

    public static TopicTree getTopicTree(View aView) {
        TopicTree theTree = null;
        if (aView != null) {
            try {
                theTree = (TopicTree)aView.getViewData();
                theTree.findNodesForURL(null);
            }
            catch (Exception e) {
                System.err.println("View passed to RootItemModel does not contain data in TopicTree format.");
                e.printStackTrace();
                theTree = null;
            }
        }
        return theTree;
    }

    private static int _calculateDistance(TopicTreeNode node1, TopicTreeNode node2) {
        TopicTreeNode visitor;
        if (node1 == null || node2 == null) {
            return 0;
        }
        ArrayList<TopicTreeNode> path1 = new ArrayList<TopicTreeNode>();
        ArrayList<TopicTreeNode> path2 = new ArrayList<TopicTreeNode>();
        ArrayList<TopicTreeNode> shared = new ArrayList<TopicTreeNode>();
        for (visitor = node1; visitor != null; visitor = visitor.getParent()) {
            path1.add(visitor);
        }
        for (visitor = node2; visitor != null; visitor = visitor.getParent()) {
            path2.add(visitor);
        }
        for (int iter = 0; iter < path1.size(); ++iter) {
            TopicTreeNode aNode = (TopicTreeNode)path1.get(iter);
            if (!path2.contains(aNode)) continue;
            shared.add(aNode);
        }
        int numEdges = path1.size() + path2.size() - 2 * shared.size();
        return numEdges;
    }
}

