/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.Map;
import java.util.regex.Matcher;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.utils.RDFDBUtils;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public abstract class AbstractRDFActionDialog
extends ActionDialog {
    protected Connection connection = null;
    protected boolean is19cOrAfter = false;
    protected boolean isCompressionEnabled = false;
    protected DBObject nodeObj = null;
    protected Map<String, Object> dict = null;
    protected TextBoxActionControl txtNetworkOwner = null;
    protected TextBoxActionControl txtNetworkName = null;

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.nodeObj = this.getDBObject();
        String string = this.nodeObj.getDBVersion();
        this.is19cOrAfter = RDFStringUtils.isOracle19cOrAfter(string);
        this.isCompressionEnabled = RDFDBUtils.isCompressionEnabled(connection);
        this.dict = this.nodeObj.getDictionary();
        this.initializeCoreUIComponents();
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void initializeCoreUIComponents() {
        String string = (String)this.dict.get("NETWORK_OWNER");
        String string2 = (String)this.dict.get("NETWORK_NAME");
        if (string.equalsIgnoreCase("MDSYS")) {
            string2 = "";
        }
        this.txtNetworkOwner = new TextBoxActionControl("network_owner", RdfgraphArb.getString("NETWORK_OWNER"), string);
        this.txtNetworkOwner.setEditable(false);
        this.txtNetworkName = new TextBoxActionControl("network_name", RdfgraphArb.getString("NETWORK_NAME"), string2);
        this.txtNetworkName.setEditable(false);
    }

    protected String updateScriptNetworkInfo(String string, ActionDialog.Values values) {
        if (string == null) {
            return null;
        }
        if (this.is19cOrAfter) {
            String string2 = values.get("network_owner");
            if (string2 == null || string2.trim().isEmpty() || string2.equalsIgnoreCase("MDSYS")) {
                string = string.replaceAll("#network_owner#", "'MDSYS'");
                string = string.replaceAll("#network_name#", "null");
            } else {
                string = string.replaceAll("#network_owner#", "'" + Matcher.quoteReplacement(values.get("network_owner")) + "'");
                string = string.replaceAll("#network_name#", "'" + Matcher.quoteReplacement(values.get("network_name")) + "'");
            }
        }
        return string;
    }
}

