/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.language;

import oracle.dbtools.rdfgraph.sparql.language.SPARQLBlockRenderer;
import oracle.dbtools.rdfgraph.sparql.language.SPARQLLanguageSupport;
import oracle.dbtools.rdfgraph.sparql.language.SPARQLStyles;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;

public class SPARQLLanguageModule
extends LanguageModule {
    static String RDF_SPARQL_LANG = "SPARQL";
    private static final String[] supportedFileTypes = new String[]{"sparql", "SPARQL"};

    public String getPresentationName() {
        return RDF_SPARQL_LANG;
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public String[] getStyleNames() {
        return SPARQLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        String string = "PREFIX  rdf: <http://xmlns.com/foaf/0.1/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX  owl: <http://www.w3.org/2002/07/owl#>\nPREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX   dc: <http://purl.org/dc/elements/1.1/>\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\n\nSELECT ?s ?p ?o \nWHERE \n  { ?s ?p ?o }";
        return string;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new SPARQLStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new SPARQLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new SPARQLBlockRenderer(textBuffer);
    }
}

