/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.util.classfile.Mutable;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.tools.ToolException;
import sun.tools.java.RuntimeConstants;

class VerifierClassLoader
extends ClassLoader
implements RuntimeConstants {
    private ClassHandle handle;
    private Schema _schema;
    private HashMap referencedHandles;
    private HashMap referencedNames;
    boolean derivedp;
    private Class cl;
    private Throwable exception;
    boolean isLinkException;
    private int[] optInfo;
    private byte[] classBytes;
    private static HashMap handleTable = new HashMap();
    private static byte[] auroraOptInfo = VerifierClassLoader.getUTF8Bytes("aurora_opt_info");
    private static byte[] auroraDeferredError = VerifierClassLoader.getUTF8Bytes("aurora_deferred_error");
    private static int aurora_cp_index;

    VerifierClassLoader(String name, Schema schema, boolean derivedp) {
        this.handle = Handle.lookupClass(name, schema);
        this._schema = schema;
        this.derivedp = derivedp;
        handleTable.put(this.handle, this);
        this.referencedHandles = new HashMap();
        try {
            ClassHandle[] handles = this.handle.referencedClassHandles();
            for (int i = 0; i < handles.length; ++i) {
                if (handles[i] == null) continue;
                this.referencedHandles.put(VerifierClassLoader.dotName(handles[i].name()), handles[i]);
                this.referencedHandles.put(VerifierClassLoader.dotName(handles[i].pureName()), handles[i]);
            }
        }
        catch (Throwable e) {
            this.exception = e;
        }
    }

    private VerifierClassLoader(ClassHandle handle) {
        this.handle = handle;
        handleTable.put(handle, this);
    }

    int verify() {
        try {
            if (this.exception != null) {
                return 2;
            }
            if (this.cl == null) {
                this.cl = this.findClass(this.dotName());
            }
            if (this.cl == null && this.derivedp) {
                return 0;
            }
            this.resolveClass(this.cl);
            this.optInfo = this.getOptInfo();
        }
        catch (Throwable e) {
            this.exception = e;
            if (this.cl == null) {
                return this.classBytes == null ? 2 : 1;
            }
            this.isLinkException = true;
            return 1;
        }
        return 0;
    }

    byte[] getClassBytes() {
        if (this.classBytes == null) {
            return null;
        }
        if (this.exception != null) {
            if (this.cl == null) {
                this.classBytes = this.fakeClassBytes();
            }
            return this.addException();
        }
        if (this.optInfo != null) {
            return this.addOptimizationInfo();
        }
        return null;
    }

    String getNextWarning() {
        if (this.exception != null && this.classBytes != null) {
            String ret = this.exception.toString();
            this.exception = null;
            return ret;
        }
        return null;
    }

    String getNextError() {
        if (this.exception != null && this.classBytes == null) {
            String ret = this.exception.toString();
            this.exception = null;
            return ret;
        }
        return null;
    }

    private boolean beingResolved() {
        return this.referencedHandles != null;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class rcl;
        if (this.beingResolved()) {
            if (VerifierClassLoader.dotName(this.handle.pureName()).equals(name)) {
                if (this.cl == null) {
                    this.cl = this.findClass(name);
                }
                rcl = this.cl;
            } else {
                rcl = this.findReferencedClass(name);
            }
        } else {
            try {
                rcl = this.cl = this.handle.loadClass();
            }
            catch (ObjectTypeChangedException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
        if (resolve) {
            this.resolveClass(rcl);
        }
        return rcl;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] classBytes;
        int size;
        try {
            InputStream input = this.handle.inputStream(true);
            size = input.available();
            if (size == 0 && this.derivedp) {
                return null;
            }
            classBytes = new byte[size];
            input.read(classBytes, 0, size);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
        this.classBytes = VerifierClassLoader.stripAurora(classBytes);
        return this.defineClass(name, classBytes, 0, size);
    }

    private Class findReferencedClass(String name) throws ClassNotFoundException {
        ClassHandle ch = null;
        if (this.referencedHandles != null && (ch = (ClassHandle)this.referencedHandles.get(name)) == null) {
            if (this.referencedNames == null) {
                this.referencedNames = new HashMap();
                try {
                    String[] names = this.handle.referencedClassNames();
                    for (int i = 0; i < names.length; ++i) {
                        if (names[i] == null) continue;
                        this.referencedNames.put(names[i], names[i]);
                        this.referencedNames.put(VerifierClassLoader.dotName(names[i]), names[i]);
                    }
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }
            if (this.referencedNames.get(name) != null) {
                return null;
            }
        }
        if (ch == null && (ch = Handle.lookupClass(name, this._schema)) == null) {
            return this.findSystemClass(name);
        }
        VerifierClassLoader loader = VerifierClassLoader.getLoaderFor(ch);
        return loader.loadClass(name);
    }

    private static VerifierClassLoader getLoaderFor(final ClassHandle ch) {
        VerifierClassLoader loader = (VerifierClassLoader)handleTable.get(ch);
        if (loader == null) {
            loader = (VerifierClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new VerifierClassLoader(ch);
                }
            });
        }
        return loader;
    }

    private String name() {
        return this.handle.name();
    }

    private static String dotName(String str) {
        return str.replace('/', '.');
    }

    private String dotName() {
        return VerifierClassLoader.dotName(this.name());
    }

    private static byte[] getUTF8Bytes(String str) {
        if (str == null) {
            return new byte[0];
        }
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    private byte[] fakeClassBytes() {
        int off = 8;
        int cplen = VerifierClassLoader.readu2(this.classBytes, off);
        off += 2;
        Object[] cpinfo = new Object[cplen - 1];
        int newlen = 24;
        block7: for (int i = 0; i < cplen - 1; ++i) {
            switch (this.classBytes[off]) {
                case 7: {
                    cpinfo[i] = new Integer(VerifierClassLoader.readu2(this.classBytes, off + 1));
                    newlen += 3;
                }
                case 8: {
                    off += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    off += 5;
                    continue block7;
                }
                case 5: 
                case 6: {
                    ++i;
                    off += 9;
                    continue block7;
                }
                case 1: {
                    int len = VerifierClassLoader.readu2(this.classBytes, off + 1);
                    cpinfo[i] = new byte[len];
                    System.arraycopy(this.classBytes, off + 3, cpinfo[i], 0, len);
                    off += 3 + len;
                    newlen += 3 + len;
                }
            }
        }
        int access = VerifierClassLoader.readu2(this.classBytes, off);
        int selfidx = VerifierClassLoader.readu2(this.classBytes, off + 2);
        int superidx = VerifierClassLoader.readu2(this.classBytes, off + 4);
        int newidx = 1;
        int newself = 0;
        int newsuper = 0;
        byte[] fakes = new byte[newlen];
        System.arraycopy(this.classBytes, 0, fakes, 0, 8);
        int newoff = 10;
        for (int i = 0; i < cplen - 1; ++i) {
            if (!(cpinfo[i] instanceof Integer)) continue;
            byte[] utf = (byte[])cpinfo[(Integer)cpinfo[i] - 1];
            fakes[newoff] = 7;
            VerifierClassLoader.writeu2(fakes, newoff + 1, newidx + 1);
            fakes[newoff + 3] = 1;
            VerifierClassLoader.writeu2(fakes, newoff + 4, utf.length);
            System.arraycopy(utf, 0, fakes, newoff + 6, utf.length);
            if (i + 1 == selfidx) {
                newself = newidx;
            }
            if (i + 1 == superidx) {
                newsuper = newidx;
            }
            newoff += 6 + utf.length;
            newidx += 2;
        }
        VerifierClassLoader.writeu2(fakes, 8, newidx);
        VerifierClassLoader.writeu2(fakes, newoff, access);
        if (newself == 0) {
            throw new InternalError("self index botch");
        }
        VerifierClassLoader.writeu2(fakes, newoff + 2, newself);
        if (newsuper == 0) {
            throw new InternalError("super index botch");
        }
        VerifierClassLoader.writeu2(fakes, newoff + 4, newsuper);
        byte[] ret = new byte[newoff + 14];
        System.arraycopy(fakes, 0, ret, 0, newoff + 14);
        return ret;
    }

    private static boolean compareBytes(byte[] arr1, int off, int len, byte[] arr2) {
        if (len != arr2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (arr1[off + i] == arr2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAuroraUTF(byte[] bytes, int off, int len) {
        return VerifierClassLoader.compareBytes(bytes, off, len, auroraOptInfo) || VerifierClassLoader.compareBytes(bytes, off, len, auroraDeferredError);
    }

    private static boolean needsStripping(byte[] classBytes) {
        int off = 8;
        int cplen = VerifierClassLoader.readu2(classBytes, off);
        off += 2;
        block6: for (int i = 0; i < cplen - 1; ++i) {
            switch (classBytes[off]) {
                case 7: 
                case 8: {
                    off += 3;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    off += 5;
                    continue block6;
                }
                case 5: 
                case 6: {
                    ++i;
                    off += 9;
                    continue block6;
                }
                case 1: {
                    int len = VerifierClassLoader.readu2(classBytes, off + 1);
                    if (VerifierClassLoader.hasAuroraUTF(classBytes, off + 3, len)) {
                        aurora_cp_index = i + 1;
                        return true;
                    }
                    off += 3 + len;
                    continue block6;
                }
            }
        }
        return false;
    }

    private static byte[] stripAurora(byte[] classBytes) {
        if (!VerifierClassLoader.needsStripping(classBytes)) {
            return classBytes;
        }
        try {
            Mutable m = new Mutable(new Raw.Class(new ByteArrayInputStream(classBytes)));
            return m.stripAurora(aurora_cp_index);
        }
        catch (ToolException te) {
            return classBytes;
        }
        catch (IOException ex) {
            return classBytes;
        }
    }

    private int skipCpool() {
        int off = 8;
        int cplen = VerifierClassLoader.readu2(this.classBytes, off);
        off += 2;
        block6: for (int i = 1; i < cplen; ++i) {
            switch (this.classBytes[off]) {
                case 7: 
                case 8: {
                    off += 3;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    off += 5;
                    continue block6;
                }
                case 5: 
                case 6: {
                    ++i;
                    off += 9;
                    continue block6;
                }
                case 1: {
                    int len = VerifierClassLoader.readu2(this.classBytes, off + 1);
                    off += 3 + len;
                }
            }
        }
        return off;
    }

    private int skipAttrs(int attrsStart) {
        int attrscount = VerifierClassLoader.readu2(this.classBytes, attrsStart);
        int off = attrsStart + 2;
        for (int i = 0; i < attrscount; ++i) {
            int attrlen = VerifierClassLoader.readu4(this.classBytes, off + 2);
            off += attrlen + 4 + 2;
        }
        return off;
    }

    private int skipMembers(int membersStart) {
        int membercount = VerifierClassLoader.readu2(this.classBytes, membersStart);
        int off = membersStart + 2;
        for (int i = 0; i < membercount; ++i) {
            off = this.skipAttrs(off + 6);
        }
        return off;
    }

    private int skipIntf(int intfStart) {
        int intfCount = VerifierClassLoader.readu2(this.classBytes, intfStart);
        return intfStart + 2 + intfCount * 2;
    }

    private int incrLen(int oldOffset, byte[] newBytes, int newOffset) {
        int len = VerifierClassLoader.readu2(this.classBytes, oldOffset);
        if (len + 1 > 65535) {
            throw new UnknownError();
        }
        VerifierClassLoader.writeu2(newBytes, newOffset, len + 1);
        return len;
    }

    private byte[] addAttribute(byte[] nameBytes, byte[] attrData) {
        byte[] newBytes = new byte[this.classBytes.length + 1 + 2 + nameBytes.length + 2 + 4 + attrData.length];
        int cpEnd = this.skipCpool();
        int intfEnd = this.skipIntf(cpEnd + 6);
        int fieldEnd = this.skipMembers(intfEnd);
        int methodEnd = this.skipMembers(fieldEnd);
        int attrEnd = this.skipAttrs(methodEnd);
        if (attrEnd != this.classBytes.length) {
            System.out.println("blew it");
        }
        System.arraycopy(this.classBytes, 0, newBytes, 0, cpEnd);
        int oldCplen = this.incrLen(8, newBytes, 8);
        newBytes[cpEnd] = 1;
        VerifierClassLoader.writeu2(newBytes, cpEnd + 1, nameBytes.length);
        System.arraycopy(nameBytes, 0, newBytes, cpEnd + 1 + 2, nameBytes.length);
        int adjust = 3 + nameBytes.length;
        System.arraycopy(this.classBytes, cpEnd, newBytes, cpEnd + adjust, this.classBytes.length - cpEnd);
        this.incrLen(methodEnd, newBytes, methodEnd + adjust);
        VerifierClassLoader.writeu2(newBytes, this.classBytes.length + adjust, oldCplen);
        VerifierClassLoader.writeu4(newBytes, this.classBytes.length + adjust + 2, attrData.length);
        System.arraycopy(attrData, 0, newBytes, this.classBytes.length + adjust + 2 + 4, attrData.length);
        return newBytes;
    }

    private byte[] addException() {
        byte[] namearr = VerifierClassLoader.getUTF8Bytes(this.exception.getMessage());
        int exlen = namearr.length + 4;
        byte[] attrBytes = new byte[exlen];
        short code = this.getExceptionCode(this.exception);
        if (this.isLinkException) {
            code = (short)(code | 0x8000);
        }
        VerifierClassLoader.writeu2(attrBytes, 0, code);
        VerifierClassLoader.writeu2(attrBytes, 2, namearr.length);
        System.arraycopy(namearr, 0, attrBytes, 4, namearr.length);
        return this.addAttribute(auroraDeferredError, attrBytes);
    }

    private byte[] addOptimizationInfo() {
        try {
            byte[] attrBytes = new byte[this.optInfo.length * 4];
            for (int i = 0; i < this.optInfo.length; ++i) {
                VerifierClassLoader.writeu4(attrBytes, i << 2, this.optInfo[i]);
            }
            return this.addAttribute(auroraOptInfo, attrBytes);
        }
        catch (UnknownError e) {
            return null;
        }
    }

    private static int readu2(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    private static int readu4(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    private static void writeu2(byte[] bytes, int offset, int val) {
        bytes[offset] = (byte)(val >> 8);
        bytes[offset + 1] = (byte)val;
    }

    private static void writeu4(byte[] bytes, int offset, int val) {
        bytes[offset] = (byte)(val >> 24);
        bytes[offset + 1] = (byte)(val >> 16);
        bytes[offset + 2] = (byte)(val >> 8);
        bytes[offset + 3] = (byte)val;
    }

    private native int[] getOptInfo();

    private native short getExceptionCode(Throwable var1);
}

