/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm.config;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class CmConfig
extends HashStructureAdapter
implements Copyable {
    public static final String KEY = "CmConfig";
    public static final String SETDEBUG = "setDEBUG";
    public static final String SETGENERATECONSTRAINTINDEXES = "setGenerateConstraintIndexes";
    public static final String SETGENERATECONSTRAINTS = "setGenerateConstraints";
    public static final String SETGENERATEPASSWORDVALUE = "setGeneratePasswordValue";
    public static final String SETGENERATEREFCONSTRAINTS = "setGenerateRefConstraints";
    public static final String SETGENERATESQLTERMINATOR = "setGenerateSQLTerminator";
    public static final String SETIGNOREPHYSICALATTRIBUTES = "setIgnorePhysicalAttributes";
    public static final String SETIGNORESEGMENTATTRIBUTES = "setIgnoreSegmentAttributes";
    public static final String SETIGNORESTORAGE = "setIgnoreStorage";
    public static final String SETIGNORETABLECOLUMNPOSITION = "setIgnoreTableColumnPosition";
    public static final String SETIGNORETABLESPACE = "setIgnoreTablespace";
    public static final String SETMATCHCONSTRAINTSBYNAME = "setMatchConstraintsByName";
    public static final String SETREPORTCONSTRAINTNAMEDIFFERENCES = "setReportConstraintNameDifferences";
    public static final String SETSTATISTICS = "setStatistics";
    public static final String CONFLICT_EXISTS_DIFFERENT = "setConflictExistsDifferent";
    public static final String CONFLICT_MODIFIED_DIFFERENT = "setConflictModifiedDifferent";
    public static final String CONFLICT_MODIFIED_PREVIOUSLY = "setConflictModifiedPreviously";
    private static Map<String, Object> s_defaults = new HashMap<String, Object>();

    public CmConfig() {
        super(HashStructure.newInstance());
    }

    private CmConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static CmConfig getInstance(PropertyStorage propertyStorage) {
        return new CmConfig(CmConfig.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public static CmConfig getInstance(TraversableContext traversableContext) {
        return CmConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static synchronized CmConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return CmConfig.getInstance((PropertyStorage)preferences);
    }

    private static Integer getIntegerDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Integer ? (Integer)object : (object != null ? Integer.valueOf(Integer.parseInt(object.toString())) : null);
    }

    private static String getStringDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof String ? (String)object : (object != null ? object.toString() : null);
    }

    private Boolean getBooleanDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Boolean ? (Boolean)object : (object != null ? Boolean.valueOf(object.toString()) : null);
    }

    public String getString(String string) {
        return this._hash.getString(string, CmConfig.getStringDefault(string));
    }

    public void setString(String string, String string2) {
        this._hash.putString(string, string2);
    }

    public int getInt(String string) {
        return this._hash.getInt(string, CmConfig.getIntegerDefault(string).intValue());
    }

    public void setInt(String string, int n) {
        this._hash.putInt(string, n);
    }

    public Boolean getBoolean(String string) {
        return this._hash.getBoolean(string, this.getBooleanDefault(string).booleanValue());
    }

    public void setBoolean(String string, boolean bl) {
        this._hash.putBoolean(string, bl);
    }

    public void clearBinds() {
        this._hash.clear();
    }

    static {
        s_defaults.put(SETDEBUG, false);
        s_defaults.put(SETGENERATECONSTRAINTINDEXES, true);
        s_defaults.put(SETGENERATECONSTRAINTS, true);
        s_defaults.put(SETGENERATEPASSWORDVALUE, true);
        s_defaults.put(SETGENERATEREFCONSTRAINTS, true);
        s_defaults.put(SETGENERATESQLTERMINATOR, true);
        s_defaults.put(SETIGNOREPHYSICALATTRIBUTES, true);
        s_defaults.put(SETIGNORESEGMENTATTRIBUTES, true);
        s_defaults.put(SETIGNORESTORAGE, true);
        s_defaults.put(SETIGNORETABLECOLUMNPOSITION, true);
        s_defaults.put(SETIGNORETABLESPACE, true);
        s_defaults.put(SETMATCHCONSTRAINTSBYNAME, true);
        s_defaults.put(SETREPORTCONSTRAINTNAMEDIFFERENCES, false);
        s_defaults.put(SETSTATISTICS, false);
        s_defaults.put(CONFLICT_EXISTS_DIFFERENT, false);
        s_defaults.put(CONFLICT_MODIFIED_DIFFERENT, true);
        s_defaults.put(CONFLICT_MODIFIED_PREVIOUSLY, false);
    }
}

