/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseUpgradeHistoryEntrySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="source")
    private final Source source;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="targetDBVersion")
    private final String targetDBVersion;
    @JsonProperty(value="targetDatabaseSoftwareImageId")
    private final String targetDatabaseSoftwareImageId;
    @JsonProperty(value="targetDbHomeId")
    private final String targetDbHomeId;
    @JsonProperty(value="sourceDbHomeId")
    private final String sourceDbHomeId;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="options")
    private final String options;

    @Deprecated
    @ConstructorProperties(value={"id", "action", "source", "lifecycleState", "lifecycleDetails", "targetDBVersion", "targetDatabaseSoftwareImageId", "targetDbHomeId", "sourceDbHomeId", "timeStarted", "timeEnded", "options"})
    public DatabaseUpgradeHistoryEntrySummary(String id, Action action, Source source, LifecycleState lifecycleState, String lifecycleDetails, String targetDBVersion, String targetDatabaseSoftwareImageId, String targetDbHomeId, String sourceDbHomeId, Date timeStarted, Date timeEnded, String options) {
        this.id = id;
        this.action = action;
        this.source = source;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.targetDBVersion = targetDBVersion;
        this.targetDatabaseSoftwareImageId = targetDatabaseSoftwareImageId;
        this.targetDbHomeId = targetDbHomeId;
        this.sourceDbHomeId = sourceDbHomeId;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.options = options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public Action getAction() {
        return this.action;
    }

    public Source getSource() {
        return this.source;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getTargetDBVersion() {
        return this.targetDBVersion;
    }

    public String getTargetDatabaseSoftwareImageId() {
        return this.targetDatabaseSoftwareImageId;
    }

    public String getTargetDbHomeId() {
        return this.targetDbHomeId;
    }

    public String getSourceDbHomeId() {
        return this.sourceDbHomeId;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String getOptions() {
        return this.options;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseUpgradeHistoryEntrySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", targetDBVersion=").append(String.valueOf(this.targetDBVersion));
        sb.append(", targetDatabaseSoftwareImageId=").append(String.valueOf(this.targetDatabaseSoftwareImageId));
        sb.append(", targetDbHomeId=").append(String.valueOf(this.targetDbHomeId));
        sb.append(", sourceDbHomeId=").append(String.valueOf(this.sourceDbHomeId));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", options=").append(String.valueOf(this.options));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseUpgradeHistoryEntrySummary)) {
            return false;
        }
        DatabaseUpgradeHistoryEntrySummary other = (DatabaseUpgradeHistoryEntrySummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.targetDBVersion, other.targetDBVersion) && Objects.equals(this.targetDatabaseSoftwareImageId, other.targetDatabaseSoftwareImageId) && Objects.equals(this.targetDbHomeId, other.targetDbHomeId) && Objects.equals(this.sourceDbHomeId, other.sourceDbHomeId) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.options, other.options) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.targetDBVersion == null ? 43 : this.targetDBVersion.hashCode());
        result = result * 59 + (this.targetDatabaseSoftwareImageId == null ? 43 : this.targetDatabaseSoftwareImageId.hashCode());
        result = result * 59 + (this.targetDbHomeId == null ? 43 : this.targetDbHomeId.hashCode());
        result = result * 59 + (this.sourceDbHomeId == null ? 43 : this.sourceDbHomeId.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.options == null ? 43 : this.options.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Source implements BmcEnum
    {
        DbHome("DB_HOME"),
        DbVersion("DB_VERSION"),
        DbSoftwareImage("DB_SOFTWARE_IMAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Source> map;

        private Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Source create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Source', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Source.class);
            map = new HashMap<String, Source>();
            for (Source v : Source.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action implements BmcEnum
    {
        Precheck("PRECHECK"),
        Upgrade("UPGRADE"),
        Rollback("ROLLBACK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="source")
        private Source source;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="targetDBVersion")
        private String targetDBVersion;
        @JsonProperty(value="targetDatabaseSoftwareImageId")
        private String targetDatabaseSoftwareImageId;
        @JsonProperty(value="targetDbHomeId")
        private String targetDbHomeId;
        @JsonProperty(value="sourceDbHomeId")
        private String sourceDbHomeId;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="options")
        private String options;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder targetDBVersion(String targetDBVersion) {
            this.targetDBVersion = targetDBVersion;
            this.__explicitlySet__.add("targetDBVersion");
            return this;
        }

        public Builder targetDatabaseSoftwareImageId(String targetDatabaseSoftwareImageId) {
            this.targetDatabaseSoftwareImageId = targetDatabaseSoftwareImageId;
            this.__explicitlySet__.add("targetDatabaseSoftwareImageId");
            return this;
        }

        public Builder targetDbHomeId(String targetDbHomeId) {
            this.targetDbHomeId = targetDbHomeId;
            this.__explicitlySet__.add("targetDbHomeId");
            return this;
        }

        public Builder sourceDbHomeId(String sourceDbHomeId) {
            this.sourceDbHomeId = sourceDbHomeId;
            this.__explicitlySet__.add("sourceDbHomeId");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder options(String options) {
            this.options = options;
            this.__explicitlySet__.add("options");
            return this;
        }

        public DatabaseUpgradeHistoryEntrySummary build() {
            DatabaseUpgradeHistoryEntrySummary model = new DatabaseUpgradeHistoryEntrySummary(this.id, this.action, this.source, this.lifecycleState, this.lifecycleDetails, this.targetDBVersion, this.targetDatabaseSoftwareImageId, this.targetDbHomeId, this.sourceDbHomeId, this.timeStarted, this.timeEnded, this.options);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseUpgradeHistoryEntrySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("targetDBVersion")) {
                this.targetDBVersion(model.getTargetDBVersion());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseSoftwareImageId")) {
                this.targetDatabaseSoftwareImageId(model.getTargetDatabaseSoftwareImageId());
            }
            if (model.wasPropertyExplicitlySet("targetDbHomeId")) {
                this.targetDbHomeId(model.getTargetDbHomeId());
            }
            if (model.wasPropertyExplicitlySet("sourceDbHomeId")) {
                this.sourceDbHomeId(model.getSourceDbHomeId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("options")) {
                this.options(model.getOptions());
            }
            return this;
        }
    }
}

