/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSKEKRecipientInfo;
import oracle.security.crypto.cms.CMSKEKRecipientInfoSpec;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfo;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfoSpec;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSRecipientInfoSpec;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.EncryptedContentInfo;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.cms.UnknownRecipientException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSEnvelopedDataContentInfo
extends CMSContentInfo {
    private EncryptedContentInfo eci;
    private Hashtable recipTable;
    private SecretKey contentEncryptionKey;
    private ASN1Integer version;
    private OriginatorInfo origInfo;
    private AttributeSet unprotectedAttributes;
    private boolean writeDetached = false;
    private byte[] exposedContent = null;

    public CMSEnvelopedDataContentInfo() {
        super(CMS.id_envelopedData);
    }

    public CMSEnvelopedDataContentInfo(CMSContentInfo contentInfo, AlgorithmIdentifier contentEncryptionAlgID) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        super(CMS.id_envelopedData);
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        byte[] random = new byte[8];
        SecureRandom sr = new SecureRandom();
        String algoName = CMSUtils.getAlgoName(contentEncryptionAlgID, true);
        KeyGenerator kg = KeyGenerator.getInstance(algoName);
        int keysize = 0;
        if (contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc)) {
            keysize = CMSUtils.getKeySize(contentEncryptionAlgID);
            kg.init(keysize, sr);
        } else {
            kg.init(sr);
        }
        this.contentEncryptionKey = kg.generateKey();
        Cipher cipher = null;
        String AlgoName = null;
        try {
            AlgoName = CMSUtils.addPadding(CMSUtils.getAlgoName(contentEncryptionAlgID));
            cipher = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(AlgoName);
            if (AlgoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                cipher.init(1, (Key)this.contentEncryptionKey, new IvParameterSpec(iv));
            } else {
                cipher.init(1, this.contentEncryptionKey);
            }
        }
        catch (InvalidKeyException ex) {
            throw new NoSuchAlgorithmException(ex.toString() + AlgoName);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        this.eci = new EncryptedContentInfo(contentInfo, cipher, contentEncryptionAlgID, true);
        this.recipTable = new Hashtable();
    }

    public CMSEnvelopedDataContentInfo(InputStream is) throws IOException {
        super(CMS.id_envelopedData);
        this.input(is);
    }

    @Override
    public boolean isDetached() {
        return this.eci.getEncryptedContent() == null;
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            if (this.eci == null) {
                return null;
            }
            try {
                UnsyncByteArrayOutputStream edStore = new UnsyncByteArrayOutputStream();
                boolean version0 = true;
                if (this.origInfo != null) {
                    version0 = false;
                }
                if (!version0) {
                    Enumeration e = this.recipTable.elements();
                    while (version0 && e.hasMoreElements()) {
                        CMSRecipientInfo ris = (CMSRecipientInfo)e.nextElement();
                        if (ris.getVersion().equals(0)) continue;
                        version0 = false;
                    }
                }
                if (this.unprotectedAttributes != null) {
                    version0 = false;
                }
                this.version = version0 ? new ASN1Integer(0L) : new ASN1Integer(2L);
                this.version.output((OutputStream)edStore);
                if (this.origInfo != null) {
                    ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.origInfo, (int)0)).output((OutputStream)edStore);
                }
                ASN1Set recipInfoSet = new ASN1Set();
                Enumeration enr = this.recipTable.elements();
                while (enr.hasMoreElements()) {
                    ASN1Integer ver;
                    CMSRecipientInfo rcp = (CMSRecipientInfo)enr.nextElement();
                    if (rcp instanceof CMSKeyTransRecipientInfo) {
                        ver = new ASN1Integer(((CMSKeyTransRecipientInfo)rcp).getVersionNumber());
                        if (ver.equals(0) || ver.equals(2)) {
                            recipInfoSet.addElement((ASN1Object)((CMSKeyTransRecipientInfo)rcp));
                            continue;
                        }
                        throw new IOException("Version 0/2 but Not KeyTransportRecipientInfo");
                    }
                    if (rcp instanceof CMSKEKRecipientInfo) {
                        ver = new ASN1Integer(((CMSKEKRecipientInfo)rcp).getVersionNumber());
                        if (ver.equals(4)) {
                            recipInfoSet.addElement((ASN1Object)((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)((CMSKEKRecipientInfo)rcp), (int)2)));
                            continue;
                        }
                        throw new IOException("Version 4 but Not KEKRecipientInfo");
                    }
                    throw new IOException("Unknown/Unsupported RecipientInfo ");
                }
                recipInfoSet.output((OutputStream)edStore);
                this.eci.output((OutputStream)edStore);
                if (this.unprotectedAttributes != null) {
                    ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.unprotectedAttributes, (int)1)).output((OutputStream)edStore);
                }
                byte[] buf = edStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NullPointerException ex) {
                throw new StreamableOutputException("CMS Object is not initialized: " + ex.toString());
            }
        }
        return this.exposedContent;
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1ObjectID getEnclosedContentType() {
        return this.eci.getContentType();
    }

    public AlgorithmIdentifier getContentEncryptionAlgID() {
        return this.eci.getContentEncryptionAlgID();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Version: " + this.version.intValue() + "\n");
        if (this.isDetached()) {
            sb.append("detached CMS 'envelopedData' object\n");
        } else {
            sb.append("CMS 'envelopedData' object, encloses " + this.eci.toString() + ", " + Utils.plural((int)this.recipTable.size(), (String)"recipient") + "\n");
        }
        Enumeration e = this.recipTable.elements();
        while (e.hasMoreElements()) {
            CMSRecipientInfo r = (CMSRecipientInfo)e.nextElement();
            sb.append("RecipientInfo: " + r.toString());
        }
        return sb.toString();
    }

    public Enumeration recipients() {
        return this.recipTable.elements();
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSEnvelopedDataContentInfo)) {
            return false;
        }
        return this.hashCode() == ((CMSEnvelopedDataContentInfo)obj).hashCode();
    }

    public void writeDetached(boolean writeDetached) {
        this.writeDetached = writeDetached;
        this.eci.writeDetached(writeDetached);
        this.update();
    }

    public void setEnclosed(byte[] encryptedContent) {
        if (encryptedContent == null) {
            throw new IllegalArgumentException("Null Original Encrypted Content");
        }
        this.eci.setEncryptedContent(encryptedContent);
        this.update();
    }

    public void addRecipient(X509Certificate recipientCert, AlgorithmIdentifier keyEncryptionAlgID) throws CertificateEncodingException, IOException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchPaddingException {
        if (recipientCert == null) {
            throw new IllegalArgumentException("Null Recipient Certificate");
        }
        IssuerAndSerialNo iasn = new IssuerAndSerialNo(new X509(recipientCert.getEncoded()));
        this.recipTable.put(iasn, new CMSKeyTransRecipientInfo(this.contentEncryptionKey, recipientCert.getPublicKey(), iasn, keyEncryptionAlgID));
        this.update();
    }

    public void addRecipient(X509Certificate recipientCert, AlgorithmIdentifier keyEncryptionAlgID, boolean useSPKI64) throws NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, IllegalBlockSizeException, NoSuchPaddingException {
        if (recipientCert == null) {
            throw new IllegalArgumentException("Null Recipient Certificate");
        }
        byte[] spki = null;
        spki = useSPKI64 ? CMSUtils.generateSPKI64(recipientCert) : CMSUtils.generateSPKI160(recipientCert);
        this.recipTable.put(spki, new CMSKeyTransRecipientInfo(this.contentEncryptionKey, recipientCert.getPublicKey(), spki, keyEncryptionAlgID));
        this.update();
    }

    public void addRecipient(CMSRecipientInfoSpec ris) throws NoSuchAlgorithmException, InvalidInputException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException {
        if (ris instanceof CMSKeyTransRecipientInfoSpec) {
            CMSKeyTransRecipientInfoSpec kt = (CMSKeyTransRecipientInfoSpec)ris;
            if (kt.getSPKI() == null) {
                this.recipTable.put(kt.getIASN(), new CMSKeyTransRecipientInfo(this.contentEncryptionKey, kt.getRecipientKey(), kt.getIASN(), kt.getKeyEncryptionAlgID()));
            } else {
                this.recipTable.put(kt.getSPKI(), new CMSKeyTransRecipientInfo(this.contentEncryptionKey, kt.getRecipientKey(), kt.getSPKI(), kt.getKeyEncryptionAlgID()));
            }
        } else if (ris instanceof CMSKEKRecipientInfoSpec) {
            CMSKEKRecipientInfoSpec kek = (CMSKEKRecipientInfoSpec)ris;
            this.recipTable.put(kek, new CMSKEKRecipientInfo(this.contentEncryptionKey, kek));
        } else {
            throw new InvalidInputException("Unrecognized CMSRecipientInfo Type");
        }
        this.update();
    }

    public void addRecipient(AlgorithmIdentifier keyEncryptionAlgID, SecretKey keyEncryptionKey, byte[] keyIdentifier, Date keyDate, ASN1Sequence otherKeyAttribute) throws NoSuchAlgorithmException, InvalidKeyException, InvalidInputException, InvalidKeySpecException, InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        CMSKEKRecipientInfoSpec ri = new CMSKEKRecipientInfoSpec(keyEncryptionAlgID, keyEncryptionKey, keyIdentifier, keyDate, otherKeyAttribute);
        this.recipTable.put(ri, new CMSKEKRecipientInfo(this.contentEncryptionKey, ri));
        this.update();
    }

    public CMSContentInfo getEnclosed(PrivateKey privateKey, X509Certificate recipientCert) throws NoSuchAlgorithmException, InvalidKeyException, UnknownRecipientException, InvalidInputException, CertificateEncodingException, IOException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        CMSKeyTransRecipientInfo recip = (CMSKeyTransRecipientInfo)this.recipTable.get(new IssuerAndSerialNo(new X509(recipientCert.getEncoded())));
        if (recip == null) {
            recip = (CMSKeyTransRecipientInfo)this.recipTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI64(recipientCert)));
        }
        if (recip == null) {
            recip = (CMSKeyTransRecipientInfo)this.recipTable.get(Utils.toHexString((byte[])CMSUtils.generateSPKI160(recipientCert)));
        }
        if (recip == null) {
            throw new UnknownRecipientException("No matching RecipientInfo found");
        }
        try {
            return this.eci.getDecryptedContentInfo(recip.getContentEncryptionKey(privateKey, CMSUtils.getAlgoName(this.eci.getContentEncryptionAlgID(), true)));
        }
        catch (InvalidKeySpecException ex) {
            throw new InvalidKeyException(ex.toString());
        }
    }

    public CMSContentInfo getEnclosed(SecretKey symmetricKey, byte[] keyIdentifier) throws NoSuchAlgorithmException, InvalidKeyException, UnknownRecipientException, InvalidInputException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        return this.getEnclosed(symmetricKey, keyIdentifier, null);
    }

    public CMSContentInfo getEnclosed(SecretKey symmetricKey, byte[] keyIdentifier, Date keyDate) throws InvalidKeyException, UnknownRecipientException, InvalidInputException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        return this.getEnclosed(symmetricKey, keyIdentifier, keyDate, null);
    }

    public CMSContentInfo getEnclosed(SecretKey symmetricKey, byte[] keyIdentifier, Date keyDate, ASN1Sequence otherKeyAttribute) throws InvalidKeyException, UnknownRecipientException, InvalidInputException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        CMSRecipientInfo recip;
        CMSKEKRecipientInfoSpec spec = new CMSKEKRecipientInfoSpec(CMS.id_alg_CMS3DESwrap, symmetricKey, keyIdentifier);
        if (keyDate != null) {
            spec.setKeyDate(keyDate);
        }
        if (otherKeyAttribute != null) {
            spec.setOtherKeyAttribute(otherKeyAttribute);
        }
        if ((recip = (CMSRecipientInfo)this.recipTable.get(spec)) == null) {
            throw new UnknownRecipientException("No matching RecipientInfo Found");
        }
        CMSKEKRecipientInfo recipient = null;
        if (!(recip instanceof CMSKEKRecipientInfo)) {
            throw new UnknownRecipientException("RecipientInfo is not of type Key Encipherment");
        }
        recipient = (CMSKEKRecipientInfo)recip;
        return this.eci.getDecryptedContentInfo(recipient.getContentEncryptionKey(symmetricKey));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream ed = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)ed);
        if (!this.version.equals(0) && !this.version.equals(2)) {
            throw new VersionException("Expected Version 0 or 2 But Got " + this.version.getValue());
        }
        if (ed.getCurrentTag() == 0) {
            ed.setCurrentTag(16);
            this.origInfo = new OriginatorInfo((InputStream)ed);
        } else {
            this.origInfo = null;
        }
        this.recipTable = new Hashtable();
        ASN1SetInputStream ris = new ASN1SetInputStream((InputStream)ed);
        while (ris.hasMoreData()) {
            CMSRecipientInfo rii;
            CMSRecipientInfo ri = CMSRecipientInfo.inputInstance((InputStream)ris);
            if (ri instanceof CMSKeyTransRecipientInfo) {
                rii = (CMSKeyTransRecipientInfo)ri;
                if (((CMSKeyTransRecipientInfo)rii).getSPKI() == null) {
                    this.recipTable.put(((CMSKeyTransRecipientInfo)rii).getIASN(), rii);
                    continue;
                }
                this.recipTable.put(Utils.toHexString((byte[])((CMSKeyTransRecipientInfo)rii).getSPKI()), rii);
                continue;
            }
            if (!(ri instanceof CMSKEKRecipientInfo)) throw new IOException("Unknown CMSRecipientInfo Type");
            rii = (CMSKEKRecipientInfo)ri;
            this.recipTable.put(((CMSKEKRecipientInfo)rii).getRecipientInfoSpec(), rii);
        }
        ris.terminate();
        this.eci = new EncryptedContentInfo((InputStream)ed);
        if (ed.hasMoreData()) {
            if (ed.getCurrentTag() != 1) throw new IOException("Expected Unprotected Attributes");
            ed.setCurrentTag(17);
            this.unprotectedAttributes = new AttributeSet((InputStream)ed);
        } else {
            this.unprotectedAttributes = null;
        }
        ed.terminate();
        if (this.eci.getEncryptedContent() != null) return;
        this.writeDetached = true;
    }

    public byte[] getEncryptedContent() {
        return this.eci.getEncryptedContent();
    }

    public void setOriginatorInfo(OriginatorInfo origInfo) {
        this.origInfo = origInfo;
        this.update();
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.origInfo;
    }

    public void setUnprotectedAttribs(AttributeSet unprotectedAttributes) {
        this.unprotectedAttributes = unprotectedAttributes;
        this.update();
    }

    public AttributeSet getUnprotectedAttribs() {
        return this.unprotectedAttributes;
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }
}

