/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSEncryptedDataOutputStream;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.core.AlgorithmIdentifier;

public class CMSEncryptedDataOutputConnector
implements CMSOutputConnector {
    private CMSEncryptedDataOutputStream edOut;

    public CMSEncryptedDataOutputConnector(OutputStream out, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType) throws NoSuchAlgorithmException, InvalidKeyException {
        this.edOut = new CMSEncryptedDataOutputStream(out, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType);
    }

    public CMSEncryptedDataOutputConnector(OutputStream out, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes) throws NoSuchAlgorithmException, InvalidKeyException {
        this.edOut = new CMSEncryptedDataOutputStream(out, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, unprotectedAttributes, true);
    }

    public CMSEncryptedDataOutputConnector(OutputStream out, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes, boolean writeEncryptedOutput) throws NoSuchAlgorithmException, InvalidKeyException {
        this.edOut = new CMSEncryptedDataOutputStream(out, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, unprotectedAttributes, writeEncryptedOutput);
    }

    public CMSEncryptedDataOutputConnector(CMSOutputConnector conn, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType) throws NoSuchAlgorithmException, InvalidKeyException {
        this.edOut = new CMSEncryptedDataOutputStream(conn, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType);
    }

    public CMSEncryptedDataOutputConnector(CMSOutputConnector conn, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes) throws NoSuchAlgorithmException, InvalidKeyException {
        this.edOut = new CMSEncryptedDataOutputStream(conn, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, unprotectedAttributes, true);
    }

    public CMSEncryptedDataOutputConnector(CMSOutputConnector conn, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes, boolean writeEncryptedOutput) throws NoSuchAlgorithmException, InvalidKeyException {
        this.edOut = new CMSEncryptedDataOutputStream(conn, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, unprotectedAttributes, writeEncryptedOutput);
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_encryptedData;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.edOut;
    }
}

