/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSDigestedDataOutputStream;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.core.AlgorithmIdentifier;

public class CMSDigestedDataOutputConnector
implements CMSOutputConnector {
    private CMSDigestedDataOutputStream digOut;

    public CMSDigestedDataOutputConnector(OutputStream out, AlgorithmIdentifier digestAlgID, ASN1ObjectID contentType, boolean writeEContentInfo) throws NoSuchAlgorithmException {
        this.digOut = new CMSDigestedDataOutputStream(out, digestAlgID, contentType, writeEContentInfo);
    }

    public CMSDigestedDataOutputConnector(CMSOutputConnector conn, AlgorithmIdentifier digestAlgID, ASN1ObjectID contentType, boolean writeEContentInfo) throws NoSuchAlgorithmException {
        this.digOut = new CMSDigestedDataOutputStream(conn, digestAlgID, contentType, writeEContentInfo);
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_digestedData;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.digOut;
    }
}

