/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CIInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSInputConnector;
import oracle.security.crypto.cms.CMSInputStream;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSDigestedDataInputStream
extends CMSInputStream {
    private ASN1Integer version;
    private AlgorithmIdentifier digestAlgID;
    private byte[] digest;
    private MessageDigest md;
    private byte[] computedDigest;
    private boolean readingFromConnector;
    private ASN1ObjectID eContentType;
    private boolean readInitial = false;
    private boolean terminated = false;
    private ASN1ConstructedInputStream ci_in;
    private ASN1ConstructedInputStream cic_in;
    private ASN1ConstructedInputStream dd_in;
    private CIInputStream content_in;

    public CMSDigestedDataInputStream(InputStream in) {
        super(in);
        this.readingFromConnector = false;
    }

    public CMSDigestedDataInputStream(CMSInputConnector conn) {
        super(conn.getInputStream());
        this.readingFromConnector = true;
    }

    private void ensureReadInitial() throws IOException {
        if (!this.readInitial) {
            if (!this.readingFromConnector) {
                this.ci_in = new ASN1SequenceInputStream(this.in);
                if (!CMS.id_digestedData.equals((Object)new ASN1ObjectID((InputStream)this.ci_in))) {
                    throw new InvalidInputException("Content-type 'id-digestedData' expected.");
                }
                this.cic_in = new ASN1ConstructedInputStream((InputStream)this.ci_in, 0);
                this.dd_in = new ASN1SequenceInputStream((InputStream)this.cic_in);
            } else {
                this.dd_in = new ASN1SequenceInputStream(this.in);
            }
            this.version = new ASN1Integer((InputStream)this.dd_in);
            if (!this.version.equals(0) && !this.version.equals(2)) {
                throw new VersionException("Expected Version 0 or 2 but got Version " + this.version.getValue());
            }
            this.digestAlgID = new AlgorithmIdentifier((InputStream)this.dd_in);
            try {
                this.md = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidInputException("Unrecognized algorithm identifier or invalid parameters");
            }
            this.content_in = new CIInputStream((InputStream)this.dd_in);
            this.eContentType = this.content_in.getContentType();
            if (this.eContentType.equals((Object)CMS.id_data) && !this.version.equals(0)) {
                throw new VersionException("Expected Version 0 but got Version " + this.version.getValue());
            }
            if (!this.eContentType.equals((Object)CMS.id_data) && !this.version.equals(2)) {
                throw new VersionException("Expected Version 2 but got Version " + this.version.getValue());
            }
            this.readInitial = true;
        }
    }

    @Override
    public void terminate() throws IOException {
        if (!this.terminated) {
            this.content_in.ensureTerminated();
            this.digest = ASN1OctetString.inputValue((InputStream)this.dd_in);
            this.dd_in.terminate();
            if (!this.readingFromConnector) {
                this.cic_in.terminate();
                this.ci_in.terminate();
            }
            this.computedDigest = this.md.digest();
            this.terminated = true;
        }
    }

    public BigInteger getVersionNumber() throws IOException {
        this.ensureReadInitial();
        return this.version.getValue();
    }

    public ASN1Integer getVersion() throws IOException {
        this.ensureReadInitial();
        return this.version;
    }

    public byte[] getDigest() throws IOException {
        return this.digest;
    }

    public AlgorithmIdentifier getDigestAlgID() throws IOException {
        this.ensureReadInitial();
        return this.digestAlgID;
    }

    public void verify() throws AuthenticationException, IOException {
        if (!this.readInitial) {
            throw new AuthenticationException("No input read");
        }
        this.terminate();
        if (!Utils.areEqual((byte[])this.computedDigest, (byte[])this.digest)) {
            throw new AuthenticationException("Message digest is incorrect");
        }
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        this.ensureReadInitial();
        return this.eContentType;
    }

    @Override
    public int read() throws IOException {
        this.ensureReadInitial();
        int ch = this.content_in.read();
        if (ch == -1) {
            this.terminate();
        } else {
            this.md.update((byte)ch);
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        this.ensureReadInitial();
        int efflen = this.content_in.read(buffer, offset, len);
        if (efflen == -1) {
            this.terminate();
        } else {
            this.md.update(buffer, offset, efflen);
        }
        return efflen;
    }

    @Override
    public int available() throws IOException {
        this.ensureReadInitial();
        return this.content_in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureReadInitial();
        return this.content_in.skip(n);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

