/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.zip.DeflaterOutputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.EncapsulatedContentInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSCompressedDataContentInfo
extends CMSContentInfo {
    private AlgorithmIdentifier compressionAlgID;
    private CMSContentInfo contentInfo;
    private ASN1Integer version;
    private boolean writeDetached = false;
    private byte[] exposedContent = null;

    public CMSCompressedDataContentInfo() {
        super(CMS.id_ct_compressedData);
    }

    public CMSCompressedDataContentInfo(CMSContentInfo contentInfo, AlgorithmIdentifier compressionAlgID) throws AlgorithmIdentifierException {
        super(CMS.id_ct_compressedData);
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        if (!compressionAlgID.equals((Object)CMS.id_alg_zlibCompress)) {
            throw new AlgorithmIdentifierException("Unsupported Compression Algorithm: " + compressionAlgID);
        }
        this.contentInfo = contentInfo;
        this.compressionAlgID = compressionAlgID;
        this.version = new ASN1Integer(0L);
    }

    public CMSCompressedDataContentInfo(InputStream is) throws IOException {
        super(CMS.id_ct_compressedData);
        this.input(is);
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            if (this.contentInfo == null) {
                return null;
            }
            try {
                UnsyncByteArrayOutputStream ddStore = new UnsyncByteArrayOutputStream(10240000);
                this.version.output((OutputStream)ddStore);
                this.compressionAlgID.output((OutputStream)ddStore);
                ASN1Sequence s = new ASN1Sequence();
                s.addElement((ASN1Object)this.contentInfo.getContentType());
                byte[] buf = this.contentInfo.getExposedContent();
                if (buf != null) {
                    UnsyncByteArrayOutputStream ccStore = new UnsyncByteArrayOutputStream(256000);
                    DeflaterOutputStream dfo = new DeflaterOutputStream((OutputStream)ccStore);
                    dfo.write(buf, 0, buf.length);
                    dfo.finish();
                    dfo.flush();
                    byte[] compbuf = ccStore.toByteArray();
                    ASN1OctetString oct = new ASN1OctetString(compbuf);
                    s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)oct, 0));
                }
                s.output((OutputStream)ddStore);
                buf = ddStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NullPointerException ex) {
                throw new StreamableOutputException("CMS Object is not initialized: " + ex.toString());
            }
        }
        return this.exposedContent;
    }

    public void writeDetached(boolean writeDetached) {
        this.writeDetached = writeDetached;
        this.update();
    }

    public void setEnclosed(CMSContentInfo content) {
        if (this.contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        this.contentInfo = content;
        this.update();
    }

    public CMSContentInfo getEnclosed() {
        return this.contentInfo;
    }

    public ASN1ObjectID getEnclosedContentType() {
        return this.contentInfo.getContentType();
    }

    public AlgorithmIdentifier getCompressionAlgID() {
        return this.compressionAlgID;
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean isDetached() {
        if (this.contentInfo == null) {
            return true;
        }
        ASN1ObjectID cType = this.contentInfo.getContentType();
        if (cType.equals((Object)CMS.id_digestedData) || cType.equals((Object)CMS.id_signedData) || cType.equals((Object)CMS.id_ct_authData) || cType.equals((Object)CMS.id_encryptedData) || cType.equals((Object)CMS.id_envelopedData) || cType.equals((Object)CMS.id_ct_compressedData)) {
            return false;
        }
        return this.contentInfo.isDetached();
    }

    public String toString() {
        StringBuffer stbuf = new StringBuffer(32);
        stbuf.append("Version: " + this.version.intValue() + "\n");
        stbuf.append("CompressionAlgID: " + this.compressionAlgID.toString() + "\n");
        stbuf.append("Encapsulated Content-Type: " + this.contentInfo.getContentType() + "\n");
        if (this.isDetached()) {
            stbuf.append("detached CMS 'compressedData' object \n");
        } else {
            stbuf.append("CMS 'compressedData' object, encloses " + this.contentInfo.toString() + "\n");
        }
        return stbuf.toString();
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSCompressedDataContentInfo)) {
            return false;
        }
        return this.hashCode() == ((CMSCompressedDataContentInfo)obj).hashCode();
    }

    @Override
    protected void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream dd = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)dd);
        if (!this.version.equals(0)) {
            throw new VersionException("Expected Version 0 but got Version " + this.version.getValue());
        }
        this.compressionAlgID = new AlgorithmIdentifier((InputStream)dd);
        if (!this.compressionAlgID.equals((Object)CMS.id_alg_zlibCompress)) {
            throw new InvalidInputException("Unsupported Compression Algorithm: " + this.compressionAlgID);
        }
        EncapsulatedContentInfo encap_info = new EncapsulatedContentInfo((InputStream)dd, true);
        this.contentInfo = encap_info.getCMSContentInfo();
        dd.terminate();
        if (this.contentInfo.isDetached()) {
            this.writeDetached = true;
        }
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }
}

