/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;

class OracleButtonListener
extends BasicButtonListener {
    private static final int _sPADDING = 5;
    private boolean _mouseOver;
    private boolean _mousePressed;

    public OracleButtonListener(AbstractButton b) {
        super(b);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this._isOutsideButtonLabel(e)) {
            return;
        }
        super.mouseEntered(e);
        this._mouseOver = true;
        ((AbstractButton)e.getSource()).getModel().setArmed(this._mouseOver);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this._mouseOver = false;
        ((AbstractButton)e.getSource()).getModel().setArmed(this._mouseOver);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        if (this._isOutsideButtonLabel(e)) {
            b.requestFocus();
            return;
        }
        this._mousePressed = true;
        super.mousePressed(e);
        ((AbstractButton)e.getSource()).getModel().setArmed(this._mouseOver);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this._mousePressed && this._isOutsideButtonLabel(e)) {
            return;
        }
        this._mousePressed = false;
        super.mouseReleased(e);
        ((AbstractButton)e.getSource()).getModel().setArmed(this._mouseOver);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this._mouseOver = !this._isOutsideButtonLabel(e);
        super.mouseMoved(e);
        ((AbstractButton)e.getSource()).getModel().setArmed(this._mouseOver);
    }

    private boolean _isOutsideButtonLabel(MouseEvent e) {
        AbstractButton b = (AbstractButton)e.getSource();
        ButtonUI ui = b.getUI();
        if (ui instanceof BasicRadioButtonUI) {
            Graphics g;
            BasicRadioButtonUI radioUI = (BasicRadioButtonUI)ui;
            Dimension size = b.getSize();
            Rectangle viewRect = new Rectangle(size);
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            int iconGap = b.getIconTextGap();
            Insets i = b.getInsets();
            viewRect.x += i.left;
            viewRect.y += i.top;
            viewRect.width -= i.right + viewRect.x;
            viewRect.height -= i.bottom + viewRect.y;
            Icon altIcon = b.getIcon();
            FontMetrics fm = null;
            Font f = b.getFont();
            if (f != null) {
                fm = b.getFontMetrics(f);
            }
            if (fm == null && (g = b.getGraphics()) != null) {
                fm = g.getFontMetrics();
            }
            if (fm == null) {
                return false;
            }
            SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), altIcon != null ? altIcon : radioUI.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, iconGap);
            int x = e.getX();
            int y = e.getY();
            Rectangle iconText = new Rectangle();
            iconText.x = Math.min(iconRect.x, textRect.x);
            iconText.width = iconRect.width + textRect.width + iconGap;
            iconText.y = Math.min(iconRect.y, textRect.y);
            iconText.height = Math.max(iconRect.y + iconRect.height, textRect.y + textRect.height) - iconText.y;
            if (x < iconText.x - 5 || x > iconText.x + iconText.width + 5 || y < iconText.y - 5 || y > iconText.y + iconText.height + 5) {
                return true;
            }
        }
        return false;
    }
}

