/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.ide.event.AttributeImpl;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.LocationAdapterImpl;
import javax.ide.extension.spi.LocatorImpl;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.events.Attribute;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXManifestParser {
    private final DefaultElementContext _context;
    private SAXParser _parser = null;
    private Handler _handler = null;
    private Locator _locator;
    private static LocatorWrapperFactory s_locatorWrapper = null;

    public SAXManifestParser(DefaultElementContext initialContext) {
        this._context = initialContext;
    }

    public ElementContext getContext() {
        return this._context;
    }

    public void parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        this.parse(null, inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XMLReader reader, InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        if (reader == null) {
            if (this._parser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                this._parser = factory.newSAXParser();
            }
            reader = this._parser.getXMLReader();
        }
        if (this._handler == null) {
            this._handler = new Handler();
        }
        reader.setContentHandler(this._handler);
        reader.setErrorHandler(this._handler);
        try {
            reader.parse(inputSource);
        }
        finally {
            this._context.reset();
        }
    }

    public static void setLocatorWrapperFactory(LocatorWrapperFactory factory) {
        s_locatorWrapper = factory;
    }

    public static Locator copyLocator(Locator locator) {
        if (locator == null) {
            return null;
        }
        if (locator instanceof LocatorWrapper) {
            return ((LocatorWrapper)locator).createSnapshotCopy();
        }
        return new LocatorImpl(locator.getPublicId(), locator.getSystemId(), locator.getColumnNumber(), locator.getLineNumber());
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
            ElementVisitor visitor = SAXManifestParser.this._context.getVisitorForStartElement(new ElementName(uri, name));
            SAXManifestParser.this._context.beginElement(uri, name, new SAXAttributesAdapter(attributes));
            if (visitor != null) {
                this.recordPosition(SAXManifestParser.this._context);
                try {
                    visitor.start(SAXManifestParser.this._context);
                }
                catch (Throwable re) {
                    if (re instanceof ThreadDeath) {
                        throw (ThreadDeath)re;
                    }
                    ExtensionLogRecord r = new ExtensionLogRecord(new LocationAdapterImpl(SAXManifestParser.this._locator), Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                    r.setThrown(re);
                    SAXManifestParser.this._context.getLogger().log(r);
                }
            }
            SAXManifestParser.this._context.postBeginElement();
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            SAXManifestParser.this._context.endElement(uri, name);
            ElementVisitor visitor = SAXManifestParser.this._context.getVisitorForEndElement();
            if (visitor != null) {
                this.recordPosition(SAXManifestParser.this._context);
                try {
                    visitor.end(SAXManifestParser.this._context);
                }
                catch (Throwable re) {
                    if (re instanceof ThreadDeath) {
                        throw (ThreadDeath)re;
                    }
                    ExtensionLogRecord r = new ExtensionLogRecord(new LocationAdapterImpl(SAXManifestParser.this._locator), Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                    r.setThrown(re);
                    SAXManifestParser.this._context.getLogger().log(r);
                }
            }
            SAXManifestParser.this._context.postEndElement();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            SAXManifestParser.this._context.appendCharacters(ch, start, length);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            SAXManifestParser.this._locator = s_locatorWrapper != null ? s_locatorWrapper.wrapLocator(locator) : locator;
        }

        private void recordPosition(ElementContext context) {
            context.getScopeData().put("xml.locator", SAXManifestParser.this._locator != null ? new LocationAdapterImpl(SAXManifestParser.this._locator) : SAXManifestParser.this._locator);
        }

        private class SAXAttributesAdapter
        implements DefaultElementContext.Attributes {
            private final Attributes m_attributes;

            SAXAttributesAdapter(Attributes attributes) {
                this.m_attributes = attributes;
            }

            @Override
            public String getValue(String key) {
                return this.m_attributes.getValue(key);
            }

            @Override
            public Iterator<Attribute> iterator() {
                return new Iterator<Attribute>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < SAXAttributesAdapter.this.m_attributes.getLength();
                    }

                    @Override
                    public Attribute next() {
                        AttributeImpl attribute = new AttributeImpl(SAXAttributesAdapter.this.m_attributes.getLocalName(this.index), SAXAttributesAdapter.this.m_attributes.getValue(this.index));
                        ++this.index;
                        return attribute;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove not supported");
                    }
                };
            }
        }
    }

    public static interface LocatorWrapperFactory {
        public LocatorWrapper wrapLocator(Locator var1);
    }

    public static interface LocatorWrapper
    extends Locator {
        public LocatorWrapper createSnapshotCopy();
    }
}

