/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.Service;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.UnrecognizedElementException;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.DependencyTree;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.MinimalExtensionParser;
import javax.ide.extension.spi.MinimalExtensionVisitor;
import javax.ide.extension.spi.PullManifestParser;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.Version;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;

public abstract class ExtensionRegistry
extends Service {
    private Map<String, Extension> _extensions;
    private ElementVisitorFactory _hookFactory;
    private ExtensionVisitor _extensionVisitor;
    private Map<String, Extension> _idToMinimalExtensionMap;

    public final Extension findExtension(String id) {
        if (this._extensions == null) {
            return this._extensionVisitor != null ? this._extensionVisitor.findExtension(id) : null;
        }
        return this._extensions.get(id);
    }

    public final Collection<Extension> getExtensions() {
        return Collections.unmodifiableCollection(this._extensions.values());
    }

    public ExtensionHook getHook(ElementName hookElement) {
        if (hookElement == null) {
            throw new NullPointerException("Null hookElement");
        }
        try {
            return (ExtensionHook)this._hookFactory.getVisitor(hookElement);
        }
        catch (UnrecognizedElementException ue) {
            return null;
        }
    }

    public Extension findMinimalExtension(String extensionId) {
        return this._idToMinimalExtensionMap.get(extensionId);
    }

    protected abstract Collection findAllExtensionSources();

    protected ElementContext createInitialContext() {
        return new DefaultElementContext();
    }

    protected Collection loadExtensions() {
        Collection sources = this.findAllExtensionSources();
        ArrayList<ExtensionSource> validSources = new ArrayList<ExtensionSource>();
        ArrayList<ExtensionSource> failedSources = new ArrayList<ExtensionSource>();
        for (ExtensionSource source : sources) {
            if (source.getManifestURI() == null) continue;
            validSources.add(source);
        }
        MinimalExtensionVisitor visitor = this.createMinimalExtensionVisitor();
        MinimalExtensionParser.loadMinimal(visitor, (DefaultElementContext)this.createInitialContext(), validSources, failedSources);
        this._idToMinimalExtensionMap = visitor.getIdToMinimalExtensionMap();
        Map<Extension, ExtensionSource> minimalExtensionsToSources = visitor.getSourcesByExtension();
        Iterator<Extension> iter = minimalExtensionsToSources.keySet().iterator();
        while (iter.hasNext()) {
            Extension minimalExtension = iter.next();
            if (this.isExtensionEnabled(minimalExtension.getID(), minimalExtension.getVersion())) continue;
            iter.remove();
        }
        Sorter extensionSorter = this.createExtensionSorter(minimalExtensionsToSources);
        List<ExtensionSource> orderedSources = extensionSorter.getOrderedExtensionSources();
        Collection extensions = this.loadExtensions(orderedSources);
        extensionSorter.handleCycles();
        extensionSorter.handleUnsatisfiedDependencies();
        return extensions;
    }

    protected Sorter createExtensionSorter(Map<Extension, ExtensionSource> minimalExtensionsToSources) {
        return new DefaultSorter(minimalExtensionsToSources);
    }

    protected MinimalExtensionVisitor createMinimalExtensionVisitor() {
        return new MinimalExtensionVisitor();
    }

    protected boolean isExtensionEnabled(String id, Version version) {
        return true;
    }

    protected void cycleEncountered(Collection cycle) {
    }

    protected void unsatisfiedExtensionDependencies(Extension ext, Collection deps) {
    }

    protected Collection loadExtensions(Collection orderedSources) {
        if (this._hookFactory == null) {
            this._hookFactory = this.createHookVisitorFactory();
        }
        DefaultElementContext context = (DefaultElementContext)this.createInitialContext();
        PullManifestParser parser = new PullManifestParser(context);
        this._extensionVisitor = this.createExtensionVisitor(this._hookFactory);
        parser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, this._extensionVisitor);
        int totalCount = orderedSources.size();
        int currentCount = 1;
        for (ExtensionSource source : orderedSources) {
            this.loadExtension(parser, context.getLogger(), source, totalCount, currentCount);
            ++currentCount;
        }
        return this._extensionVisitor.getExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExtension(PullManifestParser parser, Logger logger, ExtensionSource source, int totalCount, int currentCount) {
        parser.getContext().getScopeData().put("extSource", source);
        URI uri = source.getManifestURI();
        InputStream inStream = null;
        try {
            inStream = source.getInputStream();
            parser.parse(inStream, uri.toString());
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Error loading manifest from " + source.getName(), ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException("Badly configured jaxb");
        }
        catch (XMLStreamException xmlSE) {
            logger.log(Level.SEVERE, "Failed to parse manifest from " + source.getName(), xmlSE);
        }
        catch (RuntimeException re) {
            logger.log(Level.SEVERE, "RuntimeException parsing manifest from " + source.getName() + ": " + re, re);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Error closing stream for " + source.getName(), ioe);
            }
        }
    }

    protected Logger createExtensionLogger() {
        return Logger.getLogger(ExtensionRegistry.class.getName());
    }

    protected abstract ExtensionVisitor createExtensionVisitor(ElementVisitorFactory var1);

    protected void addToClassPath(ExtensionSource source) {
    }

    protected ElementVisitorFactory createHookVisitorFactory() {
        return new DefaultHookVisitorFactory();
    }

    @Override
    protected void initialize() {
        Collection extensions = this.loadExtensions();
        this._extensions = new LinkedHashMap<String, Extension>(256);
        for (Extension ext : extensions) {
            this._extensions.put(ext.getID(), ext);
        }
    }

    public static ExtensionRegistry getExtensionRegistry() {
        try {
            return (ExtensionRegistry)ExtensionRegistry.getService(ExtensionRegistry.class);
        }
        catch (ProviderNotFoundException nse) {
            throw new IllegalStateException("No extension registry", nse);
        }
    }

    public abstract URI getInstallRoot(Extension var1);

    public ClassLoader getClassLoader(String extensionId) {
        return Thread.currentThread().getContextClassLoader();
    }

    public static interface Sorter {
        public List<ExtensionSource> getOrderedExtensionSources();

        public void handleCycles();

        public void handleUnsatisfiedDependencies();
    }

    private class DefaultSorter
    implements Sorter {
        private DependencyTree _dependencyTree;

        DefaultSorter(Map<Extension, ExtensionSource> minimalExtensionsToSources) {
            this._dependencyTree = DependencyTree.buildTree(minimalExtensionsToSources);
        }

        @Override
        public List<ExtensionSource> getOrderedExtensionSources() {
            ArrayList<ExtensionSource> orderedSources = new ArrayList<ExtensionSource>();
            for (String id : this._dependencyTree.getSortedExtensionIDs()) {
                orderedSources.add(this._dependencyTree.getSource(id));
            }
            return orderedSources;
        }

        @Override
        public void handleCycles() {
            Iterator i = this._dependencyTree.getCycles().iterator();
            while (i.hasNext()) {
                ExtensionRegistry.this.cycleEncountered((Collection)i.next());
            }
        }

        @Override
        public void handleUnsatisfiedDependencies() {
            for (Extension unsatisfied : this._dependencyTree.getUnsatisfiedExtensions()) {
                Collection deps = this._dependencyTree.getUnsatisfiedDependencies(unsatisfied);
                ExtensionRegistry.this.unsatisfiedExtensionDependencies(unsatisfied, deps);
            }
        }
    }
}

