/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common.build;

import java.util.Locale;
import oracle.dmt.dataminer.core.model.CorePartitionsLrb;
import oracle.dmt.dataminer.core.model.common.build.Column;
import oracle.dmt.dataminer.core.utils.StringUtils;

public class ColumnFilter {
    private Column _targetColumn;
    private String _filterValue;
    private Operator _operator;

    public ColumnFilter(Column column, Operator operator, String string) {
        this._targetColumn = column;
        this._operator = operator;
        this._filterValue = string;
    }

    public void setTargetColumn(Column column) {
        this._targetColumn = column;
    }

    public Column getTargetColumn() {
        return this._targetColumn;
    }

    public void setOperator(Operator operator) {
        this._operator = operator;
    }

    public Operator getOperator() {
        return this._operator;
    }

    public void setValue(String string) {
        this._filterValue = string;
    }

    public String getValue() {
        return this._filterValue;
    }

    public static ColumnFilter createEmptyFilter() {
        return new ColumnFilter(null, Operator.EMPTY, "");
    }

    public boolean isComplete() {
        return this._targetColumn != null && this._operator != Operator.EMPTY && (this._operator.isNumberOperator() && StringUtils.isEmpty(this._filterValue) || StringUtils.isNotEmpty(this._filterValue));
    }

    public boolean isEmpty() {
        return this._targetColumn == null && this._operator == Operator.EMPTY && StringUtils.isEmpty(this._filterValue);
    }

    public static final class Operator
    extends Enum<Operator> {
        public static final /* enum */ Operator CONTAINS = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_CONTAINS"), true, false, "%{}%", "LIKE ?");
        public static final /* enum */ Operator EMPTY = new Operator("", true, true, "", "");
        public static final /* enum */ Operator ENDS = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_END"), true, false, "%{}", "LIKE ?");
        public static final /* enum */ Operator EXIST = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_EXIST"), false, true, "%{}", "IS NOT NULL");
        public static final /* enum */ Operator EQUALS = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_IS"), true, true, "{}", "= ?");
        public static final /* enum */ Operator IS = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_IS"), true, true, "{}", "= ?");
        public static final /* enum */ Operator IS_NOT = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_ISNOT"), true, false, "{}", "!= ?");
        public static final /* enum */ Operator GREATER_THAN = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_GT"), false, true, "{}", "> ?");
        public static final /* enum */ Operator LESS_THAN = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_LT"), false, true, "{}", "< ?");
        public static final /* enum */ Operator NOT_CONTAINS = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_NOT_CONTAINS"), true, false, "%{}%", "NOT LIKE ?");
        public static final /* enum */ Operator NOT_END = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_NOT_END"), true, false, "%{}", "NOT LIKE ?");
        public static final /* enum */ Operator NOT_START = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_NOT_STARTS"), true, false, "{}%", "NOT LIKE ?");
        public static final /* enum */ Operator STARTS = new Operator(CorePartitionsLrb.get("FILTER_OPERATOR_STARTS"), true, false, "{}%", "LIKE ?");
        private String label;
        private boolean isStringOperator;
        private boolean isNumberOperator;
        private String sqlQueryParam;
        private String sqlQueryOperator;
        private static final /* synthetic */ Operator[] $VALUES;

        public static Operator[] values() {
            return (Operator[])$VALUES.clone();
        }

        public static Operator valueOf(String string) {
            return Enum.valueOf(Operator.class, string);
        }

        private Operator(String string2, boolean bl, boolean bl2, String string3, String string4) {
            this.label = string2;
            this.isStringOperator = bl;
            this.isNumberOperator = bl2;
            this.sqlQueryParam = string3;
            this.sqlQueryOperator = string4;
        }

        public String toString() {
            return this.label;
        }

        public boolean isStringOperator() {
            return this.isStringOperator;
        }

        public boolean isNumberOperator() {
            return this.isNumberOperator;
        }

        public String toStringQueryParam(String string) {
            assert (this.isStringOperator()) : "Not a string operator";
            string = string.toUpperCase(Locale.getDefault());
            return this.sqlQueryParam.replace("{}", string);
        }

        public Double toNumberQueryParam(String string) {
            assert (this.isNumberOperator()) : "Not a number Operator";
            return Double.valueOf(string);
        }

        public String getSqlQueryOperator() {
            return this.sqlQueryOperator;
        }

        private static /* synthetic */ Operator[] $values() {
            return new Operator[]{CONTAINS, EMPTY, ENDS, EXIST, EQUALS, IS, IS_NOT, GREATER_THAN, LESS_THAN, NOT_CONTAINS, NOT_END, NOT_START, STARTS};
        }

        static {
            $VALUES = Operator.$values();
        }
    }

    public static enum Match {
        ALL,
        ANY,
        NONE;

    }
}

