/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.common.GetModelPartitionsMapper;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionTestResult;
import oracle.dmt.dataminer.core.model.common.build.partition.Rule;
import oracle.dmt.dataminer.core.model.common.build.partition.RulesPartitionFilterData;
import oracle.javatools.util.Version;

public class GetModelPartitionsQuery
extends SqlQuery<PartitionTestResult, PreparedStatement> {
    private String[] models;
    private String quotedModelsList;
    private RulesPartitionFilterData filterData;
    private Map<String, String> mapPerformanceTables;

    public GetModelPartitionsQuery(Version version, String[] stringArray, String string, RulesPartitionFilterData rulesPartitionFilterData, Map<String, String> map, GetModelPartitionsMapper getModelPartitionsMapper) {
        super(version, getModelPartitionsMapper);
        this.models = stringArray;
        this.quotedModelsList = string;
        this.filterData = rulesPartitionFilterData;
        this.mapPerformanceTables = map;
    }

    @Override
    public String getSQLCommand() {
        StringBuilder stringBuilder = new StringBuilder();
        this.createQueryAllModelPartitions(stringBuilder);
        this.createQueryFilteredPartitions(stringBuilder, this.filterData);
        this.createQueryTopValues(stringBuilder, this.filterData);
        this.createQuerySelectedModelPartions(stringBuilder);
        this.createQueryPartMetricTable(stringBuilder);
        this.createFullInformationTable(stringBuilder);
        this.createFinalQuery(stringBuilder);
        String string = stringBuilder.toString();
        return string;
    }

    private void createQueryAllModelPartitions(StringBuilder stringBuilder) {
        stringBuilder.append("WITH\nModelPartitionsTable AS\n  (SELECT mp.owner, mp.model_name, mp.partition_name, mp.position, ma.attribute_name, \n          ma.data_type, NVL(mp.column_value, '(null)') AS column_value \n   FROM all_mining_model_partitions mp\n   INNER JOIN all_mining_model_attributes ma \n    ON  mp.owner       = ma.owner\n    AND mp.model_name  = ma.model_name\n    AND mp.column_name = ma.attribute_name\n   WHERE mp.model_name IN (");
        stringBuilder.append(this.quotedModelsList);
        stringBuilder.append(") \n   ORDER BY mp.owner, mp.model_name, mp.partition_name, mp.position),\n\n");
    }

    private void createQueryFilteredPartitions(StringBuilder stringBuilder, RulesPartitionFilterData rulesPartitionFilterData) {
        for (int i = 0; i < this.models.length; ++i) {
            String string = "FilteredPartitionsTable" + i;
            String string2 = this.mapPerformanceTables.get(this.models[i]);
            String string3 = "'" + this.models[i] + "'";
            stringBuilder.append(string);
            stringBuilder.append(" AS \n");
            stringBuilder.append("  (SELECT DISTINCT model_name, partition_name FROM\n");
            stringBuilder.append("    (");
            this.createQueryFilteredPartitionsRules(stringBuilder, string3, rulesPartitionFilterData);
            stringBuilder.append("     ORDER BY partition_name)\n");
            stringBuilder.append("   WHERE partition_name IN (SELECT DISTINCT partition_name FROM ");
            stringBuilder.append(string2);
            stringBuilder.append(")),\n\n");
        }
    }

    private void createQueryFilteredPartitionsRules(StringBuilder stringBuilder, String string, RulesPartitionFilterData rulesPartitionFilterData) {
        boolean bl;
        String string2 = "SELECT DISTINCT model_name, partition_name\n     FROM ModelPartitionsTable\n     WHERE model_name = ";
        boolean bl2 = bl = !rulesPartitionFilterData.getRules().isEmpty();
        if (bl) {
            Iterator<Rule> iterator = rulesPartitionFilterData.getRules().iterator();
            while (iterator.hasNext()) {
                Rule rule = iterator.next();
                stringBuilder.append(string2);
                stringBuilder.append(string);
                stringBuilder.append("\n     AND attribute_name = '");
                stringBuilder.append(rule.getPartitionKey());
                stringBuilder.append("' AND ");
                if (rule.getPartitionKey().isStringDataType()) {
                    stringBuilder.append("UPPER(column_value)");
                } else {
                    stringBuilder.append("TO_NUMBER(column_value)");
                }
                stringBuilder.append(rule.getOperator().getSqlQueryOperator());
                boolean bl3 = iterator.hasNext();
                if (!bl3) continue;
                if (rulesPartitionFilterData.isMatchAll()) {
                    stringBuilder.append(" \n       INTERSECT \n     ");
                    continue;
                }
                stringBuilder.append(" \n       UNION \n     ");
            }
        } else {
            stringBuilder.append(string2);
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
    }

    private void createQueryTopValues(StringBuilder stringBuilder, RulesPartitionFilterData rulesPartitionFilterData) {
        stringBuilder.append("TopValuesTable AS\n  (SELECT DISTINCT model_name, partition_name \n   FROM \n     (");
        this.createQueryTopValuesSorting(stringBuilder, rulesPartitionFilterData);
        stringBuilder.append(") \n  WHERE ROWNUM <= ");
        stringBuilder.append(rulesPartitionFilterData.getFetchSize());
        stringBuilder.append("),\n\n");
    }

    private void createQueryTopValuesSorting(StringBuilder stringBuilder, RulesPartitionFilterData rulesPartitionFilterData) {
        for (int i = 0; i < this.models.length; ++i) {
            boolean bl = i == this.models.length - 1;
            String string = "FilteredPartitionsTable" + i;
            String string2 = this.mapPerformanceTables.get(this.models[i]);
            String string3 = "'" + this.models[i] + "'";
            if (rulesPartitionFilterData.getSortColumn() == null) {
                this.createQueryTopValuesSortingSimple(stringBuilder, string);
            } else {
                String string4 = rulesPartitionFilterData.getSortColumn().getTableColumnName();
                String string5 = null;
                if ("MODEL_NAME".equals(string4)) {
                    this.createQueryTopValuesSortingSimple(stringBuilder, string);
                    string5 = "model_name";
                } else if ("PARTITION_NAME".equals(string4)) {
                    this.createQueryTopValuesSortingSimple(stringBuilder, string);
                    string5 = "partition_name";
                } else if ("PART_VALUES".equals(string4)) {
                    this.createQueryTopValuesSortingByPartitionName(stringBuilder, string);
                    string5 = "partition_gui_name";
                } else if ("NUM_ROWS".equals(string4)) {
                    this.createQueryTopValuesSortingByBuildRows(stringBuilder, string, this.models[i]);
                    string5 = "numeric_value";
                } else {
                    this.createQueryTopValuesSortingByMetric(stringBuilder, string, string3, string2, string4);
                    string5 = "metric_num_value";
                }
                if (bl) {
                    stringBuilder.append("\n      ORDER BY ");
                    stringBuilder.append(string5);
                    stringBuilder.append(' ');
                    stringBuilder.append(rulesPartitionFilterData.getSortOrder().getSqlKeyword());
                }
            }
            if (bl) continue;
            stringBuilder.append("\n       UNION\n      ");
        }
    }

    private void createQueryTopValuesSortingSimple(StringBuilder stringBuilder, String string) {
        stringBuilder.append("SELECT model_name, partition_name FROM ");
        stringBuilder.append(string);
    }

    private void createQueryTopValuesSortingByPartitionName(StringBuilder stringBuilder, String string) {
        stringBuilder.append("SELECT model_name, partition_name, \n");
        stringBuilder.append("             LISTAGG(column_value, '_') WITHIN GROUP(ORDER BY owner, model_name, partition_name, position) AS partition_gui_name \n");
        stringBuilder.append("      FROM ModelPartitionsTable \n");
        stringBuilder.append("      WHERE partition_name IN ( SELECT partition_name FROM ");
        stringBuilder.append(string);
        stringBuilder.append(" )\n");
        stringBuilder.append("      GROUP BY owner, model_name, partition_name");
    }

    private void createQueryTopValuesSortingByMetric(StringBuilder stringBuilder, String string, String string2, String string3, String string4) {
        stringBuilder.append("SELECT ");
        stringBuilder.append(string2);
        stringBuilder.append(" AS model_name, partition_name, metric_num_value \n");
        stringBuilder.append("      FROM ");
        stringBuilder.append(string3);
        stringBuilder.append("\n      WHERE metric_name = ");
        stringBuilder.append("'");
        stringBuilder.append(string4);
        stringBuilder.append("' \n");
        stringBuilder.append("      AND partition_name IN ( SELECT partition_name FROM ");
        stringBuilder.append(string);
        stringBuilder.append(" )");
    }

    private void createQueryTopValuesSortingByBuildRows(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append("SELECT '");
        stringBuilder.append(string2);
        stringBuilder.append("' AS model_name, m.partition_name, numeric_value\n");
        stringBuilder.append("      FROM DM$VG");
        stringBuilder.append(string2);
        stringBuilder.append(" m inner join ");
        stringBuilder.append(string);
        stringBuilder.append(" f on m.partition_name = f.partition_name  WHERE name = 'NUM_ROWS'");
    }

    private void createQuerySelectedModelPartions(StringBuilder stringBuilder) {
        stringBuilder.append("SelectedPartitionsTable AS\n");
        stringBuilder.append("  (SELECT DISTINCT p.owner, p.model_name, p.partition_name, p.position, p.attribute_name, p.data_type, \n");
        stringBuilder.append("          NVL(p.column_value, '(null)') AS column_value \n");
        stringBuilder.append("   FROM ModelPartitionsTable p \n");
        stringBuilder.append("   INNER JOIN TopValuesTable t ON p.partition_name = t.partition_name\n");
        stringBuilder.append("    AND p.model_name = t.model_name\n");
        stringBuilder.append("   ORDER BY p.partition_name, p.position),\n\n");
    }

    private void createQueryPartMetricTable(StringBuilder stringBuilder) {
        String string;
        int n;
        boolean bl = false;
        for (n = 0; n < this.models.length; ++n) {
            bl = n == this.models.length - 1;
            string = "'" + this.models[n] + "'";
            String string2 = this.mapPerformanceTables.get(this.models[n]);
            String string3 = "PartMetricsTable" + n;
            stringBuilder.append(string3);
            stringBuilder.append(" AS \n");
            stringBuilder.append("  (SELECT p.owner, p.model_name, p.partition_name, p.position, p.attribute_name, \n");
            stringBuilder.append("          p.data_type, p.column_value, m.metric_name, m.metric_num_value \n");
            stringBuilder.append("   FROM SelectedPartitionsTable p \n");
            stringBuilder.append("   INNER JOIN\n");
            stringBuilder.append("    (SELECT metric_name, partition_name, metric_num_value FROM ");
            stringBuilder.append(string2);
            stringBuilder.append("\n     UNION \n");
            stringBuilder.append("     SELECT NAME AS metric_name, partition_name, numeric_value\n");
            stringBuilder.append("     FROM DM$VG");
            stringBuilder.append(this.models[n]);
            stringBuilder.append(" WHERE NAME = 'NUM_ROWS')\n");
            stringBuilder.append("    m ON p.partition_name = m.partition_name \n");
            stringBuilder.append("    AND p.model_name = ");
            stringBuilder.append(string);
            stringBuilder.append("\n   ORDER BY p.owner, p.partition_name, p.position, m.metric_name)");
            stringBuilder.append(",\n\n");
        }
        stringBuilder.append("PartMetricsTable AS\n  (");
        for (n = 0; n < this.models.length; ++n) {
            bl = n == this.models.length - 1;
            string = "PartMetricsTable" + n;
            stringBuilder.append("SELECT * FROM ");
            stringBuilder.append(string);
            if (bl) {
                stringBuilder.append("),\n\n");
                continue;
            }
            stringBuilder.append("\n    UNION\n   ");
        }
    }

    private void createFullInformationTable(StringBuilder stringBuilder) {
        stringBuilder.append("FullInformationTable AS\n");
        stringBuilder.append(" (SELECT owner, model_name, partition_name, position, attribute_name, data_type, column_value,\n");
        stringBuilder.append("        LISTAGG(metric_name,      chr(0)) WITHIN GROUP(ORDER BY owner, model_name, partition_name, position, metric_name) AS metrics,\n");
        stringBuilder.append("        LISTAGG(metric_num_value, chr(0)) WITHIN GROUP(ORDER BY owner, model_name, partition_name, position, metric_name) AS metrics_values\n");
        stringBuilder.append(" FROM PartMetricsTable\n");
        stringBuilder.append(" GROUP BY owner, model_name, partition_name, position, attribute_name, data_type, column_value\n");
        stringBuilder.append(" ORDER BY owner, model_name, partition_name)\n\n");
    }

    private void createFinalQuery(StringBuilder stringBuilder) {
        stringBuilder.append("SELECT owner, model_name, partition_name,\n");
        stringBuilder.append("       LISTAGG(attribute_name, chr(0)) WITHIN GROUP(ORDER BY owner, model_name, partition_name, position) as attribute_name,\n");
        stringBuilder.append("       LISTAGG(data_type,      chr(0)) WITHIN GROUP(ORDER BY owner, model_name, partition_name, position) as data_type,\n");
        stringBuilder.append("       LISTAGG(column_value,   chr(0)) WITHIN GROUP(ORDER BY owner, model_name, partition_name, position) as column_value,\n");
        stringBuilder.append("       metrics, metrics_values\n");
        stringBuilder.append("FROM FullInformationTable\n");
        stringBuilder.append("GROUP BY owner, model_name, partition_name, metrics, metrics_values\n");
        stringBuilder.append("ORDER BY owner, model_name, partition_name");
    }

    @Override
    public void setParameters(PreparedStatement preparedStatement) throws SQLException {
        int n = 1;
        for (int i = 0; i < this.models.length; ++i) {
            for (Rule rule : this.filterData.getRules()) {
                String string = rule.getValue().toUpperCase(Locale.getDefault());
                if (rule.getPartitionKey().isStringDataType()) {
                    preparedStatement.setString(n++, rule.getOperator().toStringQueryParam(string));
                    continue;
                }
                preparedStatement.setDouble(n++, rule.getOperator().toNumberQueryParam(string));
            }
        }
    }
}

