/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIterator
implements Iterator {
    private BufferedReader reader;
    private String previousLine;
    private String nextLine;
    private boolean done;
    private int lineCount;

    public LineIterator(BufferedReader reader) {
        this.reader = reader;
    }

    public LineIterator(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public LineIterator(InputStream stream) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    public boolean hasNext() {
        try {
            this.advance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !this.done;
    }

    public Object next() {
        try {
            this.advance();
        }
        catch (IOException e) {
            NoSuchElementException f = new NoSuchElementException();
            f.initCause(e);
            throw f;
        }
        if (this.nextLine == null) {
            throw new NoSuchElementException();
        }
        this.previousLine = this.nextLine;
        this.nextLine = null;
        ++this.lineCount;
        return this.previousLine;
    }

    public void repeat() {
        if (this.previousLine == null) {
            throw new NoSuchElementException();
        }
        this.nextLine = this.previousLine;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advance() throws IOException {
        if (this.nextLine == null) {
            this.nextLine = this.reader.readLine();
            if (this.nextLine == null) {
                this.done = true;
                this.previousLine = null;
            }
        }
    }
}

