/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class DependencyGraph<T>
implements Collection<T> {
    private final HashMap<T, Node<T>> nodes;
    private final HashSet<Node<T>> vertices = new HashSet();
    private final HashSet<Node<T>> dependentFree = new HashSet();
    private final HashSet<Node<T>> bidirectionalNodes = new HashSet();
    private final AtomicInteger edges = new AtomicInteger(0);
    private final AtomicInteger sequence = new AtomicInteger(0);
    private final ThreadLocal<Boolean> snapshotMode = new ThreadLocal();
    private final ThreadLocal<ArrayDeque<Node.Snapshot>> snapshotNodes = new ThreadLocal();
    private List<T> orderedListCache;
    private Collection<Collection<T>> foundCyclesCache;
    private final boolean threadSafe;
    private ReentrantReadWriteLock lock;

    public DependencyGraph(boolean threadSafe) {
        this.threadSafe = threadSafe;
        if (threadSafe) {
            this.lock = new ReentrantReadWriteLock();
        }
        this.nodes = new HashMap();
        this.snapshotMode.set(Boolean.FALSE);
    }

    public DependencyGraph() {
        this(false);
    }

    public DependencyGraph(int initialCapacity, boolean threadSafe) {
        this.threadSafe = threadSafe;
        if (threadSafe) {
            this.lock = new ReentrantReadWriteLock();
        }
        this.nodes = new HashMap(initialCapacity);
        this.snapshotMode.set(Boolean.FALSE);
    }

    public DependencyGraph(int initialCapacity) {
        this(initialCapacity, false);
    }

    private void takeSnapshot() {
        this.checkWriteLock();
        try {
            if (!this.snapshotMode.get().booleanValue()) {
                this.snapshotMode.set(Boolean.TRUE);
                this.snapshotNodes.set(new ArrayDeque());
            }
        }
        finally {
            this.checkWriteUnlock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardSnapshot() {
        block7: {
            this.checkWriteLock();
            try {
                this.snapshotMode.set(Boolean.FALSE);
                ArrayDeque<Node.Snapshot> snapshots = this.snapshotNodes.get();
                if (snapshots == null) break block7;
                this.snapshotNodes.remove();
                this.checkReadLock();
                try {
                    this.checkWriteUnlock(false);
                    Iterator<Node.Snapshot> iter = snapshots.iterator();
                    while (iter.hasNext()) {
                        iter.next().remove();
                        iter.remove();
                    }
                }
                finally {
                    this.checkReadUnlock();
                }
            }
            finally {
                this.checkWriteUnlock(false);
            }
        }
    }

    private boolean isSnapshot() {
        this.checkReadLock();
        try {
            boolean bl = this.snapshotMode.get();
            return bl;
        }
        finally {
            this.checkReadUnlock();
        }
    }

    private Node<T> createNode(T content) {
        return new Node<T>(content, this.sequence.getAndIncrement());
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public Collection<T> getDependentFreeNodes() {
        ArrayList list = new ArrayList(this.dependentFree.size());
        for (Node<T> node : this.dependentFree) {
            list.add(node.content);
        }
        return list;
    }

    public Collection<T> getIndependentNodes() {
        ArrayList list = new ArrayList(this.vertices.size());
        for (Node<T> node : this.vertices) {
            list.add(node.content);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean add(T content, boolean addOnlyIfNewContent) {
        node = null;
        modified = false;
        if (addOnlyIfNewContent) {
            this.checkWriteLock();
            try {
                if (this.nodes.containsKey(content)) ** GOTO lbl19
                node = this.createNode(content);
                this.nodes.put(content, node);
                modified = true;
            }
            finally {
                this.checkWriteUnlock(modified);
            }
        } else {
            node = this.createNode(content);
            this.nodes.put(content, node);
            modified = true;
        }
lbl19:
        // 3 sources

        if (modified) {
            this.vertices.add(node);
            if (!DependencyGraph.$assertionsDisabled && this.nodes.size() < this.vertices.size()) {
                throw new AssertionError((Object)"The number of vertices should never be greater than total number of nodes");
            }
            this.dependentFree.add(node);
            if (!DependencyGraph.$assertionsDisabled && this.nodes.size() < this.dependentFree.size()) {
                throw new AssertionError((Object)"The number of dependent-free nodes should never be greater than total number of nodes");
            }
        }
        return modified;
    }

    @Override
    public boolean add(T content) {
        if (content != null) {
            if (!this.nodes.containsKey(content)) {
                return this.add(content, true);
            }
            return false;
        }
        throw new NullPointerException("Can't add null content");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencies(T dependent, Collection<T> dependencies) {
        if (dependent == null || dependencies == null) {
            throw new NullPointerException("Can't add null content");
        }
        Node<T> to = null;
        boolean modified = false;
        boolean hasIncoming = false;
        this.checkWriteLock();
        try {
            to = this.nodes.get(dependent);
            if (to == null) {
                modified = this.add(dependent, false);
                to = this.nodes.get(dependent);
            } else {
                hasIncoming = to.hasIncoming();
                if (to.hasOutgoing() && !hasIncoming && dependencies.size() > 0) {
                    boolean added = this.bidirectionalNodes.add(to);
                    assert (added) : dependent + " has outgoing but not incoming connections, hence it should NOT have been found in internal bidirectionalNodes set.";
                }
            }
            for (T dep : dependencies) {
                boolean removed;
                Node<T> from = this.nodes.get(dep);
                if (from == null) {
                    this.add(dep, false);
                    from = this.nodes.get(dep);
                } else if (!from.hasOutgoing()) {
                    removed = this.dependentFree.remove(from);
                    assert (removed) : dep + " has no outgoing connections, hence it should have been found in internal dependentFree set.";
                }
                if (!hasIncoming) {
                    removed = this.vertices.remove(to);
                    assert (removed) : dep + " has no incoming connections, hence it should have been found in internal vertices set.";
                    hasIncoming = false;
                }
                boolean connectedOut = from.addOutgoing(to);
                boolean connectedIn = to.addIncoming(from);
                if (connectedOut && connectedIn) {
                    this.edges.incrementAndGet();
                } else assert (!(connectedOut ^ connectedIn)) : String.format("Found a previously existing illegal weak connection (one-way only) between %s and %s: %s -%s %s", dependent, dep, dependent, connectedOut ? "<" : ">", dep);
                if (!from.hasIncoming()) continue;
                this.bidirectionalNodes.add(from);
            }
            this.checkWriteUnlock(modified || dependencies.size() > 0);
        }
        catch (Throwable throwable) {
            this.checkWriteUnlock(modified || dependencies.size() > 0);
            throw throwable;
        }
    }

    public void addDependencies(T dependent, T ... dependencies) {
        if (dependent == null) {
            throw new NullPointerException("Can't add null content");
        }
        this.addDependencies(dependent, (Collection<T>)Arrays.asList(dependencies));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependencies(T dependent, T ... dependencies) {
        block10: {
            if (dependent == null) {
                throw new IllegalArgumentException("Can't remove dependencies from null content");
            }
            if (dependencies != null && dependencies.length > 0) {
                this.checkReadLock();
                try {
                    Node<T> to = this.nodes.get(dependent);
                    if (to == null) break block10;
                    this.checkReadUnlock();
                    this.checkWriteLock();
                    try {
                        for (T dep : dependencies) {
                            Node<T> from = this.nodes.get(dep);
                            if (from == null) continue;
                            this.edges.decrementAndGet();
                            from.removeOutgoing(to);
                            if (!from.hasOutgoing()) {
                                this.dependentFree.add(from);
                                this.bidirectionalNodes.remove(from);
                            }
                            to.removeIncoming(from);
                            if (to.hasIncoming()) continue;
                            this.vertices.add(to);
                            this.bidirectionalNodes.remove(to);
                        }
                    }
                    finally {
                        this.checkReadLock();
                        this.checkWriteUnlock(true);
                    }
                }
                finally {
                    this.checkReadUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        if (object != null) {
            this.checkWriteLock();
            try {
                Node<T> node = this.nodes.remove(object);
                if (node != null) {
                    this.edges.addAndGet(-node.countEdges());
                    Collection<Node<T>> edges = node.getOutgoingNodes();
                    for (Node<T> out : edges) {
                        out.removeIncoming(node);
                        if (out.hasIncoming()) continue;
                        this.vertices.add(out);
                        this.bidirectionalNodes.remove(out);
                    }
                    if (!node.hasIncoming()) {
                        this.vertices.remove(node);
                        this.bidirectionalNodes.remove(node);
                    } else {
                        edges = node.getIncomingNodes();
                        for (Node<T> in : edges) {
                            in.removeOutgoing(node);
                            if (in.hasOutgoing()) continue;
                            this.dependentFree.add(in);
                            this.bidirectionalNodes.remove(in);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.checkWriteUnlock(true);
            }
        }
        throw new NullPointerException("This graph does not accept null content");
    }

    @Override
    public boolean contains(Object content) {
        this.checkReadLock();
        try {
            boolean bl = this.nodes.containsKey(content);
            return bl;
        }
        finally {
            this.checkReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getDirectDependencies(T content) {
        this.checkReadLock();
        try {
            Node<T> node = this.nodes.get(content);
            if (node != null) {
                Collection<T> collection = Collections.unmodifiableCollection(node.getIncomingContents());
                return collection;
            }
        }
        finally {
            this.checkReadUnlock();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getDirectDependents(T content) {
        this.checkReadLock();
        try {
            Node<T> node = this.nodes.get(content);
            if (node != null) {
                Collection<T> collection = Collections.unmodifiableCollection(node.getOutgoingContents());
                return collection;
            }
        }
        finally {
            this.checkReadUnlock();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> toOrderedList() {
        ArrayList<T> list = null;
        int edgesLeft = 0;
        try {
            TreeSet<Node<T>> sortedVertices;
            this.checkWriteLock();
            try {
                if (this.orderedListCache != null) {
                    List<T> list2 = this.orderedListCache;
                    return list2;
                }
                this.takeSnapshot();
                this.checkReadLock();
                try {
                    this.checkWriteUnlock(true);
                    edgesLeft = this.edges.get();
                    list = new ArrayList<T>(this.nodes.size());
                    sortedVertices = new TreeSet<Node<T>>(this.vertices);
                }
                finally {
                    this.checkReadUnlock();
                }
            }
            finally {
                this.checkWriteUnlock(false);
            }
            Iterator<Node<T>> vertIter = sortedVertices.iterator();
            while (vertIter.hasNext()) {
                Node<T> node = vertIter.next();
                vertIter.remove();
                list.add(node.content);
                Collection<Node<T>> outgoing = node.getOutgoingNodes();
                Iterator<Node<T>> outIter = outgoing.iterator();
                while (outIter.hasNext()) {
                    Node<T> dependent = outIter.next();
                    outIter.remove();
                    --edgesLeft;
                    Collection<Node<T>> incoming = dependent.getIncomingNodes();
                    incoming.remove(node);
                    if (!incoming.isEmpty()) continue;
                    sortedVertices.add(dependent);
                    vertIter = sortedVertices.iterator();
                }
            }
        }
        finally {
            this.discardSnapshot();
        }
        if (edgesLeft > 0) {
            throw new IllegalStateException("Circular dependency detected");
        }
        this.checkWriteLock();
        try {
            this.orderedListCache = list != null ? list : Collections.emptyList();
        }
        finally {
            this.checkWriteUnlock(false);
        }
        return this.orderedListCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collection<T>> findCycles() {
        final HashSet<Collection<T>> cycles = new HashSet<Collection<T>>();
        final HashSet<Node<T>> candidateCycleRoots = new HashSet<Node<T>>(this.bidirectionalNodes.size());
        try {
            this.checkWriteLock();
            try {
                if (this.foundCyclesCache != null) {
                    Collection<Collection<T>> collection = this.foundCyclesCache;
                    return collection;
                }
                this.takeSnapshot();
                this.checkReadLock();
                try {
                    this.checkWriteUnlock(true);
                    candidateCycleRoots.addAll(this.bidirectionalNodes);
                }
                finally {
                    this.checkReadUnlock();
                }
            }
            finally {
                this.checkWriteUnlock(false);
            }
            Iterator nodesIter = candidateCycleRoots.iterator();
            while (nodesIter.hasNext()) {
                try {
                    final class CycleFinder {
                        final LinkedHashSet<T> currentCycle = new LinkedHashSet();
                        final Node<T> root;

                        public CycleFinder(Node<T> root) {
                            this.root = root;
                        }

                        public void findCycles() {
                            this.findCycles(this.root);
                        }

                        private void findCycles(Node<T> node) {
                            if (node != this.root || this.currentCycle.isEmpty()) {
                                if (this.currentCycle.contains(node.content)) {
                                    return;
                                }
                                this.currentCycle.add(node.content);
                                Collection outgoing = node.getOutgoingNodes();
                                for (Node out : outgoing) {
                                    if (!out.hasOutgoing()) continue;
                                    if (out.countEdges() == 2) {
                                        candidateCycleRoots.remove(out);
                                    }
                                    this.findCycles(out);
                                }
                                this.currentCycle.remove(node.content);
                            } else {
                                cycles.add(new LinkedHashSet(this.currentCycle));
                            }
                        }
                    }
                    CycleFinder finder = new CycleFinder((Node)nodesIter.next());
                    finder.findCycles();
                }
                catch (ConcurrentModificationException ex) {
                    nodesIter = candidateCycleRoots.iterator();
                }
            }
        }
        finally {
            this.discardSnapshot();
        }
        this.checkWriteLock();
        try {
            this.foundCyclesCache = cycles != null ? cycles : Collections.emptySet();
        }
        finally {
            this.checkWriteUnlock(false);
        }
        return this.foundCyclesCache;
    }

    private void checkWriteLock() {
        if (this.threadSafe) {
            this.lock.writeLock().lock();
        }
    }

    private void checkWriteUnlock(boolean markDirty) {
        if (markDirty) {
            this.orderedListCache = null;
            this.foundCyclesCache = null;
        }
        if (this.threadSafe && this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().unlock();
        }
    }

    private void checkReadLock() {
        if (this.threadSafe) {
            this.lock.readLock().lock();
        }
    }

    private void checkReadUnlock() {
        if (this.threadSafe) {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> content) {
        if (content != null) {
            boolean modified = false;
            this.checkWriteLock();
            try {
                for (T c : content) {
                    if (!this.add(c) || modified) continue;
                    modified = true;
                }
            }
            finally {
                this.checkWriteUnlock(modified);
            }
            return modified;
        }
        throw new NullPointerException("Specified Collection cannot be null");
    }

    @Override
    public void clear() {
        this.checkWriteLock();
        try {
            this.nodes.clear();
            this.vertices.clear();
            this.dependentFree.clear();
            this.bidirectionalNodes.clear();
            this.edges.set(0);
            this.sequence.set(0);
        }
        finally {
            this.checkWriteUnlock(true);
        }
    }

    @Override
    public boolean containsAll(Collection c) {
        if (c != null) {
            this.checkReadLock();
            try {
                boolean bl = this.nodes.keySet().containsAll(c);
                return bl;
            }
            finally {
                this.checkReadUnlock();
            }
        }
        throw new NullPointerException("Specified Collection cannot be null");
    }

    @Override
    public boolean isEmpty() {
        this.checkReadLock();
        try {
            boolean bl = this.nodes.isEmpty();
            return bl;
        }
        finally {
            this.checkReadUnlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.checkReadLock();
        try {
            ContentIterator contentIterator = new ContentIterator(this.nodes.keySet().iterator());
            return contentIterator;
        }
        finally {
            this.checkReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection content) {
        if (content != null) {
            boolean modified = false;
            this.checkWriteLock();
            try {
                for (Object c : content) {
                    if (!this.remove(c) || modified) continue;
                    modified = true;
                }
            }
            finally {
                this.checkWriteUnlock(true);
            }
            return modified;
        }
        throw new NullPointerException("Specified Collection cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection content) {
        if (content != null) {
            boolean modified = false;
            this.checkWriteLock();
            try {
                for (T c : this.nodes.keySet()) {
                    if (content.contains(c) || !this.remove(c) || modified) continue;
                    modified = true;
                }
            }
            finally {
                this.checkWriteUnlock(true);
            }
            return modified;
        }
        throw new NullPointerException("Specified Collection cannot be null");
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        return this.toArray((E[])array);
    }

    @Override
    public <E> E[] toArray(E[] array) {
        this.checkReadLock();
        try {
            E[] EArray = this.nodes.keySet().toArray(array);
            return EArray;
        }
        finally {
            this.checkReadUnlock();
        }
    }

    public String toString() {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) break;
            sb.append(',').append(' ');
        }
        return sb.append(']').toString();
    }

    private final class Node<C>
    implements Comparable<Node> {
        private final C content;
        private final int sequence;
        private final WeakHashMap<Node<C>, C> inbound = new WeakHashMap();
        private final WeakHashMap<Node<C>, C> outbound = new WeakHashMap();
        private final ThreadLocal<HashMap<Node<C>, C>> inboundSnapshot = new Snapshot(EdgeType.INBOUND);
        private final ThreadLocal<HashMap<Node<C>, C>> outboundSnapshot = new Snapshot(EdgeType.OUTBOUND);

        public Node(C content, int sequence) {
            assert (content != null) : "Each node in a DependencyGraph must have a non-null content";
            assert (sequence >= 0) : "Invalid negative sequence number";
            this.content = content;
            this.sequence = sequence;
        }

        private void discardSnapshots() {
            this.inboundSnapshot.remove();
            this.outboundSnapshot.remove();
        }

        private Map<Node<C>, C> getInbound(boolean readOnly) {
            Map<Node<Object>, Object> inbound = this.inbound;
            if (!DependencyGraph.this.isSnapshot()) {
                this.discardSnapshots();
            } else if (readOnly) {
                inbound = this.inboundSnapshot.get();
            }
            return inbound;
        }

        private Map<Node<C>, C> getOutbound(boolean readOnly) {
            Map<Node<Object>, Object> outbound = this.outbound;
            if (!DependencyGraph.this.isSnapshot()) {
                this.discardSnapshots();
            } else if (readOnly) {
                outbound = this.outboundSnapshot.get();
            }
            return outbound;
        }

        public boolean addIncoming(Node<C> node) {
            return this.getInbound(false).put(node, node.content) == null;
        }

        public boolean removeIncoming(Node<C> node) {
            return this.getInbound(false).remove(node) != null;
        }

        public boolean addOutgoing(Node<C> node) {
            return this.getOutbound(false).put(node, node.content) == null;
        }

        public boolean removeOutgoing(Node<C> node) {
            return this.getOutbound(false).remove(node) != null;
        }

        public boolean hasOutgoing() {
            return !this.getOutbound(true).isEmpty();
        }

        public boolean hasOutgoing(Node<T> node) {
            return this.getOutbound(true).containsKey(node);
        }

        public boolean hasIncoming() {
            return !this.getInbound(true).isEmpty();
        }

        public boolean hasIncoming(Node<T> node) {
            return this.getInbound(true).containsKey(node);
        }

        public Collection<Node<C>> getIncomingNodes() {
            return this.getInbound(true).keySet();
        }

        public Collection<Node<C>> getOutgoingNodes() {
            return this.getOutbound(true).keySet();
        }

        public Collection<C> getIncomingContents() {
            return this.getInbound(true).values();
        }

        public Collection<C> getOutgoingContents() {
            return this.getOutbound(true).values();
        }

        public int countEdges() {
            return this.getInbound(true).size() + this.getOutbound(true).size();
        }

        @Override
        public int compareTo(Node o) {
            int r = this.getInbound(true).size() - o.getOutbound(true).size();
            if (r == 0) {
                r = o.getOutbound(true).size() - this.getOutbound(true).size();
            }
            if (r == 0) {
                r = this.sequence - o.sequence;
            }
            return r;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                return this.content.equals(((Node)obj).content);
            }
            return false;
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public String toString() {
            return "DependencyGraph.Node : " + this.content.toString();
        }

        private final class Snapshot
        extends ThreadLocal<HashMap<Node<C>, C>> {
            private final EdgeType type;

            public Snapshot(EdgeType type) {
                this.type = type;
            }

            @Override
            protected HashMap<Node<C>, C> initialValue() {
                DependencyGraph.this.snapshotNodes.get().push(this);
                return this.type == EdgeType.INBOUND ? new HashMap(Node.this.inbound) : new HashMap(Node.this.outbound);
            }
        }
    }

    private final class ContentIterator
    implements Iterator<T> {
        private final Iterator<T> iter;

        private ContentIterator(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This Iterator does not support the remove operation");
        }
    }

    private static enum EdgeType {
        INBOUND,
        OUTBOUND;

        private static final long serialVersionUID = 1L;
    }
}

