/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DelayedSwingRunnable {
    private Timer timer;
    private TimerActionListener timerActionListener;
    private Runnable runnable;

    public DelayedSwingRunnable(int delay, Runnable runnable) {
        assert (SwingUtilities.isEventDispatchThread()) : "Needs to run on the EDT";
        this.runnable = runnable;
        this.timerActionListener = new TimerActionListener();
        this.timer = new Timer(delay, this.timerActionListener);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public boolean stop() {
        assert (SwingUtilities.isEventDispatchThread()) : "Needs to run on the EDT";
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.timer = null;
            return true;
        }
        return false;
    }

    public boolean run() {
        assert (SwingUtilities.isEventDispatchThread()) : "Needs to run on the EDT";
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.timer = null;
            this.runnable.run();
            return true;
        }
        return false;
    }

    private class TimerActionListener
    implements ActionListener {
        private TimerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DelayedSwingRunnable.this.timer != null) {
                DelayedSwingRunnable.this.timer = null;
                DelayedSwingRunnable.this.runnable.run();
            }
        }
    }
}

