/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ErrorSymbol;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;

public class RootSymbol
extends PlsqlSymbol
implements ErrorReporter {
    private PackageSymbol[] packageArray = null;
    private FunctionSymbol[] functionArray = null;
    private ErrorSymbol[] errorArray = null;
    private ArrayList functions = RootSymbol.allocArrayList();
    private ArrayList packages = RootSymbol.allocArrayList();

    public FunctionSymbol[] getFunctions() {
        return this.functionArray;
    }

    public PackageSymbol[] getPackages() {
        return this.packageArray;
    }

    RootSymbol() {
        super(25);
    }

    private void generateFunctionArray() {
        this.functionArray = FunctionSymbol.EMPTY_ARRAY;
        this.functionArray = this.functions.toArray(this.functionArray);
        RootSymbol.freeArrayList(this.functions);
        this.functions = null;
    }

    private void generatePackageArray() {
        this.packageArray = PackageSymbol.EMPTY_ARRAY;
        this.packageArray = this.packages.toArray(this.packageArray);
        RootSymbol.freeArrayList(this.packages);
        this.packages = null;
    }

    void addFunction(FunctionSymbol i) {
        this.functions.add(i);
    }

    void addPackage(PackageSymbol p) {
        this.packages.add(p);
    }

    @Override
    void doneParsing() {
        super.doneParsing();
        this.generateFunctionArray();
        this.generatePackageArray();
        if (this.parent.code == 10) {
            ((CommonRoot)this.parent).setRoot(this);
        }
    }

    @Override
    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    @Override
    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    @Override
    public void setErrors(CommonRoot root) {
        this.errorArray = root.getErrors();
    }
}

