/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VersionSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVersion;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public class TreeSym
extends Sym {
    private static final Comparator<Sym> SYMSTART_COMPARATOR = new Comparator<Sym>(){

        @Override
        public int compare(Sym left, Sym right) {
            return left.symStart - right.symStart;
        }

        public boolean equals(Sym left, Sym right) {
            return left.symStart == right.symStart;
        }
    };
    public Sym[] treeChildren = Sym.EMPTY_ARRAY;

    protected List<Sym> getTreeChildren(Byte filter) {
        int length = this.treeChildren.length;
        ArrayList<Sym> filtered = new ArrayList<Sym>(length);
        for (int i = 0; i < length; ++i) {
            Sym child = this.getNthChild(i);
            if (child == null || filter != null && !child.is(filter)) continue;
            filtered.add(child);
        }
        return filtered;
    }

    protected List<Sym> getTreeDescendants(Byte filter, int depth) {
        ArrayList<Sym> filtered = new ArrayList<Sym>(this.treeChildren.length * 2);
        TreeSym.descend(this, filter, depth, filtered);
        return filtered;
    }

    private static void descend(TreeSym sym, Byte filter, int depth, List<Sym> filtered) {
        --depth;
        int length = sym.treeChildren.length;
        for (int i = 0; i < length; ++i) {
            Sym child = sym.getNthChild(i);
            if (child == null) continue;
            if (filter == null || child.is(filter)) {
                filtered.add(child);
            }
            if (depth <= 0 || !(child instanceof TreeSym)) continue;
            TreeSym c = (TreeSym)child;
            TreeSym.descend(c, filter, depth, filtered);
        }
    }

    public SourceName getNameElement() {
        return this.getNameSym();
    }

    public void setNameElement(SourceName name) {
        this.setNameSym((NameSym)name);
    }

    public String getName() {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            return nameSym.getValue();
        }
        return "";
    }

    public void setName(String input) {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            if (!input.equals(nameSym.getValue())) {
                nameSym.setValue(input);
            }
        } else {
            this.setNameSym((NameSym)this.symFile.factory.createName(input));
        }
    }

    public SourceVersion getVersionElement() {
        return (VersionSym)this.getChild((byte)42);
    }

    public void setVersionElement(SourceVersion version) {
        this.setSym((byte)42, (Sym)((Object)version));
    }

    public String getVersion() {
        VersionSym versionSym = (VersionSym)this.getChild((byte)42);
        if (versionSym != null) {
            return versionSym.getVersion();
        }
        return "";
    }

    public void setVersion(String input) {
        VersionSym versionSym = (VersionSym)this.getChild((byte)42);
        if (versionSym != null) {
            if (!input.equals(versionSym.getVersion())) {
                versionSym.setVersion(input);
            }
        } else {
            this.setSym((byte)42, (VersionSym)this.symFile.factory.createVersion(input));
        }
    }

    public final SourceBlock getBlock() {
        return this.getBlockSym();
    }

    public final void setBlock(SourceBlock block) {
        this.setBlockSym((BlockSym)block);
    }

    public final SourceTypeReference getSourceType() {
        return this.getTypeSym();
    }

    public final String getTypeName() {
        TypeSym typeSym = this.getTypeSym();
        return typeSym != null ? typeSym.getName() : "";
    }

    public UnresolvedType getUnresolvedType() {
        String typeName;
        TypeSym typeSym = this.getTypeSym();
        if (typeSym != null && (typeName = typeSym.getName()).length() > 0) {
            return QuickUnresolvedType.createUnresolvedType(typeName, typeSym.getArrayDimension());
        }
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    public final void setSourceType(SourceTypeReference type) {
        this.setTypeSym((TypeSym)type);
    }

    public final SourceExpression getExpression() {
        return this.getExpressionSym();
    }

    public final Expr getExpressionSym() {
        return (Expr)this.getChild((byte)108);
    }

    public void setExpressionSym(Expr e) {
        this.setSym((byte)108, e);
    }

    @Override
    public List<SourceAnnotation> getSourceAnnotations() {
        return this.getChildrenList(1);
    }

    public final SourceClass getEnclosingClass() {
        return this.getOwningClassSym();
    }

    protected final void setSym(byte filter, Sym sym) {
        int found = this.indexOf(filter);
        if (found != -1) {
            if (sym != null) {
                this.replaceChild(found, sym);
            } else {
                this.unlinkChild(found);
            }
        } else if (sym != null) {
            this.add(sym);
        }
    }

    public final NameSym getNameSym() {
        return (NameSym)this.getChild((byte)20);
    }

    public final void setNameSym(NameSym sym) {
        this.setSym((byte)20, sym);
    }

    public final BlockSym getBlockSym() {
        return (BlockSym)this.getChild((byte)2);
    }

    public final void setBlockSym(BlockSym sym) {
        this.setSym((byte)2, sym);
    }

    public TypeSym getTypeSym() {
        return (TypeSym)this.getChild((byte)27);
    }

    public void setTypeSym(TypeSym sym) {
        this.setSym((byte)27, sym);
    }

    public final SourceDocComment getDocComment() {
        return this.getJavadocSym();
    }

    public final void setDocComment(SourceDocComment newComment) {
        this.setJavadocSym((DocCommentSym)newComment);
    }

    public DocCommentSym getJavadocSym() {
        return (DocCommentSym)this.getChild((byte)89);
    }

    public void setJavadocSym(DocCommentSym sym) {
        this.setSym((byte)89, sym);
    }

    @Override
    public final boolean hasHiddenTag() {
        DocCommentSym doc = this.getJavadocSym();
        return doc != null && doc.isHidden();
    }

    @Override
    public final boolean hasDeprecatedTag() {
        DocCommentSym doc = this.getJavadocSym();
        return doc != null && doc.isDeprecated();
    }

    protected void add(Sym child, byte filter) {
        if (this.indexOf(child) != -1) {
            return;
        }
        int targetIndex = this.getTargetIndex(child, filter);
        if (targetIndex < 0) {
            return;
        }
        int count = this.treeChildren.length;
        if (count < targetIndex) {
            targetIndex = count;
        }
        this.linkChild(targetIndex, child, filter);
    }

    @Override
    protected final void add(Sym child) {
        this.add(child, (byte)0);
    }

    @Override
    protected final void replace(Sym oldSym, Sym newSym) {
        int index = this.indexOf(oldSym);
        if (index == -1) {
            TreeSym.errorInvalidParent();
        }
        this.replaceChild(index, newSym);
    }

    @Override
    protected final void remove(Sym child) {
        int index = this.indexOf(child);
        if (index == -1) {
            TreeSym.errorInvalidParent();
        }
        this.unlinkChild(index);
    }

    @Override
    protected final void remove(Sym child, byte filter) {
        int index = this.indexOf(child);
        if (index == -1) {
            TreeSym.errorInvalidParent();
        }
        this.unlinkChild(index, filter);
    }

    @Override
    public final int indexOf(Sym sym) {
        if (sym == null) {
            return -1;
        }
        List<Sym> children = this.getTreeChildren(null);
        for (int i = 0; i < children.size(); ++i) {
            if (sym != children.get(i)) continue;
            return i;
        }
        return super.indexOf(sym);
    }

    @Override
    public final int lastIndexOf(Sym sym) {
        return this.indexOf(sym);
    }

    @Override
    public int getChildCount(int mask) {
        if (mask == 0) {
            return 0;
        }
        if (mask == 458752) {
            return this.treeChildren.length;
        }
        return this.getChildren(mask).size();
    }

    @Override
    public List<SourceElement> getChildren() {
        return new SimpleSymList<SourceElement>(0, null);
    }

    @Override
    public List<SourceElement> getChildren(int mask) {
        return this.getChildrenList(mask, null);
    }

    public <T extends SourceElement> List<T> getChildrenList(int mask) {
        return this.getChildrenList(mask, null);
    }

    protected <T extends SourceElement> List<T> getChildrenList(int mask, Sym include) {
        if (mask == 0) {
            return Collections.emptyList();
        }
        if (mask == 65536) {
            return new SimpleSymList(0, include);
        }
        if (mask < 0 || mask >> 8 == 0 || (mask & 0xFFFFFF00) == -256) {
            return this.getChildrenList((byte)mask, include);
        }
        if (mask == 131072) {
            return this.getChildrenList((byte)95, include);
        }
        if (mask == 262144) {
            return this.getChildrenList((byte)96, include);
        }
        int supportedMask = 458752;
        if ((mask & ~supportedMask) != 0) {
            throw new IllegalArgumentException("Invalid mask " + Integer.toHexString(mask));
        }
        if ((mask & 0x10000) == 0) {
            TreeSym.notImplementedYet();
        }
        boolean showComments = (mask & 0x20000) != 0;
        boolean showBlanklines = (mask & 0x40000) != 0;
        return new SimpleSymList(0, include, showComments, showBlanklines);
    }

    @Override
    public <T extends SourceElement> Collection<T> getSyms(byte filter) {
        if (117 <= filter && filter < 121) {
            return new SymCollection(filter);
        }
        return this.getChildrenList(filter);
    }

    public <T extends Sym> T getSym(byte filter0, byte ... filters) {
        TreeSym sym = this;
        Sym child = sym.getChild(filter0);
        if (filters == null) {
            return (T)child;
        }
        for (int i = 0; i < filters.length; ++i) {
            TreeSym ts;
            if (!(child instanceof TreeSym)) {
                return null;
            }
            sym = ts = (TreeSym)child;
            child = sym.getChild(filters[i]);
        }
        return (T)child;
    }

    public <T extends List<Sym>> T getSymPath(byte filter0, byte ... filters) {
        TreeSym ts;
        TreeSym sym = this;
        ArrayList<Sym> path = new ArrayList<Sym>();
        Sym child = sym.getChild(filter0);
        if (child != null) {
            path.add(child);
        }
        if (filters == null) {
            return (T)path;
        }
        for (int i = 0; i < filters.length && child instanceof TreeSym && (child = (sym = (ts = (TreeSym)child)).getChild(filters[i])) != null; ++i) {
            path.add(child);
        }
        return (T)path;
    }

    @Override
    public final void clearOffsets() {
        super.clearOffsets();
        for (Sym child : this.getTreeChildren(null)) {
            child.clearOffsets();
        }
    }

    @Override
    protected final void clearFormatInfo() {
        super.clearFormatInfo();
        for (Sym child : this.getTreeChildren(null)) {
            child.clearFormatInfo();
        }
    }

    public void hookupChildren() {
        if ((this.symFormat & 2) == 0) {
            TreeSym.panic("Should only be called by the factory");
        }
        Sym[] children = this.treeChildren;
        int count = children.length;
        for (int i = 0; i < count; ++i) {
            Sym parent;
            Sym child = children[i];
            if (this.symFile != child.symFile) {
                TreeSym.errorDifferentFile();
            }
            if ((parent = child.symParent) == this) continue;
            if (parent != null) {
                TreeSym.errorHasParent();
            }
            SymOperation op = null;
            if ((child.symFormat & 2) == 0) {
                SymTransaction transaction = this.verifyTransaction();
                op = transaction.newOperation((byte)1);
                op.opNewSym = child;
                op.opParent = this;
                op.opTargetIndex = i;
            } else if (!this.isValidChild(child, (byte)0)) {
                TreeSym.errorCannotLink(child, this);
            }
            child.symParent = this;
            if (op != null) {
                op.buildSelf();
            }
            child.linkSelfTrigger(this, (byte)0);
            this.linkChildTrigger(child, (byte)0);
        }
        this.renumberSelf();
    }

    protected final int getTargetIndex(Sym sym) {
        return this.getTargetIndex(sym, (byte)0);
    }

    protected int getTargetIndex(Sym sym, byte filter) {
        return this.treeChildren.length;
    }

    protected final void linkChild(int index, Sym child) {
        this.linkChild(index, child, (byte)0);
    }

    protected final void unlinkChild(int index) {
        this.unlinkChild(index, (byte)0);
    }

    protected final void replaceChild(int index, Sym child) {
        this.replaceChild(index, child, (byte)0);
    }

    protected void linkChild(int index, Sym child, byte filter) {
        this.linkChildImpl(index, child, filter);
    }

    protected void unlinkChild(int index, byte filter) {
        this.unlinkChildImpl(index, filter);
    }

    protected void replaceChild(int index, Sym child, byte filter) {
        this.replaceChildImpl(index, child, filter);
    }

    private boolean verifyLinkChild(Sym child, byte filter) {
        if (!this.isValidChild(child, filter)) {
            return false;
        }
        if (this.indexOf(child) != -1) {
            return false;
        }
        if (child.isSynthetic() && !child.isFilter((byte)114)) {
            TreeSym.errorSynthetic();
        }
        if (child.getParentSym() != null) {
            TreeSym.errorHasParent();
        }
        if (this.symFile != child.symFile) {
            TreeSym.errorDifferentFile();
        }
        if (child.getContextImpl() != null) {
            TreeSym.panic("Cannot have both parent and context");
        }
        return true;
    }

    private boolean verifyUnlinkChild(Sym target, byte filter, boolean replace) {
        if (target.isSynthetic() && !target.isFilter((byte)114)) {
            TreeSym.errorSynthetic();
        }
        if (!replace && target.isSkeleton() && !target.isFilter((byte)114)) {
            TreeSym.errorSkeleton();
        }
        if (target.getParentSym() == null) {
            TreeSym.errorNoParent();
        }
        return true;
    }

    private void linkChildImpl(int index, Sym child, byte filter) {
        Sym existing;
        if (child == null) {
            TreeSym.panic("Null made it this far into the internals. Why?");
        }
        if (!this.verifyLinkChild(child, filter)) {
            TreeSym.errorCannotLink(child, this);
        }
        int count = this.treeChildren.length;
        if (index < 0 || count < index) {
            TreeSym.errorInvalidRange(index);
        }
        if (index < count && (existing = this.getNthChild(index)) != null && existing.symKind == child.symKind && existing.isSkeleton()) {
            if (this.symFile.getTransactionSym() != null) {
                this.replaceChild(index, child, filter);
            }
            return;
        }
        SymOperation op = null;
        if (!child.isSkeleton()) {
            SymTransaction transaction = this.verifyTransaction();
            op = transaction.newOperation((byte)1);
            op.opNewSym = child;
            op.opParent = this;
            op.opTargetIndex = index;
            op.opFilter = filter;
            op.symSiblingIndex = index;
        }
        this.linkChildImpl0(index, child);
        if (op != null) {
            op.buildSelf();
        }
        child.linkSelfTrigger(this, filter);
        this.linkChildTrigger(child, filter);
    }

    private void unlinkChildImpl(int index, byte filter) {
        Sym target = this.getNthChild(index);
        if (target == null) {
            TreeSym.errorInvalidRange(index);
        }
        if (!this.verifyUnlinkChild(target, filter, false)) {
            throw new IllegalArgumentException("May not be removed");
        }
        SymTransaction transaction = this.verifyTransaction();
        SymOperation op = transaction.newOperation((byte)3);
        op.opTarget = target;
        op.opParent = this;
        op.opTargetIndex = index;
        op.opFilter = filter;
        op.symSiblingIndex = index;
        this.unlinkChildImpl0(index);
        op.buildSelf();
        target.unlinkSelfTrigger(this, filter);
        this.unlinkChildTrigger(target, filter);
    }

    private void replaceChildImpl(int index, Sym child, byte filter) {
        Sym target = this.getNthChild(index);
        if (target == null) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (target == child) {
            return;
        }
        if (child == null) {
            this.unlinkChild(index, filter);
            return;
        }
        if (!this.verifyLinkChild(child, filter)) {
            TreeSym.errorCannotLink(child, this);
        }
        if (!this.verifyUnlinkChild(target, filter, true)) {
            throw new IllegalArgumentException();
        }
        SymTransaction transaction = this.verifyTransaction();
        SymOperation op = transaction.newOperation((byte)2);
        op.opTarget = target;
        op.opNewSym = child;
        op.opParent = this;
        op.opTargetIndex = index;
        op.opFilter = filter;
        op.symSiblingIndex = index;
        op.buildSelf();
        this.replaceChildImpl0(index, child);
        op.buildSelf();
        target.unlinkSelfTrigger(this, filter);
        this.unlinkChildTrigger(target, filter);
        child.linkSelfTrigger(this, filter);
        this.linkChildTrigger(child, filter);
    }

    private void linkChildImpl0(int index, Sym child) {
        int count = this.treeChildren.length;
        Sym[] newArray = new Sym[count + 1];
        if (index != 0) {
            System.arraycopy(this.treeChildren, 0, newArray, 0, index);
        }
        if (index != count) {
            System.arraycopy(this.treeChildren, index, newArray, index + 1, count - index);
        }
        newArray[index] = child;
        this.treeChildren = newArray;
        this.renumberSelf();
        child.symParent = this;
    }

    private void unlinkChildImpl0(int index) {
        Sym target = this.treeChildren[index];
        int count = this.treeChildren.length;
        Sym[] newArray = new Sym[count - 1];
        if (index != 0) {
            System.arraycopy(this.treeChildren, 0, newArray, 0, index);
        }
        if (index != count - 1) {
            System.arraycopy(this.treeChildren, index + 1, newArray, index, count - 1 - index);
        }
        this.treeChildren = newArray;
        this.renumberSelf();
        target.symParent = null;
    }

    private void replaceChildImpl0(int index, Sym child) {
        Sym target = this.getNthChild(index);
        if (target == null) {
            TreeSym.errorInvalidRange(index);
        }
        this.treeChildren[index] = child;
        target.symSiblingIndex = -1;
        child.symSiblingIndex = index;
        target.symParent = null;
        child.symParent = this;
    }

    protected void setNameTrigger(String newValue) {
    }

    protected void linkChildTrigger(Sym added, byte filter) {
        if (this.isSkeleton()) {
            this.symFlags = (byte)(this.symFlags & 0xFFFFFFFB);
            this.symFormat = (char)(this.symFormat | 2);
        } else {
            this.unsaveText();
        }
    }

    protected void unlinkChildTrigger(Sym removed, byte filter) {
        if (!this.isSkeleton()) {
            this.unsaveText();
        }
    }

    protected Sym createSkeleton(byte symKind) {
        Sym sym = this.createSkeletonImpl(symKind);
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.symFlags = (byte)(sym.symFlags | 4);
        this.add(sym);
        return sym;
    }

    protected Sym createSkeletonImpl(byte symKind) {
        return SymFactory.createNode(this.symFile, symKind);
    }

    protected final Sym getChildOrCreateSkeleton(byte symKind) {
        Sym foundSym = this.getChild(symKind);
        return foundSym != null ? foundSym : this.createSkeleton(symKind);
    }

    protected void setupSkeleton() {
    }

    private void renumberSelf() {
        List<Sym> children = this.getTreeChildren(null);
        for (int i = children.size() - 1; i >= 0; --i) {
            Sym child = children.get(i);
            child.symSiblingIndex = i;
            if (child.symKind != 96) continue;
            BlanklineSym blanklineSym = (BlanklineSym)child;
            blanklineSym.blanklineFollowing = (byte)-1;
        }
    }

    private void buildSelf0(SyntaxData data) {
        Sym[] dataKids = data.kids;
        int childCount = data.kidCount;
        if (childCount == 0) {
            return;
        }
        int oldChildCount = this.treeChildren.length;
        int newLength = childCount + oldChildCount;
        Sym[] array = new Sym[newLength];
        if (oldChildCount == 0) {
            System.arraycopy(dataKids, 0, array, 0, childCount);
        } else {
            System.arraycopy(this.treeChildren, 0, array, 0, oldChildCount);
            System.arraycopy(dataKids, 0, array, oldChildCount, childCount);
        }
        this.treeChildren = array;
        this.renumberSelf();
    }

    @Override
    public void buildSelf() {
        SyntaxData data;
        if (this.hasSyntaxData() && (data = this.symData) != null) {
            this.buildSelf0(data);
        }
        super.buildSelf();
        this.setupSkeleton();
    }

    @Override
    public void addToSubtree(Sym target) {
        if (this.symStart <= target.symStart && target.symEnd <= this.symEnd) {
            int childCount = this.treeChildren.length;
            for (int j = 0; j < childCount; ++j) {
                Sym child = this.treeChildren[j];
                if (target.symEnd < child.symStart) {
                    this.linkChildImpl0(j, target);
                    return;
                }
                if (target.symStart == child.symStart) {
                    this.linkChildImpl0(target.symKind == 96 ? j : j + 1, target);
                    return;
                }
                if (target.symEnd > child.symEnd) continue;
                child.addToSubtree(target);
                return;
            }
            this.linkChildImpl0(childCount, target);
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        TreeSym sym = (TreeSym)super.cloneSelf(targetFile);
        int count = this.treeChildren.length;
        sym.treeChildren = new Sym[count];
        for (int i = 0; i < count; ++i) {
            Sym clone;
            sym.treeChildren[i] = clone = this.treeChildren[i].cloneSelf(targetFile);
        }
        sym.hookupChildren();
        sym.renumberSelf();
        return sym;
    }

    @Override
    public final void sortSelf() {
        Arrays.sort(this.treeChildren, SYMSTART_COMPARATOR);
        this.renumberSelf();
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        List<Sym> children = this.getTreeChildren(null);
        for (Sym child : children) {
            child.compile(compiler);
        }
        return super.compileImpl(compiler);
    }

    @Override
    protected void verboseSelf(StringBuilder stringBuffer) {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            stringBuffer.append(" name \"");
            stringBuffer.append(this.getName());
            stringBuffer.append('\"');
        }
    }

    @Override
    public void describeSelf(int depth) {
        super.describeSelf(depth);
        List<Sym> children = this.getTreeChildren(null);
        for (Sym child : children) {
            child.describeSelf(depth + 1);
        }
    }

    @Override
    protected int indexSelf(Sym[] index, int pos, TokenArray tokens) {
        Sym target = this;
        if ((this.symFlags & 2) != 0) {
            target = this.symParent;
        }
        List<Sym> children = this.getTreeChildren(null);
        for (Sym child : children) {
            while (pos < child.symStart) {
                index[pos++] = target;
            }
            pos = child.indexSelf(index, pos, tokens);
        }
        return super.indexSelf(index, pos, tokens);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print((Sym)this);
    }

    @Override
    public final boolean traverseSelf(Sym.SymTraversal traverse) {
        try {
            boolean traverseChildren = traverse.enter(this);
            if (traverseChildren) {
                Sym child;
                boolean keepGoing;
                List<Sym> children = this.getTreeChildren(null);
                Iterator<Sym> iterator = children.iterator();
                while (iterator.hasNext() && (keepGoing = (child = iterator.next()).traverseSelf(traverse))) {
                }
            }
            return traverse.leave(this);
        }
        catch (Sym.TraversalCancelledException e) {
            return false;
        }
    }

    private boolean childrenMatch(TreeSym otherSym) {
        List<Sym> children = this.getTreeChildren(null);
        List<Sym> otherChildren = otherSym.getTreeChildren(null);
        int count = children.size();
        int otherCount = otherChildren.size();
        int thisi = 0;
        for (int otheri = 0; thisi < count && otheri < otherCount; ++thisi, ++otheri) {
            Sym thisChild = children.get(thisi);
            Sym otherChild = otherChildren.get(otheri);
            if (thisChild.symKind != otherChild.symKind) {
                while (otheri + 1 < otherCount && otherChild.symKind == 96) {
                    otherChild = otherChildren.get(++otheri);
                }
                while (thisi + 1 < count && thisChild.symKind == 96) {
                    thisChild = children.get(++thisi);
                }
            }
            if (thisChild.symKind == otherChild.symKind) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean traverseDual(Sym other, Sym.SymDualTraversal traverse) {
        try {
            boolean traverseChildren = traverse.enter(this, other);
            if (traverseChildren && other instanceof TreeSym) {
                List<Sym> children = this.getTreeChildren(null);
                List<Sym> otherChildren = ((TreeSym)other).getTreeChildren(null);
                int count = children.size();
                int otherCount = otherChildren.size();
                if (this.childrenMatch((TreeSym)other)) {
                    int thisi = 0;
                    for (int otheri = 0; thisi < count && otheri < otherCount; ++thisi, ++otheri) {
                        boolean keepGoing;
                        Sym thisChild = children.get(thisi);
                        Sym otherChild = otherChildren.get(otheri);
                        if (thisChild.symKind != otherChild.symKind) {
                            while (otheri < otherCount && otherChild.symKind == 96) {
                                otherChild = otherChildren.get(++otheri);
                            }
                            while (thisi < count && thisChild.symKind == 96) {
                                thisChild = children.get(++thisi);
                            }
                        }
                        if (keepGoing = thisChild.traverseDual(otherChild, traverse)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (int i = 0; i < otherCount; ++i) {
                        Sym otherChild = otherChildren.get(i);
                        byte targetSymKind = otherChild.symKind;
                        int similarCount = this.count(targetSymKind);
                        if (similarCount == 1) {
                            boolean keepGoing = this.getChild(targetSymKind).traverseDual(otherChild, traverse);
                            if (keepGoing) continue;
                        } else {
                            boolean keepGoing;
                            int n = 0;
                            for (int j = i - 1; j >= 0; --j) {
                                if (otherChildren.get((int)j).symKind != targetSymKind) continue;
                                ++n;
                            }
                            if (n >= similarCount || (keepGoing = this.getNthChild(targetSymKind, n).traverseDual(otherChild, traverse))) {
                                continue;
                            }
                        }
                        break;
                    }
                }
            }
            return traverse.leave(this, other);
        }
        catch (Sym.TraversalCancelledException e) {
            return false;
        }
    }

    @Override
    protected void adjustSelfImpl(Sym other) {
        super.adjustSelfImpl(other);
        SymTransaction transaction = this.symFile.getTransactionSym();
        if (transaction == null) {
            return;
        }
        if (!(other instanceof TreeSym) || !this.childrenMatch((TreeSym)other)) {
            return;
        }
        int count = this.treeChildren.length;
        TreeSym otherSym = (TreeSym)other;
        Sym[] otherChildren = otherSym.treeChildren;
        int otherCount = otherChildren.length;
        int thisi = count - 1;
        int otheri = otherCount - 1;
        while (thisi >= 0) {
            boolean otherChildIsBlankline;
            Sym thisChild = this.getNthChild(thisi);
            Sym otherChild = otheri >= 0 ? otherSym.getNthChild(otheri) : null;
            boolean thisChildIsBlankline = thisChild.symKind == 96;
            boolean bl = otherChildIsBlankline = otherChild != null && otherChild.symKind == 96;
            if (thisChildIsBlankline || otherChildIsBlankline) {
                if (thisChildIsBlankline && otherChildIsBlankline) {
                    thisChild.adjustSelfImpl(otherChild);
                } else {
                    while (otheri >= 0 && otherChild.symKind == 96) {
                        Sym blanklineSym = SymFactory.createNode(this.symFile, 96);
                        blanklineSym.adjustSelfImpl(otherChild);
                        this.linkChild(thisi + 1, blanklineSym);
                        if (otheri == 0) break;
                        otherChild = otherSym.getNthChild(--otheri);
                    }
                    while (thisi >= 0 && thisChild.symKind == 96) {
                        this.unlinkChild(thisi);
                        if (thisi == 0) break;
                        thisChild = this.getNthChild(--thisi);
                    }
                }
            }
            --thisi;
            --otheri;
        }
    }

    public final void print_annotations(PrintWriter out) {
        List<SourceAnnotation> annotations = this.getSourceAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        for (SourceAnnotation annotation : annotations) {
            TreeSym.print((Sym)((Object)annotation), out);
        }
        out.println();
    }

    public final Sym getNthChild(int index) {
        if (index < 0 || index >= this.treeChildren.length) {
            return null;
        }
        return this.treeChildren[index];
    }

    @Override
    public final Sym getChildAt(int tokenPos) {
        List<Sym> children = this.getTreeChildren(null);
        for (Sym child : children) {
            if (tokenPos < child.symStart) break;
            if (tokenPos > child.symEnd) continue;
            return (child.symFlags & 2) == 0 ? child : null;
        }
        return null;
    }

    public ListIterator<SourceElement> getSiblingsFor(Sym sym) {
        return this.getSiblingsFor(sym, 458752);
    }

    public ListIterator<SourceElement> getSiblingsFor(Sym sym, int mask) {
        List list = this.getChildrenList(mask, sym);
        int listIteratorIndex = list.indexOf(sym);
        if (listIteratorIndex < 0) {
            listIteratorIndex = list.size();
        }
        ListIterator<SourceElement> iterator = list.listIterator(listIteratorIndex);
        return iterator;
    }

    protected Sym getSiblingBeforeFor(Sym sym, int mask) {
        if (mask == 0) {
            return null;
        }
        int index = this.indexOf(sym);
        if (index == -1) {
            return null;
        }
        block4: for (int i = index - 1; i >= 0; --i) {
            Sym child = this.getNthChild(i);
            if (child == null) continue;
            switch (child.symKind) {
                default: {
                    if ((mask & 0x10000) == 0) continue block4;
                    return child;
                }
                case 95: {
                    if ((mask & 0x20000) == 0) continue block4;
                    return child;
                }
                case 96: {
                    if ((mask & 0x40000) == 0) continue block4;
                    return child;
                }
            }
        }
        return null;
    }

    protected Sym getSiblingAfterFor(Sym sym, int mask) {
        if (mask == 0) {
            return null;
        }
        int index = this.indexOf(sym);
        if (index == -1) {
            return null;
        }
        block4: for (int i = index + 1; i < this.treeChildren.length; ++i) {
            Sym child = this.getNthChild(i);
            if (child == null) continue;
            switch (child.symKind) {
                default: {
                    if ((mask & 0x10000) == 0) continue block4;
                    return child;
                }
                case 95: {
                    if ((mask & 0x20000) == 0) continue block4;
                    return child;
                }
                case 96: {
                    if ((mask & 0x40000) == 0) continue block4;
                    return child;
                }
            }
        }
        return null;
    }

    public final int count(byte filter) {
        int count = 0;
        for (int i = 0; i < this.treeChildren.length; ++i) {
            Sym sym = this.getNthChild(i);
            if (sym == null || !sym.is(filter)) continue;
            ++count;
        }
        return count;
    }

    public final int indexOf(byte filter) {
        return this.indexOf(filter, 0);
    }

    public final int indexOf(byte filter, int fromIndex) {
        for (int i = fromIndex; i < this.treeChildren.length; ++i) {
            Sym sym = this.getNthChild(i);
            if (sym == null || !sym.is(filter)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOfNth(byte filter, int n) {
        for (int i = 0; i < this.treeChildren.length; ++i) {
            Sym sym = this.getNthChild(i);
            if (sym == null || !sym.is(filter) || n-- != 0) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(byte filter) {
        return this.lastIndexOf(filter, this.treeChildren.length - 1);
    }

    public final int lastIndexOf(byte filter, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            Sym sym = this.getNthChild(i);
            if (sym == null || !sym.is(filter)) continue;
            return i;
        }
        return -1;
    }

    public final Sym getChild(byte filter) {
        return this.getNthChild(filter, 0);
    }

    public final Sym getNthChild(byte filter, int n) {
        for (int i = 0; i < this.treeChildren.length; ++i) {
            Sym sym = this.getNthChild(i);
            if (sym == null || !sym.is(filter) || n-- != 0) continue;
            return sym;
        }
        return null;
    }

    public final Sym getLastChild(byte filter) {
        for (int i = this.treeChildren.length - 1; i >= 0; --i) {
            Sym sym = this.getNthChild(i);
            if (sym == null || !sym.is(filter)) continue;
            return sym;
        }
        return null;
    }

    public <T extends SourceElement> List<T> getChildrenList(byte filter, Sym include) {
        return new SimpleSymList(filter, include);
    }

    @Override
    public final <T extends SourceElement> void getChildrenRecursive(byte filter, ArrayList<T> list) {
        if (this.is(filter)) {
            list.add(this);
        }
        List<Sym> children = this.getTreeChildren(null);
        for (Sym child : children) {
            child.getChildrenRecursive(filter, list);
        }
    }

    public final JavaElement getObject(byte filter) {
        Sym child = this.getChild(filter);
        return child != null ? child.getCompiledObject() : null;
    }

    public final JavaElement getObject(byte filter, int index) {
        Sym child = this.getNthChild(filter, index);
        return child != null ? child.getCompiledObject() : null;
    }

    public final JavaElement getLastObject(byte filter) {
        Sym child = this.getLastChild(filter);
        return child != null ? child.getCompiledObject() : null;
    }

    public final <T extends JavaElement> List<T> getObjects(byte filter) {
        List<Sym> children = this.getTreeChildren(filter);
        ArrayList<JavaElement> objects = new ArrayList<JavaElement>(children.size());
        for (Sym child : children) {
            JavaElement compiledObject = child.getCompiledObject();
            if (compiledObject == null) continue;
            objects.add(compiledObject);
        }
        return objects;
    }

    public final <T extends JavaElement> List<T> getObjects(byte filter, int depth) {
        List<Sym> children = this.getTreeDescendants(filter, depth);
        ArrayList<JavaElement> objects = new ArrayList<JavaElement>(children.size());
        for (Sym child : children) {
            JavaElement compiledObject = child.getCompiledObject();
            if (compiledObject == null) continue;
            objects.add(compiledObject);
        }
        return objects;
    }

    private class SimpleSymList<T extends SourceElement>
    extends AbstractList<T> {
        private List<T> listChildren;
        protected final byte filter;
        protected final boolean showComments;
        protected final boolean showBlanklines;
        private Sym include;

        protected SimpleSymList(byte filter, Sym include) {
            this(filter, include, filter == 95, filter == 96);
        }

        protected SimpleSymList(byte filter, Sym include, boolean showComments, boolean showBlanklines) {
            this.filter = filter;
            if (117 <= filter && filter < 121) {
                throw new IllegalArgumentException("" + filter);
            }
            this.showComments = showComments;
            this.showBlanklines = showBlanklines;
            this.include = include;
            this.initChildren();
        }

        private void initChildren() {
            this.listChildren = new ArrayList<T>();
            for (int i = 0; i < TreeSym.this.treeChildren.length; ++i) {
                Sym sym = TreeSym.this.getNthChild(i);
                if (sym == null || sym != this.include && !this.match(sym)) continue;
                this.listChildren.add(sym);
            }
        }

        protected final boolean match(Sym sym) {
            if (!sym.is(this.filter) || sym.isSkeleton()) {
                return false;
            }
            switch (sym.symKind) {
                case 95: {
                    return this.showComments;
                }
                case 96: {
                    return this.showBlanklines;
                }
            }
            return true;
        }

        protected final int logical2real(int logical) {
            if (logical < 0 || logical >= this.listChildren.size()) {
                return -1;
            }
            Sym child = (Sym)this.listChildren.get(logical);
            return TreeSym.this.indexOf(child);
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            this.initChildren();
            return new SimpleSymListIterator(index, new ArrayList<T>(this.listChildren));
        }

        @Override
        public int size() {
            return this.listChildren.size();
        }

        @Override
        public boolean isEmpty() {
            return this.listChildren.isEmpty();
        }

        @Override
        public T get(int index) {
            if (index < 0 || index >= this.listChildren.size()) {
                throw new IndexOutOfBoundsException("Size = " + this.size() + ", Index = " + index);
            }
            return (T)((SourceElement)this.listChildren.get(index));
        }

        @Override
        public Object[] toArray() {
            return this.listChildren.toArray(new Sym[this.listChildren.size()]);
        }

        @Override
        public boolean add(T o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Sym)) {
                throw new ClassCastException();
            }
            this.initChildren();
            int oldIndex = this.indexOf(o);
            if (oldIndex >= 0) {
                return false;
            }
            TreeSym.this.add((Sym)o, this.filter);
            this.initChildren();
            return true;
        }

        @Override
        public void add(int index, T o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Sym)) {
                throw new ClassCastException();
            }
            this.initChildren();
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("Size = " + this.size() + ", Index = " + index);
            }
            int oldIndex = this.indexOf(o);
            if (oldIndex >= 0) {
                return;
            }
            int realIndex = this.logical2real(index);
            if (realIndex < 0 && (realIndex = this.logical2real(this.listChildren.size() - 1)) >= 0) {
                ++realIndex;
            }
            if (realIndex >= 0) {
                TreeSym.this.linkChild(realIndex, (Sym)o, this.filter);
                this.initChildren();
            } else {
                this.add(o);
            }
        }

        @Override
        public T set(int index, T o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Sym)) {
                throw new ClassCastException();
            }
            this.initChildren();
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("Size = " + this.size() + ", Index = " + index);
            }
            int existingIndex = this.indexOf(o);
            if (index == existingIndex) {
                return o;
            }
            Object oldSym = index < this.size() ? this.remove(index) : null;
            existingIndex = this.indexOf(o);
            if (existingIndex >= 0) {
                this.remove(existingIndex);
                if (oldSym != null) {
                    this.add(existingIndex, (T)oldSym);
                }
            }
            this.add(index, o);
            return (T)oldSym;
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Sym)) {
                throw new ClassCastException();
            }
            this.initChildren();
            int i = this.indexOf(o);
            if (i == -1) {
                return false;
            }
            this.remove(i);
            return true;
        }

        @Override
        public T remove(int index) {
            this.initChildren();
            int realIndex = this.logical2real(index);
            if (realIndex < 0) {
                throw new IndexOutOfBoundsException("Size = " + this.size() + ", Index = " + index);
            }
            Sym old = TreeSym.this.getNthChild(realIndex);
            TreeSym.this.unlinkChild(realIndex, this.filter);
            this.initChildren();
            return (T)old;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Sym)) {
                throw new ClassCastException();
            }
            for (int i = 0; i < this.listChildren.size(); ++i) {
                if (this.listChildren.get(i) != o) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public void sort(Comparator<? super T> c) {
            super.sort(c);
        }

        protected class SimpleSymListIterator
        implements ListIterator<T> {
            private ListIterator<T> listIterator;
            private T returned;
            private boolean returnedNext;

            SimpleSymListIterator(int index, List<T> children) {
                this.listIterator = children.listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.listIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.listIterator.hasPrevious();
            }

            @Override
            public T next() {
                this.returnedNext = true;
                this.returned = (SourceElement)this.listIterator.next();
                return this.returned;
            }

            @Override
            public int nextIndex() {
                return this.listIterator.nextIndex();
            }

            @Override
            public T previous() {
                this.returnedNext = false;
                this.returned = (SourceElement)this.listIterator.previous();
                return this.returned;
            }

            @Override
            public int previousIndex() {
                return this.listIterator.previousIndex();
            }

            @Override
            public void add(T o) {
                Sym sym = (Sym)o;
                if (!SimpleSymList.this.match(sym)) {
                    throw new IllegalArgumentException("Invalid input");
                }
                int nextIndex = this.nextIndex();
                SimpleSymList.this.add(nextIndex, o);
                this.reset(nextIndex + 1);
            }

            @Override
            public void remove() {
                if (this.returned == null) {
                    return;
                }
                int nextIndex = this.nextIndex();
                if (this.returnedNext) {
                    --nextIndex;
                }
                SimpleSymList.this.remove(this.returned);
                this.reset(nextIndex);
            }

            @Override
            public void set(T o) {
                if (this.returned == null) {
                    return;
                }
                int index = SimpleSymList.this.indexOf(this.returned);
                if (index >= 0) {
                    int nextIndex = this.nextIndex();
                    SimpleSymList.this.set(index, o);
                    this.reset(nextIndex);
                }
            }

            private void reset(int nextIndex) {
                this.listIterator = SimpleSymList.this.listIterator();
                while (this.listIterator.nextIndex() < nextIndex && this.listIterator.hasNext()) {
                    this.listIterator.next();
                }
                this.returned = null;
            }
        }
    }

    private class SymCollection<T extends SourceElement>
    extends AbstractCollection<T> {
        private List<T> children;
        protected final byte filter;

        protected SymCollection(byte filter) {
            this.filter = filter;
            this.initChildren();
        }

        private void initChildren() {
            this.children = new ArrayList<T>();
            for (int i = 0; i < TreeSym.this.treeChildren.length; ++i) {
                byte childFilter;
                Sym child = TreeSym.this.getNthChild(i);
                if (child != null && this.match(child)) {
                    this.children.add(child);
                }
                if (!(child instanceof TreeSym) || (childFilter = this.getChildFilter(child)) == -1) continue;
                for (Sym otherChild : ((TreeSym)child).getTreeChildren(childFilter)) {
                    this.children.add(otherChild);
                }
            }
        }

        @Override
        public Iterator<T> iterator() {
            this.initChildren();
            return this.children.iterator();
        }

        @Override
        public int size() {
            return this.children.size();
        }

        @Override
        public boolean isEmpty() {
            return this.children.isEmpty();
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException("Can't add to Collection.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Can't add to Collection.");
        }

        private boolean match(Sym sym) {
            return sym.is(this.filter) && !sym.isSkeleton();
        }

        private byte getChildFilter(Sym sym) {
            switch (this.filter) {
                case 117: 
                case 118: {
                    if (sym.symKind != 9) break;
                    return this.filter;
                }
                case 119: {
                    if (sym.symKind != 18) break;
                    return this.filter;
                }
                case 120: {
                    if (sym.symKind != 87) break;
                    return this.filter;
                }
            }
            return -1;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (SourceElement sym : this.children) {
                hashCode = 31 * hashCode + (sym == null ? 0 : sym.hashCode());
            }
            return hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof SymCollection)) {
                return false;
            }
            SymCollection other = (SymCollection)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (SourceElement sym : this.children) {
                if (other.contains(sym)) continue;
                return false;
            }
            return true;
        }
    }
}

