/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickHasType;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.internal.compiler.ClassObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.InterfacesSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectBinding;
import oracle.javatools.parser.java.v2.internal.symbol.PermitsSym;
import oracle.javatools.parser.java.v2.internal.symbol.RecordComponentSym;
import oracle.javatools.parser.java.v2.internal.symbol.RecordHeaderSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperclassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.model.ClassKind;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaRecordComponent;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourcePermitsClause;
import oracle.javatools.parser.java.v2.model.SourceRecordComponent;
import oracle.javatools.parser.java.v2.model.SourceRecordHeader;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public final class ClassSym
extends MemberSym
implements SourceClass {
    public TypeSym superType;
    private JavaType qualifyingType;
    private char anonymousClassIndex;
    private char localClassIndex;
    private byte classFlags;
    public static final byte RECORD = 1;
    public static final byte SEALED = 4;
    public static final byte NON_SEALED = 8;

    public void setClassFlags(byte mask) {
        this.classFlags = (byte)(this.classFlags | mask);
    }

    public void clearClassFlags(byte mask) {
        this.classFlags = (byte)(this.classFlags & ~mask);
    }

    public boolean isSet(byte mask) {
        return (this.classFlags & mask) == mask;
    }

    public boolean isFalse(byte mask) {
        return (this.classFlags | mask) == 0;
    }

    @Override
    public void clearCompiledInfo() {
    }

    @Override
    public ClassKind getClassKind() {
        if (this.isAnnotation()) {
            return ClassKind.ANNOTATION;
        }
        if (this.isInterface()) {
            return ClassKind.INTERFACE;
        }
        if (this.isEnum()) {
            return ClassKind.ENUM;
        }
        if (this.isRecord()) {
            return ClassKind.RECORD;
        }
        return ClassKind.CLASS;
    }

    @Override
    public void setClassKind(ClassKind newClassKind) {
        ClassKind oldClassKind = this.getClassKind();
        if (oldClassKind == newClassKind) {
            return;
        }
        char newAccess = (char)(this.symAccess & 0xFFFF9DFF);
        switch (newClassKind) {
            case CLASS: 
            case RECORD: {
                break;
            }
            case ANNOTATION: {
                newAccess = (char)(newAccess | 0x2600);
                newAccess = (char)(newAccess & 0xFFFFFFEF);
                break;
            }
            case INTERFACE: {
                newAccess = (char)(newAccess | 0x600);
                newAccess = (char)(newAccess & 0xFFFFFFEF);
                break;
            }
            case ENUM: {
                newAccess = (char)(newAccess | 0x4000);
            }
        }
        boolean record = oldClassKind == ClassKind.RECORD || newClassKind == ClassKind.RECORD;
        SymTransaction transaction = this.verifyTransaction();
        SymOperation op = transaction.newOperation(record ? (byte)6 : 4);
        op.opTarget = this;
        op.symAccess = this.symAccess;
        op.symFlags = this.symFlags;
        this.symAccess = newAccess;
        this.symFormat = (char)(this.symFormat | (record ? 1 : 8));
        if (oldClassKind == ClassKind.RECORD) {
            Sym recordHeader = this.getChild((byte)44);
            if (recordHeader != null) {
                this.remove(recordHeader);
            }
            this.clearClassFlags((byte)1);
        } else if (newClassKind == ClassKind.RECORD) {
            SourceRecordHeader recordHeader = this.getOwningSourceFile().getFactory().createRecordHeader(new SourceRecordComponent[0]);
            recordHeader.addSelfAfter(this.getNameSym());
            this.setClassFlags((byte)1);
        }
        op.buildSelf();
        switch (newClassKind) {
            case CLASS: {
                this.objectImplicit = '\u0000';
                break;
            }
            case ANNOTATION: {
                this.objectImplicit = (char)9728;
                break;
            }
            case ENUM: {
                this.objectImplicit = (char)16384;
                break;
            }
            case INTERFACE: {
                this.objectImplicit = (char)1536;
                break;
            }
            case RECORD: {
                this.objectImplicit = (char)16;
            }
        }
    }

    @Override
    public boolean isClass() {
        return !this.isInterface() && !this.isRecord();
    }

    @Override
    public boolean isInterface() {
        return (this.symAccess & 0x200) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.symAccess & 0x4000) != 0;
    }

    @Override
    public boolean isRecord() {
        return this.isSet((byte)1);
    }

    @Override
    public boolean isSealed() {
        return this.isSet((byte)4);
    }

    @Override
    public boolean isNonSealed() {
        return this.isSet((byte)8);
    }

    @Override
    public boolean isAnnotation() {
        return (this.symAccess & 0x2000) != 0;
    }

    @Override
    public boolean isExported() {
        Sym parentSym = this.getParentSym();
        if (parentSym != null) {
            switch (parentSym.symKind) {
                case 4: 
                case 11: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isMemberClass() {
        Sym parentSym = this.getParentSym();
        return parentSym != null && parentSym.symKind == 4;
    }

    public boolean flag_anonymous() {
        return this.testSymFlag((byte)-128);
    }

    @Override
    public boolean isAnonymous() {
        return this.flag_anonymous();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.flag_anonymous();
    }

    @Override
    public boolean isLocalClass() {
        if (this.isAnonymous()) {
            return false;
        }
        JavaElement element = this.getOwner();
        return element != null && element.getElementKind() == 8;
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.getRawOrQualifiedName(false);
    }

    private String getRawOrQualifiedName(boolean isRaw) {
        String packageName;
        if (this.isAnonymousClass()) {
            return "";
        }
        if (this.isLocalClass()) {
            return this.getName();
        }
        String thisName = this.getName();
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null) {
            String ownerName;
            String string = ownerName = isRaw ? owningClass.getRawName() : owningClass.getQualifiedName();
            if (ownerName.length() > 0) {
                return ownerName + "." + thisName;
            }
        }
        return (packageName = this.getPackageName()).length() == 0 ? thisName : packageName + "." + thisName;
    }

    @Override
    public String getVMName() {
        String ownerVMName;
        int length;
        Object thisName;
        if (this.isAnonymousClass()) {
            if (this.anonymousClassIndex == '\u0000' && (classSym = this.getOwningClassSym()) != null) {
                classSym.assignAnonymousClassIndices();
            }
            thisName = Integer.toString(this.anonymousClassIndex);
        } else if (this.isLocalClass()) {
            if (this.localClassIndex == '\u0000' && (classSym = this.getOwningClassSym()) != null) {
                classSym.assignLocalClassIndices();
            }
            thisName = Integer.toString(this.localClassIndex) + this.getName();
        } else {
            thisName = this.getName();
        }
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null && (length = (ownerVMName = owningClass.getVMName()).length()) > 0) {
            return ownerVMName + "$" + (String)thisName;
        }
        String packageName = this.getPackageName();
        return packageName.length() == 0 ? thisName : packageName.replace('.', '/') + "/" + (String)thisName;
    }

    private void assignAnonymousClassIndices() {
        ClassBodySym bodySym = this.getBodySym();
        if (bodySym != null) {
            SourceVisitor<Object> visitor = new SourceVisitor<Object>(){
                private char anonymousClassCount;

                @Override
                public void whenEnterClass(SourceClass sourceClass) {
                    if (sourceClass.isAnonymousClass()) {
                        ((ClassSym)sourceClass).anonymousClassIndex = this.anonymousClassCount = (char)(this.anonymousClassCount + '\u0001');
                    }
                    this.cancelSubtree();
                }
            };
            visitor.visit(bodySym);
        }
    }

    private void assignLocalClassIndices() {
        ClassBodySym bodySym = this.getBodySym();
        if (bodySym != null) {
            SourceVisitor<Object> visitor = new SourceVisitor<Object>(){
                private final Map<String, Character> localClassNames = new HashMap<String, Character>();

                @Override
                public void whenEnterClass(SourceClass sourceClass) {
                    if (sourceClass.isLocalClass()) {
                        String sourceClassName = sourceClass.getName();
                        Character copies = this.localClassNames.get(sourceClassName);
                        char localClassIndex = copies == null ? (char)'\u0001' : (char)(copies.charValue() + '\u0001');
                        this.localClassNames.put(sourceClassName, Character.valueOf(localClassIndex));
                        ((ClassSym)sourceClass).localClassIndex = localClassIndex;
                    }
                    this.cancelSubtree();
                }
            };
            visitor.visit(bodySym);
        }
    }

    @Override
    public String getRawName() {
        return this.getRawOrQualifiedName(true);
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public SourceClass getSourceElement() {
        if (this.symFile.isLightSourceFile) {
            JavaProvider provider = this.symFile.getProvider();
            return provider != null ? provider.getSourceClass(this.getRawName()) : null;
        }
        return this;
    }

    @Override
    public SourcePackage getSourcePackage() {
        return this.symFile.getSourcePackage();
    }

    @Override
    public String getPackageName() {
        return this.symFile.getPackageName();
    }

    @Override
    public SourceTypeReference getSourceSuperclass() {
        SuperclassSym superSym = this.getSuperclassSym();
        return superSym != null ? superSym.getSourceSuperclass() : null;
    }

    @Override
    public void setSourceSuperclass(SourceTypeReference type) {
        this.getSuperclassSym().setSourceSuperclass(type);
    }

    @Override
    public List<SourceTypeReference> getSourceInterfaces() {
        return this.getInterfacesSym().getSourceInterfaces();
    }

    @Override
    public List<SourceTypeReference> getSourcePermittedSubtypes() {
        return this.getPermitsClause().getSourcePermittedTypes();
    }

    @Override
    public SourceRecordHeader getSourceRecordHeader() {
        return this.isRecord() ? (SourceRecordHeader)((Object)this.getChild((byte)44)) : null;
    }

    @Override
    public List<SourceRecordComponent> getSourceRecordComponents() {
        return this.isRecord() ? this.getSourceRecordHeader().getSourceRecordComponents() : null;
    }

    @Override
    public List<SourceMember> getSourceMembers() {
        return this.getBodySym().getSourceMembers();
    }

    @Override
    public Collection<SourceMemberVariable> getSourceMemberVariables() {
        return this.getBodySym().getSourceMemberVariables();
    }

    @Override
    public SourceMemberVariable getSourceMemberVariable(String name) {
        return this.getBodySym().getSourceMemberVariable(name);
    }

    @Override
    public List<SourceEnumConstant> getSourceEnumConstants() {
        return this.getBodySym().getSourceEnumConstants();
    }

    @Override
    public List<SourceFieldDeclaration> getSourceFieldDeclarations() {
        return this.getBodySym().getSourceFieldDeclarations();
    }

    @Override
    public Collection<SourceFieldVariable> getSourceFieldVariables() {
        return this.getBodySym().getSourceFieldVariables();
    }

    @Override
    public SourceFieldVariable getSourceFieldVariable(String name) {
        return this.getBodySym().getSourceFieldVariable(name);
    }

    @Override
    public List<SourceMethod> getSourceMethods() {
        return this.getBodySym().getSourceMethods();
    }

    @Override
    public Collection<SourceMethod> getSourceMethods(String name) {
        return this.getBodySym().getSourceMethods(name);
    }

    @Override
    public SourceMethod getSourceMethod(String name, JavaType[] targetTypes) {
        JavaMethod target = this.getDeclaredMethod(name, targetTypes);
        return target != null ? target.getSourceElement() : null;
    }

    @Override
    public List<SourceMethod> getSourceConstructors() {
        return this.getBodySym().getSourceConstructors();
    }

    @Override
    public SourceMethod getSourceConstructor(JavaType[] targetTypes) {
        JavaMethod target = this.getDeclaredConstructor(targetTypes);
        return target != null ? target.getSourceElement() : null;
    }

    @Override
    public List<SourceClass> getSourceClasses() {
        return this.getBodySym().getSourceClasses();
    }

    @Override
    public SourceClass getSourceClass(String name) {
        return this.getBodySym().getSourceClass(name);
    }

    @Override
    public List<SourceClass> getSourceAnonymousClasses() {
        return this.getBodySym().getSourceAnonymousClasses();
    }

    @Override
    public List<SourceClass> getSourceLocalClasses() {
        return this.getBodySym().getSourceLocalClasses();
    }

    @Override
    public List<SourceClassInitializer> getSourceInitializers() {
        return this.getBodySym().getSourceInitializers();
    }

    @Override
    public SourceClassBody getSourceBody() {
        return this.getBodySym();
    }

    public SourceClassBody getBody() {
        return this.getSourceBody();
    }

    public ClassBodySym getBodySym() {
        return (ClassBodySym)this.getChild((byte)4);
    }

    @Override
    public SourceSuperclassClause getSuperclassClause() {
        return this.getSuperclassSym();
    }

    @Override
    public SourceInterfacesClause getInterfacesClause() {
        return this.getInterfacesSym();
    }

    @Override
    public SourcePermitsClause getPermitsClause() {
        return this.getPermitsSym();
    }

    public SuperclassSym getSuperclassSym() {
        return (SuperclassSym)this.getChildOrCreateSkeleton((byte)22);
    }

    public boolean hasSuperClass() {
        return this.getChild((byte)22) != null;
    }

    public InterfacesSym getInterfacesSym() {
        return (InterfacesSym)this.getChildOrCreateSkeleton((byte)15);
    }

    public PermitsSym getPermitsSym() {
        return (PermitsSym)this.getChildOrCreateSkeleton((byte)46);
    }

    public List<JavaType> getPermittedSubclasses() {
        return this.getPermitsSym().getSubclasses();
    }

    public boolean hasInterfaces() {
        InterfacesSym child = (InterfacesSym)this.getChild((byte)15);
        return child != null && child.getSourceInterfaces().size() > 0;
    }

    @Override
    public int getElementKind() {
        return 3;
    }

    @Override
    public URL getURL() {
        return this.symFile.getURL();
    }

    @Override
    public String getName() {
        return this.isAnonymousClass() ? "" : super.getName();
    }

    @Override
    @Deprecated
    public JavaClass getClosestClass() {
        return this.getTypeErasure();
    }

    @Override
    public JavaClass getTypeErasure() {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public JavaType getComponentType() {
        return null;
    }

    @Override
    public int getArrayDimensions() {
        return 0;
    }

    @Override
    public JavaType getBaseComponentType() {
        return null;
    }

    @Override
    public SourceMember getOwningMember() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.isFilter((byte)104)) {
                return (SourceMember)((Object)sym);
            }
            sym = sym.symParent;
        }
        return null;
    }

    @Override
    public JavaPackage getPackage() {
        return this.symFile.getPackage();
    }

    @Override
    public JavaType getResolvedType() {
        return this;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    public RecordHeaderSym getRecordHeader() {
        return (RecordHeaderSym)this.getChild((byte)44);
    }

    @Override
    public Collection<JavaRecordComponent> getRecordComponents() {
        return this.getDeclaredRecordComponents();
    }

    public List<RecordComponentSym> getComponents() {
        return this.getRecordHeader().getComponents();
    }

    @Override
    public JavaType getSuperclass() {
        ClassObj obj = this.getClassObj();
        if (!obj.isResolved()) {
            this.resolve();
        }
        return obj.getSuperclass();
    }

    @Override
    public UnresolvedType getUnresolvedSuperclass() {
        SourceTypeReference ref = this.getSourceSuperclass();
        if (ref != null) {
            return ref.getUnresolvedType();
        }
        if (this.isInterface() && !this.isAnnotation()) {
            return null;
        }
        if ("java.lang.Object".equals(this.getRawName())) {
            return null;
        }
        return QuickUnresolvedType.createUnresolvedType("java.lang.Object");
    }

    @Override
    public Collection<JavaType> getInterfaces() {
        JavaType resolved;
        if (this.superType != null && (resolved = this.superType.getResolvedType()) != null && resolved.getElementKind() == 3 && resolved.isInterface()) {
            return Collections.singletonList(resolved);
        }
        if (this.isAnnotation()) {
            JavaType annotationType = QuickHasType.createHasTypeByVMName(this.symFile, "java/lang/annotation/Annotation").getResolvedType();
            ArrayList<JavaType> list = new ArrayList<JavaType>();
            if (annotationType != null) {
                list.add(annotationType);
            }
            return list;
        }
        InterfacesSym interfacesSym = this.getInterfacesSym();
        return interfacesSym.getInterfaces();
    }

    @Override
    public Set<JavaType> getHierarchy() {
        return this.getClassObj().getHierarchy();
    }

    @Override
    public boolean isAssignableFrom(JavaType subject) {
        return Conversions.applyAssignmentConversion(subject, this, false, null);
    }

    @Override
    public boolean isSubtypeOf(JavaType supertype) {
        return Conversions.isSubtypeOf(this, supertype);
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        ObjectBinding declaredFieldsBinding = (ObjectBinding)this.getInternalBinding(20);
        if (declaredFieldsBinding != null) {
            return ((Map)declaredFieldsBinding.getObject()).values();
        }
        return this.cacheDeclaredFields().values();
    }

    @Override
    public JavaField getDeclaredField(String name) {
        ObjectBinding declaredFieldsBinding = (ObjectBinding)this.getInternalBinding(20);
        if (declaredFieldsBinding != null) {
            return (JavaField)((Map)declaredFieldsBinding.getObject()).get(name);
        }
        return this.cacheDeclaredFields().get(name);
    }

    private Map<String, JavaField> cacheDeclaredFields() {
        Collection<JavaField> fields = this.getBodySym().getDeclaredFields();
        LinkedHashMap<String, JavaField> fieldsByName = new LinkedHashMap<String, JavaField>(fields.size());
        for (JavaField field : fields) {
            fieldsByName.put(field.getName(), field);
        }
        this.setInternalBinding(new ObjectBinding(20, fieldsByName));
        return fieldsByName;
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        ObjectBinding declaredMethodBinding = (ObjectBinding)this.getInternalBinding(18);
        if (declaredMethodBinding != null) {
            return (Collection)declaredMethodBinding.getObject();
        }
        Collection<JavaMethod> declaredMethods = this.getBodySym().getDeclaredMethods();
        this.setInternalBinding(new ObjectBinding<Collection<JavaMethod>>(18, declaredMethods));
        return declaredMethods;
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods(String name) {
        ObjectBinding binding = (ObjectBinding)this.getInternalBinding(19);
        if (binding != null) {
            List<JavaMethod> methods = (List<JavaMethod>)((Map)binding.getObject()).get(name);
            return methods != null ? methods : Collections.emptyList();
        }
        Collection<JavaMethod> declaredMethods = this.getDeclaredMethods();
        HashMap<String, List> methodsByName = new HashMap<String, List>(declaredMethods.size());
        for (JavaMethod declaredMethod : declaredMethods) {
            String methodName = declaredMethod.getName();
            List methodList = methodsByName.computeIfAbsent(methodName, k -> new ArrayList());
            methodList.add(declaredMethod);
        }
        binding = new ObjectBinding(19, methodsByName);
        this.setInternalBinding(binding);
        List<JavaMethod> methods = (List<JavaMethod>)methodsByName.get(name);
        return methods != null ? methods : Collections.emptyList();
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredMethod(this, name, targetTypes);
    }

    @Override
    public Collection<JavaMethod> getDeclaredConstructors() {
        return this.getBodySym().getDeclaredConstructors();
    }

    @Override
    public JavaMethod getDeclaredConstructor(JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredConstructor(this, targetTypes);
    }

    @Override
    public Collection<JavaRecordComponent> getDeclaredRecordComponents() {
        RecordHeaderSym header = this.getRecordHeader();
        return header != null ? header.getRecordComponents() : Collections.emptyList();
    }

    @Override
    public JavaRecordComponent getDeclaredRecordComponent(String name) {
        return CommonUtilities.getDeclaredRecordComponent(this, name);
    }

    @Override
    public JavaMethod getClinitMethod() {
        ClassObj obj = this.getClassObj();
        if (!obj.isResolved()) {
            this.resolve();
        }
        return obj.getClinitMethod();
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        ObjectBinding declaredClassesBinding = (ObjectBinding)this.getInternalBinding(21);
        if (declaredClassesBinding != null) {
            return (JavaClass)((Map)declaredClassesBinding.getObject()).get(name);
        }
        return this.cacheDeclaredClasses().get(name);
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        ObjectBinding binding = (ObjectBinding)this.getInternalBinding(21);
        return binding != null ? ((Map)binding.getObject()).values() : this.cacheDeclaredClasses().values();
    }

    private Map<String, JavaClass> cacheDeclaredClasses() {
        Collection<SourceClass> classes = this.getBodySym().getDeclaredClasses();
        LinkedHashMap<String, JavaClass> classesByName = new LinkedHashMap<String, JavaClass>(classes.size());
        for (SourceClass type : classes) {
            classesByName.put(type.getName(), type);
        }
        this.setInternalBinding(new ObjectBinding(21, classesByName));
        return classesByName;
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return this.getBodySym().getDeclaredAnonymousClasses();
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return this.getBodySym().getDeclaredLocalClasses();
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public Collection<JavaField> getFields() {
        return CommonUtilities.getFields(this);
    }

    @Override
    public JavaField getField(String name) {
        return CommonUtilities.getField(this, name);
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return CommonUtilities.getMethods(this);
    }

    @Override
    public Collection<JavaMethod> getMethods(String name) {
        return CommonUtilities.getMethods(this, name);
    }

    @Override
    public JavaMethod getMethod(String name, JavaType ... targetTypes) {
        return CommonUtilities.getMethod(this, name, targetTypes);
    }

    @Override
    public Collection<JavaClass> getClasses() {
        return CommonUtilities.getClasses(this);
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        return CommonUtilities.getAnnotations(this);
    }

    @Override
    public JavaAnnotation getAnnotation(JavaType annotationType) {
        return CommonUtilities.getAnnotation(this, annotationType);
    }

    @Override
    public CompiledTmpVariable getThisValue() {
        return this.getClassObj().getThisValue();
    }

    public JavaVariable getThisVariable() {
        return this.getClassObj().getThisVariable();
    }

    public JavaVariable getSuperVariable() {
        return this.getClassObj().getSuperVariable();
    }

    public boolean equals(Object o) {
        return o instanceof JavaType && CommonUtilities.equals(this, (JavaType)o);
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    public String printCompiledInfo() {
        return super.printCompiledInfo() + this.getDescriptor();
    }

    @Override
    protected void add(Sym child, byte filter) {
        ClassBodySym body;
        if (!this.isValidChild(child, filter) && (body = this.getBodySym()).isValidChild(child, filter)) {
            body.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    @Override
    protected Sym createSkeleton(byte symKind) {
        Sym sym = super.createSkeleton(symKind);
        if (symKind == 4) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    @Override
    protected void setupSkeleton() {
        Sym bodySym = this.getChildOrCreateSkeleton((byte)4);
        bodySym.buildSelf();
        this.getSuperclassClause();
        this.getInterfacesClause();
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 20: {
                int typeParameterIndex = this.indexOf((byte)26);
                if (typeParameterIndex != -1) {
                    return typeParameterIndex;
                }
            }
            case 26: {
                int superIndex = this.indexOf((byte)22);
                if (superIndex != -1) {
                    return superIndex;
                }
            }
            case 22: {
                int interfacesIndex = this.indexOf((byte)15);
                if (interfacesIndex != -1) {
                    return interfacesIndex;
                }
            }
            case 15: {
                int bodyIndex = this.indexOf((byte)4);
                if (bodyIndex == -1) break;
                return bodyIndex;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 4: 
            case 15: 
            case 20: 
            case 22: 
            case 26: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected boolean isValidAccess(char access) {
        if (this.isAnonymousClass()) {
            return access == '\u0000';
        }
        int allowed = 10241;
        allowed = (access & 0x200) != 0 ? (int)((char)(allowed | 0x608)) : ((access & 0x4000) != 0 ? (int)((char)(allowed | 0x4018)) : (int)((char)(allowed | 0x418)));
        ClassSym owningSym = this.getOwningClassSym();
        if (owningSym != null) {
            if (!owningSym.isInterface()) {
                allowed = (char)(allowed | 6);
            }
            if (owningSym.getOwningClassSym() != null && !owningSym.isStatic()) {
                allowed = (char)(allowed & 0xFFFFFFF7);
            }
        } else {
            allowed = (char)(allowed & 0xFFFFFFF7);
        }
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected void setAccess(char newAccess) {
        int typeMask;
        ClassKind newClassKind;
        char oldAccess = this.symAccess;
        if (newAccess == oldAccess) {
            return;
        }
        ClassKind oldClassKind = ClassSym.accessToTypeKind(oldAccess);
        if (oldClassKind != (newClassKind = ClassSym.accessToTypeKind(newAccess))) {
            this.setClassKind(newClassKind);
        }
        if ((oldAccess = (char)(oldAccess & ~(typeMask = 25088))) != (newAccess = (char)(newAccess & ~typeMask))) {
            this.setAccessImpl((char)(newAccess | this.symAccess & typeMask));
        }
    }

    @Override
    protected void setModifiersImpl(char modifiers) {
        char access = modifiers;
        access = (char)(access & 0xFFFF9DFF);
        char typeKind = (char)(this.symAccess & 0x6200);
        access = (char)(access | typeKind);
        super.setModifiersImpl(access);
    }

    @Override
    protected void setNameTrigger(String newValue) {
        super.setNameTrigger(newValue);
        for (SourceMethod method : this.getSourceConstructors()) {
            if (!method.isConstructor()) continue;
            method.setName(newValue);
        }
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        switch (added.symKind) {
            case 44: {
                this.setClassFlags((byte)1);
                break;
            }
            case 4: {
                this.buildSelf();
            }
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        ClassSym sym = (ClassSym)super.cloneSelf(targetFile);
        if (this.superType != null) {
            sym.superType = (TypeSym)this.superType.cloneSelf(targetFile);
        }
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (!compiler.skipCompilations()) {
            compiler.startClassFlowAnalysis(this);
        }
        try {
            this.resolveImpl(compiler);
            for (SourceClass sourceClass : this.getSourceClasses()) {
                ((Sym)((Object)sourceClass)).resolve(compiler);
            }
            JavaElement result = super.compileImpl(compiler);
            if (!compiler.skipCompilations()) {
                this.checkAccessModifiers(compiler);
                this.checkAnnotations(compiler);
                compiler.compile(this);
            }
            JavaElement javaElement = result;
            return javaElement;
        }
        finally {
            if (!compiler.skipCompilations()) {
                compiler.endClassFlowAnalysis(this);
            }
        }
    }

    @Override
    public JavaElement resolveImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    public ClassObj getClassObj() {
        ClassObj binding = (ClassObj)this.getInternalBinding(5);
        if (binding != null) {
            return binding;
        }
        binding = new ClassObj();
        binding.objSym = this;
        this.setInternalBinding(binding);
        return binding;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print(out);
                return;
            }
            case 2: {
                this.print_annotations(out);
                this.printModifiers(out);
                out.print(this.getClassKind().keyword());
                out.print(' ');
            }
            case 1: 
            case 3: 
        }
        ClassSym.print(this.getNameSym(), out);
        switch (argument) {
            case 1: {
                this.print_ty_parameters(out, 1);
                break;
            }
            case 2: 
            case 3: {
                this.print_ty_parameters(out);
            }
        }
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        ArrayList list = new ArrayList();
        List<SourceTypeReference> sourceInterfaces = this.getSourceInterfaces();
        for (SourceTypeReference ref : sourceInterfaces) {
            list.add(ref.getUnresolvedType());
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    @Override
    public Collection<JavaAnnotation> getTypeAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isErasedType() {
        return false;
    }

    @Override
    public JavaProvider getProvider() {
        SourceFile file = this.getOwningSourceFile();
        return file != null ? file.getProvider() : null;
    }

    @Override
    public JavaType getQualifyingType() {
        return this.qualifyingType != null ? this.qualifyingType : this.getOwningClass();
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
        this.qualifyingType = qualifyingType;
    }

    @Override
    public JavaClass getCompiledObject() {
        return this;
    }

    @Override
    public JavaType getAnonymousClassSuperType() {
        return this.isAnonymousClass() ? (this.superType != null ? this.superType.getResolvedType() : null) : null;
    }
}

