/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.parser;

import java.util.concurrent.ConcurrentHashMap;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.parser.ParserLayer5;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public class ParserDriver
extends ParserLayer5 {
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap<Thread, ParserDriver> threadParserMap = new ConcurrentHashMap();

    public static boolean cancelParse(Thread thread) {
        ParserDriver parser = threadParserMap.get(thread);
        if (parser != null) {
            parser.isCancelled = true;
            return true;
        }
        return false;
    }

    public SourceFile parse(JdkVersion jdkVersion) {
        return this.parse(jdkVersion, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public SourceFile parse(JdkVersion jdkVersion, boolean lightParse) {
        ParserDriver parserDriver = this;
        synchronized (parserDriver) {
            threadParserMap.put(Thread.currentThread(), this);
            this.flag_lightparse = lightParse;
            try {
                FileSym fileSym;
                this.jdkVersion = jdkVersion;
                this.initializeLexerState(0);
                this.initializeParserState(null);
                this.textBuffer.readLock();
                try {
                    this.compilationUnit();
                    this.pop();
                    this.symFile.symStart = 0;
                    this.symFile.symEnd = this.symFile.getTokenArray().tokenCount - 1;
                    this.symFile.setPossibleTypes(CommonUtilities.immutableCopy(this.possibleTypes));
                    this.processNode(this.symFile);
                    this.symFile.isLightSourceFile = lightParse;
                    FileSym savedFile = this.symFile;
                    this.symFile = null;
                    fileSym = savedFile;
                    this.textBuffer.readUnlock();
                }
                catch (Throwable throwable) {
                    try {
                        this.textBuffer.readUnlock();
                        throw throwable;
                    }
                    catch (OutOfMemoryError e) {
                        System.err.print("OutOfMemoryError parsing ");
                        System.err.println(this.symFile.getURL().getPath());
                        throw e;
                    }
                }
                return fileSym;
            }
            finally {
                threadParserMap.remove(Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sym parseIsolated(FileSym file, int offset, byte inputKind) {
        ParserDriver parserDriver = this;
        synchronized (parserDriver) {
            FileSym fileSym = file;
            synchronized (fileSym) {
                TokenArray savedTokenArray = file.getTokenArray();
                TreeSym savedParseErrors = file.parseErrors;
                file.parseErrors = (TreeSym)SymFactory.createNode(file, 99);
                file.parseErrors.symParent = file;
                this.flag_setnew = true;
                Sym sym = this.parseImpl(file, offset, inputKind);
                if (sym == null) {
                    Sym sym2 = null;
                    return sym2;
                }
                if (sym.isSynthetic()) {
                    Sym sym3 = null;
                    return sym3;
                }
                sym.saveText(this.textBuffer);
                sym.clearOffsets();
                Sym sym4 = sym;
                return sym4;
                finally {
                    this.flag_setnew = false;
                    file.setTokenArray(savedTokenArray);
                    file.parseErrors = savedParseErrors;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sym parseImpl(FileSym file, int offset, byte inputKind) {
        SyntaxData fileSymData = file.symData;
        if (fileSymData != null) {
            throw new IllegalArgumentException("Uncleared parser storage");
        }
        this.jdkVersion = file.getJdkVersion();
        this.initializeLexerState(offset);
        this.initializeParserState(file);
        this.textBuffer.readLock();
        try {
            file.symFlags = (byte)(file.symFlags | 0xFFFFFF80);
            this.node((byte)99);
            switch (inputKind) {
                case 1: {
                    this.annotation(false);
                    if (this.lastPop == null) break;
                    SyntaxData data = this.lastPop.symData;
                    data.flag_repushed = true;
                    data.flag_noProcess = false;
                    this.processNode(this.lastPop);
                    break;
                }
                case 2: {
                    this.block(false);
                    break;
                }
                case 3: {
                    this.codeElement();
                    break;
                }
                case 4: {
                    this.saveJavadocAndAnnotations();
                    this.typeDeclaration(false);
                    break;
                }
                case 5: {
                    this.expression();
                    break;
                }
                case 6: {
                    this.saveJavadoc();
                    this.grabJavadoc();
                    break;
                }
                case 7: {
                    this.saveJavadocAndAnnotations();
                    this.memberDeclaration();
                    break;
                }
                case 8: {
                    this.statement();
                    break;
                }
                case 9: {
                    this.returnType();
                    break;
                }
                case 10: {
                    this.typeArgument();
                    break;
                }
                case 11: {
                    this.expressionAllowAnnotations();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Sym target = this.lastPop;
            this.pop();
            file.symData = null;
            this.symFile = null;
            if (target != null) {
                target.symParent = null;
            }
            Sym sym = target;
            return sym;
        }
        finally {
            file.symFlags = (byte)(file.symFlags & 0x7F);
            this.textBuffer.readUnlock();
        }
    }
}

