/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import oracle.javatools.filesystem.FileSystemProviderImpl;
import oracle.javatools.filesystem.PathImpl;
import oracle.javatools.filesystem.StorageFileSystem;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;

public class StorageFileSystemProvider
extends FileSystemProviderImpl {
    private StorageFileSystem storageFileSystem = new StorageFileSystem(this);

    public StorageFileSystemProvider(String string) {
        super(string);
    }

    public StorageFileSystem getFileSystem() {
        return this.storageFileSystem;
    }

    @Override
    public StorageFileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        this.checkURI(uri);
        return this.storageFileSystem;
    }

    @Override
    public StorageFileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        if (!(path instanceof PathImpl)) {
            throw new UnsupportedOperationException(path == null ? "<NULL>" : path.getClass().getName());
        }
        return this.storageFileSystem;
    }

    @Override
    public StorageFileSystem getFileSystem(URI uri) {
        this.checkURI(uri);
        return this.storageFileSystem;
    }

    public PathImpl putStorage(String path, Storage storage) throws IOException {
        if (storage == null || storage instanceof DirectoryStorage) {
            throw new IllegalArgumentException();
        }
        StorageFileSystem fileSystem = this.getFileSystem();
        PathImpl pathImpl = fileSystem.getPath(path, new String[0]);
        fileSystem.putStorage(pathImpl, storage);
        return pathImpl;
    }

    public void putStorage(PathImpl path, Storage storage) throws IOException {
        if (storage == null || storage instanceof DirectoryStorage) {
            throw new IllegalArgumentException();
        }
        StorageFileSystem fileSystem = this.getFileSystem();
        fileSystem.putStorage(path, storage);
        path.setLastModifiedTime(storage.modDate());
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new ReadOnlyFileSystemException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SeekableByteChannel newByteChannelImpl(final PathImpl path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (!this.getFileSystem().isOpen()) {
            throw new ClosedFileSystemException();
        }
        Storage storage = this.getFileSystem().getStorage(path);
        if (storage == null || options != null && (options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.APPEND) || options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.DELETE_ON_CLOSE) || options.contains(StandardOpenOption.DSYNC) || options.contains(StandardOpenOption.SPARSE) || options.contains(StandardOpenOption.SYNC) || options.contains(StandardOpenOption.TRUNCATE_EXISTING) || options.contains(StandardOpenOption.WRITE))) {
            throw new UnsupportedOperationException();
        }
        storage.open();
        byte[] bytes = null;
        try {
            bytes = storage.read();
        }
        finally {
            storage.close();
        }
        path.setLastModifiedTime(storage.modDate());
        final ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.rewind();
        return new SeekableByteChannel(){

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (!StorageFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                int remaining = byteBuffer.remaining();
                dst.put(byteBuffer);
                path.setLastAccessTime(System.currentTimeMillis());
                return remaining;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw new NonWritableChannelException();
            }

            @Override
            public long position() throws IOException {
                if (!StorageFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                return byteBuffer.position();
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                if (!StorageFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                if (newPosition < 0L || newPosition > Integer.MAX_VALUE || newPosition > (long)byteBuffer.capacity()) {
                    throw new IllegalArgumentException();
                }
                byteBuffer.position((int)newPosition);
                return this;
            }

            @Override
            public long size() throws IOException {
                if (!StorageFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                return byteBuffer.capacity();
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                throw new NonWritableChannelException();
            }

            @Override
            public boolean isOpen() {
                return StorageFileSystemProvider.this.getFileSystem().isOpen();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

