/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import oracle.ide.model.DefaultSubDirtyable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLKey;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;

public class URLPath
extends DefaultSubDirtyable
implements Copyable,
Iterable<URL> {
    private final Map<URLKey, URL> _entriesMap;
    private final List<URL> _entriesList;
    private final Collection<URL> _entriesCollection;
    private final Object _iteratorLock;

    private void assertMapIsUsed() {
        assert (this._entriesMap != null && this._entriesList == null && this._iteratorLock == this._entriesMap && this._entriesCollection == this._entriesMap.values());
    }

    private void assertListIsUsed() {
        assert (this._entriesMap == null && this._entriesList != null && this._iteratorLock != null && this._entriesCollection == this._entriesList);
    }

    public URLPath() {
        this(10);
        this.assertMapIsUsed();
    }

    public URLPath(int initialCapacity) {
        this._entriesMap = Collections.synchronizedMap(new LinkedHashMap(initialCapacity));
        this._entriesCollection = this._entriesMap.values();
        this._iteratorLock = this._entriesMap;
        this._entriesList = null;
        this.assertMapIsUsed();
    }

    public URLPath(URL entry) {
        this(1);
        this.assertMapIsUsed();
        this.add(entry);
    }

    public URLPath(URL[] entries) {
        this(entries == null ? 10 : entries.length);
        this.assertMapIsUsed();
        this.add(entries);
    }

    public URLPath(ListStructure entries) {
        this((List)entries);
        this.assertListIsUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLPath(List entries) {
        if (entries != null) {
            if (entries instanceof ListStructure) {
                this._entriesList = entries;
                this._iteratorLock = ((ListStructure)entries).iteratorLock();
            } else {
                this._iteratorLock = this._entriesList = new ArrayList<URL>(entries);
            }
            Object object = this._iteratorLock;
            synchronized (object) {
                for (Object entry : entries) {
                    if (entry == null) {
                        throw new IllegalArgumentException("The specified List contains null.");
                    }
                    if (entry instanceof URL) continue;
                    throw new IllegalArgumentException("The specified List contains a non-URL object (" + entry.getClass().toString() + ")");
                }
            }
            this._entriesCollection = this._entriesList;
            this._entriesMap = null;
            this.assertListIsUsed();
        } else {
            this._entriesMap = Collections.synchronizedMap(new LinkedHashMap(10));
            this._entriesCollection = this._entriesMap.values();
            this._iteratorLock = this._entriesMap;
            this._entriesList = null;
            this.assertMapIsUsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLPath(URLPath other) {
        this(other == null ? 10 : other.size());
        this.assertMapIsUsed();
        if (other != null) {
            Object object = other.iteratorLock();
            synchronized (object) {
                if (other._entriesMap != null) {
                    this._entriesMap.putAll(other._entriesMap);
                } else {
                    for (URL url : other._entriesList) {
                        URLKey urlKey = URLKey.getInstance(url).intern();
                        this._entriesMap.put(urlKey, urlKey.toURL());
                    }
                }
            }
        }
    }

    @Override
    public Object copyTo(Object object) {
        if (object != null) {
            this.copyToImpl((URLPath)object);
            return object;
        }
        return new URLPath(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void copyToImpl(URLPath copy) {
        List<URL> thisList = this.asList();
        Object object = copy.iteratorLock();
        synchronized (object) {
            copy.clear();
            copy.add(thisList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URL entry) {
        if (entry != null) {
            Object object = this._iteratorLock;
            synchronized (object) {
                if (!this.contains(entry)) {
                    if (this._entriesMap != null) {
                        URLKey urlKey = URLKey.getInstance(entry).intern();
                        this._entriesMap.put(urlKey, urlKey.toURL());
                    } else {
                        this._entriesList.add(entry);
                    }
                    this.markDirty(true);
                }
            }
        }
    }

    public void add(URL[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            for (int i = 0; i < numEntries; ++i) {
                this.add(entries[i]);
            }
        }
    }

    public void add(Collection<?> entries) {
        if (entries != null) {
            for (Object entry : entries) {
                if (!(entry instanceof URL)) continue;
                this.add((URL)entry);
            }
        }
    }

    public void add(URLPath urlPath) {
        if (urlPath != null) {
            this.add(urlPath.asList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> asList() {
        Object object = this._iteratorLock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<URL>(this._entriesCollection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getEntries() {
        Object object = this.iteratorLock();
        synchronized (object) {
            return this._entriesCollection.toArray(new URL[this._entriesCollection.size()]);
        }
    }

    public boolean contains(URL entry) {
        if (this._entriesMap != null) {
            return this._entriesMap.containsKey(URLKey.getInstance(entry));
        }
        return this.findEntryInList(entry) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllDirectories() {
        HashSet<String> dirList = new HashSet<String>();
        Object object = this.iteratorLock();
        synchronized (object) {
            for (URL entry : this._entriesCollection) {
                URLPath._getAllDirectories(entry, entry, dirList, URLFileSystem.findHelper(entry));
            }
        }
        ArrayList<String> list = new ArrayList<String>(dirList);
        Collections.sort(list);
        return list;
    }

    public void expandToIncludeManifestClassPaths() {
        try {
            this.expandToIncludeManifestClassPaths(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void expandToIncludeManifestClassPathsInterruptibly() throws InterruptedException {
        this.expandToIncludeManifestClassPaths(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandToIncludeManifestClassPaths(boolean throwInterruptedException) throws InterruptedException {
        HashSet<URL> processedJars = new HashSet<URL>();
        Object object = this._iteratorLock;
        synchronized (object) {
            List<URL> entries = this.asList();
            ArrayList<URL> expanded = new ArrayList<URL>(entries.size());
            for (URL entry : entries) {
                if (throwInterruptedException && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.expandToIncludeManifestClassPathImpl(entry, expanded, processedJars);
            }
            if (entries.size() != expanded.size()) {
                this.clear();
                for (URL url : expanded) {
                    this.add(url);
                }
            }
        }
    }

    private void expandToIncludeManifestClassPathImpl(URL curEntry, List<URL> expanded, Set<URL> processedJars) {
        if (!processedJars.add(curEntry)) {
            return;
        }
        expanded.add(curEntry);
        if ("".equals(JarUtil.getJarEntry(curEntry))) {
            try {
                String manifestClassPath = JarUtil.getClassPath(curEntry);
                if (manifestClassPath != null) {
                    URL jarFileURL = JarUtil.getJarFileURL(curEntry);
                    URL dirURL = URLFileSystem.getParent(jarFileURL);
                    StringTokenizer st = new StringTokenizer(manifestClassPath);
                    while (st.hasMoreTokens()) {
                        URL manifestCpItemURL;
                        String manifestCpItem = st.nextToken();
                        boolean isJar = false;
                        URL newJarFileURL = null;
                        if (JarUtil.isArchive(manifestCpItem)) {
                            isJar = true;
                            newJarFileURL = URLFactory.newURL(dirURL, manifestCpItem);
                            manifestCpItemURL = URLFactory.newJarURL(newJarFileURL, null);
                        } else {
                            manifestCpItemURL = URLFactory.newURL(dirURL, manifestCpItem);
                        }
                        if (!URLFileSystem.exists(isJar ? newJarFileURL : manifestCpItemURL)) continue;
                        if (isJar) {
                            this.expandToIncludeManifestClassPathImpl(manifestCpItemURL, expanded, processedJars);
                            continue;
                        }
                        expanded.add(manifestCpItemURL);
                    }
                }
            }
            catch (FileNotFoundException manifestClassPath) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getDirectories(String relPath) {
        return this.getDirectories(relPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDirectories(String relPath, URLFilter urlFilter) {
        ArrayList<String> list = new ArrayList<String>();
        if (relPath != null) {
            HashSet<CallSite> dirList = new HashSet<CallSite>();
            Object prefix = relPath.length() == 0 || relPath.endsWith("/") ? relPath : relPath + "/";
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL url : this._entriesCollection) {
                    URL entry = URLFactory.newDirURL(url, relPath);
                    URLFileSystemHelper helper = URLFileSystem.findHelper(entry);
                    URLFileSystem.FileInfo[] infos = helper.ls(entry, urlFilter);
                    if (infos == null) continue;
                    for (URLFileSystem.FileInfo info : infos) {
                        if (!info.isDirectory()) continue;
                        URL newURL = info.getURL();
                        dirList.add((CallSite)((Object)((String)prefix + helper.getFileName(newURL))));
                    }
                }
            }
            list.addAll(dirList);
            Collections.sort(list);
        }
        return list;
    }

    public List<URL> getFiles(String relPath) {
        return this.getFiles(relPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getFiles(String relPath, URLFilter urlFilter) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        if (relPath != null) {
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL url : this._entriesCollection) {
                    URL entry = URLFactory.newDirURL(url, relPath);
                    URLFileSystem.FileInfo[] infos = URLFileSystem.ls(entry, urlFilter);
                    if (infos == null) continue;
                    for (URLFileSystem.FileInfo info : infos) {
                        if (!info.isFile()) continue;
                        URL newURL = info.getURL();
                        fileList.add(newURL);
                    }
                }
            }
            Collections.sort(fileList, new URLComparator());
        }
        return fileList;
    }

    public List<URL> getFilesAndDirectories(String relPath, boolean dirsBeforeFiles) {
        return this.getFilesAndDirectories(relPath, dirsBeforeFiles, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getFilesAndDirectories(String relPath, boolean dirsBeforeFiles, URLFilter urlFilter) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        if (relPath != null) {
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL url : this._entriesCollection) {
                    URL entry = URLFactory.newDirURL(url, relPath);
                    URLFileSystemHelper helper = URLFileSystem.findHelper(entry);
                    URLFileSystem.FileInfo[] infos = helper.ls(entry, urlFilter);
                    if (infos == null) continue;
                    for (URLFileSystem.FileInfo info : infos) {
                        URL newURL = info.getURL();
                        fileList.add(newURL);
                    }
                }
            }
            Collections.sort(fileList, new URLComparator(dirsBeforeFiles));
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getFirstEntry() {
        Object object = this._iteratorLock;
        synchronized (object) {
            Iterator<URL> iterator = this._entriesCollection.iterator();
            return iterator.hasNext() ? iterator.next() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLPath getURLPath(HashStructure hash, String urlPathName) {
        ListStructure list;
        URLPath urlPath = new URLPath();
        if (hash != null && (list = hash.getListStructure(urlPathName)) != null) {
            Object object = list.iteratorLock();
            synchronized (object) {
                urlPath.add(list);
            }
        }
        return urlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setURLPath(HashStructure hash, String urlPathName, URLPath urlPath) {
        if (hash != null) {
            if (urlPath != null) {
                List<URL> urlPathList = urlPath == null ? null : urlPath.asList();
                ListStructure list = hash.getOrCreateListStructure(urlPathName);
                Object object = list.iteratorLock();
                synchronized (object) {
                    return list.mirror(urlPathList);
                }
            }
            if (hash.containsKey(urlPathName)) {
                hash.remove(urlPathName);
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<URL> iterator() {
        if (this._entriesMap != null) {
            class WrappedIterator
            implements Iterator<URL> {
                Iterator<URL> baseIterator;

                WrappedIterator(Iterator<URL> baseIterator) {
                    this.baseIterator = baseIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.baseIterator.hasNext();
                }

                @Override
                public URL next() {
                    return this.baseIterator.next();
                }

                @Override
                public void remove() {
                    this.baseIterator.remove();
                    URLPath.this.markDirty(true);
                }
            }
            return new WrappedIterator(this._entriesMap.values().iterator());
        }
        return this._entriesList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(Consumer<? super URL> action) {
        Object object = this._iteratorLock;
        synchronized (object) {
            for (URL entry : this._entriesCollection) {
                action.accept(entry);
            }
        }
    }

    public Object iteratorLock() {
        return this._iteratorLock;
    }

    public static URLPath newURLPathFromString(String entries) {
        URLPath urlPath = new URLPath();
        if (entries != null) {
            StringTokenizer tokenizer = new StringTokenizer(entries, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                URL url = URLPath.pathToURL(path);
                urlPath.add(url);
            }
        }
        return urlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(URL entry) {
        if (entry != null) {
            Object object = this._iteratorLock;
            synchronized (object) {
                if (this._entriesMap != null) {
                    if (null != this._entriesMap.remove(URLKey.getInstance(entry))) {
                        this.markDirty(true);
                    }
                } else {
                    int i = this.findEntryInList(entry);
                    if (i >= 0) {
                        this._entriesList.remove(i);
                        this.markDirty(true);
                    }
                }
            }
        }
    }

    public void remove(URL[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            for (int i = 0; i < numEntries; ++i) {
                this.remove(entries[i]);
            }
        }
    }

    public void remove(URLPath urlPath) {
        if (urlPath != null) {
            List<URL> copy = urlPath.asList();
            for (URL url : copy) {
                this.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntries(URL[] entries) {
        Object object = this._iteratorLock;
        synchronized (object) {
            this.clear();
            if (entries != null) {
                this.add(entries);
            }
        }
    }

    public int size() {
        return this._entriesCollection.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._iteratorLock;
        synchronized (object) {
            if (!this._entriesCollection.isEmpty()) {
                this._entriesCollection.clear();
                this.markDirty(true);
            }
        }
    }

    private boolean isArchive(URL url) {
        return ".zip".equalsIgnoreCase(URLFileSystem.getSuffix(url)) || ".jar".equalsIgnoreCase(URLFileSystem.getSuffix(url));
    }

    public URL toQualifiedURL(String relativePath) {
        URL[] urls = this.toQualifiedURL(relativePath, true);
        if (urls == null) {
            return null;
        }
        return urls[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] toQualifiedURL(String relativePath, boolean firstMatch) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (relativePath != null) {
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL url : this._entriesCollection) {
                    URL fullURL = JarUtil.isJarURL(url) ? URLFactory.newJarURL(url, relativePath) : (this.isArchive(url) ? URLFactory.newJarURL(url, relativePath) : URLFactory.newURL(url, relativePath));
                    if (!URLFileSystem.exists(fullURL)) continue;
                    urlList.add(fullURL);
                    if (!firstMatch) continue;
                    break;
                }
            }
        }
        if (urlList.size() == 0) {
            return null;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL toBoundURL(String relativePath) {
        if (relativePath != null) {
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL url : this._entriesCollection) {
                    URL fullURL = JarUtil.isJarURL(url) ? URLFactory.newJarURL(url, relativePath) : URLFactory.newURL(url, relativePath);
                    if (!URLFileSystem.isBound(fullURL)) continue;
                    return fullURL;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toRelativePath(URL url) {
        if (url != null) {
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL entry : this._entriesCollection) {
                    String relativePath = URLFileSystem.toRelativeSpec(url, entry, true);
                    if (relativePath == null) continue;
                    return relativePath;
                }
            }
        }
        return null;
    }

    public String toShortestRelativePath(URL url) {
        URL longestMatch = this.getLongestMatchingEntry(url);
        if (longestMatch != null) {
            return URLFileSystem.toRelativeSpec(url, longestMatch, true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getLongestMatchingEntry(URL url) {
        if (url != null) {
            String urlString = url.toString();
            String longestMatch = null;
            URL longestURL = null;
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL entry : this._entriesCollection) {
                    String entryString = entry.toString();
                    if (!urlString.startsWith(entryString) || longestMatch != null && entryString.length() <= longestMatch.length()) continue;
                    longestMatch = entryString;
                    longestURL = entry;
                }
            }
            return longestURL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] toStrings() {
        Object object = this.iteratorLock();
        synchronized (object) {
            String[] result = new String[this.size()];
            int i = 0;
            for (URL entry : this._entriesCollection) {
                result[i++] = URLFileSystem.getPlatformPathName(entry);
            }
            return result;
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((URLPath)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.iteratorLock();
        synchronized (object) {
            int hashCode = 0;
            for (URL url : this._entriesCollection) {
                hashCode = hashCode * 31 + url.hashCode();
            }
            return hashCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean equalsImpl(URLPath that) {
        if (this == that) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        List<URL> thatList = that.asList();
        Object object = this.iteratorLock();
        synchronized (object) {
            Iterator<URL> iter1 = this._entriesCollection.iterator();
            Iterator<URL> iter2 = thatList.iterator();
            while (iter1.hasNext()) {
                URL url2;
                URL url1 = iter1.next();
                if (URLFileSystem.equals(url1, url2 = iter2.next())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Object object = this.iteratorLock();
        synchronized (object) {
            for (URL url : this._entriesCollection) {
                String path = URLFileSystem.getPlatformPathName(url);
                buffer.append(path).append(File.pathSeparatorChar);
            }
        }
        int len = buffer.length();
        if (len > 0) {
            buffer.setLength(len - 1);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAllEntriesExist() {
        Object object = this.iteratorLock();
        synchronized (object) {
            for (URL entry : this._entriesCollection) {
                if (URLFileSystem.exists(entry)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findEntryInList(URL entry) {
        assert (this._entriesList != null && this._entriesMap == null);
        if (entry != null && this._entriesList != null) {
            int i = 0;
            Object object = this.iteratorLock();
            synchronized (object) {
                for (URL url : this._entriesList) {
                    if (URLFileSystem.equals(entry, url)) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    private static URL pathToURL(String pathname) {
        if (JarUtil.isArchive(pathname) && !new File(pathname).isDirectory()) {
            URL url = URLFactory.newFileURL(pathname);
            return URLFactory.newJarURL(url, "");
        }
        URL dirURL = URLFactory.newDirURL(pathname);
        return URLFileSystem.canonicalize(dirURL);
    }

    private static void _getAllDirectories(URL baseURL, URL currentURL, Set<String> dirList, URLFileSystemHelper helper) {
        URLFileSystem.FileInfo[] infos = helper.ls(currentURL);
        if (infos != null) {
            String relPath = helper.toRelativeSpec(currentURL, baseURL);
            if (relPath != null && relPath.length() > 0) {
                dirList.add(relPath);
            }
            for (URLFileSystem.FileInfo info : infos) {
                if (!info.isDirectory()) continue;
                URLPath._getAllDirectories(baseURL, info.getURL(), dirList, helper);
            }
        }
    }
}

