/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespacesets;

import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.AbstractTablespaceSetAction;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.AbstractTablespaceSetGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.AdvancedPropertiesTab;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.AlterTablespaceSetGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.CreateTablespaceSetGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.DefaultParametersTab;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.Operation;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.TablespaceSetValues;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class CreateEditTablespaceSetAction
extends AbstractTablespaceSetAction {
    private TablespaceSetValues tablespaceSetValues;
    private AbstractTablespaceSetGenerator generator;

    protected String getTitle() {
        String string = this.tablespaceSetValues.getOperation() == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_TABLESPACE_TITLE") : DbaNavigatorResources.getString("CREATE_TABLESPACE_TITLE");
        return string;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>();
        arrayList.add(new AdvancedPropertiesTab("ADVANCED_PROPERTIES_TAB", this.tablespaceSetValues));
        arrayList.add(new DefaultParametersTab("DEFAULT_PARAMETERS_TAB", this.tablespaceSetValues));
        return arrayList;
    }

    protected List<ActionControl> createControls(Connection connection) {
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        TextBoxActionControl textBoxActionControl;
        String string2;
        this.loadShardedDDLStatus(connection);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        Operation operation = Operation.valueOf(this.getArgs());
        this.tablespaceSetValues = new TablespaceSetValues(operation, string -> this.getQuery(connection, (String)string));
        switch (operation) {
            case CREATE_NEW: {
                string2 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
                this.generator = new CreateTablespaceSetGenerator();
                break;
            }
            case CREATE_LIKE: {
                string2 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
                this.tablespaceSetValues.loadFromCatalog(connection, this.getObjectName());
                this.generator = new CreateTablespaceSetGenerator();
                break;
            }
            default: {
                string2 = this.getObjectName();
                this.tablespaceSetValues.loadFromCatalog(connection, string2);
                this.generator = new AlterTablespaceSetGenerator();
            }
        }
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl("SetName", DbaNavigatorResources.getString("TABLESPACE_SET_NAME_LABEL"), string2);
        arrayList.add((ActionControl)textBoxActionControl2);
        switch (operation) {
            case CREATE_NEW: {
                textBoxActionControl = new SqlComboBoxActionControl("ShardSpace", DbaNavigatorResources.getString("SHARD_SPACE_LABEL"), connection, this.getQuery(connection, "getShardspaceNames"));
                break;
            }
            case CREATE_LIKE: {
                textBoxActionControl = new SqlComboBoxActionControl("ShardSpace", DbaNavigatorResources.getString("SHARD_SPACE_LABEL"), connection, this.getQuery(connection, "getShardspaceNames"), this.tablespaceSetValues.getShardSpace());
                break;
            }
            default: {
                textBoxActionControl = new TextBoxActionControl("ShardSpace", DbaNavigatorResources.getString("SHARD_SPACE_LABEL"), this.tablespaceSetValues.getShardSpace());
                textBoxActionControl.enableUI(false);
            }
        }
        arrayList.add((ActionControl)textBoxActionControl);
        switch (operation) {
            case CREATE_NEW: 
            case CREATE_LIKE: {
                booleanCheckBoxActionControl = new BooleanCheckBoxActionControl("DataFile", DbaNavigatorResources.getString("DATA_FILE_LABEL"), this.tablespaceSetValues.isDataFileSpecified());
                arrayList.add((ActionControl)booleanCheckBoxActionControl);
                break;
            }
            default: {
                booleanCheckBoxActionControl = null;
            }
        }
        FileSizeActionControl fileSizeActionControl = switch (operation) {
            case Operation.CREATE_LIKE -> new FileSizeActionControl("FileSize", DbaNavigatorResources.getString("FILE_SIZE_LABEL"), (long)this.tablespaceSetValues.getInitialSize());
            default -> new FileSizeActionControl("FileSize", DbaNavigatorResources.getString("FILE_SIZE_LABEL"), (long)this.tablespaceSetValues.getFileSize());
        };
        arrayList.add((ActionControl)fileSizeActionControl);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl("AutoExtend", DbaNavigatorResources.getString("AUTO_EXTEND_LABEL"), this.tablespaceSetValues.isAutoExtend());
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        FileSizeActionControl fileSizeActionControl2 = new FileSizeActionControl("NextSize", DbaNavigatorResources.getString("NEXT_SIZE_LABEL"), (long)this.tablespaceSetValues.getNextSize());
        arrayList.add((ActionControl)fileSizeActionControl2);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl3 = new BooleanCheckBoxActionControl("UnlimitedMaxSize", DbaNavigatorResources.getString("UNLIMITED_MAX_SIZE_LABEL"), this.tablespaceSetValues.isUnlimitedMaxSize());
        arrayList.add((ActionControl)booleanCheckBoxActionControl3);
        FileSizeActionControl fileSizeActionControl3 = new FileSizeActionControl("MaxSize", DbaNavigatorResources.getString("MAX_SIZE_LABEL"), (long)this.tablespaceSetValues.getMaxSize());
        arrayList.add((ActionControl)fileSizeActionControl3);
        this.resetControlEnablement((ActionControl)booleanCheckBoxActionControl, (ActionControl)fileSizeActionControl, (ActionControl)booleanCheckBoxActionControl2, (ActionControl)fileSizeActionControl2, (ActionControl)booleanCheckBoxActionControl3, (ActionControl)fileSizeActionControl3);
        if (booleanCheckBoxActionControl != null) {
            booleanCheckBoxActionControl.addPropertyChangeListener(arg_0 -> this.lambda$createControls$1((ActionControl)booleanCheckBoxActionControl, (ActionControl)fileSizeActionControl, (ActionControl)booleanCheckBoxActionControl2, (ActionControl)fileSizeActionControl2, (ActionControl)booleanCheckBoxActionControl3, (ActionControl)fileSizeActionControl3, arg_0));
        }
        booleanCheckBoxActionControl2.addPropertyChangeListener(arg_0 -> this.lambda$createControls$2((ActionControl)booleanCheckBoxActionControl, (ActionControl)fileSizeActionControl, (ActionControl)booleanCheckBoxActionControl2, (ActionControl)fileSizeActionControl2, (ActionControl)booleanCheckBoxActionControl3, (ActionControl)fileSizeActionControl3, arg_0));
        booleanCheckBoxActionControl3.addPropertyChangeListener(arg_0 -> this.lambda$createControls$3((ActionControl)booleanCheckBoxActionControl, (ActionControl)fileSizeActionControl, (ActionControl)booleanCheckBoxActionControl2, (ActionControl)fileSizeActionControl2, (ActionControl)booleanCheckBoxActionControl3, (ActionControl)fileSizeActionControl3, arg_0));
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPreSql(stringBuilder);
        stringBuilder.append(this.generator.generate(this.tablespaceSetValues, values));
        this.appendPostSql(stringBuilder);
        return stringBuilder.toString();
    }

    private void resetControlEnablement(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, ActionControl actionControl5, ActionControl actionControl6) {
        boolean bl = actionControl != null ? Boolean.parseBoolean(actionControl.getValue().get()) : true;
        boolean bl2 = Boolean.parseBoolean(actionControl3.getValue().get());
        boolean bl3 = Boolean.parseBoolean(actionControl5.getValue().get());
        actionControl2.enableUI(bl);
        actionControl3.enableUI(bl);
        actionControl4.enableUI(bl && bl2);
        actionControl5.enableUI(bl && bl2);
        actionControl6.enableUI(bl && bl2 && !bl3);
    }

    private /* synthetic */ void lambda$createControls$3(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, ActionControl actionControl5, ActionControl actionControl6, PropertyChangeEvent propertyChangeEvent) {
        this.resetControlEnablement(actionControl, actionControl2, actionControl3, actionControl4, actionControl5, actionControl6);
    }

    private /* synthetic */ void lambda$createControls$2(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, ActionControl actionControl5, ActionControl actionControl6, PropertyChangeEvent propertyChangeEvent) {
        this.resetControlEnablement(actionControl, actionControl2, actionControl3, actionControl4, actionControl5, actionControl6);
    }

    private /* synthetic */ void lambda$createControls$1(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, ActionControl actionControl5, ActionControl actionControl6, PropertyChangeEvent propertyChangeEvent) {
        this.resetControlEnablement(actionControl, actionControl2, actionControl3, actionControl4, actionControl5, actionControl6);
    }
}

