/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.widgets;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.ui.controller.CloudMigrationController;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.raptor.ui.LayoutControl;

public class AvailableDatabasesShuttlePanel {
    JLabel availableDBs;
    JLabel selectedDBs;
    JList<String> availableDBList;
    DefaultListModel<String> availableDBListModel;
    JList<String> selectedDBList;
    DefaultListModel<String> selectedDBListModel;
    Shuttle shuttle;
    ListPicker availableDBPicker;
    ListPicker selectedDBPicker;
    JPanel shuttlePanel;
    private static CloudMigrationController cloudMigrationController;

    public AvailableDatabasesShuttlePanel() {
        cloudMigrationController = CloudMigrationController.getInstance();
        this.createShuttleStructure();
    }

    public void createShuttleStructure() {
        this.availableDBListModel = this.populateAvailableSchemasListModel();
        this.availableDBList = new JList<String>(this.availableDBListModel);
        this.selectedDBListModel = new DefaultListModel();
        this.selectedDBList = new JList<String>(this.selectedDBListModel);
        this.availableDBPicker = new ListPicker(this.availableDBList);
        this.selectedDBPicker = new ListPicker(this.selectedDBList);
        this.shuttle = new Shuttle();
        this.availableDBs = new JLabel(this.getNLS("AVALIABLE_DATABASES_PANEL_AVALIABLE_DATABASES"));
        this.selectedDBs = new JLabel(this.getNLS("SELECTED_DATABASES_PANEL_AVALIABLE_DATABASES"));
        this.shuttle.add((Component)this.availableDBs, (Object)"FromHeader");
        this.shuttle.add((Component)this.selectedDBs, (Object)"ToHeader");
        this.shuttle.setFromPicker((ItemPicker)this.availableDBPicker);
        this.shuttle.setToPicker((ItemPicker)this.selectedDBPicker);
    }

    public JPanel createShuttlePanel() {
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this.shuttle, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        return jPanel;
    }

    protected String getNLS(String string) {
        return CloudMigrationsResources.get(string);
    }

    public DefaultListModel<String> populateAvailableSchemasListModel() {
        return Utilities.createEmptyAvaliableListModel();
    }

    public void updateAvailableSchemasListModel(String[] stringArray) {
        this.availableDBList.setListData((String[])stringArray);
    }

    public void addShuttleListener(ShuttleListener shuttleListener) {
        this.shuttle.addShuttleListener(shuttleListener);
    }

    public void updateSelectedSchemasListModel(String[] stringArray) {
        this.selectedDBList.setListData((String[])stringArray);
    }

    public void addAvailableSchemasActionListener(ActionListener actionListener) {
        this.availableDBPicker.addActionListener(actionListener);
    }

    public void addSelectedSchemasPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.selectedDBPicker.addPropertyChangeListener(propertyChangeListener);
    }

    public void updateBothList() {
        int n;
        cloudMigrationController.cleanAvailableSchemas();
        cloudMigrationController.cleanSelectedSchemas();
        int n2 = this.selectedDBList.getModel().getSize();
        for (n = 0; n < n2; ++n) {
            cloudMigrationController.addToSelectedSchemas(this.selectedDBList.getModel().getElementAt(n));
        }
        n = this.availableDBList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            cloudMigrationController.addToAvailableSchemas(this.availableDBList.getModel().getElementAt(i));
        }
    }

    public void cleanBothLists() {
        cloudMigrationController.cleanAvailableSchemas();
        cloudMigrationController.cleanSelectedSchemas();
        ((DefaultListModel)this.selectedDBList.getModel()).clear();
        ((DefaultListModel)this.availableDBList.getModel()).clear();
        this.selectedDBList.removeAll();
        this.availableDBList.removeAll();
    }

    public void updateBothListModelToUI() {
        this.selectedDBList.removeAll();
        this.availableDBList.removeAll();
        String[] stringArray = cloudMigrationController.getSelectedSchemas();
        for (int i = 0; i < stringArray.length; ++i) {
            this.selectedDBListModel.addElement(stringArray[i]);
        }
        String[] stringArray2 = cloudMigrationController.getAvailableSchemas();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.availableDBListModel.addElement(stringArray2[i]);
        }
    }

    public boolean clearBothListModels() {
        if (this.selectedDBListModel == null || this.availableDBListModel == null) {
            return false;
        }
        if (this.selectedDBListModel != null) {
            this.selectedDBListModel.clear();
        }
        if (this.availableDBListModel != null) {
            this.availableDBListModel.clear();
        }
        return true;
    }
}

