/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.util.function.Function;

public class LibraryDependency {
    private final String id;
    private final boolean reexported;
    private boolean resolved;
    private Object library;

    public LibraryDependency(String id, boolean reexported) {
        this.id = id;
        this.reexported = reexported;
    }

    public String getId() {
        return this.id;
    }

    public boolean isReexported() {
        return this.reexported;
    }

    public Object resolve(Function<String, ? extends Object> resolver) {
        if (this.resolved) {
            return this.library;
        }
        this.resolved = true;
        this.library = resolver.apply(this.id);
        return this.library;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public Object getLibrary() {
        if (!this.resolved) {
            throw new IllegalStateException("dependency not resolved");
        }
        return this.library;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LibraryDependency that = (LibraryDependency)object;
        return this.reexported == that.reexported && this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.reexported ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.reexported ? this.id + " (reexported)" : this.id;
    }
}

