/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class StringPool {
    public abstract String pool(String var1);

    public static StringPool synchronizedPool() {
        return new SynchronizedStringPool();
    }

    public static StringPool synchronizedPool(Collection<String> strings) {
        SynchronizedStringPool pool = new SynchronizedStringPool();
        for (String string : strings) {
            ((StringPool)pool).pool(string);
        }
        return pool;
    }

    public static StringPool nullPool() {
        return new NullStringPool();
    }

    private static final class SynchronizedStringPool
    extends StringPool {
        private final Map<String, String> map = new HashMap<String, String>();

        private SynchronizedStringPool() {
        }

        @Override
        public final synchronized String pool(String string) {
            String predecessor = this.map.putIfAbsent(string, string);
            return predecessor != null ? predecessor : string;
        }
    }

    private static final class NullStringPool
    extends StringPool {
        private NullStringPool() {
        }

        @Override
        public final String pool(String string) {
            return string;
        }
    }
}

