/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.comment.RemediationCommentsWriter;
import oracle.javatools.exports.common.StringPool;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Tag;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.xml.sax.SAXException;

public class MergeCommentsTask
extends Task {
    private Resources files = new Resources();
    private File toFile;
    private boolean failOnError;
    private RemediationCommentsWriter.Type commentType = RemediationCommentsWriter.Type.ELEMENT;

    public void setFile(File file) {
        this.files.add((ResourceCollection)new FileResource(file));
    }

    public void setToFile(File file) {
        this.toFile = file;
    }

    public void setCommentType(String type) {
        this.commentType = RemediationCommentsWriter.Type.valueOf(type.trim().toUpperCase());
    }

    public void add(ResourceCollection c) {
        this.files.add(c);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void execute() {
        RemediationCommentsReader reader = new RemediationCommentsReader(StringPool.synchronizedPool(), true, false);
        RemediationCommentsWriter writer = new RemediationCommentsWriter();
        writer.setCommentType(this.commentType);
        HashMap<String, String> mergedComments = new HashMap<String, String>();
        for (Resource resource : this.files) {
            String name = resource.getName();
            try {
                InputStream stream = resource.getInputStream();
                try {
                    Log log = Log.newLog(new Tag[0]);
                    Map<String, String> comments = reader.read(name, stream, log);
                    Collection<Message> messages = log.getMessages();
                    if (!messages.isEmpty()) {
                        this.log("Comments file " + name + " has " + messages.size() + " issue" + (messages.size() == 1 ? ":" : "s:"));
                        for (Message message : messages) {
                            this.log("    " + message.getMessage());
                        }
                    }
                    for (Map.Entry<String, String> entry : comments.entrySet()) {
                        String predecessor = mergedComments.putIfAbsent(entry.getKey(), entry.getValue());
                        if (predecessor == null) continue;
                        this.log("Duplicate comment ignored for " + entry.getKey() + " in " + name, 0);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new BuildException("Exception reading " + name + ": " + e, (Throwable)e);
            }
        }
        try {
            writer.write(mergedComments, this.toFile.toPath());
        }
        catch (IOException e) {
            throw new BuildException("Exception writing " + this.toFile + ": " + e, (Throwable)e);
        }
        try {
            Log log = Log.newLog(new Tag[0]);
            Map<String, String> restoredComments = reader.read(this.toFile.toPath(), log);
            Collection<Message> messages = log.getMessages();
            if (!messages.isEmpty()) {
                this.log("Comments file " + this.toFile + " has " + messages.size() + " issue" + (messages.size() == 1 ? ":" : "s:"));
                for (Message message : messages) {
                    this.log("    " + message.getMessage());
                }
            }
            int differenceCount = 0;
            for (Map.Entry entry : mergedComments.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String restoredValue = restoredComments.remove(key);
                if (!value.isEmpty() ? value.equals(restoredValue) : restoredValue == null) continue;
                if (differenceCount++ == 0) {
                    this.log("Verifying " + this.toFile + " failed:", 0);
                }
                this.log("Key: " + key, 0);
                this.log("  Expected: " + value, 0);
                this.log("  Actual:   " + restoredValue, 0);
            }
            if (!restoredComments.isEmpty()) {
                throw new BuildException("unexpected comments in " + this.toFile + ": " + restoredComments);
            }
            if (differenceCount > 0) {
                String string = differenceCount + " discrepanc" + (differenceCount == 1 ? "y" : "ies") + " verifying " + this.toFile;
                if (this.failOnError) {
                    throw new BuildException(string);
                }
                this.log(string, 0);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new BuildException("Exception verifying " + this.toFile + ": " + e, (Throwable)e);
        }
    }
}

