/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.ant;

import java.io.File;
import java.util.Arrays;
import java.util.TreeSet;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.ant.ExtensionResource;
import oracle.javatools.exports.ant.InstallationResource;
import oracle.javatools.exports.ant.LibraryList;
import oracle.javatools.exports.ant.LibraryResource;
import oracle.javatools.exports.ant.PathList;
import oracle.javatools.exports.command.Command;
import oracle.javatools.exports.command.CommandInput;
import oracle.javatools.exports.command.CommandOutput;
import oracle.javatools.exports.file.Paths;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ExportTask
extends Task
implements CommandOutput {
    private PathList classPath = new PathList(this.getProject());
    private LibraryList libraries = new LibraryList(this.getProject());
    private LibraryList dependencies = new LibraryList(this.getProject());
    private PathList baselines = new PathList(this.getProject());
    private PathList scope = new PathList(this.getProject());
    private PathList bootClassPath = new PathList(this.getProject());
    private PathList messages = new PathList(this.getProject());
    private PathList exports = new PathList(this.getProject());
    private PathList approvals = new PathList(this.getProject());
    private CommandInput properties = new CommandInput();

    public void setMiddlewareHome(File directory) {
        this.properties.setMiddlewareHome(directory.toPath());
    }

    public void setSource(String source) {
        this.properties.setSource(source);
    }

    public void setOwner(String owner) {
        this.properties.setOwner(owner);
    }

    public void setConsumers(String names) {
        TreeSet<String> consumers = new TreeSet<String>();
        for (String consumer : names.split(",")) {
            consumers.add(consumer.trim());
        }
        this.properties.setConsumers(consumers);
    }

    public void setDomain(String name) {
        if ("fmw".equalsIgnoreCase(name)) {
            this.properties.setDomain(CommandInput.FMW_DOMAIN);
        } else {
            this.properties.setDomain(Paths.get(name, new String[0]));
        }
    }

    public void setLibraryName(String libraryName) {
        this.properties.setLibraryName(libraryName);
    }

    public void setLibraryId(String libraryId) {
        this.properties.setLibraryId(libraryId);
    }

    public void setLibraryDescription(String libraryDescription) {
        this.properties.setLibraryDescription(libraryDescription);
    }

    public void setValidate(boolean validate) {
        this.properties.setValidating(validate);
    }

    public void setFailOnClassPathError(boolean failOnClassPathError) {
        this.properties.setFailOnClassPathError(failOnClassPathError);
    }

    public Path createClassPath() {
        return this.classPath;
    }

    @Deprecated
    public void setOfficialDomain(boolean official) {
        this.properties.setDomain(CommandInput.FMW_DOMAIN);
    }

    public void setOfficial(boolean official) {
        this.properties.setOfficial(official);
    }

    public void setAccess(CompatibilityAccess access) {
        this.properties.setAccess(access);
    }

    public void setCompareTo(File file) {
        this.properties.setCompareTo(file.toPath());
    }

    public PathList createExports() {
        return this.exports;
    }

    public void setExports(File file) {
        this.createExports().setLocation(file);
    }

    public void setExportsRef(Reference reference) {
        this.createExports().setRefid(reference);
    }

    public PathList createMessages() {
        return this.messages;
    }

    public void setMessages(File file) {
        this.createMessages().setLocation(file);
    }

    public void setMessagesRef(Reference reference) {
        this.createMessages().setRefid(reference);
    }

    public void setTraces(boolean traces) {
        this.properties.setTraces(traces);
    }

    public void setUses(boolean uses) {
        this.properties.setUses(uses);
    }

    public void setRecentUses(boolean uses) {
        this.properties.setUses(uses);
    }

    public void setClasses(boolean classes) {
        this.properties.setClasses(classes);
    }

    public void setClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public Path createAnnotatedClassPath() {
        return this.classPath;
    }

    public void setAnnotatedClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public LibraryList createLibraries() {
        return this.libraries;
    }

    public void setLibrariesRef(Reference reference) {
        this.createLibraries().setRefid(reference);
    }

    public void addInstallation(InstallationResource installation) {
        this.createLibraries().addInstallation(installation);
    }

    public void addExtension(ExtensionResource library) {
        this.createLibraries().addExtension(library);
    }

    public void addLibrary(LibraryResource library) {
        this.createLibraries().addLibrary(library);
    }

    public void setPackages(String names) {
        this.properties.setPackages(Arrays.asList(names.split("\\s*,\\s*")));
    }

    public PathList createScope() {
        return this.scope;
    }

    public void setScopeRef(Reference reference) {
        this.createScope().setRefid(reference);
    }

    public PathList createApprovals() {
        return this.approvals;
    }

    public void setApprovalsRef(Reference reference) {
        this.createApprovals().setRefid(reference);
    }

    public void setDependencies(Path classpath) {
        this.createDependencies().add(classpath);
    }

    public LibraryList createDependencies() {
        return this.dependencies;
    }

    public void setDependenciesRef(Reference reference) {
        this.createDependencies().setRefid(reference);
    }

    public void setBootClasspath(Path classpath) {
        this.createBootClasspath().append(classpath);
    }

    public void setBootClassPathRef(Reference reference) {
        this.createBootClasspath().setRefid(reference);
    }

    public Path createBootClasspath() {
        return this.bootClassPath;
    }

    public void setDirectory(File directory) {
        this.properties.setDirectory(directory.toPath());
    }

    public void setOutputDir(File directory) {
        this.properties.setDirectory(directory.toPath());
    }

    public void setReference(File fileOrDirectory) {
        this.properties.setBaseline0(fileOrDirectory.toPath());
    }

    public void setRevision(File fileOrDirectory) {
        this.properties.setBaseline1(fileOrDirectory.toPath());
    }

    public void setOutput(String text) {
        this.properties.setOutput(Arrays.asList(text.split(",")));
    }

    public void setBaselineFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.BASELINE, file.toPath());
    }

    public void setCommentsFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.COMMENTS, file.toPath());
    }

    public void setComments11gFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.COMMENTS, file.toPath());
    }

    public void setConcealedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.CONCEALED, file.toPath());
    }

    public void setConcealedSignaturesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.CONCEALED, file.toPath());
    }

    public void setErrorsFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.ERRORS, file.toPath());
    }

    public void setErrorsUsedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.ERRORS_USED, file.toPath());
    }

    public void setExportedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.EXPORTED, file.toPath());
    }

    public void setExportedSignaturesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.EXPORTED, file.toPath());
    }

    public void setExportsFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.EXPORTS, file.toPath());
    }

    public void setIssuesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.ISSUES, file.toPath());
    }

    public void setLibrariesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.LIBRARIES, file.toPath());
    }

    public void setLibraryFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.LIBRARY, file.toPath());
    }

    public void setMatchedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.MATCHED, file.toPath());
    }

    public void setNotesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.NOTES, file.toPath());
    }

    public void setPackagesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.PACKAGES, file.toPath());
    }

    public void setProblemsFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.PROBLEMS, file.toPath());
    }

    public void setProblemTypesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.PROBLEMS, file.toPath());
    }

    public void setRecentCommentedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RECENT_COMMENTED, file.toPath());
    }

    public void setRecentConcealedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RECENT_CONCEALED, file.toPath());
    }

    public void setRecentExportedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RECENT_EXPORTED, file.toPath());
    }

    public void setRecentUncommentedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RECENT_UNCOMMENTED, file.toPath());
    }

    public void setRecentMigratedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RECENT_MIGRATED, file.toPath());
    }

    public void setRecentMissingFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RECENT_MISSING, file.toPath());
    }

    public void setRestrictedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RESTRICTED, file.toPath());
    }

    public void setRestrictedSignaturesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.RESTRICTED, file.toPath());
    }

    public void setSubmittedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.SUBMITTED, file.toPath());
    }

    public void setTracesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.TRACES, file.toPath());
    }

    public void setTypesFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.TYPES, file.toPath());
    }

    public void setUnmatchedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.UNMATCHED, file.toPath());
    }

    public void setUsedFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.USED, file.toPath());
    }

    public void setWarningsFile(File file) {
        this.properties.setOutputPath(CommandInput.OutputType.WARNINGS, file.toPath());
    }

    public void setTaskName(String name) {
        super.setTaskName(name);
        CommandInput.CommandType type = name.contains("generate") ? CommandInput.CommandType.GENERATE : (name.contains("merge") ? CommandInput.CommandType.MERGE : (name.contains("capture") ? CommandInput.CommandType.CAPTURE : (name.contains("compare") ? CommandInput.CommandType.COMPARE : (name.contains("convert") ? CommandInput.CommandType.CONVERT : CommandInput.CommandType.ANALYZE))));
        this.properties.setCommandType(type);
    }

    public void execute() {
        this.properties.setClassPath(this.classPath.asList());
        this.properties.setLibraries(this.libraries.asList());
        this.properties.setDependencies(this.dependencies.asList());
        this.properties.setScope(this.scope.asList());
        this.properties.setApprovals(this.approvals.asList());
        this.properties.setFiles(this.messages.asList());
        this.properties.setBootClassPath(this.bootClassPath.asList());
        switch (this.properties.getCommandType()) {
            case GENERATE: {
                if (!this.properties.getClassPath().isEmpty()) break;
                throw new BuildException("<generate> task requires classpath attribute or <classpath> element");
            }
            case ANALYZE: 
            case MERGE: 
            case CAPTURE: {
                if (!this.properties.getClassPath().isEmpty() || !this.properties.getLibraries().isEmpty()) break;
                throw new BuildException("<" + this.properties.getCommandType() + "> task requires <classpath> or <libraries> element");
            }
        }
        try {
            this.properties.validate(this);
            Command.execute(this.properties, this);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void error(String message, Object ... arguments) {
        this.getProject().log(String.format(message, arguments), 0);
    }

    @Override
    public void warning(String message, Object ... arguments) {
        this.getProject().log(String.format(message, arguments), 1);
    }

    @Override
    public void note(String message, Object ... arguments) {
        this.getProject().log(String.format(message, arguments), 2);
    }

    @Override
    public void coarse(String message, Object ... arguments) {
        this.getProject().log(String.format(message, arguments), 3);
    }

    @Override
    public void fine(String message, Object ... arguments) {
        this.getProject().log(String.format(message, arguments), 4);
    }

    @Override
    public String propertyDescription(String propertyName) {
        switch (propertyName) {
            case "annotatedclasspath": {
                return "<annotatedclasspath> element";
            }
            case "baselines": 
            case "baseline0": 
            case "baseline1": {
                return "<baselines> element";
            }
            case "bootclasspath": {
                return "<bootclasspath> element";
            }
            case "classpath": {
                return "<classpath> element";
            }
            case "dependencies": {
                return "<dependencies> element";
            }
            case "exports": {
                return "<exports> element";
            }
            case "libraries": {
                return "<libraries> element";
            }
        }
        return propertyName + " attribute";
    }

    @Override
    public String propertyDescription(CommandInput.OutputType type) {
        return "\"" + type.getTypeName() + "\" in output attribute, or \"" + type.getOptionName() + "\" attribute";
    }

    @Override
    public String libraryOrExtensionDescription(String id) {
        return "<library id=\"" + id + "\"/> or <extension id=\"" + id + "\"/>";
    }
}

