/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.javaxide.Util;
import oracle.ide.model.ContentType;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ClassUtils;
import oracle.ide.util.Mutables;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.util.deferred.Thunk;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdevimpl.compare.CompareUtil2;

public final class CompareHandler
extends ElementVisitor {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "compare-hook");
    private static final ElementName COMPARE_TYPE = new ElementName("http://xmlns.oracle.com/ide/extension", "compare-type");
    private static final ElementName FALLBACK_COMPARE_TYPE = new ElementName("http://xmlns.oracle.com/ide/extension", "fallback-compare-type");
    private static final ElementName CONTENT_IS_BINARY = new ElementName("http://xmlns.oracle.com/ide/extension", "content-is-binary");
    private static final ElementName FILE_TYPE = new ElementName("http://xmlns.oracle.com/ide/extension", "file-type");
    private static final ElementName NODE_TYPE = new ElementName("http://xmlns.oracle.com/ide/extension", "node-type");
    private static final ElementName STREAM_TYPE = new ElementName("http://xmlns.oracle.com/ide/extension", "stream-type");
    private static final ElementName ALGORITHM_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "algorithm-class");
    private static final ElementName VIEW_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "view-class");
    private static final ElementName METHOD_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "method-class");
    private final ElementVisitor _compareTypeHandler = new CompareTypeHandler();
    private final ElementVisitor _fallbackCompareTypeHandler = new FallbackCompareTypeHandler();
    private final ElementVisitor _contentIsBinaryHandler = new ContentIsBinaryHandler();
    private final ElementVisitor _fileTypeHandler = new FileTypeHandler();
    private final ElementVisitor _nodeTypeHandler = new NodeTypeHandler();
    private final ElementVisitor _streamTypeHandler = new StreamTypeHandler();
    private final ElementVisitor _algorithmClassHandler = new AlgorithmClassHandler();
    private final ElementVisitor _viewClassHandler = new ViewClassHandler();
    private final ElementVisitor _methodClassHandler = new MethodClassHandler();
    private static final String KEY_SCOPE_COMPARE_TYPE = "oide_compare_compare_type";
    private static final String KEY_SCOPE_FALLBACK_TYPES = "oide_compare_fallback_types";
    private static final String KEY_SCOPE_NODE_TYPE = "oide_compare_node_type";
    private static final String KEY_SCOPE_STREAM_TYPE = "oide_compare_stream_type";
    private static final String KEY_SCOPE_CONTENT_TYPE = "oide_compare_content_type";
    private static final String KEY_SCOPE_FILE_TYPES = "oide_compare_file_types";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(COMPARE_TYPE, this._compareTypeHandler);
        context.registerChildVisitor(FALLBACK_COMPARE_TYPE, this._fallbackCompareTypeHandler);
        context.registerChildVisitor(CONTENT_IS_BINARY, this._contentIsBinaryHandler);
        context.registerChildVisitor(FILE_TYPE, this._fileTypeHandler);
        context.registerChildVisitor(NODE_TYPE, this._nodeTypeHandler);
        context.registerChildVisitor(STREAM_TYPE, this._streamTypeHandler);
        context.registerChildVisitor(ALGORITHM_CLASS, this._algorithmClassHandler);
        context.registerChildVisitor(VIEW_CLASS, this._viewClassHandler);
        context.registerChildVisitor(METHOD_CLASS, this._methodClassHandler);
        context.getScopeData().put(KEY_SCOPE_COMPARE_TYPE, new Mutables.Object(null));
        context.getScopeData().put(KEY_SCOPE_FALLBACK_TYPES, new ArrayList());
        context.getScopeData().put(KEY_SCOPE_CONTENT_TYPE, new Mutables.Object(null));
        context.getScopeData().put(KEY_SCOPE_FILE_TYPES, new ArrayList());
        context.getScopeData().put(KEY_SCOPE_NODE_TYPE, new Mutables.Object(null));
        context.getScopeData().put(KEY_SCOPE_STREAM_TYPE, new Mutables.Object(null));
    }

    private final class CompareTypeHandler
    extends ElementVisitor {
        private CompareTypeHandler() {
        }

        public void end(ElementEndContext context) {
            ((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_COMPARE_TYPE)).set((Object)new CompareType(context.getText()));
        }
    }

    private final class FallbackCompareTypeHandler
    extends ElementVisitor {
        private FallbackCompareTypeHandler() {
        }

        public void end(ElementEndContext context) {
            ((Collection)context.getScopeData().get(CompareHandler.KEY_SCOPE_FALLBACK_TYPES)).add(new CompareType(context.getText()));
        }
    }

    private final class ContentIsBinaryHandler
    extends ElementVisitor {
        private ContentIsBinaryHandler() {
        }

        public void end(ElementEndContext context) {
            ((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_CONTENT_TYPE)).set((Object)ContentType.BINARY);
        }
    }

    private final class FileTypeHandler
    extends ElementVisitor {
        private FileTypeHandler() {
        }

        public void end(ElementEndContext context) {
            ((Collection)context.getScopeData().get(CompareHandler.KEY_SCOPE_FILE_TYPES)).add(Recognizer.sanitizeExtension((String)context.getText()));
        }
    }

    private final class NodeTypeHandler
    extends MetaClassVisitor {
        private NodeTypeHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            ((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_NODE_TYPE)).set((Object)mc);
        }
    }

    private final class StreamTypeHandler
    extends ElementVisitor {
        private StreamTypeHandler() {
        }

        public void end(ElementEndContext context) {
            try {
                ((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_STREAM_TYPE)).set((Object)StreamType.valueOf(context.getText()));
            }
            catch (IllegalArgumentException iae) {
                this.log((ElementContext)context, Level.SEVERE, "Not a recognized stream type: " + context.getText());
            }
        }
    }

    private final class AlgorithmClassHandler
    extends MetaClassVisitor {
        private AlgorithmClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            CompareType type = (CompareType)((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_COMPARE_TYPE)).get();
            if (type != null) {
                CompareModelFactory.registerCompareAlgorithm((CompareType)type, new MetaClassThunk(mc));
            }
        }
    }

    private final class ViewClassHandler
    extends MetaClassVisitor {
        private ViewClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            CompareType type = (CompareType)((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_COMPARE_TYPE)).get();
            if (type != null) {
                CompareViewFactory.registerCompareView((CompareType)type, new MetaClassThunk(mc));
            }
        }
    }

    private final class MethodClassHandler
    extends MetaClassVisitor {
        private MethodClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            CompareType compareType = (CompareType)((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_COMPARE_TYPE)).get();
            if (compareType == null) {
                this.log(context, Level.SEVERE, "No compare-type before method-class");
            }
            MetaClassCompareMethod compareMethod = new MetaClassCompareMethod(mc, compareType);
            compareMethod.setFallbackCompareTypes((Collection)context.getScopeData().get(CompareHandler.KEY_SCOPE_FALLBACK_TYPES));
            compareMethod.setContentType((ContentType)((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_CONTENT_TYPE)).get());
            compareMethod.setFileTypes((Collection)context.getScopeData().get(CompareHandler.KEY_SCOPE_FILE_TYPES));
            compareMethod.setNodeType((MetaClass)((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_NODE_TYPE)).get());
            compareMethod.setStreamType((StreamType)((Object)((Mutables.Object)context.getScopeData().get(CompareHandler.KEY_SCOPE_STREAM_TYPE)).get()));
            CompareManager.getCompareManager().registerCompareMethod(compareMethod);
        }
    }

    public static final class MetaClassThunk<T>
    extends Thunk<Class<T>> {
        private final MetaClass<T> _metaClass;

        public MetaClassThunk(MetaClass<T> metaClass) {
            this._metaClass = metaClass;
        }

        protected Class<T> compute() {
            try {
                return this._metaClass.toClass();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException(cnfe);
            }
        }
    }

    private final class MetaClassCompareMethod
    extends CompareMethod {
        private final MetaClass _metaClass;
        private final CompareType _compareType;
        private Collection<CompareType> _fallbackCompareTypes;
        private MetaClass _nodeType;
        private StreamType _streamType;
        private ContentType _contentType;
        private Collection<File> _fileTypes;
        private CompareMethod _delegate;

        MetaClassCompareMethod(MetaClass metaClass, CompareType compareType) {
            this._metaClass = metaClass;
            this._compareType = compareType;
        }

        final void setFallbackCompareTypes(Collection<CompareType> fallbackCompareTypes) {
            this._fallbackCompareTypes = fallbackCompareTypes;
        }

        final void setNodeType(MetaClass nodeType) {
            this._nodeType = nodeType;
        }

        final void setStreamType(StreamType streamType) {
            this._streamType = streamType;
        }

        final void setContentType(ContentType contentType) {
            this._contentType = contentType;
        }

        final void setFileTypes(Collection<File> fileTypes) {
            this._fileTypes = fileTypes;
        }

        @Override
        public boolean canCompare(Element contextNode, CompareContributor left, CompareContributor right, StreamType streamType) {
            if (!this.checkStreamType(new CompareContributor[]{left, right}, streamType)) {
                return false;
            }
            if (!this.checkNode(contextNode)) {
                return false;
            }
            this.createDelegate();
            return this._delegate.canCompare(contextNode, left, right, streamType);
        }

        @Override
        public boolean canFallBack(CompareFailedException cfe) {
            this.createDelegate();
            return this._delegate.canFallBack(cfe);
        }

        @Override
        public boolean canMerge(Element contextNode, CompareContributor left, CompareContributor right, CompareContributor ancestor) {
            if (!this.checkStreamType(new CompareContributor[]{left, right, ancestor}, null)) {
                return false;
            }
            if (!this.checkNode(contextNode)) {
                return false;
            }
            this.createDelegate();
            return this._delegate.canMerge(contextNode, left, right, ancestor);
        }

        private final boolean checkStreamType(CompareContributor[] contributors, StreamType streamType) {
            if (this._streamType == null) {
                return true;
            }
            if (streamType != null) {
                return this._streamType == streamType;
            }
            for (CompareContributor contributor : contributors) {
                if (this._streamType == CompareUtil2.getStreamType(contributor)) continue;
                return false;
            }
            return true;
        }

        @Override
        public CompareType[] getFallbackCompareTypes() {
            return this._fallbackCompareTypes != null ? this._fallbackCompareTypes.toArray(new CompareType[this._fallbackCompareTypes.size()]) : null;
        }

        @Override
        public CompareType getCompareType() {
            return this._compareType;
        }

        @Override
        public void processOptions() {
            this.createDelegate();
            this._delegate.processOptions();
        }

        @Override
        public boolean recognizeContent(URL url) {
            ContentType contentType;
            ContentType contentType2 = contentType = this._contentType != null ? this._contentType : ContentType.TEXT;
            if (FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)url)) != contentType) {
                return false;
            }
            return this.checkFileTypes(url);
        }

        private final boolean checkNode(Element node) {
            if (node == null) {
                return false;
            }
            if (node instanceof Locatable && !this.checkFileTypes(((Locatable)node).getURL())) {
                return false;
            }
            return this._nodeType == null || ClassUtils.isInstanceOf(node.getClass(), (String)this._nodeType.getClassName());
        }

        private final boolean checkFileTypes(URL url) {
            if (!this._fileTypes.isEmpty()) {
                String suffix;
                if (url != null && (suffix = URLFileSystem.getSuffix((URL)url)) != "") {
                    File suffixAsFile = Recognizer.sanitizeExtension((String)suffix);
                    for (File fileType : this._fileTypes) {
                        if (!suffixAsFile.equals(fileType)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private final void createDelegate() {
            if (this._delegate != null) {
                return;
            }
            this._delegate = (CompareMethod)Util.createInstance((MetaClass)this._metaClass, CompareMethod.class);
            if (this._delegate == null) {
                this._delegate = new CompareMethod(){

                    @Override
                    public boolean canCompare(CompareContributor left, CompareContributor right, StreamType streamType) {
                        return false;
                    }

                    @Override
                    public CompareType getCompareType() {
                        return MetaClassCompareMethod.this._compareType;
                    }
                };
            }
        }
    }
}

