/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.jdevimpl.audit.core.Converters;

public class Cache {
    public static final String PREFIX = "audit.";

    public static void put(String key, Object value) {
        if (key == null) {
            return;
        }
        Ide.getDTCache().putData(PREFIX + key, (List)new Wrapper(value));
    }

    public static void put(String key, boolean value) {
        if (key == null) {
            return;
        }
        Ide.getDTCache().putBoolean(PREFIX + key, value);
    }

    public static void put(String key, Boolean value) {
        if (key == null) {
            return;
        }
        Ide.getDTCache().putBoolean(PREFIX + key, value);
    }

    public static void put(String key, int value) {
        if (key == null) {
            return;
        }
        Ide.getDTCache().putInteger(PREFIX + key, value);
    }

    public static void put(String key, Integer value) {
        if (key == null) {
            return;
        }
        Ide.getDTCache().putInteger(PREFIX + key, value);
    }

    public static void put(String key, float value) {
        if (key == null) {
            return;
        }
        Cache.put(key, Float.valueOf(value));
    }

    public static void put(String key, Float value) {
        if (key == null) {
            return;
        }
        Cache.put(key, (Object)value);
    }

    public static Object get(String key) {
        if (key == null) {
            return null;
        }
        Object value = Ide.getDTCache().getData(PREFIX + key);
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).get(0);
        }
        return value;
    }

    public static Object get(String key, Object defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Object value = Cache.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean get(String key, boolean defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Boolean value = (Boolean)Cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int get(String key, int defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Number value = (Number)Cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.intValue();
    }

    public static float get(String key, float defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Number value = (Number)Cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.floatValue();
    }

    public static class Wrapper
    extends ArrayList<Object> {
        public Wrapper() {
            super(1);
        }

        public Wrapper(Object value) {
            this();
            this.add(value);
        }

        static {
            Converters.register();
        }
    }
}

