/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ide.log.LogManager;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.transform.TransformerException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdevimpl.audit.report.ReportBundle;
import oracle.jdevimpl.audit.report.StyleSheet;
import oracle.jdevimpl.audit.report.StyleSheetRepository;
import oracle.jdevimpl.audit.report.XmlReporter;
import oracle.jdevimpl.audit.report.XsltReporter;
import oracle.jdevimpl.audit.swing.DialogFactory;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.swing.Resources;
import oracle.jdevimpl.audit.util.Cache;
import oracle.jdevimpl.audit.util.Strings;

public class XmlReportDialog {
    private final AuditModel model;
    private final XmlReporter xmlReporter;
    private final String dialogTitle;
    private final String reportDescription;
    private final String modelDescription;
    private final String helpTopic;
    private final Context ideContext;
    private static final String DEFAULT_OUTPUT_SUFFIX = ".xml";

    public XmlReportDialog(AuditModel model, XmlReporter xmlReporter, String dialogTitle, String reportDescription, String modelDescription, String helpTopic, Context ideContext) {
        this.model = model;
        this.xmlReporter = xmlReporter;
        this.modelDescription = modelDescription;
        this.reportDescription = reportDescription;
        this.dialogTitle = dialogTitle;
        this.helpTopic = helpTopic;
        this.ideContext = ideContext;
    }

    public void show() {
        JComboBox<StyleSheet> styleSheetSelector;
        JCheckBox applyCheckBox;
        String LAST_STYLE_SHEET_KEY = "report.style.sheet";
        String LAST_DIRECTORY_KEY = "report.directory";
        StyleSheetRepository repository = new StyleSheetRepository();
        List<StyleSheet> styleSheets = repository.getStyleSheets();
        StyleSheet lastStyleSheet = null;
        styleSheets.sort(new StyleSheetComparator());
        LinkedHashMap<String, URLFilter> filters = new LinkedHashMap<String, URLFilter>();
        filters.put(DEFAULT_OUTPUT_SUFFIX, (URLFilter)new DefaultURLFilter(ReportBundle.get("chooser.filter.xml.label"), DEFAULT_OUTPUT_SUFFIX));
        if (!styleSheets.isEmpty()) {
            lastStyleSheet = repository.getStyleSheet((String)Cache.get(LAST_STYLE_SHEET_KEY));
            filters.put(".html", (URLFilter)new DefaultURLFilter(ReportBundle.get("chooser.filter.html.label"), ".html"));
            filters.put(".txt", (URLFilter)new DefaultURLFilter(ReportBundle.get("chooser.filter.text.label"), ".txt"));
            for (StyleSheet sheet : styleSheets) {
                String suffix = sheet.getOutputSuffix();
                if (filters.containsKey(suffix)) continue;
                filters.put(suffix, (URLFilter)new DefaultURLFilter(ReportBundle.format("chooser.filter.other.label", suffix), suffix));
            }
        }
        filters.put((String)null, (URLFilter)new DefaultURLFilter(ReportBundle.get("chooser.filter.all.label")));
        URL lastDirectory = (URL)Cache.get(LAST_DIRECTORY_KEY);
        if (lastDirectory == null) {
            Project node = this.ideContext.getProject();
            if (node == null) {
                node = this.ideContext.getWorkspace();
            }
            lastDirectory = node == null ? Ide.getWorkspaces().getWorkDirectory() : URLFileSystem.getParent((URL)node.getURL());
        }
        String outputSuffix = lastStyleSheet != null ? lastStyleSheet.getOutputSuffix() : DEFAULT_OUTPUT_SUFFIX;
        int dot = this.modelDescription.lastIndexOf(46);
        String defaultFileName = (dot >= 0 ? this.modelDescription.substring(0, dot) : this.modelDescription).replace(' ', '_') + outputSuffix;
        URL file = URLFactory.newURL((URL)lastDirectory, (String)defaultFileName);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        JTextField titleField = new JTextField(this.reportDescription);
        panel.add((Component)Resources.labelFor(titleField, ReportBundle.get("title.label")), constraints);
        ++constraints.gridy;
        constraints.insets.top = 6;
        constraints.fill = 2;
        panel.add((Component)titleField, constraints);
        constraints.fill = 0;
        ++constraints.gridy;
        if (!styleSheets.isEmpty()) {
            applyCheckBox = Resources.checkBox(ReportBundle.get("apply-style-sheet.label"), lastStyleSheet != null);
            constraints.insets.top = 16;
            constraints.weightx = 1.0;
            panel.add((Component)applyCheckBox, constraints);
            ++constraints.gridy;
            styleSheetSelector = new JComboBox<StyleSheet>(styleSheets.toArray(new StyleSheet[styleSheets.size()]));
            styleSheetSelector.setRenderer(new StyleSheetRenderer());
            styleSheetSelector.setEnabled(lastStyleSheet != null);
            styleSheetSelector.setSelectedItem(lastStyleSheet != null ? lastStyleSheet : styleSheets.get(0));
            constraints.insets.top = 6;
            constraints.insets.left = 16;
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            panel.add((Component)Resources.labelFor(styleSheetSelector, ReportBundle.get("style-sheet.label")), constraints);
            constraints.gridx = 1;
            constraints.insets.left = 8;
            constraints.weightx = 1.0;
            panel.add(styleSheetSelector, constraints);
            constraints.insets.left = 0;
            constraints.gridx = 0;
            constraints.gridwidth = 3;
            ++constraints.gridy;
        } else {
            applyCheckBox = null;
            styleSheetSelector = null;
        }
        final URLField fileField = new URLField(this.ideContext, file, 32, filters);
        constraints.insets.top = 16;
        panel.add((Component)Resources.labelFor((Component)((Object)fileField), ReportBundle.get("output-file.label")), constraints);
        ++constraints.gridy;
        constraints.insets.top = 6;
        constraints.fill = 2;
        panel.add((Component)((Object)fileField), constraints);
        constraints.fill = 0;
        ++constraints.gridy;
        JButton browse = Resources.button(ReportBundle.get("browse.label"));
        browse.addActionListener((ActionListener)((Object)fileField));
        constraints.anchor = 13;
        panel.add((Component)browse, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.weighty = 1.0;
        panel.add(Box.createVerticalGlue(), constraints);
        DialogFactory dialog = new DialogFactory();
        dialog.setMinimumSize(new Dimension(500, 0));
        dialog.setMinimumSizeTracksPreferredSize(true);
        dialog.setTitle(this.dialogTitle);
        dialog.setContent(panel);
        dialog.addCancelButton(null);
        final JButton ok = dialog.addOkButton(null);
        dialog.setHelpTopic(this.helpTopic);
        if (applyCheckBox != null) {
            applyCheckBox.addActionListener(e -> {
                boolean applyStyleSheet = applyCheckBox.isSelected();
                StyleSheet styleSheet = (StyleSheet)styleSheetSelector.getSelectedItem();
                styleSheetSelector.setEnabled(applyStyleSheet);
                this.resetOutputSuffix(applyStyleSheet, styleSheet, fileField);
            });
            styleSheetSelector.addActionListener(e -> {
                boolean applyStyleSheet = applyCheckBox.isSelected();
                StyleSheet styleSheet = (StyleSheet)styleSheetSelector.getSelectedItem();
                styleSheetSelector.setEnabled(applyStyleSheet);
                this.resetOutputSuffix(applyStyleSheet, styleSheet, fileField);
            });
        }
        fileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ok.setEnabled(fileField.getURL() != null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(null);
            }
        });
        JButton result = dialog.show();
        if (result == ok) {
            String title = titleField.getText();
            StyleSheet styleSheet = null;
            if (applyCheckBox != null && applyCheckBox.isSelected()) {
                styleSheet = (StyleSheet)styleSheetSelector.getSelectedItem();
            }
            if (URLFileSystem.getSuffix((URL)(file = fileField.getURL())).isEmpty()) {
                file = URLFileSystem.ensureSuffix((URL)file, (String)(styleSheet != null ? styleSheet.getOutputSuffix() : DEFAULT_OUTPUT_SUFFIX));
            }
            String path = URLFileSystem.getPlatformPathName((URL)file);
            try {
                if (styleSheet != null) {
                    reporter = new XsltReporter();
                    ((XsltReporter)reporter).setModel(this.model);
                    ((XsltReporter)reporter).setStyleSheet(styleSheet);
                    ((XsltReporter)reporter).setTitle(title);
                    ((XsltReporter)reporter).setXmlReporter(this.xmlReporter);
                    ((XsltReporter)reporter).setOutputFile(file);
                    ((XsltReporter)reporter).report();
                } else {
                    reporter = this.xmlReporter;
                    ((XmlReporter)reporter).setModel(this.model);
                    ((XmlReporter)reporter).setTitle(title);
                    ((XmlReporter)reporter).setOutputFile(file);
                    ((XmlReporter)reporter).report();
                }
                Cache.put(LAST_STYLE_SHEET_KEY, styleSheet != null ? styleSheet.getName() : null);
                Cache.put(LAST_DIRECTORY_KEY, URLFileSystem.getParent((URL)file));
                String message = ReportBundle.format("completed.message", title, path);
                LogManager.getLogManager().getMsgPage().log((Object)message);
            }
            catch (InvocationTargetException e2) {
                this.showException(e2.getCause(), path, styleSheet != null ? styleSheet.getName() : null);
            }
        }
    }

    private void showException(Throwable cause, String path, String styleSheetName) {
        Log.error((String)"exception exporting \"{0}\": {1}", (Object)path, (Object)cause);
        MessageDialog message = new MessageDialog(MessageDialog.ERROR);
        if (styleSheetName != null && cause instanceof TransformerException) {
            message.setTitle(ReportBundle.get("transformer-exception.title"));
            message.setContent(Strings.toString(ReportBundle.get("transformer-exception.message"), path, styleSheetName, ((TransformerException)cause).getMessageAndLocation()));
        } else {
            message.setTitle(ReportBundle.get("exception.title"));
            message.setContent(Strings.toString(ReportBundle.get("exception.message"), path, cause));
        }
        message.show();
    }

    private void resetOutputSuffix(boolean apply, StyleSheet styleSheet, URLField fileField) {
        String oldSuffix;
        String newSuffix = DEFAULT_OUTPUT_SUFFIX;
        if (apply) {
            newSuffix = styleSheet.getOutputSuffix();
        }
        fileField.setOutputSuffix(newSuffix);
        URL url = fileField.getURL();
        if (url != null && !newSuffix.equals(oldSuffix = URLFileSystem.getSuffix((URL)url))) {
            fileField.setURL(URLFileSystem.convertSuffix((URL)url, (String)oldSuffix, (String)newSuffix));
        }
    }

    private static class StyleSheetComparator
    implements Comparator<StyleSheet> {
        private StyleSheetComparator() {
        }

        @Override
        public int compare(StyleSheet o1, StyleSheet o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class StyleSheetRenderer
    extends DefaultListCellRenderer {
        private StyleSheetRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof StyleSheet) {
                StyleSheet styleSheet = (StyleSheet)value;
                Object itemName = styleSheet.getName();
                String outputSuffix = styleSheet.getOutputSuffix();
                if (outputSuffix != null) {
                    itemName = (String)itemName + " (" + outputSuffix + ")";
                }
                value = itemName;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class URLField
    extends URLTextField {
        private final Context context;
        private final Map<String, URLFilter> filters;
        private String outputSuffix;

        public URLField(Context context, URL url, int columns, Map<String, URLFilter> filters) {
            super(url, false);
            this.setColumns(columns);
            this.context = context;
            this.filters = filters;
            this.outputSuffix = URLFileSystem.getSuffix((URL)url);
        }

        public void setOutputSuffix(String suffix) {
            this.outputSuffix = suffix;
        }

        public boolean browseForURL() {
            URL url = this.getURL();
            String filterSuffix = null;
            String oldSuffix = url == null ? null : URLFileSystem.getSuffix((URL)url);
            URLFilter filter = this.filters.get(this.outputSuffix);
            if (filter != null) {
                filterSuffix = this.outputSuffix;
            } else {
                filter = this.filters.get(null);
            }
            if (oldSuffix != null && oldSuffix.equals(filterSuffix)) {
                url = URLFileSystem.convertSuffix((URL)url, (String)oldSuffix, (String)"");
            }
            URLChooser chooser = DialogUtil.newURLChooser((Context)this.context, (URL)url);
            chooser.clearChooseableURLFilters();
            for (URLFilter urlFilter : this.filters.values()) {
                chooser.addChooseableURLFilter(urlFilter);
            }
            chooser.setURLFilter(filter);
            chooser.setSelectionMode(0);
            chooser.setSelectionScope(0);
            int response = chooser.showSaveDialog((Component)((Object)this), ReportBundle.get("chooser.title"));
            if (response != 0) {
                return false;
            }
            url = chooser.getSelectedURL();
            if (URLFileSystem.getSuffix((URL)url).isEmpty()) {
                filter = chooser.getSelectedFilter();
                String newSuffix = XmlReportDialog.DEFAULT_OUTPUT_SUFFIX;
                for (Map.Entry<String, URLFilter> entry : this.filters.entrySet()) {
                    if (filter != entry.getValue()) continue;
                    newSuffix = entry.getKey();
                    break;
                }
                url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)newSuffix);
            }
            this.setURL(url);
            return true;
        }
    }
}

