/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelListener;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.core.DefaultAuditModel;
import oracle.jdevimpl.audit.log.AuditLogPanel;
import oracle.jdevimpl.audit.log.AuditTreeTable;

public class AuditLogPage
extends AbstractLogPage
implements AuditModelListener {
    private static final Log LOG = new Log("log");
    private Auditor auditor;
    private AuditModel model;
    private NodeListener nodeListener = new AuditLogNodeListener();
    private List<Node> attachedNodes = new ArrayList<Node>();
    private AuditLogPanel component;
    private String label;
    private volatile boolean closing;
    private Context context;
    private boolean logPageForced;
    private static final Map<String, AuditLogPage> auditPages = new HashMap<String, AuditLogPage>();
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private long start;
    private ModelAdapter lastModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuditLogPage auditLogPage(Context context, Auditor auditor, AuditModel model, String label) {
        AuditLogPage page;
        if (auditor == null || model == null) {
            throw new NullPointerException();
        }
        if (auditor.isAuditing()) {
            throw new IllegalStateException();
        }
        Map<String, AuditLogPage> map = auditPages;
        synchronized (map) {
            Icon icon = OracleIcons.getIcon((String)"audit.png");
            page = new AuditLogPage(context, auditor, model, label, icon);
            LOG.trace("created log page {0}", (Object)page);
            auditPages.put(label, page);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuditModel runShow(final Context context, final Auditor auditor, String label, final Thread.UncaughtExceptionHandler handler) {
        boolean reset;
        AuditModel model;
        AuditLogPage page;
        if (auditor == null) {
            throw new NullPointerException();
        }
        if (auditor.isAuditing()) {
            throw new IllegalStateException();
        }
        Map<String, AuditLogPage> map = auditPages;
        synchronized (map) {
            AuditLogPage existingPage = auditPages.get(label);
            if (existingPage != null && !existingPage.auditor.isAuditing()) {
                page = existingPage;
                LOG.trace("reusing log page {0}", (Object)page);
                model = page.model;
                reset = true;
            } else {
                if (existingPage != null) {
                    existingPage.auditor.cancel();
                }
                Icon icon = OracleIcons.getIcon((String)"audit.png");
                model = new DefaultAuditModel();
                auditor.addAuditListener(model);
                page = new AuditLogPage(context, auditor, model, label, icon);
                LOG.trace("created log page {0}", (Object)page);
                auditPages.put(label, page);
                reset = false;
            }
        }
        Runnable launcher = new Runnable(){

            @Override
            public void run() {
                if (reset) {
                    page.reset(context, auditor);
                }
                page.show();
                auditor.runAsynchronously(handler);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            launcher.run();
        } else {
            SwingUtilities.invokeLater(launcher);
        }
        return model;
    }

    private AuditLogPage(Context context, Auditor auditor, AuditModel model, String label, Icon icon) {
        super(new ViewId(BUNDLE.get("audit.tab.label"), label), icon, false);
        this.auditor = auditor;
        this.context = context;
        this.model = model;
        this.label = label;
        model.addAuditModelListener(this);
    }

    private void reset(Context context, Auditor newAuditor) {
        LOG.trace("setting auditor on {0} to {1}", (Object)this, (Object)newAuditor);
        for (Node node : this.attachedNodes) {
            node.removeNodeListener(this.nodeListener);
        }
        if (this.component != null) {
            this.component.reset(newAuditor);
        }
        this.auditor = newAuditor;
        this.lastModel = null;
        this.logPageForced = false;
        newAuditor.addAuditListener(this.model);
        this.context = context;
    }

    public void show() {
        boolean pageNeedFocus = true;
        LogManager manager = LogManager.getLogManager();
        LogPage[] currentPages = manager.getPages();
        if (currentPages != null) {
            for (int index = 0; index < currentPages.length; ++index) {
                if (currentPages[index] != this) continue;
                pageNeedFocus = false;
                break;
            }
        }
        if (!this.logPageForced) {
            this.logPageForced = true;
            if (!manager.isLogVisible()) {
                manager.showLog();
            }
        }
        super.show();
        if (pageNeedFocus) {
            GraphicsUtils.focusComponentOrChild((Component)this.getGUI(), (boolean)true);
        }
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public AuditModel getModel() {
        return this.model;
    }

    public static boolean isReady(String label) {
        AuditLogPage page = auditPages.get(label);
        return page == null || !page.auditor.isAuditing();
    }

    public String getToolTip() {
        return BUNDLE.get("audit.tab.summary", new Object[]{this.label});
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(BUNDLE.get("audit.tab.help"));
    }

    public Component getTopComponent() {
        return this.component.getTopComponent();
    }

    public Toolbar getToolbar() {
        return this.component.getToolBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void auditStarted(AuditModel model, List<Metric> columns, List<Location> locations, Object root, Class type) {
        Node node;
        Project project;
        if (this.closing) {
            return;
        }
        this.start = System.currentTimeMillis();
        for (Node node2 : this.attachedNodes) {
            node2.removeNodeListener(this.nodeListener);
        }
        this.attachedNodes.clear();
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("locations empty");
        }
        ModelAdapter rootModel = model.getLocation(root).getModel();
        Workspace workspace = rootModel.getWorkspace();
        if (workspace != null) {
            workspace.addNodeListener(this.nodeListener);
            this.attachedNodes.add((Node)workspace);
        }
        if ((project = rootModel.getProject()) != null) {
            project.addNodeListener(this.nodeListener);
            this.attachedNodes.add((Node)project);
        }
        if ((node = rootModel.getNode()) != null) {
            node.addNodeListener(this.nodeListener);
            this.attachedNodes.add(node);
        }
        LOG.trace("updater started on {0}", locations);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < locations.size(); ++i) {
            Location location = locations.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            ModelAdapter adapter = location.getModel();
            boolean locked = false;
            try {
                adapter.beginRead();
                locked = true;
                buffer.append(adapter.getLabel(location));
            }
            catch (ModelAccessError e) {
                buffer.append(e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                if (locked) {
                    adapter.endRead();
                }
            }
            if (i != 0) continue;
            Object text = locations.size() > 1 ? buffer + "..." : buffer.toString();
            Ide.getStatusBar().setText((String)text);
        }
        buffer.append('\n');
        LogManager.getLogManager().getMsgPage().log((Object)BUNDLE.get("audit.status.started", new Object[]{buffer}));
        this.show();
        this.lastModel = null;
        this.getComponent().auditStarted(model, columns, root);
    }

    @Override
    public void auditStopped(AuditModel model, boolean cancelled) {
        if (this.closing) {
            return;
        }
        if (this.component != null) {
            this.component.auditStopped(model, cancelled);
        }
        this.lastModel = null;
        if (cancelled) {
            LOG.trace("updater cancelled");
            String text = BUNDLE.get("audit.status.cancelled");
            Ide.getStatusBar().setText(text);
            LogManager.getLogManager().getMsgPage().log((Object)(text + "\n"));
        } else {
            LOG.trace("updater stopped");
            this.show();
            Object root = model.getRoot();
            String p1 = this.count("issues", model.getCount(root, AuditModel.Count.ISSUES));
            String p3 = this.count("documents", model.getCount(root, AuditModel.Count.FILES));
            String p4 = this.count("seconds", (int)((System.currentTimeMillis() - this.start) / 1000L));
            String message = BUNDLE.get("status.completed.detail", new Object[]{BUNDLE.get("audit.status.completed"), p1, p3, p4});
            Ide.getStatusBar().setText(BUNDLE.get("audit.status.completed"));
            LogManager.getLogManager().getMsgPage().log((Object)(message + "\n"));
        }
    }

    @Override
    public void rowsInserted(AuditModel model, List<?> rows, Object parent, int index) {
        ModelAdapter thisModel = model.getLocation(rows.get(0)).getModel();
        if (thisModel != this.lastModel && !this.closing) {
            LOG.trace("updater started document");
            this.lastModel = thisModel;
            String text = BUNDLE.get("audit.status.auditing", new Object[]{this.lastModel.getShortLabel()});
            Ide.getStatusBar().setText(text);
        }
    }

    @Override
    public void rowsRemoved(AuditModel model, List<?> rows, Object parent, int index) {
    }

    @Override
    public void rowsShown(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
    }

    @Override
    public void rowsHidden(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
    }

    @Override
    public void rowsRestructureBegin(AuditModel model, Object parent, Object visibleParent) {
    }

    @Override
    public void rowsRestructureEnd(AuditModel model, Object parent, Object visibleParent) {
    }

    @Override
    public void countChanged(AuditModel model, Object row, AuditModel.Count count, int oldValue, int newValue) {
    }

    @Override
    public void valueChanged(AuditModel model, Object row, int column, Object oldValue, Object newValue) {
    }

    @Override
    public void modelResorted(AuditModel model) {
    }

    @Override
    public void appliedTransformsChanged(AuditModel model, Object row, List<Transform> appliedTransforms) {
    }

    private String count(String prefix, int count) {
        return BUNDLE.get(switch (count) {
            case 0 -> prefix + "-0";
            case 1 -> prefix + "-1";
            default -> prefix + "-n";
        }, new Object[]{count});
    }

    private AuditLogPanel getComponent() {
        if (this.component == null) {
            LOG.trace("creating log page UI for {0}", (Object)this);
            this.component = new AuditLogPanel(this.auditor, this.model, (View)this, this.label);
        }
        return this.component;
    }

    public Component getGUI() {
        return this.getComponent();
    }

    public Context getContext(EventObject event) {
        Workspace workspace = this.context.getWorkspace();
        Project project = this.context.getProject();
        Element[] selection = this.context.getSelection();
        Context newContext = new Context(workspace, project);
        newContext.setSelection(selection);
        newContext.setView((View)this);
        return newContext;
    }

    public void clearAll() {
        if (this.component != null) {
            this.component.clear();
        }
    }

    protected void logMsg(Object message) {
    }

    public Controller getController() {
        return this.getComponent();
    }

    public ContextMenu getContextMenu() {
        return LogManager.getLogManager().getContextMenu();
    }

    public void addMouseListener(MouseListener listener) {
        LOG.trace("adding mouse listener to {0}: {1}", (Object)this, (Object)listener);
        this.getComponent().addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.closing = true;
        if (this.component != null) {
            this.component.removeMouseListener(listener);
        }
        LOG.trace("removing mouse listener from {0}", (Object)this);
        this.model.removeAuditModelListener(this);
        boolean running = this.auditor.cancel();
        auditPages.remove(this.label);
        if (running) {
            String text = BUNDLE.get("audit.status.cancelled");
            Ide.getStatusBar().setText(text);
            LogManager.getLogManager().getMsgPage().log((Object)(text + "\n"));
        }
    }

    public String toString() {
        return this.getToolTip() + "#" + System.identityHashCode(this);
    }

    public AuditTreeTable getTable() {
        return this.component.getTable();
    }

    private class AuditLogNodeListener
    extends NodeListener
    implements Runnable {
        private AuditLogNodeListener() {
        }

        public void nodeWillClose(NodeEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            LogManager.getLogManager().removePage((LogPage)AuditLogPage.this);
        }
    }
}

