/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.controller.CommandExecutionTracker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.ArraySortedSet;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.Tuple;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.SuppressionSchemeDefinition;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.DefaultTransformsAction;
import oracle.jdeveloper.audit.service.HasSuppressionName;
import oracle.jdeveloper.audit.service.Iteration;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdeveloper.audit.service.TransformAction;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.TransformerListener;
import oracle.jdeveloper.audit.service.TransformerQueryInterceptor;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.CompositeTransform;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.TransformFailedException;
import oracle.jdeveloper.audit.transform.TransformSequenceContext;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.util.Beans;

public class DefaultTransformer
implements Transformer {
    private final AuditELContext expressionContext = new AuditELContext();
    private boolean queryAllowed = true;
    private Map<Transform, TransformerQueryInterceptor> interceptors;
    private final Map<Tuple<ModelAdapter, TransformAdapter>, Boolean> transformable = new HashMap<Tuple<ModelAdapter, TransformAdapter>, Boolean>();
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private static final TransformContext[] NO_TRANSFORMS = new TransformContext[0];
    private static final Log LOG = new Log("transformer");
    private final Map<String, Method> mostSpecificMethods = new HashMap<String, Method>();
    private final Map<Class<?>, Method[]> allMethods = new HashMap();

    @Override
    public void setQueryAllowed(boolean queryAllowed) {
        LOG.trace("query allowed {0}", queryAllowed);
        this.queryAllowed = queryAllowed;
    }

    @Override
    public void setQueryInterceptor(Transform transform, TransformerQueryInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new HashMap<Transform, TransformerQueryInterceptor>();
        }
        this.interceptors.put(transform, interceptor);
    }

    private List<Violation> getViolationsWithDefaultTransforms(AuditModel model, Object[] objects) {
        final ArrayList<Violation> violations = new ArrayList<Violation>();
        for (Object object : objects) {
            if (object == null) continue;
            model.iterateViolations(object, new Iteration(){

                @Override
                public boolean iteration(Object object) {
                    Violation violation = (Violation)object;
                    if (violation.getDefaultTransform() != null) {
                        violations.add(violation);
                    }
                    return true;
                }
            });
        }
        return violations;
    }

    private TransformContext[] createContexts(Transform transform, Violation violation) {
        TransformContext[] contexts;
        Map<String, DeferredSetter> setters = transform.setters();
        if (setters != null && !setters.isEmpty()) {
            this.expressionContext.setBean(transform, violation.getRule(), violation);
            for (Map.Entry entry : setters.entrySet()) {
                DeferredSetter setter = (DeferredSetter)entry.getValue();
                try {
                    setter.set(transform, this.expressionContext);
                }
                catch (Throwable e) {
                    setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform, setter.getText(), e);
                    return NO_TRANSFORMS;
                }
            }
            this.expressionContext.clear();
        }
        if (transform instanceof CompositeTransform) {
            for (Transform transform2 : ((CompositeTransform)transform).getComponents()) {
                setters = transform2.setters();
                if (setters == null || setters.isEmpty()) continue;
                this.expressionContext.setBean(transform2, violation.getRule(), violation);
                for (Map.Entry<String, DeferredSetter> entry : setters.entrySet()) {
                    DeferredSetter setter = entry.getValue();
                    try {
                        setter.set(transform2, this.expressionContext);
                    }
                    catch (Throwable e) {
                        setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform2, setter.getText(), e);
                        return NO_TRANSFORMS;
                    }
                }
                this.expressionContext.clear();
            }
        }
        try {
            contexts = transform.createContexts(violation);
            if (contexts == null || contexts.length == 0) {
                LOG.trace("transform {0} returned no contexts for {1}", (Object)transform, (Object)violation);
                contexts = NO_TRANSFORMS;
            } else if (contexts[0].getModel() == null) {
                LOG.trace("transform {0} returned first context {1} with null model for {2}", (Object)transform, (Object)contexts[0], (Object)violation);
                contexts = NO_TRANSFORMS;
            }
        }
        catch (Exception exception) {
            LOG.trace("transform {0} failed to create contexts for {1}: {2}", (Object)transform, (Object)violation, (Object)exception, (Object)"unused");
            contexts = NO_TRANSFORMS;
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isApplicable(TransformContext[] contexts) {
        if (contexts.length == 0) {
            return false;
        }
        Sequencer sequencer = new Sequencer();
        HashMap<ModelAdapter, Integer> dependencies = new HashMap<ModelAdapter, Integer>();
        Method[][] contextMethods = new Method[contexts.length][];
        Object[] contextConstructs = new Object[contexts.length];
        try {
            boolean bl = this.isApplicable(sequencer, this.transformable, contexts, dependencies, contextMethods, contextConstructs);
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        catch (ModelAccessError e) {
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            AuditLogger.error(e, "exception caught while evaluating transform {0}: {1}", contexts[0].getTransform(), e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                sequencer.maybeTransition(null);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean isApplicable(Sequencer sequencer, Map<Tuple<ModelAdapter, TransformAdapter>, Boolean> transformable, TransformContext[] contexts, Map<ModelAdapter, Integer> dependencies, Method[][] contextMethods, Object[] contextConstructs) throws InterruptedException, IllegalAccessException, InvocationTargetException {
        HashSet<URL> createdMovedLocations = new HashSet<URL>();
        HashSet<URL> deletedLocations = new HashSet<URL>();
        for (int k = 0; k < contexts.length; ++k) {
            TransformContext context = contexts[k];
            TransformAdapter adapter = context.getAdapter();
            TransformContext.Shape shape = context.getShape();
            Location location = context.getLocation();
            ModelAdapter model = context.getModel();
            URL pendingLocation = context.getPendingLocation();
            if (location != null) {
                if (deletedLocations.contains(model.getUrl())) {
                    LOG.trace("skip {0} because predecessor context deletes location", (Object)context);
                    return false;
                }
                if (pendingLocation != null) {
                    assert (shape == TransformContext.Shape.CREATE || shape == TransformContext.Shape.MOVE);
                    if (createdMovedLocations.contains(pendingLocation)) {
                        LOG.trace("skip {0} because predecessor context creates pending location", (Object)context);
                        return false;
                    }
                    if (URLFileSystem.exists((URL)pendingLocation)) {
                        LOG.trace("skip {0} because pending location exists", (Object)context);
                        return false;
                    }
                    if (!URLFileSystem.canCreate((URL)pendingLocation)) {
                        LOG.trace("skip {0} because pending location not creatable", (Object)context);
                        return false;
                    }
                    createdMovedLocations.add(pendingLocation);
                } else if (context.getShape() == TransformContext.Shape.DELETE) {
                    deletedLocations.add(model.getUrl());
                }
                sequencer.maybeTransition(model);
                if (!transformable.computeIfAbsent((Tuple<ModelAdapter, TransformAdapter>)new Tuple((Object)model, (Object)adapter), b -> adapter.isTransformable(model)).booleanValue()) {
                    LOG.trace("skip {0} because model not transformable", (Object)context);
                    return false;
                }
                if (!context.getAdapter().isTransformable(context.getLocation())) {
                    LOG.trace("skip {0} because location not transformable", (Object)context);
                    return false;
                }
                dependencies.computeIfAbsent(model, i -> this.getVersion(model));
                Object construct = contextConstructs[k] = model.getConstruct(location);
                contextMethods[k] = this.methods(context, construct);
                Method[] methods = contextMethods[k];
                if (methods == null) {
                    LOG.trace("skip {0} because no methods are applicable", (Object)context);
                    return false;
                }
                Method applicableMethod = methods[0];
                if (applicableMethod == null) continue;
                if (!this.invokeBoolean(context.getTransform(), applicableMethod, context, construct)) {
                    LOG.trace("skip {0} because {1} returned false", (Object)context, (Object)applicableMethod);
                    return false;
                }
                LOG.trace("isApplicable: {0} returned true", (Object)applicableMethod);
                continue;
            }
            assert (pendingLocation != null);
            assert (shape == TransformContext.Shape.WRITE);
            if (createdMovedLocations.contains(pendingLocation)) continue;
            LOG.trace("skip {0} because no predecessor context creates pending location", (Object)context);
            return false;
        }
        return true;
    }

    @Override
    public List<TransformAction> createTransformActions(Violation violation, TransformerListener listener, AuditModel model) {
        return this.createTransformActions(Collections.singletonList(violation), listener, model);
    }

    @Override
    public List<TransformAction> createTransformActions(Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        return this.createTransformActions(violations, null, listener, model);
    }

    @Override
    public boolean hasTransforms(Collection<? extends Violation> violations, Profile profile) {
        if (profile == null) {
            AuditManager manager = AuditManager.getAuditManager();
            AuditPreferences preferences = manager.getPreferences();
            ProfileRepository repository = manager.getDefaultProfileRepository();
            profile = repository.getProfile(preferences.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        }
        HashMap<String, ExtensionBean> schemeContext = new HashMap<String, ExtensionBean>();
        ArrayList<SuppressionScheme> schemes = new ArrayList<SuppressionScheme>();
        for (SuppressionSchemeDefinition suppressionSchemeDefinition : AuditHook.getAuditHook().getSuppressionSchemes()) {
            SuppressionScheme scheme;
            if (profile.getDefinition(suppressionSchemeDefinition.getId()) == null || (scheme = (SuppressionScheme)profile.createBean(suppressionSchemeDefinition, false, schemeContext)) == null || !scheme.isEnabled()) continue;
            schemes.add(scheme);
        }
        for (Violation violation : violations) {
            Rule rule = violation.getRule();
            if (rule == null) {
                throw new NullArgumentException("null rule in " + violation.getClass());
            }
            if (!rule.mandatoryError() && !rule.assist() && violation.getSuppressionCount() == 0) {
                ArraySortedSet suppressionNames = new ArraySortedSet();
                Set<String> aliases = AuditHook.getAuditHook().getSuppressionNames(rule.definition());
                if (aliases != null) {
                    suppressionNames.addAll(aliases);
                }
                suppressionNames.add(rule.id());
                for (SuppressionScheme scheme : schemes) {
                    for (Transform transform : scheme.getTransforms()) {
                        ((HasSuppressionName)((Object)transform)).setSuppressionName((String)suppressionNames.first());
                        TransformContext[] contexts = this.createContexts(transform, violation);
                        for (String suppressionName : suppressionNames) {
                            ((HasSuppressionName)((Object)transform)).setSuppressionName(suppressionName);
                            if (!this.isApplicable(contexts)) continue;
                            return true;
                        }
                    }
                }
            }
            for (int i = 0; i < violation.getTransformCount(); ++i) {
                Transform transform = violation.getTransform(i);
                TransformContext[] contexts = this.createContexts(transform, violation);
                if (!this.isApplicable(contexts)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasStandardTransforms(Collection<? extends Violation> violations) {
        for (Violation violation : violations) {
            for (int i = 0; i < violation.getTransformCount(); ++i) {
                Transform transform = violation.getTransform(i);
                TransformContext[] contexts = this.createContexts(transform, violation);
                if (!this.isApplicable(contexts)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSuppressionTransforms(Collection<? extends Violation> violations, Profile profile) {
        if (profile == null) {
            AuditManager manager = AuditManager.getAuditManager();
            AuditPreferences preferences = manager.getPreferences();
            ProfileRepository repository = manager.getDefaultProfileRepository();
            profile = repository.getProfile(preferences.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        }
        HashMap<String, ExtensionBean> schemeContext = new HashMap<String, ExtensionBean>();
        ArrayList<SuppressionScheme> schemes = new ArrayList<SuppressionScheme>();
        for (SuppressionSchemeDefinition suppressionSchemeDefinition : AuditHook.getAuditHook().getSuppressionSchemes()) {
            SuppressionScheme scheme;
            if (profile.getDefinition(suppressionSchemeDefinition.getId()) == null || !(scheme = (SuppressionScheme)profile.createBean(suppressionSchemeDefinition, false, schemeContext)).isEnabled()) continue;
            schemes.add(scheme);
        }
        for (Violation violation : violations) {
            Rule rule = violation.getRule();
            if (rule == null) {
                throw new NullArgumentException("null rule in " + violation.getClass());
            }
            if (rule.mandatoryError() || rule.assist() || violation.getSuppressionCount() != 0) continue;
            ArraySortedSet suppressionNames = new ArraySortedSet();
            Set<String> aliases = AuditHook.getAuditHook().getSuppressionNames(rule.definition());
            if (aliases != null) {
                suppressionNames.addAll(aliases);
            }
            suppressionNames.add(rule.id());
            for (SuppressionScheme scheme : schemes) {
                for (Transform transform : scheme.getTransforms()) {
                    for (String suppressionName : suppressionNames) {
                        ((HasSuppressionName)((Object)transform)).setSuppressionName(suppressionName);
                        TransformContext[] contexts = this.createContexts(transform, violation);
                        if (!this.isApplicable(contexts)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public List<TransformAction> createTransformActions(Collection<? extends Violation> violations, Profile profile, TransformerListener listener, AuditModel model) {
        if (profile == null) {
            AuditManager manager = AuditManager.getAuditManager();
            AuditPreferences preferences = manager.getPreferences();
            ProfileRepository repository = manager.getDefaultProfileRepository();
            profile = repository.getProfile(preferences.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        }
        HashMap<String, ExtensionBean> schemeContext = new HashMap<String, ExtensionBean>();
        ArrayList<SuppressionScheme> schemes = new ArrayList<SuppressionScheme>();
        for (SuppressionSchemeDefinition definition : AuditHook.getAuditHook().getSuppressionSchemes()) {
            SuppressionScheme scheme;
            if (profile.getDefinition(definition.getId()) == null || !(scheme = (SuppressionScheme)profile.createBean(definition, false, schemeContext)).isEnabled()) continue;
            schemes.add(scheme);
        }
        ArrayList<TransformAction> actions = new ArrayList<TransformAction>();
        HashSet<String> labels = new HashSet<String>();
        for (Violation violation : violations) {
            Rule rule = violation.getRule();
            Icon icon = rule.getSeverity().getIcon();
            for (int i = 0; i < violation.getTransformCount(); ++i) {
                String label;
                Transform transform = violation.getTransform(i);
                TransformContext[] contexts = this.createContexts(transform, violation);
                if (contexts.length == 0 || !labels.add(label = transform.boundLabel(contexts[0]))) continue;
                DefaultTransformAction action = new DefaultTransformAction(label, icon, Collections.singletonList(violation), transform, null, listener, model);
                if (!this.isApplicable(contexts)) {
                    action.setEnabled(false);
                    action.putValue("ShortDescription", AuditBundle.get("transform.disabled.tip"));
                }
                actions.add(action);
            }
            if (rule.mandatoryError() || rule.assist() || violation.getSuppressionCount() != 0) continue;
            ArrayList<String> suppressionNames = new ArrayList<String>();
            Set<String> aliases = AuditHook.getAuditHook().getSuppressionNames(rule.definition());
            if (aliases != null) {
                suppressionNames.addAll(aliases);
            }
            suppressionNames.add(rule.id());
            String ruleLabel = rule.label();
            for (SuppressionScheme scheme : schemes) {
                String schemeLabel = scheme.label();
                for (Transform transform : scheme.getTransforms()) {
                    Iterator i = suppressionNames.iterator();
                    while (i.hasNext()) {
                        String label;
                        String suppressionName = (String)i.next();
                        ((HasSuppressionName)((Object)transform)).setSuppressionName(suppressionName);
                        TransformContext[] contexts = this.createContexts(transform, violation);
                        if (contexts.length == 0 || !labels.add(label = i.hasNext() ? BUNDLE.get("transform.suppress.alias.label", new Object[]{ruleLabel, schemeLabel}) : BUNDLE.get("transform.suppress.id.label", new Object[]{ruleLabel, schemeLabel})) || !this.isApplicable(contexts)) continue;
                        ArrayMap properties = new ArrayMap();
                        properties.put("suppressionName", suppressionName);
                        DefaultTransformAction action = new DefaultTransformAction(label, icon, Collections.singletonList(violation), transform, (Map<String, Object>)properties, listener, model);
                        actions.add(action);
                    }
                    ((HasSuppressionName)((Object)transform)).setSuppressionName(null);
                }
            }
        }
        return actions;
    }

    @Override
    public DefaultTransformsAction createDefaultTransformsAction(String label, Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        DefaultTransformAction action = new DefaultTransformAction(label != null ? label : BUNDLE.get("apply-default-fixes.label"), OracleIcons.getIcon((String)"fix.png"), violations, null, null, listener, model);
        action.setEnabled(false);
        for (Violation violation : violations) {
            TransformContext[] contexts;
            boolean applicable;
            Transform transform = violation.getDefaultTransform();
            if (transform == null || !(applicable = this.isApplicable(contexts = this.createContexts(transform, violation)))) continue;
            action.setEnabled(true);
        }
        return action;
    }

    @Override
    public DefaultTransformsAction createDefaultTransformsAction(String label, AuditModel model, Object[] objects, TransformerListener listener) {
        return this.createDefaultTransformsAction(label, this.getViolationsWithDefaultTransforms(model, objects), listener, model);
    }

    @Override
    public Throwable applyDefaultTransforms(String label, Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        DefaultTransformsAction action = this.createDefaultTransformsAction(label, violations, listener, model);
        return action.apply();
    }

    @Override
    public Throwable applyDefaultTransforms(String label, AuditModel model, Object[] objects, TransformerListener listener) {
        List<Violation> violations = this.getViolationsWithDefaultTransforms(model, objects);
        if (violations.isEmpty()) {
            return null;
        }
        return this.applyDefaultTransforms(label, violations, listener, model);
    }

    private Method[] methods(TransformContext context, Object construct) {
        Transform transform = context.getTransform();
        try {
            if (construct == null) {
                LOG.trace("not applicable: construct null");
                return null;
            }
            Class<?> type = construct.getClass();
            Method applyMethod = this.method("apply", transform, context, construct);
            if (applyMethod == null) {
                LOG.trace("not applicable: no apply method in {0}", type);
                return null;
            }
            Method queryRequiredMethod = this.method("isQueryRequired", transform, context, construct);
            Method queryMethod = this.method("query", transform, context, construct);
            if (!this.queryAllowed && queryMethod != null && queryRequiredMethod == null) {
                LOG.trace("not applicable: query required but queries disallowed");
                return null;
            }
            Method applicableMethod = this.method("isApplicable", transform, context, construct);
            return new Method[]{applicableMethod, queryRequiredMethod, queryMethod, applyMethod};
        }
        catch (Throwable e) {
            AuditLogger.error(e, "exception caught while evaluating transform {0}: {1}", transform, e);
            return null;
        }
    }

    private boolean invokeBoolean(Object target, Method method, TransformContext context, Object construct) throws IllegalAccessException, InvocationTargetException {
        return Boolean.TRUE.equals(this.invoke(target, method, context, construct));
    }

    private Object invoke(Object target, Method method, TransformContext context, Object construct) throws IllegalAccessException, InvocationTargetException {
        Object[] arguments = new Object[]{context, construct};
        return method.invoke(target, arguments);
    }

    private Method method(String name, Object transformOrInterceptor, TransformContext context, Object construct) {
        Class<?> transformType = transformOrInterceptor.getClass();
        Class<?> contextType = context.getClass();
        Class<?> constructType = construct.getClass();
        String key = name + transformType.getName() + contextType.getName() + constructType.getName();
        Method mostSpecificMethod = this.mostSpecificMethods.get(key);
        if (mostSpecificMethod != null) {
            return mostSpecificMethod;
        }
        Method[] methods = this.allMethods.computeIfAbsent(transformType, k -> transformType.getMethods());
        ArrayList<Method> maximallySpecificMethods = new ArrayList<Method>();
        for (Method method : methods) {
            Class<?> methodConstructType;
            Class<?> methodContextType;
            if (!name.equals(method.getName())) continue;
            Class<?> returnType = method.getReturnType();
            if ("isApplicable".equals(name) && !Boolean.TYPE.equals(returnType)) {
                AuditLogger.error("Method {0} ignored because return type is not boolean", method);
            } else if ("query".equals(name) && !returnType.equals(Boolean.TYPE)) {
                AuditLogger.error("Method {0} ignored because return type is not boolean", method);
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 2 || !(methodContextType = parameterTypes[0]).isAssignableFrom(contextType) || !(methodConstructType = parameterTypes[1]).isAssignableFrom(constructType)) continue;
            if (maximallySpecificMethods.isEmpty()) {
                maximallySpecificMethods.add(method);
                continue;
            }
            ListIterator<Method> i = maximallySpecificMethods.listIterator();
            while (i.hasNext()) {
                Method maximallySpecificMethod = (Method)i.next();
                Class<?>[] types = maximallySpecificMethod.getParameterTypes();
                boolean contextMoreSpecific = types[0].isAssignableFrom(methodContextType);
                boolean constructMoreSpecific = types[1].isAssignableFrom(methodConstructType);
                if (contextMoreSpecific && constructMoreSpecific) {
                    i.remove();
                    i.add(method);
                    continue;
                }
                if (!contextMoreSpecific && !constructMoreSpecific) continue;
                i.add(method);
            }
        }
        switch (maximallySpecificMethods.size()) {
            case 0: {
                mostSpecificMethod = null;
                break;
            }
            case 1: {
                mostSpecificMethod = (Method)maximallySpecificMethods.iterator().next();
                break;
            }
            default: {
                if (transformOrInterceptor instanceof Transform) {
                    ((Transform)transformOrInterceptor).logError("No {0} method in {1} is unambiguously most specific for {2} - {3}; methods: {4}", name, transformType.getName(), contextType.getName(), constructType.getName(), maximallySpecificMethods);
                } else {
                    ExtensionRegistry.getExtensionRegistry().getManifestLogger().log(Level.WARNING, "No {0} method in {1} is unambiguously most specific for {2} - {3}; methods: {4}", new Object[]{name, transformType.getName(), contextType.getName(), constructType.getName(), maximallySpecificMethods});
                }
                mostSpecificMethod = null;
            }
        }
        this.mostSpecificMethods.put(key, mostSpecificMethod);
        return mostSpecificMethod;
    }

    private Integer getVersion(ModelAdapter model) {
        return model instanceof TextFileModelAdapter ? ((TextFileModelAdapter)model).getTextBuffer().getChangeId() : 0;
    }

    private static class Sequencer {
        private ModelAdapter readModel = null;
        private TransformSequenceContext sequenceContext = null;
        private String label;
        private int applied = 0;

        private Sequencer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean maybeTransition(ModelAdapter newModel) throws InterruptedException {
            ModelAdapter oldModel = this.readModel;
            if (newModel == oldModel) {
                return false;
            }
            try {
                if (this.sequenceContext != null) {
                    assert (oldModel != null);
                    if (this.applied > 0) {
                        LOG.trace("endTransformSequence {0}", (Object)this.sequenceContext);
                        this.sequenceContext.getAdapter().endTransformSequence(this.sequenceContext);
                    } else {
                        LOG.trace("cancelTransformSequence {0}", (Object)this.sequenceContext);
                        this.sequenceContext.getAdapter().cancelTransformSequence(this.sequenceContext);
                    }
                    this.sequenceContext = null;
                }
            }
            catch (InterruptedException | CancellationException e) {
                throw e;
            }
            catch (Throwable e) {
                AuditLogger.error(e, "exception cancelling transform sequence for {0}: {1}", this.label, e);
            }
            finally {
                this.sequenceContext = null;
                if (oldModel != null) {
                    LOG.trace("endRead {0}", (Object)oldModel.getSimpleName());
                    oldModel.endRead();
                }
            }
            if (newModel != null) {
                LOG.trace("beginRead {0}", (Object)newModel.getSimpleName());
                newModel.beginRead();
            }
            this.readModel = newModel;
            return newModel != null;
        }

        void maybeBeginSequence(TransformContext context) throws Exception {
            assert (context.getModel() == this.readModel);
            TransformAdapter adapter = context.getAdapter();
            if (this.sequenceContext == null || this.sequenceContext.getAdapter().getClass() != adapter.getClass()) {
                if (this.sequenceContext != null) {
                    if (this.applied > 0) {
                        LOG.trace("endTransformSequence {0}", (Object)this.sequenceContext);
                        this.sequenceContext.getAdapter().endTransformSequence(this.sequenceContext);
                    } else {
                        LOG.trace("cancelTransformSequence {0}", (Object)this.sequenceContext);
                        this.sequenceContext.getAdapter().cancelTransformSequence(this.sequenceContext);
                    }
                }
                this.sequenceContext = new TransformSequenceContext(adapter, this.readModel);
                this.applied = 0;
                this.label = context.getTransform().label();
                LOG.trace("beginTransformSequence {0}", (Object)this.sequenceContext);
                adapter.beginTransformSequence(this.sequenceContext);
            }
        }

        void transformApplied() {
            ++this.applied;
        }
    }

    private class DefaultTransformAction
    extends DefaultTransformsAction {
        private final Collection<? extends Violation> violations;
        private final Map<String, Object> properties;
        private final AuditModel trackingModel;
        private int applicableTransformCount;
        private Map<String, String> applicableDescriptions;
        private Set<ModelAdapter> applicableDocuments;
        private Set<ModelAdapter> dirtyApplicableDocuments;
        private Map<ModelAdapter, Collection<Violation>> violationsByDocument;
        private Set<Node> addedNodes;
        private Set<ModelAdapter> transformedModels;
        private Set<ModelAdapter> deletedModels;
        private Set<ModelAdapter> movedModels;
        private int appliedTransformCount;

        public DefaultTransformAction(String label, Icon icon, Collection<? extends Violation> violations, Transform transform, Map<String, Object> properties, TransformerListener listener, AuditModel model) {
            super(label, icon, transform);
            this.violations = violations;
            this.properties = properties;
            this.trackingModel = model;
            this.putValue(TransformerListener.class.getName(), listener);
        }

        @Override
        public Throwable apply() {
            IdeMainWindow mainWindow;
            TransformerQueryInterceptor interceptor;
            Transform transform = this.getTransform();
            String label = (String)this.getValue("Name");
            LOG.trace("transform {0}", (Object)transform);
            TransformerListener listener = (TransformerListener)this.getValue(TransformerListener.class.getName());
            if (this.properties != null) {
                for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                    try {
                        Beans.setPropertyValue(transform, entry.getKey(), entry.getValue());
                    }
                    catch (Exception e) {
                        listener.transformFailed(e, this.violations.iterator().next(), transform, label);
                        return e;
                    }
                }
            }
            if ((interceptor = (TransformerQueryInterceptor)this.getValue(TransformerQueryInterceptor.class.getName())) == null && DefaultTransformer.this.interceptors != null) {
                interceptor = DefaultTransformer.this.interceptors.get(transform);
            }
            Throwable exception = this.apply(this.violations, transform, label, listener, interceptor, this.trackingModel);
            if (this.getAppliedTransformCount() == 0 && (mainWindow = Ide.getMainWindow()) != null) {
                mainWindow.getToolkit().beep();
            }
            return exception;
        }

        public void actionPerformed(ActionEvent event) {
            this.apply();
        }

        @Override
        public int getApplicableTransformCount() {
            this.scan(this.violations, this.getTransform());
            return this.applicableTransformCount;
        }

        @Override
        public Collection<String> getTransformDescriptions() {
            this.scan(this.violations, this.getTransform());
            return this.applicableDescriptions.values();
        }

        @Override
        public int getApplicableModelCount() {
            this.scan(this.violations, this.getTransform());
            return this.applicableDocuments.size();
        }

        @Override
        public Collection<ModelAdapter> getApplicableModels() {
            this.scan(this.violations, this.getTransform());
            return Collections.unmodifiableSet(this.applicableDocuments);
        }

        @Override
        public int getAppliedTransformCount() {
            return this.appliedTransformCount;
        }

        @Override
        public int getModifiedModelCount() {
            return this.transformedModels.size() + this.deletedModels.size() + this.addedNodes.size();
        }

        private void scan(Collection<? extends Violation> violations, Transform transform) {
            if (violations == null) {
                throw new IllegalStateException("no violations set");
            }
            if (this.violationsByDocument != null) {
                return;
            }
            this.applicableTransformCount = 0;
            this.applicableDescriptions = new LinkedHashMap<String, String>();
            this.applicableDocuments = new LinkedHashSet<ModelAdapter>();
            this.dirtyApplicableDocuments = new LinkedHashSet<ModelAdapter>();
            this.violationsByDocument = new LinkedHashMap<ModelAdapter, Collection<Violation>>();
            for (Violation violation : violations) {
                TransformContext[] contexts;
                Transform t = transform;
                if (t == null) {
                    t = violation.getDefaultTransform();
                }
                if (t == null || (contexts = DefaultTransformer.this.createContexts(t, violation)).length == 0) continue;
                ++this.applicableTransformCount;
                String name = t.id();
                if (!this.applicableDescriptions.containsKey(name)) {
                    this.applicableDescriptions.put(name, t.boundLabel(contexts[0]));
                }
                ModelAdapter model = contexts[0].getModel();
                assert (model != null);
                Collection documentViolations = this.violationsByDocument.computeIfAbsent(model, k -> new ArrayList());
                documentViolations.add(violation);
                for (TransformContext context : contexts) {
                    Node node;
                    model = context.getModel();
                    if (model == null || (node = model.getNode()) == null) continue;
                    this.applicableDocuments.add(model);
                    if (!node.isDirty()) continue;
                    this.dirtyApplicableDocuments.add(model);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Throwable apply(Collection<? extends Violation> violations, Transform explicitTransform, String label, TransformerListener listener, TransformerQueryInterceptor interceptor, AuditModel trackingModel) {
            this.scan(violations, explicitTransform);
            for (CodeEditor editor : CodeEditor.getVisibleInstances()) {
                BasicEditorPane pane = editor.getFocusedEditorPane();
                if (pane == null) continue;
                pane.invokeAction("cancel");
            }
            CommandProcessor processor = CommandProcessor.getInstance();
            TransformEndCommand endCommand = new TransformEndCommand(trackingModel);
            CommandExecutionTracker.commandExecutionTracker().start(label);
            LOG.trace("beginning batch transaction for {0}", (Object)label);
            processor.beginTrans(label);
            Throwable exception = null;
            try {
                this.addedNodes = new LinkedHashSet<Node>();
                this.transformedModels = new LinkedHashSet<ModelAdapter>();
                this.deletedModels = new LinkedHashSet<ModelAdapter>();
                this.movedModels = new LinkedHashSet<ModelAdapter>();
                this.appliedTransformCount = 0;
                block42: for (Collection<Violation> list : this.violationsByDocument.values()) {
                    if (exception != null) break;
                    Sequencer sequencer = new Sequencer();
                    HashMap<Tuple<ModelAdapter, TransformAdapter>, Boolean> transformable = new HashMap<Tuple<ModelAdapter, TransformAdapter>, Boolean>();
                    try {
                        block43: for (Violation violation : list) {
                            if (exception != null) continue block42;
                            Transform transform = explicitTransform;
                            if (transform == null && (transform = violation.getDefaultTransform()) == null) continue;
                            LOG.trace("begin application of {0}", (Object)transform);
                            TransformContext[] contexts = DefaultTransformer.this.createContexts(transform, violation);
                            if (contexts.length == 0) continue;
                            HashMap<ModelAdapter, Integer> dependencies = new HashMap<ModelAdapter, Integer>();
                            transform.sequenceBegin();
                            try {
                                ModelAdapter model;
                                Location location;
                                Method[][] contextMethods = new Method[contexts.length][];
                                Object[] contextConstructs = new Object[contexts.length];
                                if (!DefaultTransformer.this.isApplicable(sequencer, transformable, contexts, dependencies, contextMethods, contextConstructs)) continue;
                                for (int k = 0; k < contexts.length; ++k) {
                                    Method interceptorQueryMethod;
                                    Method queryMethod;
                                    Method[] methods = contextMethods[k];
                                    if (methods == null || (queryMethod = methods[2]) == null) continue;
                                    TransformContext context = contexts[k];
                                    location = context.getLocation();
                                    model = location.getModel();
                                    Object queryTarget = context.getTransform();
                                    if (interceptor != null && (interceptorQueryMethod = DefaultTransformer.this.method("query", interceptor, context, contextConstructs[k])) != null) {
                                        queryTarget = interceptor;
                                        queryMethod = interceptorQueryMethod;
                                    }
                                    Method queryRequiredMethod = methods[1];
                                    boolean queryRequired = true;
                                    if (queryRequiredMethod != null) {
                                        sequencer.maybeTransition(model);
                                        queryRequired = DefaultTransformer.this.invokeBoolean(context.getTransform(), queryRequiredMethod, context, contextConstructs[k]);
                                        LOG.trace("isQueryRequired: {0} returned {1}", (Object)queryRequiredMethod, (Object)queryRequired);
                                    }
                                    if (!queryRequired) continue;
                                    if (!DefaultTransformer.this.queryAllowed) {
                                        LOG.trace("skip {0} because query required but not allowed", (Object)context);
                                        continue block43;
                                    }
                                    sequencer.maybeTransition(null);
                                    if (!DefaultTransformer.this.invokeBoolean(queryTarget, queryMethod, context, contextConstructs[k])) {
                                        LOG.trace("skip {0} because {1} returned false", (Object)context, (Object)queryMethod);
                                        continue block43;
                                    }
                                    LOG.trace("isQuery: {0} returned true", (Object)queryMethod);
                                }
                                for (Map.Entry entry : dependencies.entrySet()) {
                                    sequencer.maybeTransition((ModelAdapter)entry.getKey());
                                    if (((Integer)entry.getValue()).equals(DefaultTransformer.this.getVersion((ModelAdapter)entry.getKey()))) continue;
                                    LOG.trace("abort {0} because {1} dependency version changed", (Object)transform, entry.getKey());
                                    throw new ModelChangedException((ModelAdapter)entry.getKey());
                                }
                                Object predecessorData = null;
                                block46: for (int k = 0; k < contexts.length; ++k) {
                                    TransformAdapter adapter;
                                    TransformContext context;
                                    block87: {
                                        context = contexts[k];
                                        if (context.getShape() == TransformContext.Shape.WRITE) {
                                            URL pendingLocation = context.getPendingLocation();
                                            if (pendingLocation != null) {
                                                ModelFactory factory = violation.getLocation().getModel().getFactory();
                                                if (!URLFileSystem.exists((URL)pendingLocation)) {
                                                    throw new IllegalStateException("pending location " + pendingLocation + " not created by predecessor context");
                                                }
                                                Node node = NodeFactory.find((URL)pendingLocation);
                                                if (node == null) {
                                                    throw new IllegalStateException("pending node " + pendingLocation + " not created by predecessor context");
                                                }
                                                Collection<ModelAdapter> models = factory.getModelAdapters((Element)node, pendingLocation, context.getProject(), context.getWorkspace());
                                                if (models.isEmpty()) {
                                                    throw new IllegalStateException("failed to create model for new node " + pendingLocation);
                                                }
                                                ModelAdapter model2 = models.iterator().next();
                                                LOG.trace("relocated {0} to {1}", (Object)context, (Object)model2);
                                                context.relocate(model2.getLocation());
                                                sequencer.maybeTransition(model2);
                                                dependencies.put(model2, DefaultTransformer.this.getVersion(model2));
                                            }
                                            TransformAdapter adapter2 = context.getAdapter();
                                            model = context.getModel();
                                            sequencer.maybeTransition(model);
                                            LOG.trace("invoking makeTransformable for {0}", (Object)context);
                                            Boolean writable = adapter2.makeTransformable(context);
                                            if (writable != null) {
                                                Integer dependency;
                                                if (!writable.booleanValue()) {
                                                    LOG.trace("skip {0} because makeTransformable failed", (Object)context);
                                                    continue block43;
                                                }
                                                if (listener != null) {
                                                    listener.modelWritable(model);
                                                }
                                                if (!(dependency = DefaultTransformer.this.getVersion(model)).equals(dependencies.get(model))) {
                                                    dependencies.put(model, dependency);
                                                    contextConstructs[k] = null;
                                                    for (int j = k + 1; j < contexts.length; ++j) {
                                                        if (contexts[j].getModel() != model) continue;
                                                        contextConstructs[j] = null;
                                                    }
                                                }
                                            }
                                        }
                                        adapter = context.getAdapter();
                                        location = context.getLocation();
                                        model = context.getModel();
                                        sequencer.maybeTransition(model);
                                        if (!DefaultTransformer.this.getVersion(model).equals(dependencies.get(model))) {
                                            LOG.trace("abort {0} because {1} dependency version changed", (Object)transform, (Object)model);
                                            throw new ModelChangedException(model);
                                        }
                                        sequencer.maybeBeginSequence(context);
                                        adapter.beginTransform(context);
                                        Method applyMethod = null;
                                        boolean aborting = false;
                                        try {
                                            Object reevaluation = model.getConstruct(location);
                                            if (reevaluation == null) {
                                                LOG.trace("abort {0} because {1} construct reevaluation failed", (Object)context);
                                                throw new ModelChangedException(model);
                                            }
                                            if (contextConstructs[k] == null || reevaluation.getClass() != contextConstructs[k].getClass()) {
                                                contextConstructs[k] = reevaluation;
                                                contextMethods[k] = DefaultTransformer.this.methods(contexts[k], contextConstructs[k]);
                                                if (contextMethods[k] == null) {
                                                    LOG.trace("abort {0} because {1} method reevaluation", (Object)context);
                                                    throw new ModelChangedException(model);
                                                }
                                            }
                                            adapter.setPredecessorApplyData(context, predecessorData);
                                            if (explicitTransform != null) {
                                                model.edit(location);
                                            }
                                            applyMethod = contextMethods[k][3];
                                            LOG.trace("apply: {0}", (Object)applyMethod);
                                            predecessorData = DefaultTransformer.this.invoke(context.getTransform(), applyMethod, context, contextConstructs[k]);
                                            adapter.endTransform(context);
                                            dependencies.put(model, DefaultTransformer.this.getVersion(model));
                                            if (!aborting) break block87;
                                        }
                                        catch (CancellationException e) {
                                            try {
                                                LOG.trace("{0} cancelled: {1}", applyMethod, (Object)e);
                                                aborting = true;
                                                throw e;
                                                catch (InterruptedException e2) {
                                                    LOG.trace("{0} interrupted: {1}", applyMethod, (Object)e2);
                                                    aborting = true;
                                                    throw e2;
                                                }
                                                catch (Throwable e3) {
                                                    aborting = true;
                                                    Throwable cause = e3.getCause();
                                                    if (cause instanceof CancellationException) {
                                                        LOG.trace("{0} cancelled: {1}", applyMethod, (Object)e3);
                                                        throw cause;
                                                    }
                                                    if (cause instanceof InterruptedException) {
                                                        LOG.trace("{0} interrupted: {1}", applyMethod, (Object)e3);
                                                        throw cause;
                                                    }
                                                    LOG.trace("exception applying {0} to {1}: {2}", (Object)transform, (Object)violation, (Object)e3);
                                                    throw e3;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                if (!aborting) throw throwable;
                                                try {
                                                    adapter.cancelTransform(context);
                                                    throw throwable;
                                                }
                                                catch (Throwable e4) {
                                                    AuditLogger.error(e4, "cancelling {0} failed: {1}", transform, e4);
                                                }
                                                throw throwable;
                                            }
                                        }
                                        try {
                                            adapter.cancelTransform(context);
                                        }
                                        catch (Throwable e) {
                                            AuditLogger.error(e, "cancelling {0} failed: {1}", transform, e);
                                        }
                                    }
                                    for (Command deferredCommand : adapter.getDeferredCommands()) {
                                        sequencer.maybeTransition(null);
                                        LOG.trace("invoking deferred command {0} for {1}", (Object)deferredCommand.getName(), (Object)context);
                                        CommandProcessor.getInstance().invoke(deferredCommand);
                                    }
                                    switch (context.getShape()) {
                                        case READ: {
                                            continue block46;
                                        }
                                        case WRITE: {
                                            if (this.addedNodes.contains(model.getNode())) continue block46;
                                            this.transformedModels.add(model);
                                            continue block46;
                                        }
                                        case MOVE: {
                                            URL movedUrl = context.getInitialLocation();
                                            if (URLFileSystem.exists((URL)movedUrl)) {
                                                throw new IllegalStateException("location not changed " + movedUrl);
                                            }
                                            this.movedModels.add(model);
                                            this.transformedModels.remove(model);
                                        }
                                        case CREATE: {
                                            URL pendingLocation = context.getPendingLocation();
                                            if (URLFileSystem.isRegularFile((URL)pendingLocation)) {
                                                Node node = NodeFactory.findOrCreate((URL)pendingLocation);
                                                if (node == null) {
                                                    throw new IllegalStateException("pending location file created but not node: " + pendingLocation);
                                                }
                                                this.addedNodes.add(node);
                                                LOG.trace("created pending node for {0}", (Object)context);
                                                continue block46;
                                            }
                                            if (!URLFileSystem.isDirectory((URL)pendingLocation)) throw new IllegalStateException("pending location not created: " + pendingLocation);
                                            LOG.trace("created pending directory for {0}", (Object)context);
                                            continue block46;
                                        }
                                        case DELETE: {
                                            URL deletedUrl = context.getInitialLocation();
                                            if (URLFileSystem.exists((URL)deletedUrl)) {
                                                throw new IllegalStateException("location not deleted" + deletedUrl);
                                            }
                                            this.deletedModels.add(model);
                                            this.transformedModels.remove(model);
                                            LOG.trace("deleted file for {0}", (Object)context);
                                            continue block46;
                                        }
                                    }
                                }
                                listener.transformApplied(violation, transform, transform.boundLabel(contexts[0]));
                            }
                            catch (InterruptedException | CancellationException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                if (e instanceof InvocationTargetException && e.getCause() != null) {
                                    e = e.getCause();
                                }
                                if (!(e.getCause() instanceof TransformFailedException)) {
                                    AuditLogger.error(e, "exception applying {0} to {1}: {2}", transform, violation, e);
                                } else {
                                    e = e.getCause();
                                }
                                sequencer.maybeTransition(null);
                                boolean ok = listener != null && listener.transformFailed(e, violation, transform, label);
                                if (ok || exception != null) continue block42;
                                exception = e;
                                continue block42;
                            }
                            finally {
                                transform.sequenceEnd();
                                continue block42;
                            }
                            sequencer.transformApplied();
                            ++this.appliedTransformCount;
                            endCommand.setTransformApplied(transform, violation);
                        }
                    }
                    finally {
                        sequencer.maybeTransition(null);
                    }
                }
                if (exception == null && !this.transformedModels.isEmpty()) {
                    try {
                        endCommand.setContext(this.transformedModels.iterator().next());
                        processor.invoke((Command)endCommand);
                    }
                    catch (Throwable e) {
                        AuditLogger.error(e, "exception invoking transform end command for {0}: {1}", e, label);
                    }
                }
            }
            catch (InterruptedException | CancellationException e) {
                exception = e;
            }
            finally {
                if (exception == null && this.transformedModels.size() + this.deletedModels.size() + this.addedNodes.size() + this.movedModels.size() > 0) {
                    LOG.trace("ending batch transaction for {0}", (Object)label);
                    processor.endTrans();
                } else if (processor.isTransactionActive()) {
                    LOG.trace("aborting batch transaction for {0}", (Object)label);
                    processor.abortTrans();
                } else {
                    LOG.trace("batch transaction for {0} apparently aborted", (Object)label);
                }
                CommandExecutionTracker.commandExecutionTracker().end();
            }
            Collection visibleEditors = CodeEditor.getVisibleInstances();
            for (ModelAdapter model : this.transformedModels) {
                if (this.dirtyApplicableDocuments.contains(model)) continue;
                Node node = model.getNode();
                if (this.applicableDocuments.size() == 1) {
                    CodeEditor editor;
                    boolean visible = false;
                    Iterator violation = visibleEditors.iterator();
                    while (violation.hasNext() && !(visible = (editor = (CodeEditor)violation.next()).getContext().getNode() == node)) {
                    }
                    if (visible) continue;
                }
                try {
                    LOG.trace("saving transformed model {0}", (Object)model);
                    node.save();
                    if (listener == null) continue;
                    listener.modelSaved(model);
                }
                catch (IOException e) {
                    boolean ok = false;
                    if (listener != null) {
                        ok = listener.saveFailed((Throwable)e, model, label);
                    }
                    if (ok || exception != null) continue;
                    exception = e;
                }
            }
            Iterator<ModelAdapter> iterator = this.addedNodes.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                try {
                    LOG.trace("saving added node {0}", (Object)node);
                    node.save();
                    if (listener == null) continue;
                    listener.nodeCreated(node);
                }
                catch (IOException e) {
                    boolean ok = false;
                    if (listener != null) {
                        ok = listener.saveFailed((Throwable)e, node, label);
                    }
                    if (ok || exception != null) continue;
                    exception = e;
                }
            }
            return exception;
        }
    }

    private static class TransformEndCommand
    extends Command {
        private static final String NAME = "audit-transform-end";
        private static final int CID = Ide.createCmdID((String)"audit-transform-end");
        private final WeakReference<AuditModel> model;
        private final List<Tuple<Transform, Violation>> appliedTransforms = new ArrayList<Tuple<Transform, Violation>>();

        public TransformEndCommand(AuditModel model) {
            super(CID, 0, NAME);
            this.model = new WeakReference<AuditModel>(model);
        }

        public void setTransformApplied(Transform transform, Violation violation) {
            this.appliedTransforms.add((Tuple<Transform, Violation>)new Tuple((Object)transform, (Object)violation));
        }

        public void setContext(ModelAdapter model) {
            this.setContext(new Context(null, model.getWorkspace(), model.getProject(), model.getNode()));
        }

        public int doit() throws Exception {
            for (Tuple<Transform, Violation> tuple : this.appliedTransforms) {
                Transform transform = (Transform)tuple.object1();
                Violation violation = (Violation)tuple.object2();
                AuditModel model = (AuditModel)this.model.get();
                if (model == null) continue;
                model.setTransformDone(transform, violation);
            }
            return 0;
        }

        public int undo() throws Exception {
            for (Tuple<Transform, Violation> tuple : this.appliedTransforms) {
                Transform transform = (Transform)tuple.object1();
                Violation violation = (Violation)tuple.object2();
                AuditModel model = (AuditModel)this.model.get();
                if (model == null) continue;
                model.setTransformUndone(transform, violation);
            }
            return 0;
        }
    }

    private static class ModelChangedException
    extends Exception {
        private final ModelAdapter model;

        public ModelChangedException(ModelAdapter model) {
            this.model = model;
        }

        public ModelAdapter getModel() {
            return this.model;
        }
    }
}

